/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.accesslog;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.health.connect.datatypes.MedicalResource;
import android.health.connect.datatypes.Record;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.utils.HealthConnectMappings;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@SystemApi
public class AccessLog
implements Parcelable {
    @NonNull
    private final String mPackageName;
    @NonNull
    private final Instant mAccessTime;
    private final int mOperationType;
    @NonNull
    private final List<Class<? extends Record>> mRecordTypesList = new ArrayList<Class<? extends Record>>();
    @NonNull
    private Set<Integer> mMedicalResourceTypes = new HashSet<Integer>();
    private boolean mIsMedicalDataSourceAccessed = false;
    @NonNull
    public static final Parcelable.Creator<AccessLog> CREATOR = new Parcelable.Creator<AccessLog>(){

        @Override
        public AccessLog createFromParcel(Parcel in) {
            return new AccessLog(in);
        }

        public AccessLog[] newArray(int size) {
            return new AccessLog[size];
        }
    };

    public AccessLog(@NonNull String packageName, @NonNull List<Integer> recordTypes, long accessTimeInMillis, int operationType) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(recordTypes);
        this.mPackageName = packageName;
        HealthConnectMappings healthConnectMappings = HealthConnectMappings.getInstance();
        for (int recordType : recordTypes) {
            this.mRecordTypesList.add(healthConnectMappings.getRecordIdToExternalRecordClassMap().get(recordType));
        }
        this.mAccessTime = Instant.ofEpochMilli(accessTimeInMillis);
        this.mOperationType = operationType;
    }

    public AccessLog(@NonNull String packageName, long accessTimeInMillis, int operationType, @NonNull Set<Integer> medicalResourceTypes, boolean isMedicalDataSourceAccessed) {
        Objects.requireNonNull(packageName);
        OperationType.validateOperationType(operationType);
        Objects.requireNonNull(medicalResourceTypes);
        for (int medicalResourceType : medicalResourceTypes) {
            MedicalResource.validateMedicalResourceType(medicalResourceType);
        }
        this.mPackageName = packageName;
        this.mAccessTime = Instant.ofEpochMilli(accessTimeInMillis);
        this.mOperationType = operationType;
        this.mMedicalResourceTypes = medicalResourceTypes;
        this.mIsMedicalDataSourceAccessed = isMedicalDataSourceAccessed;
    }

    private AccessLog(Parcel in) {
        int[] medicalResourceTypes;
        int[] recordTypes;
        HealthConnectMappings healthConnectMappings = HealthConnectMappings.getInstance();
        for (int recordType : recordTypes = Objects.requireNonNull(in.createIntArray())) {
            this.mRecordTypesList.add(healthConnectMappings.getRecordIdToExternalRecordClassMap().get(recordType));
        }
        this.mPackageName = Objects.requireNonNull(in.readString());
        this.mAccessTime = Instant.ofEpochMilli(in.readLong());
        this.mOperationType = in.readInt();
        for (int medicalResourceType : medicalResourceTypes = Objects.requireNonNull(in.createIntArray())) {
            this.mMedicalResourceTypes.add(medicalResourceType);
        }
        this.mIsMedicalDataSourceAccessed = in.readBoolean();
    }

    @NonNull
    public List<Class<? extends Record>> getRecordTypes() {
        return this.mRecordTypesList;
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public Instant getAccessTime() {
        return this.mAccessTime;
    }

    public int getOperationType() {
        return this.mOperationType;
    }

    @NonNull
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public Set<Integer> getMedicalResourceTypes() {
        return this.mMedicalResourceTypes;
    }

    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public boolean isMedicalDataSourceAccessed() {
        return this.mIsMedicalDataSourceAccessed;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        int recordTypeCount = this.mRecordTypesList.size();
        HealthConnectMappings healthConnectMappings = HealthConnectMappings.getInstance();
        int[] recordTypes = new int[recordTypeCount];
        for (int i = 0; i < recordTypeCount; ++i) {
            recordTypes[i] = healthConnectMappings.getRecordType(this.mRecordTypesList.get(i));
        }
        dest.writeIntArray(recordTypes);
        dest.writeString(this.mPackageName);
        dest.writeLong(this.mAccessTime.toEpochMilli());
        dest.writeInt(this.mOperationType);
        dest.writeIntArray(this.mMedicalResourceTypes.stream().mapToInt(Integer::intValue).toArray());
        dest.writeBoolean(this.mIsMedicalDataSourceAccessed);
    }

    public static class OperationType {
        public static final int OPERATION_TYPE_READ = 2;
        public static final int OPERATION_TYPE_UPSERT = 0;
        public static final int OPERATION_TYPE_DELETE = 1;

        private static void validateOperationType(int operationType) {
            ValidationUtils.validateIntDefValue(operationType, Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)), OperationTypes.class.getSimpleName());
        }

        private OperationType() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface OperationTypes {
        }
    }
}

