/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.health.connect.datatypes.FhirResource;
import android.health.connect.datatypes.MedicalDataSource;
import android.health.connect.internal.datatypes.utils.FhirResourceTypeStringToIntMapper;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
public class MedicalResourceId
implements Parcelable {
    @NonNull
    private final String mDataSourceId;
    private final int mFhirResourceType;
    @NonNull
    private final String mFhirResourceId;
    private static final String FHIR_REFERENCE_REGEX = "([A-Za-z]+)/([A-Za-z0-9-.]+)";
    @NonNull
    public static final Parcelable.Creator<MedicalResourceId> CREATOR = new Parcelable.Creator<MedicalResourceId>(){

        @Override
        public MedicalResourceId createFromParcel(Parcel in) {
            return new MedicalResourceId(in);
        }

        public MedicalResourceId[] newArray(int size) {
            return new MedicalResourceId[size];
        }
    };

    public MedicalResourceId(@NonNull String dataSourceId, int fhirResourceType, @NonNull String fhirResourceId) {
        Objects.requireNonNull(dataSourceId);
        Objects.requireNonNull(fhirResourceId);
        FhirResource.validateFhirResourceType(fhirResourceType);
        MedicalDataSource.validateMedicalDataSourceIds(Set.of(dataSourceId));
        this.mDataSourceId = dataSourceId;
        this.mFhirResourceType = fhirResourceType;
        this.mFhirResourceId = fhirResourceId;
    }

    @NonNull
    public static MedicalResourceId fromFhirReference(@NonNull String dataSourceId, @NonNull String fhirReference) {
        Objects.requireNonNull(dataSourceId);
        Objects.requireNonNull(fhirReference);
        MedicalDataSource.validateMedicalDataSourceIds(Set.of(dataSourceId));
        Pattern pattern = Pattern.compile(FHIR_REFERENCE_REGEX);
        Matcher matcher = pattern.matcher(fhirReference);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid FHIR reference. Provided " + fhirReference + "does not match " + FHIR_REFERENCE_REGEX);
        }
        int fhirResourceType = FhirResourceTypeStringToIntMapper.getFhirResourceTypeInt(matcher.group(1));
        String fhirResourceId = matcher.group(2);
        return new MedicalResourceId(dataSourceId, fhirResourceType, fhirResourceId);
    }

    private MedicalResourceId(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mDataSourceId = Objects.requireNonNull(in.readString());
        MedicalDataSource.validateMedicalDataSourceIds(Set.of(this.mDataSourceId));
        this.mFhirResourceType = in.readInt();
        FhirResource.validateFhirResourceType(this.mFhirResourceType);
        this.mFhirResourceId = Objects.requireNonNull(in.readString());
    }

    @NonNull
    public String getDataSourceId() {
        return this.mDataSourceId;
    }

    public int getFhirResourceType() {
        return this.mFhirResourceType;
    }

    @NonNull
    public String getFhirResourceId() {
        return this.mFhirResourceId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeString(this.getDataSourceId());
        dest.writeInt(this.getFhirResourceType());
        dest.writeString(this.getFhirResourceId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MedicalResourceId)) {
            return false;
        }
        MedicalResourceId that = (MedicalResourceId)o;
        return this.getDataSourceId().equals(that.getDataSourceId()) && this.getFhirResourceType() == that.getFhirResourceType() && this.getFhirResourceId().equals(that.getFhirResourceId());
    }

    public int hashCode() {
        return Objects.hash(this.getDataSourceId(), this.getFhirResourceType(), this.getFhirResourceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append("dataSourceId=").append(this.getDataSourceId());
        sb.append(",fhirResourceType=").append(this.getFhirResourceType());
        sb.append(",fhirResourceId=").append(this.getFhirResourceId());
        sb.append("}");
        return sb.toString();
    }
}

