/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.health.connect.datatypes.MedicalDataSource;
import android.health.connect.datatypes.MedicalResource;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
public class DeleteMedicalResourcesRequest
implements Parcelable {
    @NonNull
    private final Set<String> mDataSourceIds;
    @NonNull
    private final Set<Integer> mMedicalResourceTypes;
    @NonNull
    public static final Parcelable.Creator<DeleteMedicalResourcesRequest> CREATOR = new Parcelable.Creator<DeleteMedicalResourcesRequest>(){

        @Override
        public DeleteMedicalResourcesRequest createFromParcel(Parcel in) {
            return new DeleteMedicalResourcesRequest(in);
        }

        public DeleteMedicalResourcesRequest[] newArray(int size) {
            return new DeleteMedicalResourcesRequest[size];
        }
    };

    private DeleteMedicalResourcesRequest(@NonNull Set<String> dataSourceIds, @NonNull Set<Integer> medicalResourceTypes) {
        if (dataSourceIds.isEmpty() && medicalResourceTypes.isEmpty()) {
            throw new IllegalArgumentException("No restrictions specified for delete. The request must restrict by data source or resource type");
        }
        MedicalDataSource.validateMedicalDataSourceIds(dataSourceIds);
        medicalResourceTypes.forEach(MedicalResource::validateMedicalResourceType);
        this.mDataSourceIds = dataSourceIds;
        this.mMedicalResourceTypes = medicalResourceTypes;
    }

    private DeleteMedicalResourcesRequest(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        ArrayList<String> dataSourceIdList = Objects.requireNonNull(in.createStringArrayList());
        int[] resourceTypes = Objects.requireNonNull(in.createIntArray());
        if (dataSourceIdList.isEmpty() && resourceTypes.length == 0) {
            throw new IllegalArgumentException("Empty data sources and resource types in parcel");
        }
        this.mDataSourceIds = new HashSet<String>(dataSourceIdList);
        MedicalDataSource.validateMedicalDataSourceIds(this.mDataSourceIds);
        this.mMedicalResourceTypes = new HashSet<Integer>();
        for (int resourceType : resourceTypes) {
            MedicalResource.validateMedicalResourceType(resourceType);
            this.mMedicalResourceTypes.add(resourceType);
        }
    }

    @NonNull
    public Set<String> getDataSourceIds() {
        return new HashSet<String>(this.mDataSourceIds);
    }

    @NonNull
    public Set<Integer> getMedicalResourceTypes() {
        return new HashSet<Integer>(this.mMedicalResourceTypes);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeStringList(new ArrayList<String>(this.mDataSourceIds));
        dest.writeIntArray(this.mMedicalResourceTypes.stream().mapToInt(Integer::intValue).toArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteMedicalResourcesRequest)) {
            return false;
        }
        DeleteMedicalResourcesRequest that = (DeleteMedicalResourcesRequest)o;
        return this.mDataSourceIds.equals(that.mDataSourceIds) && this.mMedicalResourceTypes.equals(that.mMedicalResourceTypes);
    }

    public int hashCode() {
        return Objects.hash(this.mDataSourceIds, this.mMedicalResourceTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append("dataSourceIds=").append(this.mDataSourceIds);
        sb.append(",medicalResourceTypes=").append(this.mMedicalResourceTypes);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private final Set<String> mDataSourceIds = new HashSet<String>();
        private final Set<Integer> mMedicalResourceTypes = new HashSet<Integer>();

        public Builder() {
        }

        public Builder(@NonNull Builder other) {
            this.mDataSourceIds.addAll(other.mDataSourceIds);
            this.mMedicalResourceTypes.addAll(other.mMedicalResourceTypes);
        }

        public Builder(@NonNull DeleteMedicalResourcesRequest other) {
            this.mDataSourceIds.addAll(other.getDataSourceIds());
            this.mMedicalResourceTypes.addAll(other.getMedicalResourceTypes());
        }

        @NonNull
        public Builder addDataSourceId(@NonNull String dataSourceId) {
            this.mDataSourceIds.add(Objects.requireNonNull(dataSourceId));
            MedicalDataSource.validateMedicalDataSourceIds(Set.of(dataSourceId));
            return this;
        }

        @NonNull
        public Builder addMedicalResourceType(int resourceType) {
            MedicalResource.validateMedicalResourceType(resourceType);
            this.mMedicalResourceTypes.add(resourceType);
            return this;
        }

        @NonNull
        public Builder clearDataSourceIds() {
            this.mDataSourceIds.clear();
            return this;
        }

        @NonNull
        public Builder clearMedicalResourceTypes() {
            this.mMedicalResourceTypes.clear();
            return this;
        }

        @NonNull
        public DeleteMedicalResourcesRequest build() {
            return new DeleteMedicalResourcesRequest(this.mDataSourceIds, this.mMedicalResourceTypes);
        }
    }
}

