/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.AggregateRecordsResponse;
import android.health.connect.AggregateResult;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.internal.datatypes.utils.AggregationTypeIdMapper;
import android.util.ArrayMap;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AggregateRecordsGroupedByDurationResponse<T> {
    private final Instant mStartTime;
    private final Instant mEndTime;
    private final Map<AggregationType<T>, AggregateResult<T>> mResult;

    public AggregateRecordsGroupedByDurationResponse(@NonNull Instant startTime, @NonNull Instant endTime, @NonNull Map<Integer, AggregateResult<?>> result) {
        Objects.requireNonNull(startTime);
        Objects.requireNonNull(endTime);
        Objects.requireNonNull(result);
        this.mStartTime = startTime;
        this.mEndTime = endTime;
        this.mResult = new ArrayMap<AggregationType<T>, AggregateResult<T>>(result.size());
        result.forEach((key, value) -> this.mResult.put(AggregationTypeIdMapper.getInstance().getAggregationTypeFor((int)key), (AggregateResult<T>)value));
    }

    @NonNull
    public Instant getStartTime() {
        return this.mStartTime;
    }

    @NonNull
    public Instant getEndTime() {
        return this.mEndTime;
    }

    @Nullable
    public T get(@NonNull AggregationType<T> aggregationType) {
        return AggregateRecordsResponse.getInternal(aggregationType, this.mResult);
    }

    @Nullable
    public ZoneOffset getZoneOffset(@NonNull AggregationType<T> aggregationType) {
        return AggregateRecordsResponse.getZoneOffsetInternal(aggregationType, this.mResult);
    }

    @NonNull
    public Set<DataOrigin> getDataOrigins(@NonNull AggregationType<T> aggregationType) {
        return AggregateRecordsResponse.getDataOriginsInternal(aggregationType, this.mResult);
    }
}

