/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.annotation.FlaggedApi;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.hardware.radio.hd_radio_emergency_alert_system")
public class RadioAlert
implements Parcelable {
    public static final int STATUS_ACTUAL = 0;
    public static final int STATUS_EXERCISE = 1;
    public static final int STATUS_TEST = 2;
    public static final int MESSAGE_TYPE_ALERT = 0;
    public static final int MESSAGE_TYPE_UPDATE = 1;
    public static final int MESSAGE_TYPE_CANCEL = 2;
    public static final int CATEGORY_GEO = 0;
    public static final int CATEGORY_MET = 1;
    public static final int CATEGORY_SAFETY = 2;
    public static final int CATEGORY_SECURITY = 3;
    public static final int CATEGORY_RESCUE = 4;
    public static final int CATEGORY_FIRE = 5;
    public static final int CATEGORY_HEALTH = 6;
    public static final int CATEGORY_ENV = 7;
    public static final int CATEGORY_TRANSPORT = 8;
    public static final int CATEGORY_INFRA = 9;
    public static final int CATEGORY_CBRNE = 10;
    public static final int CATEGORY_OTHER = 11;
    public static final int URGENCY_IMMEDIATE = 0;
    public static final int URGENCY_EXPECTED = 1;
    public static final int URGENCY_FUTURE = 2;
    public static final int URGENCY_PAST = 3;
    public static final int URGENCY_UNKNOWN = 4;
    public static final int SEVERITY_EXTREME = 0;
    public static final int SEVERITY_SEVERE = 1;
    public static final int SEVERITY_MODERATE = 2;
    public static final int SEVERITY_MINOR = 3;
    public static final int SEVERITY_UNKNOWN = 4;
    public static final int CERTAINTY_OBSERVED = 0;
    public static final int CERTAINTY_LIKELY = 1;
    public static final int CERTAINTY_POSSIBLE = 2;
    public static final int CERTAINTY_UNLIKELY = 3;
    public static final int CERTAINTY_UNKNOWN = 4;
    private final int mStatus;
    private final int mMessageType;
    private final List<AlertInfo> mInfoList;
    @NonNull
    public static final Parcelable.Creator<RadioAlert> CREATOR = new Parcelable.Creator<RadioAlert>(){

        @Override
        public RadioAlert createFromParcel(Parcel in) {
            return new RadioAlert(in);
        }

        public RadioAlert[] newArray(int size) {
            return new RadioAlert[size];
        }
    };

    public RadioAlert(int status, int messageType, @NonNull List<AlertInfo> infoList) {
        this.mStatus = status;
        this.mMessageType = messageType;
        this.mInfoList = Objects.requireNonNull(infoList, "Alert info list can not be null");
    }

    private RadioAlert(Parcel in) {
        this.mStatus = in.readInt();
        this.mMessageType = in.readInt();
        this.mInfoList = in.readParcelableList(new ArrayList(), AlertInfo.class.getClassLoader(), AlertInfo.class);
    }

    public int getStatus() {
        return this.mStatus;
    }

    public int getMessageType() {
        return this.mMessageType;
    }

    @NonNull
    public List<AlertInfo> getInfoList() {
        return this.mInfoList;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mStatus);
        dest.writeInt(this.mMessageType);
        dest.writeParcelableList(this.mInfoList, 0);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public String toString() {
        return "RadioAlert [status=" + this.mStatus + ", messageType=" + this.mMessageType + ", infoList= " + this.mInfoList + "]";
    }

    public int hashCode() {
        return Objects.hash(this.mStatus, this.mMessageType, this.mInfoList);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RadioAlert)) {
            return false;
        }
        RadioAlert other = (RadioAlert)obj;
        return this.mStatus == other.mStatus && this.mMessageType == other.mMessageType && this.mInfoList.equals(other.mInfoList);
    }

    public static class AlertInfo
    implements Parcelable {
        @NonNull
        private final int[] mCategories;
        private final int mUrgency;
        private final int mSeverity;
        private final int mCertainty;
        @NonNull
        private final String mTextualMessage;
        @NonNull
        private final List<AlertArea> mAreaList;
        @Nullable
        private final String mLanguage;
        @NonNull
        public static final Parcelable.Creator<AlertInfo> CREATOR = new Parcelable.Creator<AlertInfo>(){

            @Override
            public AlertInfo createFromParcel(Parcel in) {
                return new AlertInfo(in);
            }

            public AlertInfo[] newArray(int size) {
                return new AlertInfo[size];
            }
        };

        public AlertInfo(@NonNull int[] categories, int urgency, int severity, int certainty, String textualMessage, @NonNull List<AlertArea> areaList, @Nullable String language) {
            Objects.requireNonNull(categories, "Categories can not be null");
            Arrays.sort(categories);
            this.mCategories = categories;
            this.mUrgency = urgency;
            this.mSeverity = severity;
            this.mCertainty = certainty;
            this.mTextualMessage = textualMessage;
            this.mAreaList = Objects.requireNonNull(areaList, "Area list can not be null");
            this.mLanguage = language;
        }

        private AlertInfo(Parcel in) {
            this.mCategories = new int[in.readInt()];
            in.readIntArray(this.mCategories);
            this.mUrgency = in.readInt();
            this.mSeverity = in.readInt();
            this.mCertainty = in.readInt();
            this.mTextualMessage = in.readString8();
            this.mAreaList = new ArrayList<AlertArea>();
            in.readTypedList(this.mAreaList, AlertArea.CREATOR);
            boolean hasLanguage = in.readBoolean();
            this.mLanguage = hasLanguage ? in.readString8() : null;
        }

        @NonNull
        public int[] getCategories() {
            return this.mCategories;
        }

        public int getUrgency() {
            return this.mUrgency;
        }

        public int getSeverity() {
            return this.mSeverity;
        }

        public int getCertainty() {
            return this.mCertainty;
        }

        @NonNull
        public String getDescription() {
            return this.mTextualMessage;
        }

        @NonNull
        public List<AlertArea> getAreas() {
            return this.mAreaList;
        }

        @Nullable
        public String getLanguage() {
            return this.mLanguage;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mCategories.length);
            dest.writeIntArray(this.mCategories);
            dest.writeInt(this.mUrgency);
            dest.writeInt(this.mSeverity);
            dest.writeInt(this.mCertainty);
            dest.writeString8(this.mTextualMessage);
            dest.writeTypedList(this.mAreaList);
            if (this.mLanguage == null) {
                dest.writeBoolean(false);
            } else {
                dest.writeBoolean(true);
                dest.writeString8(this.mLanguage);
            }
        }

        @NonNull
        public String toString() {
            return "AlertInfo [categories=" + Arrays.toString(this.mCategories) + ", urgency=" + this.mUrgency + ", severity=" + this.mSeverity + ", certainty=" + this.mCertainty + ", textualMessage=" + this.mTextualMessage + ", areaList=" + this.mAreaList + ", language=" + this.mLanguage + "]";
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.mCategories), this.mUrgency, this.mSeverity, this.mCertainty, this.mTextualMessage, this.mAreaList, this.mLanguage);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AlertInfo)) {
                return false;
            }
            AlertInfo other = (AlertInfo)obj;
            return Arrays.equals(this.mCategories, other.mCategories) && this.mUrgency == other.mUrgency && this.mSeverity == other.mSeverity && this.mCertainty == other.mCertainty && this.mTextualMessage.equals(other.mTextualMessage) && this.mAreaList.equals(other.mAreaList) && Objects.equals(this.mLanguage, other.mLanguage);
        }
    }

    public static class AlertArea
    implements Parcelable {
        private final List<Polygon> mPolygons;
        private final List<Geocode> mGeocodes;
        @NonNull
        public static final Parcelable.Creator<AlertArea> CREATOR = new Parcelable.Creator<AlertArea>(){

            @Override
            public AlertArea createFromParcel(Parcel in) {
                return new AlertArea(in);
            }

            public AlertArea[] newArray(int size) {
                return new AlertArea[size];
            }
        };

        public AlertArea(@NonNull List<Polygon> polygons, @NonNull List<Geocode> geocodes) {
            this.mPolygons = Objects.requireNonNull(polygons, "Polygons can not be null");
            this.mGeocodes = Objects.requireNonNull(geocodes, "Geocodes can not be null");
        }

        private AlertArea(Parcel in) {
            this.mPolygons = new ArrayList<Polygon>();
            this.mGeocodes = new ArrayList<Geocode>();
            in.readTypedList(this.mPolygons, Polygon.CREATOR);
            in.readTypedList(this.mGeocodes, Geocode.CREATOR);
        }

        @NonNull
        public List<Polygon> getPolygons() {
            return this.mPolygons;
        }

        @NonNull
        public List<Geocode> getGeocodes() {
            return this.mGeocodes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeTypedList(this.mPolygons);
            dest.writeTypedList(this.mGeocodes);
        }

        @NonNull
        public String toString() {
            return "AlertArea [polygons=" + this.mPolygons + ", geocodes=" + this.mGeocodes + "]";
        }

        public int hashCode() {
            return Objects.hash(this.mPolygons, this.mGeocodes);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AlertArea)) {
                return false;
            }
            AlertArea other = (AlertArea)obj;
            return this.mPolygons.equals(other.mPolygons) && this.mGeocodes.equals(other.mGeocodes);
        }
    }

    public static class Polygon
    implements Parcelable {
        private final List<Coordinate> mCoordinates;
        @NonNull
        public static final Parcelable.Creator<Polygon> CREATOR = new Parcelable.Creator<Polygon>(){

            @Override
            public Polygon createFromParcel(Parcel in) {
                return new Polygon(in);
            }

            public Polygon[] newArray(int size) {
                return new Polygon[size];
            }
        };

        public Polygon(@NonNull List<Coordinate> coordinates) {
            Objects.requireNonNull(coordinates, "Coordinates can not be null");
            if (coordinates.size() < 4) {
                throw new IllegalArgumentException("Number of coordinates must be at least 4");
            }
            if (!coordinates.get(0).equals(coordinates.get(coordinates.size() - 1))) {
                throw new IllegalArgumentException("The last and first coordinates must be the same");
            }
            this.mCoordinates = coordinates;
        }

        private Polygon(Parcel in) {
            this.mCoordinates = new ArrayList<Coordinate>();
            in.readTypedList(this.mCoordinates, Coordinate.CREATOR);
        }

        @NonNull
        public List<Coordinate> getCoordinates() {
            return this.mCoordinates;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeTypedList(this.mCoordinates);
        }

        @NonNull
        public String toString() {
            return "Polygon [coordinates=" + this.mCoordinates + "]";
        }

        public int hashCode() {
            return Objects.hash(this.mCoordinates);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Polygon)) {
                return false;
            }
            Polygon other = (Polygon)obj;
            return this.mCoordinates.equals(other.mCoordinates);
        }
    }

    public static class Coordinate
    implements Parcelable {
        private final double mLatitude;
        private final double mLongitude;
        @NonNull
        public static final Parcelable.Creator<Coordinate> CREATOR = new Parcelable.Creator<Coordinate>(){

            @Override
            public Coordinate createFromParcel(Parcel in) {
                return new Coordinate(in);
            }

            public Coordinate[] newArray(int size) {
                return new Coordinate[size];
            }
        };

        public Coordinate(double latitude, double longitude) {
            if (latitude < -90.0 || latitude > 90.0) {
                throw new IllegalArgumentException("Latitude value should be between -90 and 90");
            }
            if (longitude < -180.0 || longitude > 180.0) {
                throw new IllegalArgumentException("Longitude value should be between -180 and 180");
            }
            this.mLatitude = latitude;
            this.mLongitude = longitude;
        }

        private Coordinate(Parcel in) {
            this.mLatitude = in.readDouble();
            this.mLongitude = in.readDouble();
        }

        public double getLatitude() {
            return this.mLatitude;
        }

        public double getLongitude() {
            return this.mLongitude;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeDouble(this.mLatitude);
            dest.writeDouble(this.mLongitude);
        }

        @NonNull
        public String toString() {
            return "Coordinate [latitude=" + this.mLatitude + ", longitude=" + this.mLongitude + "]";
        }

        public int hashCode() {
            return Objects.hash(this.mLatitude, this.mLongitude);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Coordinate)) {
                return false;
            }
            Coordinate other = (Coordinate)obj;
            return this.mLatitude == other.mLatitude && this.mLongitude == other.mLongitude;
        }
    }

    public static class Geocode
    implements Parcelable {
        private final String mValueName;
        private final String mValue;
        @NonNull
        public static final Parcelable.Creator<Geocode> CREATOR = new Parcelable.Creator<Geocode>(){

            @Override
            public Geocode createFromParcel(Parcel in) {
                return new Geocode(in);
            }

            public Geocode[] newArray(int size) {
                return new Geocode[size];
            }
        };

        public Geocode(@NonNull String valueName, @NonNull String value) {
            this.mValueName = Objects.requireNonNull(valueName, "Geocode value name can not be null");
            this.mValue = Objects.requireNonNull(value, "Geocode value can not be null");
        }

        private Geocode(Parcel in) {
            this.mValueName = in.readString8();
            this.mValue = in.readString8();
        }

        @NonNull
        public String getValueName() {
            return this.mValueName;
        }

        @NonNull
        public String getValue() {
            return this.mValue;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString8(this.mValueName);
            dest.writeString8(this.mValue);
        }

        @NonNull
        public String toString() {
            return "Gecode [valueName=" + this.mValueName + ", value=" + this.mValue + "]";
        }

        public int hashCode() {
            return Objects.hash(this.mValueName, this.mValue);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Geocode)) {
                return false;
            }
            Geocode other = (Geocode)obj;
            return Objects.equals(this.mValueName, other.mValueName) && Objects.equals(this.mValue, other.mValue);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlertCertainty {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlertSeverity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlertUrgency {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlertCategory {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlertMessageType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlertStatus {
    }
}

