/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.hardware.location.IContextHubTransactionCallback;
import android.hardware.location.NanoAppMessage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IContextHubClient
extends IInterface {
    public int sendMessageToNanoApp(NanoAppMessage var1) throws RemoteException;

    public void close() throws RemoteException;

    public int getId() throws RemoteException;

    public void callbackFinished() throws RemoteException;

    public void reliableMessageCallbackFinished(int var1, byte var2) throws RemoteException;

    public int sendReliableMessageToNanoApp(NanoAppMessage var1, IContextHubTransactionCallback var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContextHubClient {
        public static final String DESCRIPTOR = "android.hardware.location.IContextHubClient";
        static final int TRANSACTION_sendMessageToNanoApp = 1;
        static final int TRANSACTION_close = 2;
        static final int TRANSACTION_getId = 3;
        static final int TRANSACTION_callbackFinished = 4;
        static final int TRANSACTION_reliableMessageCallbackFinished = 5;
        static final int TRANSACTION_sendReliableMessageToNanoApp = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IContextHubClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IContextHubClient) {
                return (IContextHubClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "sendMessageToNanoApp";
                }
                case 2: {
                    return "close";
                }
                case 3: {
                    return "getId";
                }
                case 4: {
                    return "callbackFinished";
                }
                case 5: {
                    return "reliableMessageCallbackFinished";
                }
                case 6: {
                    return "sendReliableMessageToNanoApp";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    NanoAppMessage _arg0 = data.readTypedObject(NanoAppMessage.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.sendMessageToNanoApp(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    this.close();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _result = this.getId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 4: {
                    this.callbackFinished();
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    byte _arg1 = data.readByte();
                    data.enforceNoDataAvail();
                    this.reliableMessageCallbackFinished(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    NanoAppMessage _arg0 = data.readTypedObject(NanoAppMessage.CREATOR);
                    IContextHubTransactionCallback _arg1 = IContextHubTransactionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.sendReliableMessageToNanoApp(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements IContextHubClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int sendMessageToNanoApp(NanoAppMessage message) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(message, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callbackFinished() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reliableMessageCallbackFinished(int messageSequenceNumber, byte errorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(messageSequenceNumber);
                    _data.writeByte(errorCode);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int sendReliableMessageToNanoApp(NanoAppMessage message, IContextHubTransactionCallback transactionCallback) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(message, 0);
                    _data.writeStrongInterface(transactionCallback);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IContextHubClient {
        @Override
        public int sendMessageToNanoApp(NanoAppMessage message) throws RemoteException {
            return 0;
        }

        @Override
        public void close() throws RemoteException {
        }

        @Override
        public int getId() throws RemoteException {
            return 0;
        }

        @Override
        public void callbackFinished() throws RemoteException {
        }

        @Override
        public void reliableMessageCallbackFinished(int messageSequenceNumber, byte errorCode) throws RemoteException {
        }

        @Override
        public int sendReliableMessageToNanoApp(NanoAppMessage message, IContextHubTransactionCallback transactionCallback) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

