/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Handler;
import android.os.HandlerExecutor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@SystemApi
public class ContextHubTransaction<T> {
    private static final String TAG = "ContextHubTransaction";
    public static final int TYPE_LOAD_NANOAPP = 0;
    public static final int TYPE_UNLOAD_NANOAPP = 1;
    public static final int TYPE_ENABLE_NANOAPP = 2;
    public static final int TYPE_DISABLE_NANOAPP = 3;
    public static final int TYPE_QUERY_NANOAPPS = 4;
    public static final int TYPE_RELIABLE_MESSAGE = 5;
    @FlaggedApi(value="android.chre.flags.offload_api")
    public static final int TYPE_HUB_MESSAGE_DEFAULT = 6;
    @FlaggedApi(value="android.chre.flags.offload_api")
    public static final int TYPE_HUB_MESSAGE_REQUIRES_RESPONSE = 7;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FAILED_UNKNOWN = 1;
    public static final int RESULT_FAILED_BAD_PARAMS = 2;
    public static final int RESULT_FAILED_UNINITIALIZED = 3;
    public static final int RESULT_FAILED_BUSY = 4;
    public static final int RESULT_FAILED_AT_HUB = 5;
    public static final int RESULT_FAILED_TIMEOUT = 6;
    public static final int RESULT_FAILED_SERVICE_INTERNAL_FAILURE = 7;
    public static final int RESULT_FAILED_HAL_UNAVAILABLE = 8;
    public static final int RESULT_FAILED_NOT_SUPPORTED = 9;
    private int mTransactionType;
    private Response<T> mResponse;
    private Executor mExecutor = null;
    private OnCompleteListener<T> mListener = null;
    private final CountDownLatch mDoneSignal = new CountDownLatch(1);
    private boolean mIsResponseSet = false;

    public ContextHubTransaction(int type) {
        this.mTransactionType = type;
    }

    public static String typeToString(int type, boolean upperCase) {
        switch (type) {
            case 0: {
                return upperCase ? "Load" : "load";
            }
            case 1: {
                return upperCase ? "Unload" : "unload";
            }
            case 2: {
                return upperCase ? "Enable" : "enable";
            }
            case 3: {
                return upperCase ? "Disable" : "disable";
            }
            case 4: {
                return upperCase ? "Query" : "query";
            }
            case 5: {
                return upperCase ? "Reliable Message" : "reliable message";
            }
        }
        return upperCase ? "Unknown" : "unknown";
    }

    public int getType() {
        return this.mTransactionType;
    }

    public Response<T> waitForResponse(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        boolean success = this.mDoneSignal.await(timeout, unit);
        if (!success) {
            throw new TimeoutException("Timed out while waiting for transaction");
        }
        return this.mResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnCompleteListener(@NonNull OnCompleteListener<T> listener, @NonNull Executor executor) {
        ContextHubTransaction contextHubTransaction = this;
        synchronized (contextHubTransaction) {
            Objects.requireNonNull(listener, "OnCompleteListener cannot be null");
            Objects.requireNonNull(executor, "Executor cannot be null");
            if (this.mListener != null) {
                throw new IllegalStateException("Cannot set ContextHubTransaction listener multiple times");
            }
            this.mListener = listener;
            this.mExecutor = executor;
            if (this.mDoneSignal.getCount() == 0L) {
                this.mExecutor.execute(() -> this.mListener.onComplete(this, this.mResponse));
            }
        }
    }

    public void setOnCompleteListener(@NonNull OnCompleteListener<T> listener) {
        this.setOnCompleteListener(listener, new HandlerExecutor(Handler.getMain()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(Response<T> response) {
        ContextHubTransaction contextHubTransaction = this;
        synchronized (contextHubTransaction) {
            Objects.requireNonNull(response, "Response cannot be null");
            if (this.mIsResponseSet) {
                throw new IllegalStateException("Cannot set response of ContextHubTransaction multiple times");
            }
            this.mResponse = response;
            this.mIsResponseSet = true;
            this.mDoneSignal.countDown();
            if (this.mListener != null) {
                this.mExecutor.execute(() -> this.mListener.onComplete(this, this.mResponse));
            }
        }
    }

    @FunctionalInterface
    public static interface OnCompleteListener<L> {
        public void onComplete(ContextHubTransaction<L> var1, Response<L> var2);
    }

    public static class Response<R> {
        private int mResult;
        private R mContents;

        public Response(int result, R contents) {
            this.mResult = result;
            this.mContents = contents;
        }

        public int getResult() {
            return this.mResult;
        }

        public R getContents() {
            return this.mContents;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Result {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

