/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;

@SystemApi
@FlaggedApi(value="android.companion.virtualdevice.flags.virtual_rotary")
public class VirtualRotaryEncoderScrollEvent
implements Parcelable {
    private final float mScrollAmount;
    private final long mEventTimeNanos;
    @NonNull
    public static final Parcelable.Creator<VirtualRotaryEncoderScrollEvent> CREATOR = new Parcelable.Creator<VirtualRotaryEncoderScrollEvent>(){

        @Override
        public VirtualRotaryEncoderScrollEvent createFromParcel(Parcel source) {
            return new VirtualRotaryEncoderScrollEvent(source);
        }

        public VirtualRotaryEncoderScrollEvent[] newArray(int size) {
            return new VirtualRotaryEncoderScrollEvent[size];
        }
    };

    private VirtualRotaryEncoderScrollEvent(float scrollAmount, long eventTimeNanos) {
        this.mScrollAmount = scrollAmount;
        this.mEventTimeNanos = eventTimeNanos;
    }

    private VirtualRotaryEncoderScrollEvent(@NonNull Parcel parcel) {
        this.mScrollAmount = parcel.readFloat();
        this.mEventTimeNanos = parcel.readLong();
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int parcelableFlags) {
        parcel.writeFloat(this.mScrollAmount);
        parcel.writeLong(this.mEventTimeNanos);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "VirtualRotaryScrollEvent( scrollAmount=" + this.mScrollAmount + " eventTime(ns)=" + this.mEventTimeNanos;
    }

    public float getScrollAmount() {
        return this.mScrollAmount;
    }

    public long getEventTimeNanos() {
        return this.mEventTimeNanos;
    }

    public static class Builder {
        private float mScrollAmount = 0.0f;
        private long mEventTimeNanos = 0L;

        @NonNull
        public VirtualRotaryEncoderScrollEvent build() {
            return new VirtualRotaryEncoderScrollEvent(this.mScrollAmount, this.mEventTimeNanos);
        }

        @NonNull
        public Builder setScrollAmount(float scrollAmount) {
            Preconditions.checkArgumentInRange(scrollAmount, -1.0f, 1.0f, "scrollAmount");
            this.mScrollAmount = scrollAmount;
            return this;
        }

        @NonNull
        public Builder setEventTimeNanos(long eventTimeNanos) {
            if (eventTimeNanos < 0L) {
                throw new IllegalArgumentException("Event time cannot be negative");
            }
            this.mEventTimeNanos = eventTimeNanos;
            return this;
        }
    }
}

