/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.app.AppGlobals;
import android.content.Context;
import android.provider.Settings;
import android.sysprop.InputProperties;
import android.view.ViewConfiguration;
import com.android.internal.hidden_from_bootclasspath.com.android.hardware.input.Flags;

public class InputSettings {
    public static final int MIN_POINTER_SPEED = -7;
    public static final int MAX_POINTER_SPEED = 7;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int DEFAULT_POINTER_SPEED = 0;
    public static final int MIN_MOUSE_SCROLLING_SPEED = -7;
    public static final int MAX_MOUSE_SCROLLING_SPEED = 7;
    public static final int DEFAULT_MOUSE_SCROLLING_SPEED = 0;
    public static final int DEFAULT_BOUNCE_KEYS_THRESHOLD_MILLIS = 500;
    public static final int DEFAULT_SLOW_KEYS_THRESHOLD_MILLIS = 500;
    public static final float DEFAULT_MOUSE_KEYS_ACCELERATION = 0.2f;
    public static final int DEFAULT_MOUSE_KEYS_MAX_SPEED = 5;
    public static final float DEFAULT_MAXIMUM_OBSCURING_OPACITY_FOR_TOUCH = 0.8f;
    public static final int MAX_ACCESSIBILITY_BOUNCE_KEYS_THRESHOLD_MILLIS = 5000;
    public static final int MAX_ACCESSIBILITY_SLOW_KEYS_THRESHOLD_MILLIS = 5000;
    public static final int DEFAULT_STYLUS_POINTER_ICON_ENABLED = 1;
    public static final int MIN_KEY_REPEAT_TIMEOUT_MILLIS = 150;
    public static final int MAX_KEY_REPEAT_TIMEOUT_MILLIS = 2000;
    public static final int MIN_KEY_REPEAT_DELAY_MILLIS = 20;
    public static final int MAX_KEY_REPEAT_DELAY_MILLIS = 2000;

    private InputSettings() {
    }

    @SuppressLint(value={"NonUserGetterCalled"})
    public static int getPointerSpeed(Context context) {
        return Settings.System.getInt(context.getContentResolver(), "pointer_speed", 0);
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setPointerSpeed(Context context, int speed) {
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        Settings.System.putInt(context.getContentResolver(), "pointer_speed", speed);
    }

    public static float getMaximumObscuringOpacityForTouch(Context context) {
        return Settings.Global.getFloat(context.getContentResolver(), "maximum_obscuring_opacity_for_touch", 0.8f);
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public static void setMaximumObscuringOpacityForTouch(@NonNull Context context, float opacity) {
        if (opacity < 0.0f || opacity > 1.0f) {
            throw new IllegalArgumentException("Maximum obscuring opacity for touch should be >= 0 and <= 1");
        }
        Settings.Global.putFloat(context.getContentResolver(), "maximum_obscuring_opacity_for_touch", opacity);
    }

    public static boolean isStylusEverUsed(@NonNull Context context) {
        return Settings.Global.getInt(context.getContentResolver(), "stylus_ever_used", 0) == 1;
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public static void setStylusEverUsed(@NonNull Context context, boolean stylusEverUsed) {
        Settings.Global.putInt(context.getContentResolver(), "stylus_ever_used", stylusEverUsed ? 1 : 0);
    }

    public static int getTouchpadPointerSpeed(@NonNull Context context) {
        return Settings.System.getIntForUser(context.getContentResolver(), "touchpad_pointer_speed", 0, -2);
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setTouchpadPointerSpeed(@NonNull Context context, int speed) {
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        Settings.System.putIntForUser(context.getContentResolver(), "touchpad_pointer_speed", speed, -2);
    }

    public static boolean useTouchpadNaturalScrolling(@NonNull Context context) {
        return Settings.System.getIntForUser(context.getContentResolver(), "touchpad_natural_scrolling", 1, -2) == 1;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setTouchpadNaturalScrolling(@NonNull Context context, boolean enabled) {
        Settings.System.putIntForUser(context.getContentResolver(), "touchpad_natural_scrolling", enabled ? 1 : 0, -2);
    }

    public static boolean useTouchpadTapToClick(@NonNull Context context) {
        return Settings.System.getIntForUser(context.getContentResolver(), "touchpad_tap_to_click", 1, -2) == 1;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setTouchpadTapToClick(@NonNull Context context, boolean enabled) {
        Settings.System.putIntForUser(context.getContentResolver(), "touchpad_tap_to_click", enabled ? 1 : 0, -2);
    }

    public static boolean isTouchpadAccelerationEnabled(@NonNull Context context) {
        if (!InputSettings.isPointerAccelerationFeatureFlagEnabled()) {
            return true;
        }
        return Settings.System.getIntForUser(context.getContentResolver(), "touchpad_acceleration_enabled", 1, -2) == 1;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setTouchpadAccelerationEnabled(@NonNull Context context, boolean enabled) {
        if (!InputSettings.isPointerAccelerationFeatureFlagEnabled()) {
            return;
        }
        Settings.System.putIntForUser(context.getContentResolver(), "touchpad_acceleration_enabled", enabled ? 1 : 0, -2);
    }

    public static boolean isTouchpadSystemGestureDisableFeatureFlagEnabled() {
        return Flags.touchpadSystemGestureDisable();
    }

    public static boolean isTouchpadVisualizerFeatureFlagEnabled() {
        return Flags.touchpadVisualizer();
    }

    public static boolean isTouchpadThreeFingerTapShortcutFeatureFlagEnabled() {
        return InputSettings.isCustomizableInputGesturesFeatureFlagEnabled() && Flags.touchpadThreeFingerTapShortcut();
    }

    public static boolean isMouseScrollingAccelerationFeatureFlagEnabled() {
        return Flags.mouseScrollingAcceleration();
    }

    public static boolean isMouseReverseVerticalScrollingFeatureFlagEnabled() {
        return Flags.mouseReverseVerticalScrolling();
    }

    public static boolean isMouseSwapPrimaryButtonFeatureFlagEnabled() {
        return Flags.mouseSwapPrimaryButton();
    }

    public static boolean isPointerAccelerationFeatureFlagEnabled() {
        return Flags.pointerAcceleration();
    }

    public static boolean useTouchpadVisualizer(@NonNull Context context) {
        if (!InputSettings.isTouchpadVisualizerFeatureFlagEnabled()) {
            return false;
        }
        return Settings.System.getIntForUser(context.getContentResolver(), "touchpad_visualizer", 0, -2) == 1;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setTouchpadVisualizer(@NonNull Context context, boolean enabled) {
        if (!InputSettings.isTouchpadVisualizerFeatureFlagEnabled()) {
            return;
        }
        Settings.System.putIntForUser(context.getContentResolver(), "touchpad_visualizer", enabled ? 1 : 0, -2);
    }

    public static boolean useTouchpadTapDragging(@NonNull Context context) {
        return Settings.System.getIntForUser(context.getContentResolver(), "touchpad_tap_dragging", 0, -2) == 1;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setTouchpadTapDragging(@NonNull Context context, boolean enabled) {
        Settings.System.putIntForUser(context.getContentResolver(), "touchpad_tap_dragging", enabled ? 1 : 0, -2);
    }

    public static boolean useTouchpadRightClickZone(@NonNull Context context) {
        return Settings.System.getIntForUser(context.getContentResolver(), "touchpad_right_click_zone", 0, -2) == 1;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setTouchpadRightClickZone(@NonNull Context context, boolean enabled) {
        Settings.System.putIntForUser(context.getContentResolver(), "touchpad_right_click_zone", enabled ? 1 : 0, -2);
    }

    public static boolean useTouchpadThreeFingerTapShortcut(@NonNull Context context) {
        int customizedShortcut = Settings.System.getIntForUser(context.getContentResolver(), "touchpad_three_finger_tap_customization", 0, -2);
        return customizedShortcut != 0 && InputSettings.isTouchpadThreeFingerTapShortcutFeatureFlagEnabled();
    }

    public static boolean useTouchpadSystemGestures(@NonNull Context context) {
        if (!InputSettings.isTouchpadSystemGestureDisableFeatureFlagEnabled()) {
            return true;
        }
        return Settings.System.getIntForUser(context.getContentResolver(), "touchpad_system_gestures", 1, -2) == 1;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setTouchpadSystemGesturesEnabled(@NonNull Context context, boolean enabled) {
        if (!InputSettings.isTouchpadSystemGestureDisableFeatureFlagEnabled()) {
            return;
        }
        Settings.System.putIntForUser(context.getContentResolver(), "touchpad_system_gestures", enabled ? 1 : 0, -2);
    }

    public static boolean isStylusPointerIconEnabled(@NonNull Context context, boolean forceReloadSetting) {
        if (InputProperties.force_enable_stylus_pointer_icon().orElse(false).booleanValue()) {
            return true;
        }
        if (!context.getResources().getBoolean(17891731)) {
            return false;
        }
        if (forceReloadSetting) {
            return Settings.Secure.getIntForUser(context.getContentResolver(), "stylus_pointer_icon_enabled", 1, -3) != 0;
        }
        return AppGlobals.getIntCoreSetting("stylus_pointer_icon_enabled", 1) != 0;
    }

    public static boolean isStylusPointerIconEnabled(@NonNull Context context) {
        return InputSettings.isStylusPointerIconEnabled(context, false);
    }

    public static boolean isMouseScrollingAccelerationEnabled(@NonNull Context context) {
        if (!InputSettings.isMouseScrollingAccelerationFeatureFlagEnabled()) {
            return true;
        }
        return Settings.System.getIntForUser(context.getContentResolver(), "mouse_scrolling_acceleration", 0, -2) != 0;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setMouseScrollingAcceleration(@NonNull Context context, boolean scrollingAcceleration) {
        if (!InputSettings.isMouseScrollingAccelerationFeatureFlagEnabled()) {
            return;
        }
        Settings.System.putIntForUser(context.getContentResolver(), "mouse_scrolling_acceleration", scrollingAcceleration ? 1 : 0, -2);
    }

    public static int getMouseScrollingSpeed(@NonNull Context context) {
        if (!InputSettings.isMouseScrollingAccelerationFeatureFlagEnabled()) {
            return 0;
        }
        return Settings.System.getIntForUser(context.getContentResolver(), "mouse_scrolling_speed", 0, -2);
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setMouseScrollingSpeed(@NonNull Context context, int speed) {
        if (InputSettings.isMouseScrollingAccelerationEnabled(context)) {
            return;
        }
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        Settings.System.putIntForUser(context.getContentResolver(), "mouse_scrolling_speed", speed, -2);
    }

    public static boolean isMouseReverseVerticalScrollingEnabled(@NonNull Context context) {
        if (!InputSettings.isMouseReverseVerticalScrollingFeatureFlagEnabled()) {
            return false;
        }
        return Settings.System.getIntForUser(context.getContentResolver(), "mouse_reverse_vertical_scrolling", 0, -2) != 0;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setMouseReverseVerticalScrolling(@NonNull Context context, boolean reverseScrolling) {
        if (!InputSettings.isMouseReverseVerticalScrollingFeatureFlagEnabled()) {
            return;
        }
        Settings.System.putIntForUser(context.getContentResolver(), "mouse_reverse_vertical_scrolling", reverseScrolling ? 1 : 0, -2);
    }

    public static boolean isMouseSwapPrimaryButtonEnabled(@NonNull Context context) {
        if (!InputSettings.isMouseSwapPrimaryButtonFeatureFlagEnabled()) {
            return false;
        }
        return Settings.System.getIntForUser(context.getContentResolver(), "mouse_swap_primary_button", 0, -2) != 0;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setMouseSwapPrimaryButton(@NonNull Context context, boolean swapPrimaryButton) {
        if (!InputSettings.isMouseSwapPrimaryButtonFeatureFlagEnabled()) {
            return;
        }
        Settings.System.putIntForUser(context.getContentResolver(), "mouse_swap_primary_button", swapPrimaryButton ? 1 : 0, -2);
    }

    public static boolean isMousePointerAccelerationEnabled(@NonNull Context context) {
        if (!InputSettings.isPointerAccelerationFeatureFlagEnabled()) {
            return true;
        }
        return Settings.System.getIntForUser(context.getContentResolver(), "mouse_pointer_acceleration_enabled", 1, -2) == 1;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setMouseAccelerationEnabled(@NonNull Context context, boolean enabled) {
        if (!InputSettings.isPointerAccelerationFeatureFlagEnabled()) {
            return;
        }
        Settings.System.putIntForUser(context.getContentResolver(), "mouse_pointer_acceleration_enabled", enabled ? 1 : 0, -2);
    }

    public static boolean isAccessibilityBounceKeysEnabled(@NonNull Context context) {
        return InputSettings.getAccessibilityBounceKeysThreshold(context) != 0;
    }

    public static int getAccessibilityBounceKeysThreshold(@NonNull Context context) {
        return Settings.Secure.getIntForUser(context.getContentResolver(), "accessibility_bounce_keys", 0, -2);
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setAccessibilityBounceKeysThreshold(@NonNull Context context, int thresholdTimeMillis) {
        if (thresholdTimeMillis < 0 || thresholdTimeMillis > 5000) {
            throw new IllegalArgumentException("Provided Bounce keys threshold should be in range [0, 5000]");
        }
        Settings.Secure.putIntForUser(context.getContentResolver(), "accessibility_bounce_keys", thresholdTimeMillis, -2);
    }

    public static boolean isAccessibilitySlowKeysEnabled(@NonNull Context context) {
        return InputSettings.getAccessibilitySlowKeysThreshold(context) != 0;
    }

    public static int getAccessibilitySlowKeysThreshold(@NonNull Context context) {
        return Settings.Secure.getIntForUser(context.getContentResolver(), "accessibility_slow_keys", 0, -2);
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setAccessibilitySlowKeysThreshold(@NonNull Context context, int thresholdTimeMillis) {
        if (thresholdTimeMillis < 0 || thresholdTimeMillis > 5000) {
            throw new IllegalArgumentException("Provided Slow keys threshold should be in range [0, 5000]");
        }
        Settings.Secure.putIntForUser(context.getContentResolver(), "accessibility_slow_keys", thresholdTimeMillis, -2);
    }

    public static boolean isAccessibilityStickyKeysEnabled(@NonNull Context context) {
        return Settings.Secure.getIntForUser(context.getContentResolver(), "accessibility_sticky_keys", 0, -2) != 0;
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setAccessibilityStickyKeysEnabled(@NonNull Context context, boolean enabled) {
        Settings.Secure.putIntForUser(context.getContentResolver(), "accessibility_sticky_keys", enabled ? 1 : 0, -2);
    }

    public static boolean isAccessibilityMouseKeysFeatureFlagEnabled() {
        return Flags.keyboardA11yMouseKeys();
    }

    @FlaggedApi(value="com.android.hardware.input.keyboard_a11y_mouse_keys")
    public static boolean isAccessibilityMouseKeysEnabled(@NonNull Context context) {
        if (!InputSettings.isAccessibilityMouseKeysFeatureFlagEnabled()) {
            return false;
        }
        return Settings.Secure.getIntForUser(context.getContentResolver(), "accessibility_mouse_keys_enabled", 0, -2) != 0;
    }

    @FlaggedApi(value="com.android.hardware.input.keyboard_a11y_mouse_keys")
    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setAccessibilityMouseKeysEnabled(@NonNull Context context, boolean enabled) {
        if (!InputSettings.isAccessibilityMouseKeysFeatureFlagEnabled()) {
            return;
        }
        Settings.Secure.putIntForUser(context.getContentResolver(), "accessibility_mouse_keys_enabled", enabled ? 1 : 0, -2);
    }

    @FlaggedApi(value="com.android.hardware.input.keyboard_a11y_mouse_keys")
    public static float getAccessibilityMouseKeysAcceleration(@NonNull Context context) {
        if (!InputSettings.isAccessibilityMouseKeysFeatureFlagEnabled()) {
            return 0.0f;
        }
        return Settings.Secure.getFloatForUser(context.getContentResolver(), "accessibility_mouse_keys_acceleration", 0.2f, -2);
    }

    @FlaggedApi(value="com.android.hardware.input.keyboard_a11y_mouse_keys")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public static void setAccessibilityMouseKeysAcceleration(@NonNull Context context, float acceleration) {
        if (!InputSettings.isAccessibilityMouseKeysFeatureFlagEnabled()) {
            return;
        }
        Settings.Secure.putFloatForUser(context.getContentResolver(), "accessibility_mouse_keys_acceleration", acceleration, -2);
    }

    @FlaggedApi(value="com.android.hardware.input.keyboard_a11y_mouse_keys")
    public static int getAccessibilityMouseKeysMaxSpeed(@NonNull Context context) {
        if (!InputSettings.isAccessibilityMouseKeysFeatureFlagEnabled()) {
            return 0;
        }
        return Settings.Secure.getIntForUser(context.getContentResolver(), "accessibility_mouse_keys_max_speed", 5, -2);
    }

    @FlaggedApi(value="com.android.hardware.input.keyboard_a11y_mouse_keys")
    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setAccessibilityMouseKeysMaxSpeed(@NonNull Context context, int maxSpeed) {
        if (!InputSettings.isAccessibilityMouseKeysFeatureFlagEnabled()) {
            return;
        }
        Settings.Secure.putIntForUser(context.getContentResolver(), "accessibility_mouse_keys_max_speed", maxSpeed, -2);
    }

    @FlaggedApi(value="com.android.hardware.input.keyboard_a11y_mouse_keys")
    public static boolean isPrimaryKeysForMouseKeysEnabled(@NonNull Context context) {
        if (!InputSettings.isAccessibilityMouseKeysFeatureFlagEnabled()) {
            return false;
        }
        return Settings.Secure.getIntForUser(context.getContentResolver(), "accessibility_mouse_keys_use_primary_keys", 1, -2) != 0;
    }

    @FlaggedApi(value="com.android.hardware.input.keyboard_a11y_mouse_keys")
    public static void setPrimaryKeysForMouseKeysEnabled(@NonNull Context context, boolean enabled) {
        if (!InputSettings.isAccessibilityMouseKeysFeatureFlagEnabled()) {
            return;
        }
        Settings.Secure.putIntForUser(context.getContentResolver(), "accessibility_mouse_keys_use_primary_keys", enabled ? 1 : 0, -2);
    }

    public static boolean isRepeatKeysFeatureFlagEnabled() {
        return com.android.internal.hidden_from_bootclasspath.com.android.input.flags.Flags.keyboardRepeatKeys();
    }

    @FlaggedApi(value="com.android.input.flags.keyboard_repeat_keys")
    public static boolean isRepeatKeysEnabled(@NonNull Context context) {
        if (!InputSettings.isRepeatKeysFeatureFlagEnabled()) {
            return true;
        }
        return Settings.Secure.getIntForUser(context.getContentResolver(), "key_repeat_enabled", 1, -2) != 0;
    }

    @FlaggedApi(value="com.android.input.flags.keyboard_repeat_keys")
    public static int getRepeatKeysTimeout(@NonNull Context context) {
        if (!InputSettings.isRepeatKeysFeatureFlagEnabled()) {
            return ViewConfiguration.getKeyRepeatTimeout();
        }
        return Settings.Secure.getIntForUser(context.getContentResolver(), "key_repeat_timeout", ViewConfiguration.getKeyRepeatTimeout(), -2);
    }

    @FlaggedApi(value="com.android.input.flags.keyboard_repeat_keys")
    public static int getRepeatKeysDelay(@NonNull Context context) {
        if (!InputSettings.isRepeatKeysFeatureFlagEnabled()) {
            return ViewConfiguration.getKeyRepeatDelay();
        }
        return Settings.Secure.getIntForUser(context.getContentResolver(), "key_repeat_delay", ViewConfiguration.getKeyRepeatDelay(), -2);
    }

    @FlaggedApi(value="com.android.input.flags.keyboard_repeat_keys")
    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setRepeatKeysEnabled(@NonNull Context context, boolean enabled) {
        if (!InputSettings.isRepeatKeysFeatureFlagEnabled()) {
            return;
        }
        Settings.Secure.putIntForUser(context.getContentResolver(), "key_repeat_enabled", enabled ? 1 : 0, -2);
    }

    @FlaggedApi(value="com.android.input.flags.keyboard_repeat_keys")
    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setRepeatKeysTimeout(@NonNull Context context, int timeoutTimeMillis) {
        if (!InputSettings.isRepeatKeysFeatureFlagEnabled() && !InputSettings.isRepeatKeysEnabled(context)) {
            return;
        }
        if (timeoutTimeMillis < 150 || timeoutTimeMillis > 2000) {
            throw new IllegalArgumentException("Provided repeat keys timeout should be in range (150,2000)");
        }
        Settings.Secure.putIntForUser(context.getContentResolver(), "key_repeat_timeout", timeoutTimeMillis, -2);
    }

    @FlaggedApi(value="com.android.input.flags.keyboard_repeat_keys")
    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void setRepeatKeysDelay(@NonNull Context context, int delayTimeMillis) {
        if (!InputSettings.isRepeatKeysFeatureFlagEnabled() && !InputSettings.isRepeatKeysEnabled(context)) {
            return;
        }
        if (delayTimeMillis < 20 || delayTimeMillis > 2000) {
            throw new IllegalArgumentException("Provided repeat keys delay should be in range (20,2000)");
        }
        Settings.Secure.putIntForUser(context.getContentResolver(), "key_repeat_delay", delayTimeMillis, -2);
    }

    public static boolean isCustomizableInputGesturesFeatureFlagEnabled() {
        return Flags.enableCustomizableInputGestures();
    }
}

