/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.hardware.BatteryState;
import android.hardware.input.AidlInputGestureData;
import android.hardware.input.HostUsiVersion;
import android.hardware.input.IInputManager;
import android.hardware.input.InputDeviceIdentifier;
import android.hardware.input.InputDeviceVibrator;
import android.hardware.input.InputGestureData;
import android.hardware.input.InputManagerGlobal;
import android.hardware.input.InputSettings;
import android.hardware.input.KeyGestureEvent;
import android.hardware.input.KeyGlyphMap;
import android.hardware.input.KeyboardBacklightState;
import android.hardware.input.KeyboardLayout;
import android.hardware.input.KeyboardLayoutPreviewDrawable;
import android.hardware.input.KeyboardLayoutSelectionResult;
import android.hardware.input.PhysicalKeyLayout;
import android.hardware.input.StickyModifierState;
import android.hardware.input.TouchCalibration;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.Vibrator;
import android.util.Log;
import android.view.Display;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputMonitor;
import android.view.PointerIcon;
import android.view.VerifiedInputEvent;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.hidden_from_bootclasspath.com.android.hardware.input.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class InputManager {
    private static final String TAG = "InputManager";
    private static final boolean DEBUG = Log.isLoggable("InputManager", 3);
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final IInputManager mIm;
    @Nullable
    private Boolean mIsStylusPointerIconEnabled = null;
    public static final String ACTION_QUERY_KEYBOARD_LAYOUTS = "android.hardware.input.action.QUERY_KEYBOARD_LAYOUTS";
    public static final String META_DATA_KEYBOARD_LAYOUTS = "android.hardware.input.metadata.KEYBOARD_LAYOUTS";
    public static final String ACTION_QUERY_KEYBOARD_GLYPH_MAPS = "android.hardware.input.action.QUERY_KEYBOARD_GLYPH_MAPS";
    public static final String META_DATA_KEYBOARD_GLYPH_MAPS = "android.hardware.input.metadata.KEYBOARD_GLYPH_MAPS";
    public static final long BLOCK_UNTRUSTED_TOUCHES = 158002302L;
    public static final int INJECT_INPUT_EVENT_MODE_ASYNC = 0;
    public static final int INJECT_INPUT_EVENT_MODE_WAIT_FOR_RESULT = 1;
    @UnsupportedAppUsage(trackingBug=171972397L)
    public static final int INJECT_INPUT_EVENT_MODE_WAIT_FOR_FINISH = 2;
    public static final int CUSTOM_INPUT_GESTURE_RESULT_SUCCESS = 1;
    public static final int CUSTOM_INPUT_GESTURE_RESULT_ERROR_ALREADY_EXISTS = 2;
    public static final int CUSTOM_INPUT_GESTURE_RESULT_ERROR_DOES_NOT_EXIST = 3;
    public static final int CUSTOM_INPUT_GESTURE_RESULT_ERROR_RESERVED_GESTURE = 4;
    public static final int CUSTOM_INPUT_GESTURE_RESULT_ERROR_OTHER = 5;
    public static final int SWITCH_STATE_UNKNOWN = -1;
    public static final int SWITCH_STATE_OFF = 0;
    public static final int SWITCH_STATE_ON = 1;
    private final InputManagerGlobal mGlobal = InputManagerGlobal.getInstance();
    private final Context mContext;

    public InputManager(Context context) {
        this.mIm = this.mGlobal.getInputManagerService();
        this.mContext = context;
    }

    @Deprecated
    @UnsupportedAppUsage
    public static InputManager getInstance() {
        return Objects.requireNonNull(ActivityThread.currentApplication()).getSystemService(InputManager.class);
    }

    public String getVelocityTrackerStrategy() {
        return this.mGlobal.getVelocityTrackerStrategy();
    }

    @Nullable
    public InputDevice getInputDevice(int id2) {
        return this.mGlobal.getInputDevice(id2);
    }

    @FlaggedApi(value="com.android.input.flags.input_device_view_behavior_api")
    @Nullable
    public InputDevice.ViewBehavior getInputDeviceViewBehavior(int deviceId) {
        InputDevice device = this.getInputDevice(deviceId);
        return device == null ? null : device.getViewBehavior();
    }

    public InputDevice getInputDeviceByDescriptor(String descriptor) {
        return this.mGlobal.getInputDeviceByDescriptor(descriptor);
    }

    public int[] getInputDeviceIds() {
        return this.mGlobal.getInputDeviceIds();
    }

    public void enableInputDevice(int id2) {
        this.mGlobal.enableInputDevice(id2);
    }

    public void disableInputDevice(int id2) {
        this.mGlobal.disableInputDevice(id2);
    }

    public void registerInputDeviceListener(InputDeviceListener listener, Handler handler) {
        this.mGlobal.registerInputDeviceListener(listener, handler);
    }

    public void unregisterInputDeviceListener(InputDeviceListener listener) {
        this.mGlobal.unregisterInputDeviceListener(listener);
    }

    public int isInTabletMode() {
        try {
            return this.mIm.isInTabletMode();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void registerOnTabletModeChangedListener(OnTabletModeChangedListener listener, Handler handler) {
        this.mGlobal.registerOnTabletModeChangedListener(listener, handler);
    }

    public void unregisterOnTabletModeChangedListener(OnTabletModeChangedListener listener) {
        this.mGlobal.unregisterOnTabletModeChangedListener(listener);
    }

    public int isMicMuted() {
        try {
            return this.mIm.isMicMuted();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public KeyboardLayout[] getKeyboardLayouts() {
        try {
            return this.mIm.getKeyboardLayouts();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @NonNull
    @SuppressLint(value={"UnflaggedApi"})
    public List<String> getKeyboardLayoutDescriptors() {
        KeyboardLayout[] layouts = this.getKeyboardLayouts();
        ArrayList<String> res = new ArrayList<String>();
        for (KeyboardLayout kl : layouts) {
            res.add(kl.getDescriptor());
        }
        return res;
    }

    @NonNull
    public String getKeyboardLayoutTypeForLayoutDescriptor(@NonNull String layoutDescriptor) {
        KeyboardLayout layout2 = this.getKeyboardLayout(layoutDescriptor);
        return layout2 == null ? "" : layout2.getLayoutType();
    }

    @NonNull
    public KeyboardLayout[] getKeyboardLayoutsForInputDevice(@NonNull InputDeviceIdentifier identifier) {
        return new KeyboardLayout[0];
    }

    @Nullable
    public KeyboardLayout getKeyboardLayout(String keyboardLayoutDescriptor) {
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            return this.mIm.getKeyboardLayout(keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @Nullable
    public String getCurrentKeyboardLayoutForInputDevice(@NonNull InputDeviceIdentifier identifier) {
        return null;
    }

    public void setCurrentKeyboardLayoutForInputDevice(@NonNull InputDeviceIdentifier identifier, @NonNull String keyboardLayoutDescriptor) {
    }

    public String[] getEnabledKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) {
        return new String[0];
    }

    public void addKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
    }

    @RequiresPermission(value="android.permission.SET_KEYBOARD_LAYOUT")
    public void removeKeyboardLayoutForInputDevice(@NonNull InputDeviceIdentifier identifier, @NonNull String keyboardLayoutDescriptor) {
    }

    @RequiresPermission(value="android.permission.REMAP_MODIFIER_KEYS")
    public void remapModifierKey(int fromKey, int toKey) {
        try {
            this.mIm.remapModifierKey(fromKey, toKey);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REMAP_MODIFIER_KEYS")
    public void clearAllModifierKeyRemappings() {
        try {
            this.mIm.clearAllModifierKeyRemappings();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @NonNull
    @RequiresPermission(value="android.permission.REMAP_MODIFIER_KEYS")
    public Map<Integer, Integer> getModifierKeyRemapping() {
        try {
            return this.mIm.getModifierKeyRemapping();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public TouchCalibration getTouchCalibration(String inputDeviceDescriptor, int surfaceRotation) {
        try {
            return this.mIm.getTouchCalibrationForInputDevice(inputDeviceDescriptor, surfaceRotation);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void setTouchCalibration(String inputDeviceDescriptor, int surfaceRotation, TouchCalibration calibration) {
        try {
            this.mIm.setTouchCalibrationForInputDevice(inputDeviceDescriptor, surfaceRotation, calibration);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @NonNull
    public KeyboardLayoutSelectionResult getKeyboardLayoutForInputDevice(@NonNull InputDeviceIdentifier identifier, int userId, @NonNull InputMethodInfo imeInfo, @Nullable InputMethodSubtype imeSubtype) {
        try {
            return this.mIm.getKeyboardLayoutForInputDevice(identifier, userId, imeInfo, imeSubtype);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SET_KEYBOARD_LAYOUT")
    public void setKeyboardLayoutForInputDevice(@NonNull InputDeviceIdentifier identifier, int userId, @NonNull InputMethodInfo imeInfo, @Nullable InputMethodSubtype imeSubtype, @NonNull String keyboardLayoutDescriptor) {
        if (identifier == null) {
            throw new IllegalArgumentException("identifier must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.setKeyboardLayoutForInputDevice(identifier, userId, imeInfo, imeSubtype, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public KeyboardLayout[] getKeyboardLayoutListForInputDevice(InputDeviceIdentifier identifier, int userId, @NonNull InputMethodInfo imeInfo, @Nullable InputMethodSubtype imeSubtype) {
        if (identifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        try {
            return this.mIm.getKeyboardLayoutListForInputDevice(identifier, userId, imeInfo, imeSubtype);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    public int getMousePointerSpeed() {
        try {
            return this.mIm.getMousePointerSpeed();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void tryPointerSpeed(int speed) {
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        try {
            this.mIm.tryPointerSpeed(speed);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public float getMaximumObscuringOpacityForTouch() {
        return InputSettings.getMaximumObscuringOpacityForTouch(this.mContext);
    }

    public boolean[] deviceHasKeys(int[] keyCodes) {
        return this.deviceHasKeys(-1, keyCodes);
    }

    public boolean[] deviceHasKeys(int id2, int[] keyCodes) {
        return this.mGlobal.deviceHasKeys(id2, keyCodes);
    }

    public int getKeyCodeForKeyLocation(int deviceId, int locationKeyCode) {
        return this.mGlobal.getKeyCodeForKeyLocation(deviceId, locationKeyCode);
    }

    @Nullable
    public Drawable getKeyboardLayoutPreview(@Nullable KeyboardLayout keyboardLayout, int width, int height) {
        PhysicalKeyLayout keyLayout = new PhysicalKeyLayout(this.mGlobal.getKeyCharacterMap(keyboardLayout), keyboardLayout);
        return new KeyboardLayoutPreviewDrawable(this.mContext, keyLayout, width, height);
    }

    @Nullable
    public KeyGlyphMap getKeyGlyphMap(int deviceId) {
        if (!Flags.keyboardGlyphMap()) {
            return null;
        }
        try {
            return this.mIm.getKeyGlyphMap(deviceId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INJECT_EVENTS")
    public boolean injectInputEvent(InputEvent event, int mode, int targetUid) {
        return this.mGlobal.injectInputEvent(event, mode, targetUid);
    }

    @RequiresPermission(value="android.permission.INJECT_EVENTS")
    @UnsupportedAppUsage
    public boolean injectInputEvent(InputEvent event, int mode) {
        return this.mGlobal.injectInputEvent(event, mode);
    }

    @Nullable
    public VerifiedInputEvent verifyInputEvent(@NonNull InputEvent event) {
        try {
            return this.mIm.verifyInputEvent(event);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void setPointerIconType(int iconId) {
        Log.e(TAG, "setPointerIcon: Unsupported app usage!");
    }

    public boolean setPointerIcon(PointerIcon icon, int displayId, int deviceId, int pointerId, IBinder inputToken) {
        return this.mGlobal.setPointerIcon(icon, displayId, deviceId, pointerId, inputToken);
    }

    public boolean isStylusPointerIconEnabled() {
        if (this.mIsStylusPointerIconEnabled == null) {
            this.mIsStylusPointerIconEnabled = InputSettings.isStylusPointerIconEnabled(this.mContext);
        }
        return this.mIsStylusPointerIconEnabled;
    }

    public void requestPointerCapture(IBinder windowToken, boolean enable) {
        this.mGlobal.requestPointerCapture(windowToken, enable);
    }

    @Deprecated
    public InputMonitor monitorGestureInput(String name, int displayId) {
        return this.mGlobal.monitorGestureInput(name, displayId);
    }

    @RequiresPermission(value="android.permission.ASSOCIATE_INPUT_DEVICE_TO_DISPLAY")
    public void addPortAssociation(@NonNull String inputPort, int displayPort) {
        try {
            this.mIm.addPortAssociation(inputPort, displayPort);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ASSOCIATE_INPUT_DEVICE_TO_DISPLAY")
    public void removePortAssociation(@NonNull String inputPort) {
        try {
            this.mIm.removePortAssociation(inputPort);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ASSOCIATE_INPUT_DEVICE_TO_DISPLAY")
    public void addUniqueIdAssociationByPort(@NonNull String inputPort, @NonNull String displayUniqueId) {
        this.mGlobal.addUniqueIdAssociationByPort(inputPort, displayUniqueId);
    }

    @RequiresPermission(value="android.permission.ASSOCIATE_INPUT_DEVICE_TO_DISPLAY")
    public void removeUniqueIdAssociationByPort(@NonNull String inputPort) {
        this.mGlobal.removeUniqueIdAssociationByPort(inputPort);
    }

    @FlaggedApi(value="com.android.input.flags.device_associations")
    @RequiresPermission(value="android.permission.ASSOCIATE_INPUT_DEVICE_TO_DISPLAY")
    public void addUniqueIdAssociationByDescriptor(@NonNull String inputDeviceDescriptor, @NonNull String displayUniqueId) {
        this.mGlobal.addUniqueIdAssociationByDescriptor(inputDeviceDescriptor, displayUniqueId);
    }

    @FlaggedApi(value="com.android.input.flags.device_associations")
    @RequiresPermission(value="android.permission.ASSOCIATE_INPUT_DEVICE_TO_DISPLAY")
    public void removeUniqueIdAssociationByDescriptor(@NonNull String inputDeviceDescriptor) {
        this.mGlobal.removeUniqueIdAssociationByDescriptor(inputDeviceDescriptor);
    }

    @Nullable
    public HostUsiVersion getHostUsiVersion(@NonNull Display display) {
        return this.mGlobal.getHostUsiVersion(display);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH")
    @Nullable
    public String getInputDeviceBluetoothAddress(int deviceId) {
        return this.mGlobal.getInputDeviceBluetoothAddress(deviceId);
    }

    public Vibrator getInputDeviceVibrator(int deviceId, int vibratorId) {
        return new InputDeviceVibrator(deviceId, vibratorId);
    }

    public void cancelCurrentTouch() {
        this.mGlobal.cancelCurrentTouch();
    }

    @RequiresPermission(value="android.permission.MONITOR_INPUT")
    public void pilferPointers(IBinder inputChannelToken) {
        this.mGlobal.pilferPointers(inputChannelToken);
    }

    public void addInputDeviceBatteryListener(int deviceId, @NonNull Executor executor, @NonNull InputDeviceBatteryListener listener) {
        this.mGlobal.addInputDeviceBatteryListener(deviceId, executor, listener);
    }

    public void removeInputDeviceBatteryListener(int deviceId, @NonNull InputDeviceBatteryListener listener) {
        this.mGlobal.removeInputDeviceBatteryListener(deviceId, listener);
    }

    public boolean areTouchpadGesturesAvailable(@NonNull Context context) {
        return true;
    }

    @RequiresPermission(value="android.permission.MONITOR_KEYBOARD_BACKLIGHT")
    public void registerKeyboardBacklightListener(@NonNull Executor executor, @NonNull KeyboardBacklightListener listener) throws IllegalArgumentException {
        this.mGlobal.registerKeyboardBacklightListener(executor, listener);
    }

    @RequiresPermission(value="android.permission.MONITOR_KEYBOARD_BACKLIGHT")
    public void unregisterKeyboardBacklightListener(@NonNull KeyboardBacklightListener listener) {
        this.mGlobal.unregisterKeyboardBacklightListener(listener);
    }

    @RequiresPermission(value="android.permission.MONITOR_STICKY_MODIFIER_STATE")
    public void registerStickyModifierStateListener(@NonNull Executor executor, @NonNull StickyModifierStateListener listener) throws IllegalArgumentException {
        this.mGlobal.registerStickyModifierStateListener(executor, listener);
    }

    @RequiresPermission(value="android.permission.MONITOR_STICKY_MODIFIER_STATE")
    public void unregisterStickyModifierStateListener(@NonNull StickyModifierStateListener listener) {
        this.mGlobal.unregisterStickyModifierStateListener(listener);
    }

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public void registerKeyGestureEventListener(@NonNull Executor executor, @NonNull KeyGestureEventListener listener) throws IllegalArgumentException {
        this.mGlobal.registerKeyGestureEventListener(executor, listener);
    }

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public void unregisterKeyGestureEventListener(@NonNull KeyGestureEventListener listener) {
        this.mGlobal.unregisterKeyGestureEventListener(listener);
    }

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public void registerKeyGestureEventHandler(List<Integer> keyGesturesToHandle, @NonNull KeyGestureEventHandler handler) throws IllegalArgumentException {
        this.mGlobal.registerKeyGestureEventHandler(keyGesturesToHandle, handler);
    }

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public void unregisterKeyGestureEventHandler(@NonNull KeyGestureEventHandler handler) {
        this.mGlobal.unregisterKeyGestureEventHandler(handler);
    }

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    @Nullable
    public InputGestureData getInputGesture(@NonNull InputGestureData.Trigger trigger) {
        try {
            AidlInputGestureData result = this.mIm.getInputGesture(this.mContext.getUserId(), trigger.getAidlTrigger());
            if (result == null) {
                return null;
            }
            return new InputGestureData(result);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public int addCustomInputGesture(@NonNull InputGestureData inputGestureData) {
        if (!Flags.enableCustomizableInputGestures()) {
            return 5;
        }
        try {
            return this.mIm.addCustomInputGesture(this.mContext.getUserId(), inputGestureData.getAidlData());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public int removeCustomInputGesture(@NonNull InputGestureData inputGestureData) {
        if (!Flags.enableCustomizableInputGestures()) {
            return 5;
        }
        try {
            return this.mIm.removeCustomInputGesture(this.mContext.getUserId(), inputGestureData.getAidlData());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public void removeAllCustomInputGestures(@Nullable InputGestureData.Filter filter) {
        if (!Flags.enableCustomizableInputGestures()) {
            return;
        }
        try {
            this.mIm.removeAllCustomInputGestures(this.mContext.getUserId(), filter == null ? -1 : filter.getTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<InputGestureData> getCustomInputGestures(@Nullable InputGestureData.Filter filter) {
        ArrayList<InputGestureData> result = new ArrayList<InputGestureData>();
        if (!Flags.enableCustomizableInputGestures()) {
            return result;
        }
        try {
            for (AidlInputGestureData data : this.mIm.getCustomInputGestures(this.mContext.getUserId(), filter == null ? -1 : filter.getTag())) {
                result.add(new InputGestureData(data));
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    public List<InputGestureData> getAppLaunchBookmarks() {
        try {
            ArrayList<InputGestureData> result = new ArrayList<InputGestureData>();
            for (AidlInputGestureData data : this.mIm.getAppLaunchBookmarks()) {
                result.add(new InputGestureData(data));
            }
            return result;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    public void resetLockedModifierState() {
        try {
            this.mIm.resetLockedModifierState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    @RequiresPermission(value="android.permission.SET_POINTER_SPEED")
    public void setMouseScalingEnabled(boolean enabled, int displayId) {
        try {
            this.mIm.setMouseScalingEnabled(enabled, displayId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    @RequiresPermission(value="android.permission.INJECT_EVENTS")
    @Nullable
    public PointF getCursorPosition(int displayId) {
        try {
            return this.mIm.getCursorPosition(displayId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.LISTEN_FOR_KEY_ACTIVITY")
    public boolean registerKeyEventActivityListener(@NonNull KeyEventActivityListener listener) {
        return this.mGlobal.registerKeyEventActivityListener(listener);
    }

    @RequiresPermission(value="android.permission.LISTEN_FOR_KEY_ACTIVITY")
    public boolean unregisterKeyEventActivityListener(@NonNull KeyEventActivityListener listener) {
        return this.mGlobal.unregisterKeyEventActivityListener(listener);
    }

    public static interface InputDeviceListener {
        public void onInputDeviceAdded(int var1);

        public void onInputDeviceRemoved(int var1);

        public void onInputDeviceChanged(int var1);
    }

    public static interface OnTabletModeChangedListener {
        public void onTabletModeChanged(long var1, boolean var3);
    }

    public static interface InputDeviceBatteryListener {
        public void onBatteryStateChanged(int var1, long var2, @NonNull BatteryState var4);
    }

    public static interface KeyboardBacklightListener {
        public void onKeyboardBacklightChanged(int var1, @NonNull KeyboardBacklightState var2, boolean var3);
    }

    public static interface StickyModifierStateListener {
        public void onStickyModifierStateChanged(@NonNull StickyModifierState var1);
    }

    public static interface KeyGestureEventListener {
        public void onKeyGestureEvent(@NonNull KeyGestureEvent var1);
    }

    public static interface KeyGestureEventHandler {
        public void handleKeyGestureEvent(@NonNull KeyGestureEvent var1, @Nullable IBinder var2);
    }

    public static interface KeyEventActivityListener {
        public void onKeyEventActivity();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CustomInputGestureResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RemappableModifierKey {
        public static final int REMAPPABLE_MODIFIER_KEY_CTRL_LEFT = 113;
        public static final int REMAPPABLE_MODIFIER_KEY_CTRL_RIGHT = 114;
        public static final int REMAPPABLE_MODIFIER_KEY_META_LEFT = 117;
        public static final int REMAPPABLE_MODIFIER_KEY_META_RIGHT = 118;
        public static final int REMAPPABLE_MODIFIER_KEY_ALT_LEFT = 57;
        public static final int REMAPPABLE_MODIFIER_KEY_ALT_RIGHT = 58;
        public static final int REMAPPABLE_MODIFIER_KEY_SHIFT_LEFT = 59;
        public static final int REMAPPABLE_MODIFIER_KEY_SHIFT_RIGHT = 60;
        public static final int REMAPPABLE_MODIFIER_KEY_CAPS_LOCK = 115;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SwitchState {
    }
}

