/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.app.ActivityThread;
import android.app.Application;
import android.content.Context;
import android.hardware.input.InputManagerGlobal;
import android.os.Binder;
import android.os.IBinder;
import android.os.IVibratorStateListener;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.VibratorInfo;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import java.util.concurrent.Executor;

class InputDeviceVibrator
extends Vibrator {
    private static final String TAG = "InputDeviceVibrator";
    private final int mDeviceId;
    private final VibratorInfo mVibratorInfo;
    private final Binder mToken;
    private final InputManagerGlobal mGlobal;
    @GuardedBy(value={"mDelegates"})
    private final ArrayMap<Vibrator.OnVibratorStateChangedListener, OnVibratorStateChangedListenerDelegate> mDelegates = new ArrayMap();

    InputDeviceVibrator(int deviceId, int vibratorId) {
        this.mGlobal = InputManagerGlobal.getInstance();
        this.mDeviceId = deviceId;
        this.mVibratorInfo = new VibratorInfo.Builder(vibratorId).setCapabilities(4L).setSupportedEffects(new int[0]).setSupportedBraking(new int[0]).build();
        this.mToken = new Binder();
    }

    @Override
    public VibratorInfo getInfo() {
        return this.mVibratorInfo;
    }

    @Override
    public boolean hasVibrator() {
        return true;
    }

    @Override
    public boolean isVibrating() {
        return this.mGlobal.isVibrating(this.mDeviceId);
    }

    @Override
    public void addVibratorStateListener(@NonNull Vibrator.OnVibratorStateChangedListener listener) {
        Preconditions.checkNotNull(listener);
        Application context = ActivityThread.currentApplication();
        this.addVibratorStateListener(((Context)context).getMainExecutor(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVibratorStateListener(@NonNull Executor executor, @NonNull Vibrator.OnVibratorStateChangedListener listener) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        ArrayMap<Vibrator.OnVibratorStateChangedListener, OnVibratorStateChangedListenerDelegate> arrayMap = this.mDelegates;
        synchronized (arrayMap) {
            if (this.mDelegates.containsKey(listener)) {
                Log.w(TAG, "Listener already registered.");
                return;
            }
            OnVibratorStateChangedListenerDelegate delegate = new OnVibratorStateChangedListenerDelegate(this, listener, executor);
            if (!this.mGlobal.registerVibratorStateListener(this.mDeviceId, delegate)) {
                Log.w(TAG, "Failed to register vibrate state listener");
                return;
            }
            this.mDelegates.put(listener, delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVibratorStateListener(@NonNull Vibrator.OnVibratorStateChangedListener listener) {
        Preconditions.checkNotNull(listener);
        ArrayMap<Vibrator.OnVibratorStateChangedListener, OnVibratorStateChangedListenerDelegate> arrayMap = this.mDelegates;
        synchronized (arrayMap) {
            if (this.mDelegates.containsKey(listener)) {
                OnVibratorStateChangedListenerDelegate delegate = this.mDelegates.get(listener);
                if (!this.mGlobal.unregisterVibratorStateListener(this.mDeviceId, delegate)) {
                    Log.w(TAG, "Failed to unregister vibrate state listener");
                    return;
                }
                this.mDelegates.remove(listener);
            }
        }
    }

    @Override
    public boolean hasAmplitudeControl() {
        return this.mVibratorInfo.hasCapability(4L);
    }

    @Override
    public void vibrate(int uid, String opPkg, @NonNull VibrationEffect effect, String reason, @NonNull VibrationAttributes attributes) {
        this.mGlobal.vibrate(this.mDeviceId, effect, (IBinder)this.mToken);
    }

    @Override
    public void cancel() {
        this.mGlobal.cancelVibrate(this.mDeviceId, this.mToken);
    }

    @Override
    public void cancel(int usageFilter) {
        this.cancel();
    }

    private class OnVibratorStateChangedListenerDelegate
    extends IVibratorStateListener.Stub {
        private final Executor mExecutor;
        private final Vibrator.OnVibratorStateChangedListener mListener;

        OnVibratorStateChangedListenerDelegate(@NonNull InputDeviceVibrator inputDeviceVibrator, @NonNull Vibrator.OnVibratorStateChangedListener listener, Executor executor) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onVibrating(boolean isVibrating) {
            this.mExecutor.execute(() -> this.mListener.onVibratorStateChanged(isVibrating));
        }
    }
}

