/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.hardware.fingerprint.Fingerprint;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IFingerprintServiceReceiver
extends IInterface {
    public void onEnrollResult(Fingerprint var1, int var2) throws RemoteException;

    public void onAcquired(int var1, int var2) throws RemoteException;

    public void onAuthenticationSucceeded(Fingerprint var1, int var2, boolean var3) throws RemoteException;

    public void onFingerprintDetected(int var1, int var2, boolean var3) throws RemoteException;

    public void onAuthenticationFailed() throws RemoteException;

    public void onError(int var1, int var2) throws RemoteException;

    public void onRemoved(Fingerprint var1, int var2) throws RemoteException;

    public void onChallengeGenerated(int var1, int var2, long var3) throws RemoteException;

    public void onUdfpsPointerDown(int var1) throws RemoteException;

    public void onUdfpsPointerUp(int var1) throws RemoteException;

    public void onUdfpsOverlayShown() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IFingerprintServiceReceiver {
        public static final String DESCRIPTOR = "android.hardware.fingerprint.IFingerprintServiceReceiver";
        static final int TRANSACTION_onEnrollResult = 1;
        static final int TRANSACTION_onAcquired = 2;
        static final int TRANSACTION_onAuthenticationSucceeded = 3;
        static final int TRANSACTION_onFingerprintDetected = 4;
        static final int TRANSACTION_onAuthenticationFailed = 5;
        static final int TRANSACTION_onError = 6;
        static final int TRANSACTION_onRemoved = 7;
        static final int TRANSACTION_onChallengeGenerated = 8;
        static final int TRANSACTION_onUdfpsPointerDown = 9;
        static final int TRANSACTION_onUdfpsPointerUp = 10;
        static final int TRANSACTION_onUdfpsOverlayShown = 11;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IFingerprintServiceReceiver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IFingerprintServiceReceiver) {
                return (IFingerprintServiceReceiver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onEnrollResult";
                }
                case 2: {
                    return "onAcquired";
                }
                case 3: {
                    return "onAuthenticationSucceeded";
                }
                case 4: {
                    return "onFingerprintDetected";
                }
                case 5: {
                    return "onAuthenticationFailed";
                }
                case 6: {
                    return "onError";
                }
                case 7: {
                    return "onRemoved";
                }
                case 8: {
                    return "onChallengeGenerated";
                }
                case 9: {
                    return "onUdfpsPointerDown";
                }
                case 10: {
                    return "onUdfpsPointerUp";
                }
                case 11: {
                    return "onUdfpsOverlayShown";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    Fingerprint _arg0 = data.readTypedObject(Fingerprint.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onEnrollResult(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAcquired(_arg0, _arg1);
                    break;
                }
                case 3: {
                    Fingerprint _arg0 = data.readTypedObject(Fingerprint.CREATOR);
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onAuthenticationSucceeded(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onFingerprintDetected(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    this.onAuthenticationFailed();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onError(_arg0, _arg1);
                    break;
                }
                case 7: {
                    Fingerprint _arg0 = data.readTypedObject(Fingerprint.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRemoved(_arg0, _arg1);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onChallengeGenerated(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onUdfpsPointerDown(_arg0);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onUdfpsPointerUp(_arg0);
                    break;
                }
                case 11: {
                    this.onUdfpsOverlayShown();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 10;
        }

        private static class Proxy
        implements IFingerprintServiceReceiver {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnrollResult(Fingerprint fp, int remaining) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(fp, 0);
                    _data.writeInt(remaining);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAcquired(int acquiredInfo, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(acquiredInfo);
                    _data.writeInt(vendorCode);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationSucceeded(Fingerprint fp, int userId, boolean isStrongBiometric) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(fp, 0);
                    _data.writeInt(userId);
                    _data.writeBoolean(isStrongBiometric);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFingerprintDetected(int sensorId, int userId, boolean isStrongBiometric) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeBoolean(isStrongBiometric);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onAuthenticationFailed() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int error, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(error);
                    _data.writeInt(vendorCode);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoved(Fingerprint fp, int remaining) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(fp, 0);
                    _data.writeInt(remaining);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChallengeGenerated(int sensorId, int userId, long challenge) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeLong(challenge);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUdfpsPointerDown(int sensorId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUdfpsPointerUp(int sensorId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onUdfpsOverlayShown() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IFingerprintServiceReceiver {
        @Override
        public void onEnrollResult(Fingerprint fp, int remaining) throws RemoteException {
        }

        @Override
        public void onAcquired(int acquiredInfo, int vendorCode) throws RemoteException {
        }

        @Override
        public void onAuthenticationSucceeded(Fingerprint fp, int userId, boolean isStrongBiometric) throws RemoteException {
        }

        @Override
        public void onFingerprintDetected(int sensorId, int userId, boolean isStrongBiometric) throws RemoteException {
        }

        @Override
        public void onAuthenticationFailed() throws RemoteException {
        }

        @Override
        public void onError(int error, int vendorCode) throws RemoteException {
        }

        @Override
        public void onRemoved(Fingerprint fp, int remaining) throws RemoteException {
        }

        @Override
        public void onChallengeGenerated(int sensorId, int userId, long challenge) throws RemoteException {
        }

        @Override
        public void onUdfpsPointerDown(int sensorId) throws RemoteException {
        }

        @Override
        public void onUdfpsPointerUp(int sensorId) throws RemoteException {
        }

        @Override
        public void onUdfpsOverlayShown() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

