/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class BrightnessChangeEvent
implements Parcelable {
    public final float brightness;
    public final long timeStamp;
    public final String packageName;
    public final int userId;
    @NonNull
    public final String uniqueDisplayId;
    public final float[] luxValues;
    public final long[] luxTimestamps;
    public final float batteryLevel;
    public final float powerBrightnessFactor;
    public final boolean nightMode;
    public final int colorTemperature;
    public final boolean reduceBrightColors;
    public final int reduceBrightColorsStrength;
    public final float reduceBrightColorsOffset;
    public final float lastBrightness;
    public final boolean isDefaultBrightnessConfig;
    public final boolean isUserSetBrightness;
    @Nullable
    public final long[] colorValueBuckets;
    public final long colorSampleDuration;
    @NonNull
    public static final Parcelable.Creator<BrightnessChangeEvent> CREATOR = new Parcelable.Creator<BrightnessChangeEvent>(){

        @Override
        public BrightnessChangeEvent createFromParcel(Parcel source) {
            return new BrightnessChangeEvent(source);
        }

        public BrightnessChangeEvent[] newArray(int size) {
            return new BrightnessChangeEvent[size];
        }
    };

    private BrightnessChangeEvent(float brightness, long timeStamp, String packageName, int userId, String uniqueDisplayId, float[] luxValues, long[] luxTimestamps, float batteryLevel, float powerBrightnessFactor, boolean nightMode, int colorTemperature, boolean reduceBrightColors, int reduceBrightColorsStrength, float reduceBrightColorsOffset, float lastBrightness, boolean isDefaultBrightnessConfig, boolean isUserSetBrightness, long[] colorValueBuckets, long colorSampleDuration) {
        this.brightness = brightness;
        this.timeStamp = timeStamp;
        this.packageName = packageName;
        this.userId = userId;
        this.uniqueDisplayId = uniqueDisplayId;
        this.luxValues = luxValues;
        this.luxTimestamps = luxTimestamps;
        this.batteryLevel = batteryLevel;
        this.powerBrightnessFactor = powerBrightnessFactor;
        this.nightMode = nightMode;
        this.colorTemperature = colorTemperature;
        this.reduceBrightColors = reduceBrightColors;
        this.reduceBrightColorsStrength = reduceBrightColorsStrength;
        this.reduceBrightColorsOffset = reduceBrightColorsOffset;
        this.lastBrightness = lastBrightness;
        this.isDefaultBrightnessConfig = isDefaultBrightnessConfig;
        this.isUserSetBrightness = isUserSetBrightness;
        this.colorValueBuckets = colorValueBuckets;
        this.colorSampleDuration = colorSampleDuration;
    }

    public BrightnessChangeEvent(BrightnessChangeEvent other, boolean redactPackage) {
        this.brightness = other.brightness;
        this.timeStamp = other.timeStamp;
        this.packageName = redactPackage ? null : other.packageName;
        this.userId = other.userId;
        this.uniqueDisplayId = other.uniqueDisplayId;
        this.luxValues = other.luxValues;
        this.luxTimestamps = other.luxTimestamps;
        this.batteryLevel = other.batteryLevel;
        this.powerBrightnessFactor = other.powerBrightnessFactor;
        this.nightMode = other.nightMode;
        this.colorTemperature = other.colorTemperature;
        this.reduceBrightColors = other.reduceBrightColors;
        this.reduceBrightColorsStrength = other.reduceBrightColorsStrength;
        this.reduceBrightColorsOffset = other.reduceBrightColorsOffset;
        this.lastBrightness = other.lastBrightness;
        this.isDefaultBrightnessConfig = other.isDefaultBrightnessConfig;
        this.isUserSetBrightness = other.isUserSetBrightness;
        this.colorValueBuckets = other.colorValueBuckets;
        this.colorSampleDuration = other.colorSampleDuration;
    }

    private BrightnessChangeEvent(Parcel source) {
        this.brightness = source.readFloat();
        this.timeStamp = source.readLong();
        this.packageName = source.readString();
        this.userId = source.readInt();
        this.uniqueDisplayId = source.readString();
        this.luxValues = source.createFloatArray();
        this.luxTimestamps = source.createLongArray();
        this.batteryLevel = source.readFloat();
        this.powerBrightnessFactor = source.readFloat();
        this.nightMode = source.readBoolean();
        this.colorTemperature = source.readInt();
        this.reduceBrightColors = source.readBoolean();
        this.reduceBrightColorsStrength = source.readInt();
        this.reduceBrightColorsOffset = source.readFloat();
        this.lastBrightness = source.readFloat();
        this.isDefaultBrightnessConfig = source.readBoolean();
        this.isUserSetBrightness = source.readBoolean();
        this.colorValueBuckets = source.createLongArray();
        this.colorSampleDuration = source.readLong();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.brightness);
        dest.writeLong(this.timeStamp);
        dest.writeString(this.packageName);
        dest.writeInt(this.userId);
        dest.writeString(this.uniqueDisplayId);
        dest.writeFloatArray(this.luxValues);
        dest.writeLongArray(this.luxTimestamps);
        dest.writeFloat(this.batteryLevel);
        dest.writeFloat(this.powerBrightnessFactor);
        dest.writeBoolean(this.nightMode);
        dest.writeInt(this.colorTemperature);
        dest.writeBoolean(this.reduceBrightColors);
        dest.writeInt(this.reduceBrightColorsStrength);
        dest.writeFloat(this.reduceBrightColorsOffset);
        dest.writeFloat(this.lastBrightness);
        dest.writeBoolean(this.isDefaultBrightnessConfig);
        dest.writeBoolean(this.isUserSetBrightness);
        dest.writeLongArray(this.colorValueBuckets);
        dest.writeLong(this.colorSampleDuration);
    }

    public String toString() {
        return "BrightnessChangeEvent{brightness: " + this.brightness + ", timeStamp: " + this.timeStamp + ", packageName: " + this.packageName + ", userId: " + this.userId + ", uniqueDisplayId: " + this.uniqueDisplayId + ", luxValues: " + Arrays.toString(this.luxValues) + ", luxTimestamps: " + Arrays.toString(this.luxTimestamps) + ", batteryLevel: " + this.batteryLevel + ", powerBrightnessFactor: " + this.powerBrightnessFactor + ", nightMode: " + this.nightMode + ", colorTemperature: " + this.colorTemperature + ", reduceBrightColors: " + this.reduceBrightColors + ", reduceBrightColorsStrength: " + this.reduceBrightColorsStrength + ", reduceBrightColorsOffset: " + this.reduceBrightColorsOffset + ", lastBrightness: " + this.lastBrightness + ", isDefaultBrightnessConfig: " + this.isDefaultBrightnessConfig + ", isUserSetBrightness: " + this.isUserSetBrightness + ", colorValueBuckets: " + Arrays.toString(this.colorValueBuckets) + ", colorSampleDuration: " + this.colorSampleDuration + "}";
    }

    public static class Builder {
        private float mBrightness;
        private long mTimeStamp;
        private String mPackageName;
        private int mUserId;
        private String mUniqueDisplayId;
        private float[] mLuxValues;
        private long[] mLuxTimestamps;
        private float mBatteryLevel;
        private float mPowerBrightnessFactor;
        private boolean mNightMode;
        private int mColorTemperature;
        private boolean mReduceBrightColors;
        private int mReduceBrightColorsStrength;
        private float mReduceBrightColorsOffset;
        private float mLastBrightness;
        private boolean mIsDefaultBrightnessConfig;
        private boolean mIsUserSetBrightness;
        private long[] mColorValueBuckets;
        private long mColorSampleDuration;

        public Builder setBrightness(float brightness) {
            this.mBrightness = brightness;
            return this;
        }

        public Builder setTimeStamp(long timeStamp) {
            this.mTimeStamp = timeStamp;
            return this;
        }

        public Builder setPackageName(String packageName) {
            this.mPackageName = packageName;
            return this;
        }

        public Builder setUserId(int userId) {
            this.mUserId = userId;
            return this;
        }

        public Builder setUniqueDisplayId(String uniqueId) {
            this.mUniqueDisplayId = uniqueId;
            return this;
        }

        public Builder setLuxValues(float[] luxValues) {
            this.mLuxValues = luxValues;
            return this;
        }

        public Builder setLuxTimestamps(long[] luxTimestamps) {
            this.mLuxTimestamps = luxTimestamps;
            return this;
        }

        public Builder setBatteryLevel(float batteryLevel) {
            this.mBatteryLevel = batteryLevel;
            return this;
        }

        public Builder setPowerBrightnessFactor(float powerBrightnessFactor) {
            this.mPowerBrightnessFactor = powerBrightnessFactor;
            return this;
        }

        public Builder setNightMode(boolean nightMode) {
            this.mNightMode = nightMode;
            return this;
        }

        public Builder setColorTemperature(int colorTemperature) {
            this.mColorTemperature = colorTemperature;
            return this;
        }

        public Builder setReduceBrightColors(boolean reduceBrightColors) {
            this.mReduceBrightColors = reduceBrightColors;
            return this;
        }

        public Builder setReduceBrightColorsStrength(int strength) {
            this.mReduceBrightColorsStrength = strength;
            return this;
        }

        public Builder setReduceBrightColorsOffset(float offset) {
            this.mReduceBrightColorsOffset = offset;
            return this;
        }

        public Builder setLastBrightness(float lastBrightness) {
            this.mLastBrightness = lastBrightness;
            return this;
        }

        public Builder setIsDefaultBrightnessConfig(boolean isDefaultBrightnessConfig) {
            this.mIsDefaultBrightnessConfig = isDefaultBrightnessConfig;
            return this;
        }

        public Builder setUserBrightnessPoint(boolean isUserSetBrightness) {
            this.mIsUserSetBrightness = isUserSetBrightness;
            return this;
        }

        public Builder setColorValues(@NonNull long[] colorValueBuckets, long colorSampleDuration) {
            Objects.requireNonNull(colorValueBuckets);
            this.mColorValueBuckets = colorValueBuckets;
            this.mColorSampleDuration = colorSampleDuration;
            return this;
        }

        public BrightnessChangeEvent build() {
            return new BrightnessChangeEvent(this.mBrightness, this.mTimeStamp, this.mPackageName, this.mUserId, this.mUniqueDisplayId, this.mLuxValues, this.mLuxTimestamps, this.mBatteryLevel, this.mPowerBrightnessFactor, this.mNightMode, this.mColorTemperature, this.mReduceBrightColors, this.mReduceBrightColorsStrength, this.mReduceBrightColorsOffset, this.mLastBrightness, this.mIsDefaultBrightnessConfig, this.mIsUserSetBrightness, this.mColorValueBuckets, this.mColorSampleDuration);
        }
    }
}

