/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.devicestate;

import android.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class DeviceStateRequest {
    public static final int FLAG_CANCEL_WHEN_BASE_CHANGES = 1;
    private final int mRequestedState;
    private final int mFlags;

    @NonNull
    public static Builder newBuilder(int requestedState) {
        return new Builder(requestedState);
    }

    private DeviceStateRequest(int requestedState, int flags) {
        this.mRequestedState = requestedState;
        this.mFlags = flags;
    }

    public int getState() {
        return this.mRequestedState;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public static class Builder {
        private final int mRequestedState;
        private int mFlags;

        private Builder(int requestedState) {
            this.mRequestedState = requestedState;
        }

        @NonNull
        public Builder setFlags(int flags) {
            this.mFlags |= flags;
            return this;
        }

        @NonNull
        public DeviceStateRequest build() {
            return new DeviceStateRequest(this.mRequestedState, this.mFlags);
        }
    }

    public static interface Callback {
        default public void onRequestActivated(@NonNull DeviceStateRequest request) {
        }

        default public void onRequestSuspended(@NonNull DeviceStateRequest request) {
        }

        default public void onRequestCanceled(@NonNull DeviceStateRequest request) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestFlags {
    }
}

