/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.devicestate;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.hardware.devicestate.DeviceState;
import android.hardware.devicestate.DeviceStateManagerGlobal;
import android.hardware.devicestate.DeviceStateRequest;
import com.android.internal.hidden_from_bootclasspath.android.hardware.devicestate.feature.flags.FeatureFlags;
import com.android.internal.hidden_from_bootclasspath.android.hardware.devicestate.feature.flags.FeatureFlagsImpl;
import com.android.internal.util.ArrayUtils;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@SystemApi
@FlaggedApi(value="android.hardware.devicestate.feature.flags.device_state_property_api")
public class DeviceStateManager {
    public static final int INVALID_DEVICE_STATE_IDENTIFIER = -1;
    public static final int MINIMUM_DEVICE_STATE_IDENTIFIER = 0;
    public static final int MAXIMUM_DEVICE_STATE_IDENTIFIER = 10000;
    public static final DeviceState INVALID_DEVICE_STATE = new DeviceState(new DeviceState.Configuration.Builder(-1, "INVALID").build());
    public static final String ACTION_SHOW_REAR_DISPLAY_OVERLAY = "com.android.intent.action.SHOW_REAR_DISPLAY_OVERLAY";
    public static final String EXTRA_ORIGINAL_DEVICE_BASE_STATE = "original_device_base_state";
    private final DeviceStateManagerGlobal mGlobal;

    public DeviceStateManager() {
        DeviceStateManagerGlobal global = DeviceStateManagerGlobal.getInstance();
        if (global == null) {
            throw new IllegalStateException("Failed to get instance of global device state manager.");
        }
        this.mGlobal = global;
    }

    @NonNull
    public List<DeviceState> getSupportedDeviceStates() {
        return this.mGlobal.getSupportedDeviceStates();
    }

    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE", conditional=true)
    public void requestState(@NonNull DeviceStateRequest request, @Nullable Executor executor, @Nullable DeviceStateRequest.Callback callback) {
        this.mGlobal.requestState(request, executor, callback);
    }

    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE", conditional=true)
    public void cancelStateRequest() {
        this.mGlobal.cancelStateRequest();
    }

    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE")
    public void requestBaseStateOverride(@NonNull DeviceStateRequest request, @Nullable Executor executor, @Nullable DeviceStateRequest.Callback callback) {
        this.mGlobal.requestBaseStateOverride(request, executor, callback);
    }

    @RequiresPermission(value="android.permission.CONTROL_DEVICE_STATE")
    public void cancelBaseStateOverride() {
        this.mGlobal.cancelBaseStateOverride();
    }

    public void registerCallback(@NonNull Executor executor, @NonNull DeviceStateCallback callback) {
        this.mGlobal.registerDeviceStateCallback(callback, executor);
    }

    public void unregisterCallback(@NonNull DeviceStateCallback callback) {
        this.mGlobal.unregisterDeviceStateCallback(callback);
    }

    public static interface DeviceStateCallback {
        default public void onSupportedStatesChanged(@NonNull List<DeviceState> supportedStates) {
        }

        public void onDeviceStateChanged(@NonNull DeviceState var1);
    }

    public static class FoldStateListener
    implements DeviceStateCallback {
        private final int[] mFoldedDeviceStates;
        private final Consumer<Boolean> mDelegate;
        private final FeatureFlags mFeatureFlags;
        @Nullable
        private Boolean lastResult;

        public FoldStateListener(Context context) {
            this(context, folded -> {});
        }

        public FoldStateListener(Context context, Consumer<Boolean> listener) {
            this.mFoldedDeviceStates = context.getResources().getIntArray(17236091);
            this.mDelegate = listener;
            this.mFeatureFlags = new FeatureFlagsImpl();
        }

        @Override
        public void onDeviceStateChanged(@NonNull DeviceState deviceState) {
            boolean folded = this.mFeatureFlags.deviceStatePropertyApi() ? deviceState.hasProperty(11) || ArrayUtils.contains(this.mFoldedDeviceStates, deviceState.getIdentifier()) : ArrayUtils.contains(this.mFoldedDeviceStates, deviceState.getIdentifier());
            if (this.lastResult == null || !((Object)this.lastResult).equals(folded)) {
                this.lastResult = folded;
                this.mDelegate.accept(folded);
            }
        }

        @Nullable
        public Boolean getFolded() {
            return this.lastResult;
        }
    }
}

