/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.contexthub;

import android.hardware.contexthub.HubEndpointInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IContextHubEndpointDiscoveryCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.contexthub.IContextHubEndpointDiscoveryCallback";

    public void onEndpointsStarted(HubEndpointInfo[] var1) throws RemoteException;

    public void onEndpointsStopped(HubEndpointInfo[] var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContextHubEndpointDiscoveryCallback {
        static final int TRANSACTION_onEndpointsStarted = 1;
        static final int TRANSACTION_onEndpointsStopped = 2;

        public Stub() {
            this.attachInterface(this, IContextHubEndpointDiscoveryCallback.DESCRIPTOR);
        }

        public static IContextHubEndpointDiscoveryCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IContextHubEndpointDiscoveryCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IContextHubEndpointDiscoveryCallback) {
                return (IContextHubEndpointDiscoveryCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onEndpointsStarted";
                }
                case 2: {
                    return "onEndpointsStopped";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IContextHubEndpointDiscoveryCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    HubEndpointInfo[] _arg0 = data.createTypedArray(HubEndpointInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onEndpointsStarted(_arg0);
                    break;
                }
                case 2: {
                    HubEndpointInfo[] _arg0 = data.createTypedArray(HubEndpointInfo.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onEndpointsStopped(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IContextHubEndpointDiscoveryCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IContextHubEndpointDiscoveryCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEndpointsStarted(HubEndpointInfo[] hubEndpointInfoList) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContextHubEndpointDiscoveryCallback.DESCRIPTOR);
                    _data.writeTypedArray(hubEndpointInfoList, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEndpointsStopped(HubEndpointInfo[] hubEndpointInfoList, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContextHubEndpointDiscoveryCallback.DESCRIPTOR);
                    _data.writeTypedArray(hubEndpointInfoList, 0);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IContextHubEndpointDiscoveryCallback {
        @Override
        public void onEndpointsStarted(HubEndpointInfo[] hubEndpointInfoList) throws RemoteException {
        }

        @Override
        public void onEndpointsStopped(HubEndpointInfo[] hubEndpointInfoList, int reason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

