/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.contexthub;

import android.annotation.FlaggedApi;
import android.annotation.SystemApi;
import android.hardware.contexthub.Service;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.chre.flags.offload_api")
public class HubServiceInfo
implements Parcelable {
    public static final int FORMAT_CUSTOM = 0;
    public static final int FORMAT_AIDL = 1;
    public static final int FORMAT_PW_RPC_PROTOBUF = 2;
    @NonNull
    private final String mServiceDescriptor;
    private final int mFormat;
    private final int mMajorVersion;
    private final int mMinorVersion;
    @NonNull
    public static final Parcelable.Creator<HubServiceInfo> CREATOR = new Parcelable.Creator<HubServiceInfo>(){

        @Override
        public HubServiceInfo createFromParcel(Parcel in) {
            return new HubServiceInfo(in);
        }

        public HubServiceInfo[] newArray(int size) {
            return new HubServiceInfo[size];
        }
    };

    public HubServiceInfo(Service service) {
        this.mServiceDescriptor = service.serviceDescriptor;
        this.mFormat = service.format;
        this.mMajorVersion = service.majorVersion;
        this.mMinorVersion = service.minorVersion;
    }

    private HubServiceInfo(Parcel in) {
        this.mServiceDescriptor = Objects.requireNonNull(in.readString());
        this.mFormat = in.readInt();
        this.mMajorVersion = in.readInt();
        this.mMinorVersion = in.readInt();
    }

    public HubServiceInfo(@NonNull String serviceDescriptor, int format, int majorVersion, int minorVersion) {
        this.mServiceDescriptor = serviceDescriptor;
        this.mFormat = format;
        this.mMajorVersion = majorVersion;
        this.mMinorVersion = minorVersion;
    }

    @NonNull
    public String getServiceDescriptor() {
        return this.mServiceDescriptor;
    }

    public int getFormat() {
        return this.mFormat;
    }

    public int getMajorVersion() {
        return this.mMajorVersion;
    }

    public int getMinorVersion() {
        return this.mMinorVersion;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("Service: ");
        out.append("descriptor=");
        out.append(this.mServiceDescriptor);
        out.append(", format=");
        out.append(this.mFormat);
        out.append(", version=");
        out.append(Integer.toHexString(this.mMajorVersion));
        out.append(".");
        out.append(Integer.toHexString(this.mMinorVersion));
        return out.toString();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mServiceDescriptor);
        dest.writeInt(this.mFormat);
        dest.writeInt(this.mMajorVersion);
        dest.writeInt(this.mMinorVersion);
    }

    public static class Builder {
        @NonNull
        private final String mServiceDescriptor;
        private final int mFormat;
        private final int mMajorVersion;
        private final int mMinorVersion;

        public Builder(@NonNull String serviceDescriptor, int format, int majorVersion, int minorVersion) {
            if (format != 0 && format != 1 && format != 2) {
                throw new IllegalArgumentException("Invalid format type.");
            }
            this.mFormat = format;
            if (majorVersion < 0) {
                throw new IllegalArgumentException("Major version cannot be set to negative number.");
            }
            this.mMajorVersion = majorVersion;
            if (minorVersion < 0) {
                throw new IllegalArgumentException("Minor version cannot be set to negative number.");
            }
            this.mMinorVersion = minorVersion;
            if (serviceDescriptor.isBlank()) {
                throw new IllegalArgumentException("Invalid service descriptor.");
            }
            this.mServiceDescriptor = serviceDescriptor;
        }

        @NonNull
        public HubServiceInfo build() {
            if (this.mMajorVersion < 0 || this.mMinorVersion < 0) {
                throw new IllegalStateException("Major and minor version must be set.");
            }
            return new HubServiceInfo(this.mServiceDescriptor, this.mFormat, this.mMajorVersion, this.mMinorVersion);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ServiceFormat {
    }
}

