/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.contexthub;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.hardware.contexthub.EndpointId;
import android.hardware.contexthub.EndpointInfo;
import android.hardware.contexthub.HubServiceInfo;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.chre.flags.offload_api")
public class HubEndpointInfo
implements Parcelable {
    public static final int TYPE_FRAMEWORK = 1;
    public static final int TYPE_APP = 2;
    public static final int TYPE_NATIVE = 3;
    public static final int TYPE_NANOAPP = 4;
    public static final int TYPE_HUB_ENDPOINT = 5;
    private final HubEndpointIdentifier mId;
    private final int mType;
    private final String mName;
    private final int mVersion;
    @Nullable
    private final String mTag;
    @NonNull
    private final List<String> mRequiredPermissions;
    @NonNull
    private final List<HubServiceInfo> mHubServiceInfos;
    @NonNull
    public static final Parcelable.Creator<HubEndpointInfo> CREATOR = new Parcelable.Creator<HubEndpointInfo>(){

        @Override
        public HubEndpointInfo createFromParcel(Parcel in) {
            return new HubEndpointInfo(in);
        }

        public HubEndpointInfo[] newArray(int size) {
            return new HubEndpointInfo[size];
        }
    };

    public HubEndpointInfo(EndpointInfo endpointInfo) {
        this.mId = new HubEndpointIdentifier(endpointInfo.id.hubId, endpointInfo.id.id);
        this.mType = endpointInfo.type;
        this.mName = endpointInfo.name;
        this.mVersion = endpointInfo.version;
        this.mTag = endpointInfo.tag;
        this.mRequiredPermissions = Arrays.asList(endpointInfo.requiredPermissions);
        this.mHubServiceInfos = new ArrayList<HubServiceInfo>(endpointInfo.services.length);
        for (int i = 0; i < endpointInfo.services.length; ++i) {
            this.mHubServiceInfos.add(new HubServiceInfo(endpointInfo.services[i]));
        }
    }

    public HubEndpointInfo(String name, int version, @Nullable String tag, @NonNull List<HubServiceInfo> hubServiceInfos) {
        this.mId = HubEndpointIdentifier.invalid();
        this.mType = 2;
        this.mName = name;
        this.mVersion = version;
        this.mTag = tag;
        this.mRequiredPermissions = Collections.emptyList();
        this.mHubServiceInfos = hubServiceInfos;
    }

    private HubEndpointInfo(Parcel in) {
        long hubId = in.readLong();
        long endpointId = in.readLong();
        this.mId = new HubEndpointIdentifier(hubId, endpointId);
        this.mType = in.readInt();
        this.mName = in.readString();
        this.mVersion = in.readInt();
        this.mTag = in.readString();
        this.mRequiredPermissions = new ArrayList<String>();
        in.readStringList(this.mRequiredPermissions);
        this.mHubServiceInfos = new ArrayList<HubServiceInfo>();
        in.readTypedList(this.mHubServiceInfos, HubServiceInfo.CREATOR);
    }

    @Override
    public int describeContents() {
        int flags = 0;
        for (HubServiceInfo serviceInfo : this.mHubServiceInfos) {
            flags |= serviceInfo.describeContents();
        }
        return flags;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.mId.getHub());
        dest.writeLong(this.mId.getEndpoint());
        dest.writeInt(this.mType);
        dest.writeString(this.mName);
        dest.writeInt(this.mVersion);
        dest.writeString(this.mTag);
        dest.writeStringList(this.mRequiredPermissions);
        dest.writeTypedList(this.mHubServiceInfos, flags);
    }

    @NonNull
    public HubEndpointIdentifier getIdentifier() {
        return this.mId;
    }

    public int getType() {
        return this.mType;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    public int getVersion() {
        return this.mVersion;
    }

    @Nullable
    public String getTag() {
        return this.mTag;
    }

    @SuppressLint(value={"RequiresPermission"})
    @NonNull
    public Collection<String> getRequiredPermissions() {
        return Collections.unmodifiableList(this.mRequiredPermissions);
    }

    @NonNull
    public Collection<HubServiceInfo> getServiceInfoCollection() {
        return Collections.unmodifiableList(this.mHubServiceInfos);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("Endpoint [0x");
        out.append(Long.toHexString(this.mId.getEndpoint()));
        out.append("@ Hub 0x");
        out.append(Long.toHexString(this.mId.getHub()));
        out.append("] Name=");
        out.append(this.mName);
        out.append(", Tag=");
        out.append(this.mTag);
        return out.toString();
    }

    public static class HubEndpointIdentifier {
        private final long mEndpointId;
        private final long mHubId;

        public HubEndpointIdentifier(long hubId, long endpointId) {
            this.mEndpointId = endpointId;
            this.mHubId = hubId;
        }

        public HubEndpointIdentifier(EndpointId halEndpointId) {
            this.mEndpointId = halEndpointId.id;
            this.mHubId = halEndpointId.hubId;
        }

        public long getEndpoint() {
            return this.mEndpointId;
        }

        public long getHub() {
            return this.mHubId;
        }

        public static HubEndpointIdentifier invalid() {
            return new HubEndpointIdentifier(0L, 0L);
        }

        public int hashCode() {
            return Objects.hash(this.mEndpointId, this.mHubId);
        }

        public boolean equals(Object o) {
            if (!(o instanceof HubEndpointIdentifier)) {
                return false;
            }
            HubEndpointIdentifier other = (HubEndpointIdentifier)o;
            if (other.mHubId != this.mHubId) {
                return false;
            }
            return other.mEndpointId == this.mEndpointId;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EndpointType {
    }
}

