/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.graphics.ColorSpace;
import android.hardware.camera2.CameraExtensionSession;
import android.hardware.camera2.params.OutputConfiguration;
import java.util.List;
import java.util.concurrent.Executor;

public class ExtensionSessionConfiguration {
    private static final String TAG = "ExtensionSessionConfiguration";
    private int mExtensionType;
    private List<OutputConfiguration> mOutputs;
    private OutputConfiguration mPostviewOutput = null;
    private Executor mExecutor = null;
    private CameraExtensionSession.StateCallback mCallback = null;
    private int mColorSpace;

    public ExtensionSessionConfiguration(int extension, @NonNull List<OutputConfiguration> outputs, @NonNull Executor executor, @NonNull CameraExtensionSession.StateCallback listener) {
        this.mExtensionType = extension;
        this.mOutputs = outputs;
        this.mExecutor = executor;
        this.mCallback = listener;
    }

    public int getExtension() {
        return this.mExtensionType;
    }

    public void setPostviewOutputConfiguration(@Nullable OutputConfiguration postviewOutput) {
        this.mPostviewOutput = postviewOutput;
    }

    @Nullable
    public OutputConfiguration getPostviewOutputConfiguration() {
        return this.mPostviewOutput;
    }

    @NonNull
    public List<OutputConfiguration> getOutputConfigurations() {
        return this.mOutputs;
    }

    @NonNull
    public CameraExtensionSession.StateCallback getStateCallback() {
        return this.mCallback;
    }

    @NonNull
    public Executor getExecutor() {
        return this.mExecutor;
    }

    public void setColorSpace(@NonNull ColorSpace.Named colorSpace) {
        this.mColorSpace = colorSpace.ordinal();
        for (OutputConfiguration outputConfiguration : this.mOutputs) {
            outputConfiguration.setColorSpace(colorSpace);
        }
        if (this.mPostviewOutput != null) {
            this.mPostviewOutput.setColorSpace(colorSpace);
        }
    }

    public void clearColorSpace() {
        this.mColorSpace = -1;
        for (OutputConfiguration outputConfiguration : this.mOutputs) {
            outputConfiguration.clearColorSpace();
        }
        if (this.mPostviewOutput != null) {
            this.mPostviewOutput.clearColorSpace();
        }
    }

    @SuppressLint(value={"MethodNameUnits"})
    @Nullable
    public ColorSpace getColorSpace() {
        if (this.mColorSpace != -1) {
            return ColorSpace.get(ColorSpace.Named.values()[this.mColorSpace]);
        }
        return null;
    }
}

