/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalHelpers;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.util.Rational;
import java.nio.ByteBuffer;

public class MarshalQueryablePrimitive<T>
implements MarshalQueryable<T> {
    @Override
    public Marshaler<T> createMarshaler(TypeReference<T> managedType, int nativeType) {
        return new MarshalerPrimitive(this, managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<T> managedType, int nativeType) {
        if (managedType.getType() instanceof Class) {
            Class klass = (Class)managedType.getType();
            if (klass == Byte.TYPE || klass == Byte.class) {
                return nativeType == 0;
            }
            if (klass == Integer.TYPE || klass == Integer.class) {
                return nativeType == 1;
            }
            if (klass == Float.TYPE || klass == Float.class) {
                return nativeType == 2;
            }
            if (klass == Long.TYPE || klass == Long.class) {
                return nativeType == 3;
            }
            if (klass == Double.TYPE || klass == Double.class) {
                return nativeType == 4;
            }
            if (klass == Rational.class) {
                return nativeType == 5;
            }
        }
        return false;
    }

    private class MarshalerPrimitive
    extends Marshaler<T> {
        private final Class<T> mClass;

        protected MarshalerPrimitive(MarshalQueryablePrimitive marshalQueryablePrimitive, TypeReference<T> typeReference, int nativeType) {
            super(marshalQueryablePrimitive, typeReference, nativeType);
            this.mClass = MarshalHelpers.wrapClassIfPrimitive(typeReference.getRawType());
        }

        @Override
        public T unmarshal(ByteBuffer buffer) {
            return this.mClass.cast(this.unmarshalObject(buffer));
        }

        @Override
        public int calculateMarshalSize(T value) {
            return MarshalHelpers.getPrimitiveTypeSize(this.mNativeType);
        }

        @Override
        public void marshal(T value, ByteBuffer buffer) {
            if (value instanceof Integer) {
                MarshalHelpers.checkNativeTypeEquals(1, this.mNativeType);
                int val = (Integer)value;
                this.marshalPrimitive(val, buffer);
            } else if (value instanceof Float) {
                MarshalHelpers.checkNativeTypeEquals(2, this.mNativeType);
                float val = ((Float)value).floatValue();
                this.marshalPrimitive(val, buffer);
            } else if (value instanceof Long) {
                MarshalHelpers.checkNativeTypeEquals(3, this.mNativeType);
                long val = (Long)value;
                this.marshalPrimitive(val, buffer);
            } else if (value instanceof Rational) {
                MarshalHelpers.checkNativeTypeEquals(5, this.mNativeType);
                this.marshalPrimitive((Rational)value, buffer);
            } else if (value instanceof Double) {
                MarshalHelpers.checkNativeTypeEquals(4, this.mNativeType);
                double val = (Double)value;
                this.marshalPrimitive(val, buffer);
            } else if (value instanceof Byte) {
                MarshalHelpers.checkNativeTypeEquals(0, this.mNativeType);
                byte val = (Byte)value;
                this.marshalPrimitive(val, buffer);
            } else {
                throw new UnsupportedOperationException("Can't marshal managed type " + this.mTypeReference);
            }
        }

        private void marshalPrimitive(int value, ByteBuffer buffer) {
            buffer.putInt(value);
        }

        private void marshalPrimitive(float value, ByteBuffer buffer) {
            buffer.putFloat(value);
        }

        private void marshalPrimitive(double value, ByteBuffer buffer) {
            buffer.putDouble(value);
        }

        private void marshalPrimitive(long value, ByteBuffer buffer) {
            buffer.putLong(value);
        }

        private void marshalPrimitive(Rational value, ByteBuffer buffer) {
            buffer.putInt(value.getNumerator());
            buffer.putInt(value.getDenominator());
        }

        private void marshalPrimitive(byte value, ByteBuffer buffer) {
            buffer.put(value);
        }

        private Object unmarshalObject(ByteBuffer buffer) {
            switch (this.mNativeType) {
                case 1: {
                    return buffer.getInt();
                }
                case 2: {
                    return Float.valueOf(buffer.getFloat());
                }
                case 3: {
                    return buffer.getLong();
                }
                case 5: {
                    int numerator = buffer.getInt();
                    int denominator = buffer.getInt();
                    return new Rational(numerator, denominator);
                }
                case 4: {
                    return buffer.getDouble();
                }
                case 0: {
                    return buffer.get();
                }
            }
            throw new UnsupportedOperationException("Can't unmarshal native type " + this.mNativeType);
        }

        @Override
        public int getNativeSize() {
            return MarshalHelpers.getPrimitiveTypeSize(this.mNativeType);
        }
    }
}

