/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.annotation.FlaggedApi;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraOfflineSession;
import android.hardware.camera2.CameraSharedCaptureSession;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.impl.CameraCaptureSessionCore;
import android.hardware.camera2.impl.CameraCaptureSessionImpl;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.params.OutputConfiguration;
import android.os.ConditionVariable;
import android.os.Handler;
import android.view.Surface;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;

@FlaggedApi(value="com.android.internal.camera.flags.camera_multi_client")
public class CameraSharedCaptureSessionImpl
extends CameraSharedCaptureSession
implements CameraCaptureSessionCore {
    private static final String TAG = "CameraSharedCaptureSessionImpl";
    private final CameraCaptureSessionImpl mSessionImpl;
    private final ConditionVariable mInitialized = new ConditionVariable();
    private final CameraDeviceImpl mCameraDevice;
    private final Executor mDeviceExecutor;

    CameraSharedCaptureSessionImpl(int id2, CameraCaptureSession.StateCallback callback, Executor stateExecutor, CameraDeviceImpl deviceImpl, Executor deviceStateExecutor, boolean configureSuccess) {
        WrapperCallback wrapperCallback = new WrapperCallback(callback);
        this.mSessionImpl = new CameraCaptureSessionImpl(id2, null, wrapperCallback, stateExecutor, deviceImpl, deviceStateExecutor, configureSuccess);
        this.mCameraDevice = deviceImpl;
        this.mDeviceExecutor = deviceStateExecutor;
        this.mInitialized.open();
    }

    @Override
    public int startStreaming(List<Surface> surfaces, Executor executor, CameraCaptureSession.CaptureCallback callback) throws CameraAccessException {
        if (surfaces.isEmpty()) {
            throw new IllegalArgumentException("No surfaces provided for streaming");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        return this.mSessionImpl.startStreaming(surfaces, executor, callback);
    }

    @Override
    public void stopStreaming() throws CameraAccessException {
        this.mSessionImpl.stopRepeating();
    }

    @Override
    public void close() {
        this.mSessionImpl.close();
    }

    @Override
    public Surface getInputSurface() {
        return null;
    }

    @Override
    public boolean isReprocessable() {
        return false;
    }

    @Override
    public boolean supportsOfflineProcessing(Surface surface) {
        return false;
    }

    @Override
    public void abortCaptures() throws CameraAccessException {
        if (this.mCameraDevice.isPrimaryClient()) {
            this.mSessionImpl.abortCaptures();
            return;
        }
        throw new UnsupportedOperationException("Shared capture session only supports this method for primary clients");
    }

    @Override
    public int setRepeatingRequest(CaptureRequest request, CameraCaptureSession.CaptureCallback listener, Handler handler) throws CameraAccessException {
        if (this.mCameraDevice.isPrimaryClient()) {
            return this.mSessionImpl.setRepeatingRequest(request, listener, handler);
        }
        throw new UnsupportedOperationException("Shared capture session only supports this method for primary clients");
    }

    @Override
    public int setSingleRepeatingRequest(CaptureRequest request, Executor executor, CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        if (this.mCameraDevice.isPrimaryClient()) {
            return this.mSessionImpl.setSingleRepeatingRequest(request, executor, listener);
        }
        throw new UnsupportedOperationException("Shared capture session only supports this method for primary clients");
    }

    @Override
    public void stopRepeating() throws CameraAccessException {
        if (this.mCameraDevice.isPrimaryClient()) {
            this.mSessionImpl.stopRepeating();
            return;
        }
        throw new UnsupportedOperationException("Shared capture session only supports this method for primary clients");
    }

    @Override
    public int capture(CaptureRequest request, CameraCaptureSession.CaptureCallback listener, Handler handler) throws CameraAccessException {
        if (this.mCameraDevice.isPrimaryClient()) {
            return this.mSessionImpl.capture(request, listener, handler);
        }
        throw new UnsupportedOperationException("Shared capture session only supports this method for primary clients");
    }

    @Override
    public int captureSingleRequest(CaptureRequest request, Executor executor, CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        if (this.mCameraDevice.isPrimaryClient()) {
            return this.mSessionImpl.captureSingleRequest(request, executor, listener);
        }
        throw new UnsupportedOperationException("Shared capture session only supports this method for primary clients");
    }

    @Override
    public void tearDown(Surface surface) throws CameraAccessException {
        this.mSessionImpl.tearDown(surface);
    }

    @Override
    public CameraDevice getDevice() {
        return this.mSessionImpl.getDevice();
    }

    @Override
    public boolean isAborting() {
        return this.mSessionImpl.isAborting();
    }

    @Override
    public CameraDeviceImpl.StateCallbackKK getDeviceStateCallback() {
        return this.mSessionImpl.getDeviceStateCallback();
    }

    @Override
    public void replaceSessionClose() {
        this.mSessionImpl.replaceSessionClose();
    }

    @Override
    public CameraOfflineSession switchToOffline(Collection<Surface> offlineSurfaces, Executor executor, CameraOfflineSession.CameraOfflineSessionCallback listener) throws CameraAccessException {
        throw new UnsupportedOperationException("Shared capture session do not support this method");
    }

    @Override
    public int setRepeatingBurst(List<CaptureRequest> requests, CameraCaptureSession.CaptureCallback listener, Handler handler) throws CameraAccessException {
        throw new UnsupportedOperationException("Shared Capture session do not support this method");
    }

    @Override
    public int setRepeatingBurstRequests(List<CaptureRequest> requests, Executor executor, CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        throw new UnsupportedOperationException("Shared Capture session do not support this method");
    }

    @Override
    public int captureBurst(List<CaptureRequest> requests, CameraCaptureSession.CaptureCallback listener, Handler handler) throws CameraAccessException {
        throw new UnsupportedOperationException("Shared Capture session do not support this method");
    }

    @Override
    public int captureBurstRequests(List<CaptureRequest> requests, Executor executor, CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        throw new UnsupportedOperationException("Shared Capture session do not support this method");
    }

    @Override
    public void updateOutputConfiguration(OutputConfiguration config) throws CameraAccessException {
        throw new UnsupportedOperationException("Shared capture session do not support this method");
    }

    @Override
    public void finalizeOutputConfigurations(List<OutputConfiguration> deferredOutputConfigs) throws CameraAccessException {
        throw new UnsupportedOperationException("Shared capture session do not support this method");
    }

    @Override
    public void prepare(Surface surface) throws CameraAccessException {
        throw new UnsupportedOperationException("Shared capture session do not support this method");
    }

    @Override
    public void prepare(int maxCount, Surface surface) throws CameraAccessException {
        throw new UnsupportedOperationException("Shared capture session do not support this method");
    }

    @Override
    public void closeWithoutDraining() {
        throw new UnsupportedOperationException("Shared capture session do not support this method");
    }

    private class WrapperCallback
    extends CameraCaptureSession.StateCallback {
        private final CameraCaptureSession.StateCallback mCallback;

        WrapperCallback(CameraCaptureSession.StateCallback callback) {
            this.mCallback = callback;
        }

        @Override
        public void onConfigured(CameraCaptureSession session) {
            CameraSharedCaptureSessionImpl.this.mInitialized.block();
            this.mCallback.onConfigured(CameraSharedCaptureSessionImpl.this);
        }

        @Override
        public void onConfigureFailed(CameraCaptureSession session) {
            CameraSharedCaptureSessionImpl.this.mInitialized.block();
            this.mCallback.onConfigureFailed(CameraSharedCaptureSessionImpl.this);
        }

        @Override
        public void onReady(CameraCaptureSession session) {
            this.mCallback.onReady(CameraSharedCaptureSessionImpl.this);
        }

        @Override
        public void onActive(CameraCaptureSession session) {
            this.mCallback.onActive(CameraSharedCaptureSessionImpl.this);
        }

        @Override
        public void onCaptureQueueEmpty(CameraCaptureSession session) {
            this.mCallback.onCaptureQueueEmpty(CameraSharedCaptureSessionImpl.this);
        }

        @Override
        public void onClosed(CameraCaptureSession session) {
            this.mCallback.onClosed(CameraSharedCaptureSessionImpl.this);
        }

        @Override
        public void onSurfacePrepared(CameraCaptureSession session, Surface surface) {
            this.mCallback.onSurfacePrepared(CameraSharedCaptureSessionImpl.this, surface);
        }
    }
}

