/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.annotation.NonNull;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.extension.CaptureBundle;
import android.hardware.camera2.extension.ICaptureProcessorImpl;
import android.hardware.camera2.extension.IProcessResultImpl;
import android.hardware.camera2.extension.Size;
import android.hardware.camera2.impl.CameraExtensionUtils;
import android.media.Image;
import android.media.ImageReader;
import android.media.ImageWriter;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.Surface;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CameraExtensionJpegProcessor
implements ICaptureProcessorImpl {
    public static final String TAG = "CameraExtensionJpeg";
    private static final int JPEG_QUEUE_SIZE = 1;
    private static final int JPEG_APP_SEGMENT_SIZE = 65536;
    private final Handler mHandler;
    private final HandlerThread mHandlerThread;
    private final ICaptureProcessorImpl mProcessor;
    private ImageReader mYuvReader = null;
    private ImageReader mPostviewYuvReader = null;
    private Size mResolution = null;
    private Size mPostviewResolution = null;
    private int mFormat = -1;
    private int mPostviewFormat = -1;
    private int mCaptureFormat = -1;
    private Surface mOutputSurface = null;
    private ImageWriter mOutputWriter = null;
    private Surface mPostviewOutputSurface = null;
    private ImageWriter mPostviewOutputWriter = null;
    private ConcurrentLinkedQueue<JpegParameters> mJpegParameters = new ConcurrentLinkedQueue();

    public CameraExtensionJpegProcessor(@NonNull ICaptureProcessorImpl processor) {
        this.mProcessor = processor;
        this.mHandlerThread = new HandlerThread(TAG);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
    }

    public void close() {
        this.mHandlerThread.quitSafely();
        if (this.mOutputWriter != null) {
            this.mOutputWriter.close();
            this.mOutputWriter = null;
        }
        if (this.mYuvReader != null) {
            this.mYuvReader.close();
            this.mYuvReader = null;
        }
    }

    private static JpegParameters getJpegParameters(List<CaptureBundle> captureBundles) {
        JpegParameters ret = new JpegParameters();
        if (!captureBundles.isEmpty()) {
            Byte jpegQuality = captureBundles.get((int)0).captureResult.get(CaptureResult.JPEG_QUALITY);
            if (jpegQuality != null) {
                ret.mQuality = jpegQuality.byteValue();
            } else {
                Log.w(TAG, "No jpeg quality set, using default: 100");
            }
            Integer orientation = captureBundles.get((int)0).captureResult.get(CaptureResult.JPEG_ORIENTATION);
            if (orientation != null) {
                ret.mRotation = (360 - orientation % 360) / 90;
            } else {
                Log.w(TAG, "No jpeg rotation set, using default: 0");
            }
            for (CaptureBundle bundle : captureBundles) {
                Long timeStamp = bundle.captureResult.get(CaptureResult.SENSOR_TIMESTAMP);
                if (timeStamp != null) {
                    ret.mTimeStamps.add(timeStamp);
                    continue;
                }
                Log.e(TAG, "Capture bundle without valid sensor timestamp!");
            }
        }
        return ret;
    }

    private static int compressJpegFromYUV420pNative(int n, int n2, ByteBuffer byteBuffer, int n3, int n4, ByteBuffer byteBuffer2, int n5, int n6, ByteBuffer byteBuffer3, int n7, int n8, ByteBuffer byteBuffer4, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        return OverrideMethod.invokeI("android.hardware.camera2.impl.CameraExtensionJpegProcessor#compressJpegFromYUV420pNative(IILjava/nio/ByteBuffer;IILjava/nio/ByteBuffer;IILjava/nio/ByteBuffer;IILjava/nio/ByteBuffer;IIIIIII)I", true, null);
    }

    @Override
    public void process(List<CaptureBundle> captureBundle, IProcessResultImpl captureCallback, boolean isPostviewRequested) throws RemoteException {
        JpegParameters jpegParams = CameraExtensionJpegProcessor.getJpegParameters(captureBundle);
        try {
            this.mJpegParameters.add(jpegParams);
            this.mProcessor.process(captureBundle, captureCallback, isPostviewRequested);
        }
        catch (Exception e) {
            this.mJpegParameters.remove(jpegParams);
            throw e;
        }
    }

    @Override
    public void onOutputSurface(Surface surface, int format) throws RemoteException {
        CameraExtensionUtils.SurfaceInfo surfaceInfo = CameraExtensionUtils.querySurface(surface);
        this.mCaptureFormat = surfaceInfo.mFormat;
        this.mOutputSurface = surface;
        this.initializePipeline();
    }

    @Override
    public void onPostviewOutputSurface(Surface surface) throws RemoteException {
        CameraExtensionUtils.SurfaceInfo postviewSurfaceInfo = CameraExtensionUtils.querySurface(surface);
        this.mPostviewFormat = postviewSurfaceInfo.mFormat;
        this.mPostviewOutputSurface = surface;
        this.initializePostviewPipeline();
    }

    @Override
    public void onResolutionUpdate(Size size, Size postviewSize) throws RemoteException {
        this.mResolution = size;
        this.mPostviewResolution = postviewSize;
        this.initializePipeline();
    }

    @Override
    public void onImageFormatUpdate(int format) throws RemoteException {
        this.mFormat = format;
        this.initializePipeline();
    }

    private void initializePipeline() throws RemoteException {
        if (this.mFormat != -1 && this.mOutputSurface != null && this.mResolution != null && this.mYuvReader == null) {
            if (this.mCaptureFormat == 35) {
                this.mProcessor.onOutputSurface(this.mOutputSurface, this.mCaptureFormat);
            } else {
                this.mOutputWriter = ImageWriter.newInstance(this.mOutputSurface, 1, 256, this.mResolution.width * this.mResolution.height * 3 / 2 + 65536, 1);
                this.mYuvReader = ImageReader.newInstance(this.mResolution.width, this.mResolution.height, this.mFormat, 1);
                this.mYuvReader.setOnImageAvailableListener(new YuvCallback(this.mYuvReader, this.mOutputWriter), this.mHandler);
                this.mProcessor.onOutputSurface(this.mYuvReader.getSurface(), this.mFormat);
            }
            this.mProcessor.onResolutionUpdate(this.mResolution, this.mPostviewResolution);
            this.mProcessor.onImageFormatUpdate(35);
        }
    }

    private void initializePostviewPipeline() throws RemoteException {
        if (this.mFormat != -1 && this.mPostviewOutputSurface != null && this.mPostviewResolution != null && this.mPostviewYuvReader == null) {
            if (this.mPostviewFormat == 35) {
                this.mProcessor.onPostviewOutputSurface(this.mPostviewOutputSurface);
            } else {
                this.mPostviewOutputWriter = ImageWriter.newInstance(this.mPostviewOutputSurface, 1, 256, this.mPostviewResolution.width * this.mPostviewResolution.height, 1);
                this.mPostviewYuvReader = ImageReader.newInstance(this.mPostviewResolution.width, this.mPostviewResolution.height, this.mFormat, 1);
                this.mPostviewYuvReader.setOnImageAvailableListener(new YuvCallback(this.mPostviewYuvReader, this.mPostviewOutputWriter), this.mHandler);
                this.mProcessor.onPostviewOutputSurface(this.mPostviewYuvReader.getSurface());
            }
            this.mProcessor.onResolutionUpdate(this.mResolution, this.mPostviewResolution);
            this.mProcessor.onImageFormatUpdate(35);
        }
    }

    @Override
    public IBinder asBinder() {
        throw new UnsupportedOperationException("Binder IPC not supported!");
    }

    private static class JpegParameters {
        public HashSet<Long> mTimeStamps = new HashSet();
        public int mRotation = 0;
        public int mQuality = 100;

        private JpegParameters() {
        }
    }

    private class YuvCallback
    implements ImageReader.OnImageAvailableListener {
        private ImageReader mImageReader;
        private ImageWriter mImageWriter;

        public YuvCallback(ImageReader imageReader, ImageWriter imageWriter) {
            this.mImageReader = imageReader;
            this.mImageWriter = imageWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onImageAvailable(ImageReader reader) {
            Image yuvImage = null;
            Image jpegImage = null;
            try {
                yuvImage = this.mImageReader.acquireNextImage();
                jpegImage = this.mImageWriter.dequeueInputImage();
            }
            catch (IllegalStateException e) {
                if (yuvImage != null) {
                    yuvImage.close();
                }
                if (jpegImage != null) {
                    jpegImage.close();
                }
                Log.e(CameraExtensionJpegProcessor.TAG, "Failed to acquire processed yuv image or jpeg image!");
                return;
            }
            ByteBuffer jpegBuffer = jpegImage.getPlanes()[0].getBuffer();
            jpegBuffer.clear();
            int jpegCapacity = jpegImage.getWidth();
            Image.Plane lumaPlane = yuvImage.getPlanes()[0];
            Image.Plane crPlane = yuvImage.getPlanes()[1];
            Image.Plane cbPlane = yuvImage.getPlanes()[2];
            ConcurrentLinkedQueue<JpegParameters> jpegParameters = new ConcurrentLinkedQueue<JpegParameters>(CameraExtensionJpegProcessor.this.mJpegParameters);
            Iterator<JpegParameters> jpegIter = jpegParameters.iterator();
            JpegParameters jpegParams = null;
            while (jpegIter.hasNext()) {
                JpegParameters currentParams = jpegIter.next();
                if (!currentParams.mTimeStamps.contains(yuvImage.getTimestamp())) continue;
                jpegParams = currentParams;
                jpegIter.remove();
                break;
            }
            if (jpegParams == null) {
                if (jpegParameters.isEmpty()) {
                    Log.w(CameraExtensionJpegProcessor.TAG, "Empty jpeg settings queue! Using default jpeg orientation and quality!");
                    jpegParams = new JpegParameters();
                    jpegParams.mRotation = 0;
                    jpegParams.mQuality = 100;
                } else {
                    Log.w(CameraExtensionJpegProcessor.TAG, "No jpeg settings found with matching timestamp for current processed input!");
                    Log.w(CameraExtensionJpegProcessor.TAG, "Using values from the top of the queue!");
                    jpegParams = jpegParameters.poll();
                }
            }
            CameraExtensionJpegProcessor.compressJpegFromYUV420pNative(yuvImage.getWidth(), yuvImage.getHeight(), lumaPlane.getBuffer(), lumaPlane.getPixelStride(), lumaPlane.getRowStride(), crPlane.getBuffer(), crPlane.getPixelStride(), crPlane.getRowStride(), cbPlane.getBuffer(), cbPlane.getPixelStride(), cbPlane.getRowStride(), jpegBuffer, jpegCapacity, jpegParams.mQuality, 0, 0, yuvImage.getWidth(), yuvImage.getHeight(), jpegParams.mRotation);
            jpegImage.setTimestamp(yuvImage.getTimestamp());
            yuvImage.close();
            try {
                this.mImageWriter.queueInputImage(jpegImage);
            }
            catch (IllegalStateException e) {
                Log.e(CameraExtensionJpegProcessor.TAG, "Failed to queue encoded result!");
            }
            finally {
                jpegImage.close();
            }
        }
    }
}

