/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.compat.CompatChanges;
import android.companion.virtual.VirtualDeviceManager;
import android.content.AttributionSource;
import android.content.AttributionSourceState;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.hardware.CameraExtensionSessionStats;
import android.hardware.CameraStatus;
import android.hardware.ICameraService;
import android.hardware.ICameraServiceListener;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraExtensionCharacteristics;
import android.hardware.camera2.CameraInjectionSession;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.ICameraInjectionSession;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.impl.CameraDeviceSetupImpl;
import android.hardware.camera2.impl.CameraInjectionSessionImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.SessionConfiguration;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.utils.CameraIdAndSessionConfiguration;
import android.hardware.camera2.utils.ConcurrentCameraIdCombination;
import android.hardware.camera2.utils.ExceptionUtils;
import android.hardware.devicestate.DeviceState;
import android.hardware.devicestate.DeviceStateManager;
import android.hardware.display.DisplayManager;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import android.util.Size;
import android.view.Display;
import android.window.DesktopModeFlags;
import com.android.internal.hidden_from_bootclasspath.android.hardware.devicestate.feature.flags.FeatureFlags;
import com.android.internal.hidden_from_bootclasspath.android.hardware.devicestate.feature.flags.FeatureFlagsImpl;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import com.android.internal.util.ArrayUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CameraManager {
    private static final String TAG = "CameraManager";
    private final boolean DEBUG = false;
    private static final int USE_CALLING_UID = -1;
    private static final int USE_CALLING_PID = -1;
    private static final int API_VERSION_1 = 1;
    private static final int API_VERSION_2 = 2;
    private static final int CAMERA_TYPE_BACKWARD_COMPATIBLE = 0;
    private static final int CAMERA_TYPE_ALL = 1;
    private final Map<String, Map<String, StreamConfiguration[]>> mCameraIdToMultiResolutionStreamConfigurationMap = new HashMap<String, Map<String, StreamConfiguration[]>>();
    private final Context mContext;
    private final Object mLock;
    private static final String CAMERA_OPEN_CLOSE_LISTENER_PERMISSION = "android.permission.CAMERA_OPEN_CLOSE_LISTENER";
    private final boolean mHasOpenCloseListenerPermission;
    private VirtualDeviceManager mVirtualDeviceManager;
    public static final long OVERRIDE_CAMERA_LANDSCAPE_TO_PORTRAIT = 250678880L;
    public static final String LANDSCAPE_TO_PORTRAIT_PROP = "camera.enable_landscape_to_portrait";
    @FlaggedApi(value="com.android.window.flags.enable_camera_compat_for_desktop_windowing")
    public static final int ROTATION_OVERRIDE_NONE = 0;
    @FlaggedApi(value="com.android.window.flags.enable_camera_compat_for_desktop_windowing")
    public static final int ROTATION_OVERRIDE_OVERRIDE_TO_PORTRAIT = 1;
    @FlaggedApi(value="com.android.window.flags.enable_camera_compat_for_desktop_windowing")
    public static final int ROTATION_OVERRIDE_ROTATION_ONLY = 2;
    static final int ROTATION_OVERRIDE_ROTATION_ONLY_REVERSE = 3;
    private static final long ENABLE_PHYSICAL_CAMERA_CALLBACK_FOR_UNAVAILABLE_LOGICAL_CAMERA = 244358506L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraManager(Context context) {
        Object object = this.mLock = new Object();
        synchronized (object) {
            this.mContext = context;
            this.mHasOpenCloseListenerPermission = this.mContext.checkSelfPermission(CAMERA_OPEN_CLOSE_LISTENER_PERMISSION) == 0;
        }
    }

    public void registerDeviceStateListener(@NonNull CameraCharacteristics chars) {
        CameraManagerGlobal.get().registerDeviceStateListener(chars, this.mContext);
    }

    @NonNull
    public String[] getCameraIdList() throws CameraAccessException {
        return CameraManagerGlobal.get().getCameraIdList(this.mContext.getDeviceId(), this.getDevicePolicyFromContext(this.mContext));
    }

    public String[] getCameraIdListNoLazy() throws CameraAccessException {
        return CameraManagerGlobal.get().getCameraIdListNoLazy(this.mContext.getDeviceId(), this.getDevicePolicyFromContext(this.mContext));
    }

    @NonNull
    public Set<Set<String>> getConcurrentCameraIds() throws CameraAccessException {
        return CameraManagerGlobal.get().getConcurrentCameraIds(this.mContext.getDeviceId(), this.getDevicePolicyFromContext(this.mContext));
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public boolean isConcurrentSessionConfigurationSupported(@NonNull Map<String, SessionConfiguration> cameraIdAndSessionConfig) throws CameraAccessException {
        return CameraManagerGlobal.get().isConcurrentSessionConfigurationSupported(cameraIdAndSessionConfig, this.mContext.getApplicationInfo().targetSdkVersion, this.getClientAttribution(), this.getDevicePolicyFromContext(this.mContext));
    }

    public void registerAvailabilityCallback(@NonNull AvailabilityCallback callback, @Nullable Handler handler) {
        CameraManagerGlobal.get().registerAvailabilityCallback(callback, CameraDeviceImpl.checkAndWrapHandler(handler), this.mHasOpenCloseListenerPermission, this.mContext.getDeviceId(), this.getDevicePolicyFromContext(this.mContext));
    }

    public void registerAvailabilityCallback(@NonNull Executor executor, @NonNull AvailabilityCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor was null");
        }
        CameraManagerGlobal.get().registerAvailabilityCallback(callback, executor, this.mHasOpenCloseListenerPermission, this.mContext.getDeviceId(), this.getDevicePolicyFromContext(this.mContext));
    }

    public void unregisterAvailabilityCallback(@NonNull AvailabilityCallback callback) {
        CameraManagerGlobal.get().unregisterAvailabilityCallback(callback);
    }

    public void registerTorchCallback(@NonNull TorchCallback callback, @Nullable Handler handler) {
        CameraManagerGlobal.get().registerTorchCallback(callback, CameraDeviceImpl.checkAndWrapHandler(handler), this.mContext.getDeviceId(), this.getDevicePolicyFromContext(this.mContext));
    }

    public void registerTorchCallback(@NonNull Executor executor, @NonNull TorchCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor was null");
        }
        CameraManagerGlobal.get().registerTorchCallback(callback, executor, this.mContext.getDeviceId(), this.getDevicePolicyFromContext(this.mContext));
    }

    public void unregisterTorchCallback(@NonNull TorchCallback callback) {
        CameraManagerGlobal.get().unregisterTorchCallback(callback);
    }

    public int getDevicePolicyFromContext(@NonNull Context context) {
        if (context.getDeviceId() == 0) {
            return 0;
        }
        if (this.mVirtualDeviceManager == null) {
            this.mVirtualDeviceManager = context.getSystemService(VirtualDeviceManager.class);
        }
        return this.mVirtualDeviceManager == null ? 0 : this.mVirtualDeviceManager.getDevicePolicy(context.getDeviceId(), 5);
    }

    private Size getDisplaySize() {
        Size ret = new Size(0, 0);
        try {
            DisplayManager displayManager = (DisplayManager)this.mContext.getSystemService("display");
            Display display = displayManager.getDisplay(0);
            if (display != null) {
                Point sz = new Point();
                display.getRealSize(sz);
                int width = sz.x;
                int height = sz.y;
                if (height > width) {
                    height = width;
                    width = sz.y;
                }
                ret = new Size(width, height);
            } else {
                Log.e(TAG, "Invalid default display!");
            }
        }
        catch (Exception e) {
            Log.e(TAG, "getDisplaySize Failed. " + e);
        }
        return ret;
    }

    private Map<String, StreamConfiguration[]> getPhysicalCameraMultiResolutionConfigs(String cameraId, CameraMetadataNative info, ICameraService cameraService) throws CameraAccessException {
        if (this.mCameraIdToMultiResolutionStreamConfigurationMap.containsKey(cameraId)) {
            return this.mCameraIdToMultiResolutionStreamConfigurationMap.get(cameraId);
        }
        HashMap<String, StreamConfiguration[]> multiResolutionStreamConfigurations = new HashMap<String, StreamConfiguration[]>();
        this.mCameraIdToMultiResolutionStreamConfigurationMap.put(cameraId, multiResolutionStreamConfigurations);
        Boolean multiResolutionStreamSupported = info.get(CameraCharacteristics.SCALER_MULTI_RESOLUTION_STREAM_SUPPORTED);
        if (multiResolutionStreamSupported == null || !multiResolutionStreamSupported.booleanValue()) {
            return multiResolutionStreamConfigurations;
        }
        Set<String> physicalCameraIds = info.getPhysicalCameraIds();
        if (physicalCameraIds.size() == 0 && info.isUltraHighResolutionSensor()) {
            StreamConfiguration[] configs = info.get(CameraCharacteristics.SCALER_PHYSICAL_CAMERA_MULTI_RESOLUTION_STREAM_CONFIGURATIONS);
            if (configs != null) {
                multiResolutionStreamConfigurations.put(cameraId, configs);
            }
            return multiResolutionStreamConfigurations;
        }
        try {
            for (String physicalCameraId : physicalCameraIds) {
                AttributionSourceState clientAttribution;
                CameraMetadataNative physicalCameraInfo = cameraService.getCameraCharacteristics(physicalCameraId, this.mContext.getApplicationInfo().targetSdkVersion, 0, clientAttribution = this.getClientAttribution(0, false), 0);
                StreamConfiguration[] configs = physicalCameraInfo.get(CameraCharacteristics.SCALER_PHYSICAL_CAMERA_MULTI_RESOLUTION_STREAM_CONFIGURATIONS);
                if (configs == null) continue;
                multiResolutionStreamConfigurations.put(physicalCameraId, configs);
            }
        }
        catch (RemoteException e) {
            ServiceSpecificException sse = new ServiceSpecificException(4, "Camera service is currently unavailable");
            throw ExceptionUtils.throwAsPublicException(sse);
        }
        return multiResolutionStreamConfigurations;
    }

    @NonNull
    public CameraCharacteristics getCameraCharacteristics(@NonNull String cameraId) throws CameraAccessException {
        return this.getCameraCharacteristics(cameraId, CameraManager.getRotationOverride(this.mContext));
    }

    @NonNull
    public CameraCharacteristics getCameraCharacteristics(@NonNull String cameraId, boolean overrideToPortrait) throws CameraAccessException {
        return this.getCameraCharacteristics(cameraId, overrideToPortrait ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private CameraCharacteristics getCameraCharacteristics(@NonNull String cameraId, int rotationOverride) throws CameraAccessException {
        CameraCharacteristics characteristics = null;
        if (CameraManagerGlobal.sCameraServiceDisabled) {
            throw new IllegalArgumentException("No cameras available on device");
        }
        Object object = this.mLock;
        synchronized (object) {
            ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
            if (cameraService == null) {
                throw new CameraAccessException(2, "Camera service is currently unavailable");
            }
            try {
                CameraMetadataNative info = cameraService.getCameraCharacteristics(cameraId, this.mContext.getApplicationInfo().targetSdkVersion, rotationOverride, this.getClientAttribution(), this.getDevicePolicyFromContext(this.mContext));
                characteristics = this.prepareCameraCharacteristics(cameraId, info, cameraService);
            }
            catch (ServiceSpecificException e) {
                throw ExceptionUtils.throwAsPublicException(e);
            }
            catch (RemoteException e) {
                throw new CameraAccessException(2, "Camera service is currently unavailable", e);
            }
        }
        this.registerDeviceStateListener(characteristics);
        return characteristics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public CameraCharacteristics prepareCameraCharacteristics(@NonNull String cameraId, CameraMetadataNative metadata, ICameraService cameraService) throws CameraAccessException {
        Object object = this.mLock;
        synchronized (object) {
            try {
                metadata.setCameraId(Integer.parseInt(cameraId));
            }
            catch (NumberFormatException e) {
                Log.v(TAG, "Failed to parse camera Id " + cameraId + " to integer");
            }
            boolean hasConcurrentStreams = CameraManagerGlobal.get().cameraIdHasConcurrentStreams(cameraId, this.mContext.getDeviceId(), this.getDevicePolicyFromContext(this.mContext));
            metadata.setHasMandatoryConcurrentStreams(hasConcurrentStreams);
            Size displaySize = this.getDisplaySize();
            metadata.setDisplaySize(displaySize);
            Map<String, StreamConfiguration[]> multiResolutionSizeMap = this.getPhysicalCameraMultiResolutionConfigs(cameraId, metadata, cameraService);
            if (!multiResolutionSizeMap.isEmpty()) {
                metadata.setMultiResolutionStreamConfigurationMap(multiResolutionSizeMap);
            }
            return new CameraCharacteristics(metadata);
        }
    }

    @NonNull
    public CameraExtensionCharacteristics getCameraExtensionCharacteristics(@NonNull String cameraId) throws CameraAccessException {
        CameraCharacteristics chars = this.getCameraCharacteristics(cameraId);
        Map<String, CameraCharacteristics> characteristicsMap = this.getPhysicalIdToCharsMap(chars);
        characteristicsMap.put(cameraId, chars);
        return new CameraExtensionCharacteristics(this.mContext, cameraId, characteristicsMap);
    }

    public Map<String, CameraCharacteristics> getPhysicalIdToCharsMap(CameraCharacteristics chars) throws CameraAccessException {
        HashMap<String, CameraCharacteristics> physicalIdsToChars = new HashMap<String, CameraCharacteristics>();
        Set<String> physicalCameraIds = chars.getPhysicalCameraIds();
        for (String physicalCameraId : physicalCameraIds) {
            CameraCharacteristics physicalChars = this.getCameraCharacteristics(physicalCameraId);
            physicalIdsToChars.put(physicalCameraId, physicalChars);
        }
        return physicalIdsToChars;
    }

    @NonNull
    public CameraDevice.CameraDeviceSetup getCameraDeviceSetup(@NonNull String cameraId) throws CameraAccessException {
        if (!this.isCameraDeviceSetupSupported(cameraId)) {
            throw new UnsupportedOperationException("CameraDeviceSetup is not supported for Camera ID: " + cameraId);
        }
        return this.getCameraDeviceSetupUnsafe(cameraId);
    }

    private CameraDevice.CameraDeviceSetup getCameraDeviceSetupUnsafe(@NonNull String cameraId) {
        return new CameraDeviceSetupImpl(cameraId, this, this.mContext);
    }

    public boolean isCameraDeviceSetupSupported(@NonNull String cameraId) throws CameraAccessException {
        if (cameraId == null) {
            throw new IllegalArgumentException("Camera ID was null");
        }
        if (CameraManagerGlobal.sCameraServiceDisabled || !Arrays.asList(CameraManagerGlobal.get().getCameraIdList(this.mContext.getDeviceId(), this.getDevicePolicyFromContext(this.mContext))).contains(cameraId)) {
            throw new IllegalArgumentException("Camera ID '" + cameraId + "' not available on device.");
        }
        CameraCharacteristics chars = this.getCameraCharacteristics(cameraId);
        return CameraDeviceSetupImpl.isCameraDeviceSetupSupported(chars);
    }

    @SystemApi
    @FlaggedApi(value="com.android.internal.camera.flags.camera_multi_client")
    public boolean isCameraDeviceSharingSupported(@NonNull String cameraId) throws CameraAccessException {
        if (cameraId == null) {
            throw new IllegalArgumentException("Camera ID was null");
        }
        if (CameraManagerGlobal.sCameraServiceDisabled || !Arrays.asList(CameraManagerGlobal.get().getCameraIdList(this.mContext.getDeviceId(), this.getDevicePolicyFromContext(this.mContext))).contains(cameraId)) {
            throw new IllegalArgumentException("Camera ID '" + cameraId + "' not available on device.");
        }
        CameraCharacteristics chars = this.getCameraCharacteristics(cameraId);
        long[] sharedOutputConfiguration = chars.get(CameraCharacteristics.SHARED_SESSION_OUTPUT_CONFIGURATIONS);
        return sharedOutputConfiguration != null;
    }

    public AttributionSourceState getClientAttribution(int deviceIdOverride, boolean useContextAttributionSource) {
        AttributionSource contextAttributionSource = this.mContext.getAttributionSource();
        if (deviceIdOverride != -1) {
            contextAttributionSource = contextAttributionSource.withDeviceId(deviceIdOverride);
        }
        AttributionSourceState contextAttributionSourceState = contextAttributionSource.asState();
        if (useContextAttributionSource) {
            return contextAttributionSourceState;
        }
        AttributionSourceState clientAttribution = new AttributionSourceState();
        clientAttribution.uid = -1;
        clientAttribution.pid = -1;
        clientAttribution.deviceId = contextAttributionSourceState.deviceId;
        clientAttribution.packageName = this.mContext.getOpPackageName();
        clientAttribution.attributionTag = this.mContext.getAttributionTag();
        clientAttribution.next = new AttributionSourceState[0];
        return clientAttribution;
    }

    public AttributionSourceState getClientAttribution(boolean useContextAttributionSource) {
        return this.getClientAttribution(-1, useContextAttributionSource);
    }

    public AttributionSourceState getClientAttribution() {
        return this.getClientAttribution(-1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Executor executor, int oomScoreOffset, int rotationOverride, boolean sharedMode) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        CameraDeviceImpl device = null;
        Object object = this.mLock;
        synchronized (object) {
            ICameraDeviceUser cameraUser = null;
            CameraDevice.CameraDeviceSetup cameraDeviceSetup = null;
            if (CameraDeviceSetupImpl.isCameraDeviceSetupSupported(characteristics)) {
                cameraDeviceSetup = this.getCameraDeviceSetupUnsafe(cameraId);
            }
            CameraDeviceImpl deviceImpl = new CameraDeviceImpl(cameraId, callback, executor, characteristics, this, this.mContext.getApplicationInfo().targetSdkVersion, this.mContext, cameraDeviceSetup, sharedMode);
            CameraDeviceImpl.CameraDeviceCallbacks callbacks = deviceImpl.getCallbacks();
            try {
                ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
                if (cameraService == null) {
                    throw new ServiceSpecificException(4, "Camera service is currently unavailable");
                }
                AttributionSourceState clientAttribution = this.getClientAttribution(true);
                cameraUser = cameraService.connectDevice(callbacks, cameraId, oomScoreOffset, this.mContext.getApplicationInfo().targetSdkVersion, rotationOverride, clientAttribution, this.getDevicePolicyFromContext(this.mContext), sharedMode);
            }
            catch (ServiceSpecificException e) {
                if (e.errorCode == 9) {
                    throw new AssertionError((Object)"Should've gone down the shim path");
                }
                if (e.errorCode == 7 || e.errorCode == 8 || e.errorCode == 6 || e.errorCode == 4 || e.errorCode == 10) {
                    deviceImpl.setRemoteFailure(e);
                    if (e.errorCode == 6 || e.errorCode == 4 || e.errorCode == 7) {
                        throw ExceptionUtils.throwAsPublicException(e);
                    }
                }
                throw ExceptionUtils.throwAsPublicException(e);
            }
            catch (RemoteException e) {
                ServiceSpecificException sse = new ServiceSpecificException(4, "Camera service is currently unavailable");
                deviceImpl.setRemoteFailure(sse);
                throw ExceptionUtils.throwAsPublicException(sse);
            }
            deviceImpl.setRemoteDevice(cameraUser);
            device = deviceImpl;
        }
        return device;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void openCamera(@NonNull String cameraId, @NonNull CameraDevice.StateCallback callback, @Nullable Handler handler) throws CameraAccessException {
        this.openCameraImpl(cameraId, callback, CameraDeviceImpl.checkAndWrapHandler(handler), 0, CameraManager.getRotationOverride(this.mContext), false);
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void openCamera(@NonNull String cameraId, boolean overrideToPortrait, @Nullable Handler handler, @NonNull CameraDevice.StateCallback callback) throws CameraAccessException {
        this.openCameraImpl(cameraId, callback, CameraDeviceImpl.checkAndWrapHandler(handler), 0, overrideToPortrait ? 1 : 0, false);
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void openCamera(@NonNull String cameraId, @NonNull Executor executor, @NonNull CameraDevice.StateCallback callback) throws CameraAccessException {
        if (executor == null) {
            throw new IllegalArgumentException("executor was null");
        }
        this.openCameraImpl(cameraId, callback, executor, 0, CameraManager.getRotationOverride(this.mContext), false);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.SYSTEM_CAMERA", "android.permission.CAMERA"})
    @FlaggedApi(value="com.android.internal.camera.flags.camera_multi_client")
    public void openSharedCamera(@NonNull String cameraId, @NonNull Executor executor, @NonNull CameraDevice.StateCallback callback) throws CameraAccessException {
        if (executor == null) {
            throw new IllegalArgumentException("executor was null");
        }
        if (!this.isCameraDeviceSharingSupported(cameraId)) {
            throw new UnsupportedOperationException("CameraDevice sharing is not supported for Camera ID: " + cameraId);
        }
        this.openCameraImpl(cameraId, callback, executor, 0, CameraManager.getRotationOverride(this.mContext), true);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.SYSTEM_CAMERA", "android.permission.CAMERA"})
    public void openCamera(@NonNull String cameraId, int oomScoreOffset, @NonNull Executor executor, @NonNull CameraDevice.StateCallback callback) throws CameraAccessException {
        if (executor == null) {
            throw new IllegalArgumentException("executor was null");
        }
        if (oomScoreOffset < 0) {
            throw new IllegalArgumentException("oomScoreOffset < 0, cannot increase priority of camera client");
        }
        this.openCameraImpl(cameraId, callback, executor, oomScoreOffset, CameraManager.getRotationOverride(this.mContext), false);
    }

    public void openCameraImpl(@NonNull String cameraId, @NonNull CameraDevice.StateCallback callback, @NonNull Executor executor, int oomScoreOffset, int rotationOverride, boolean sharedMode) throws CameraAccessException {
        if (cameraId == null) {
            throw new IllegalArgumentException("cameraId was null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback was null");
        }
        if (CameraManagerGlobal.sCameraServiceDisabled) {
            throw new IllegalArgumentException("No cameras available on device");
        }
        this.openCameraDeviceUserAsync(cameraId, callback, executor, oomScoreOffset, rotationOverride, sharedMode);
    }

    public void setTorchMode(@NonNull String cameraId, boolean enabled) throws CameraAccessException {
        if (CameraManagerGlobal.sCameraServiceDisabled) {
            throw new IllegalArgumentException("No cameras available on device");
        }
        CameraManagerGlobal.get().setTorchMode(cameraId, enabled, this.getClientAttribution(), this.getDevicePolicyFromContext(this.mContext));
    }

    public void turnOnTorchWithStrengthLevel(@NonNull String cameraId, int torchStrength) throws CameraAccessException {
        if (CameraManagerGlobal.sCameraServiceDisabled) {
            throw new IllegalArgumentException("No camera available on device");
        }
        CameraManagerGlobal.get().turnOnTorchWithStrengthLevel(cameraId, torchStrength, this.getClientAttribution(), this.getDevicePolicyFromContext(this.mContext));
    }

    public int getTorchStrengthLevel(@NonNull String cameraId) throws CameraAccessException {
        if (CameraManagerGlobal.sCameraServiceDisabled) {
            throw new IllegalArgumentException("No camera available on device.");
        }
        return CameraManagerGlobal.get().getTorchStrengthLevel(cameraId, this.getClientAttribution(), this.getDevicePolicyFromContext(this.mContext));
    }

    public static int getRotationOverride(@Nullable Context context) {
        PackageManager packageManager = null;
        String packageName = null;
        if (context != null) {
            packageManager = context.getPackageManager();
            packageName = context.getOpPackageName();
        }
        return CameraManager.getRotationOverride(context, packageManager, packageName);
    }

    public static int getRotationOverride(@Nullable Context context, @Nullable PackageManager packageManager, @Nullable String packageName) {
        if (!Process.isIsolated() && DesktopModeFlags.ENABLE_CAMERA_COMPAT_SIMULATE_REQUESTED_ORIENTATION.isTrue()) {
            return CameraManager.getRotationOverrideInternal(context, packageManager, packageName);
        }
        return CameraManager.shouldOverrideToPortrait(packageManager, packageName) ? 1 : 0;
    }

    @FlaggedApi(value="com.android.window.flags.enable_camera_compat_for_desktop_windowing")
    public static int getRotationOverrideInternal(@Nullable Context context, @Nullable PackageManager packageManager, @Nullable String packageName) {
        ActivityManager activityManager;
        if (!CameraManagerGlobal.sLandscapeToPortrait) {
            return 0;
        }
        if (context != null && !Process.isIsolated() && (activityManager = context.getSystemService(ActivityManager.class)) != null) {
            for (ActivityManager.AppTask appTask : activityManager.getAppTasks()) {
                ActivityManager.RecentTaskInfo taskInfo = appTask.getTaskInfo();
                int freeformCameraCompatMode = taskInfo.appCompatTaskInfo.cameraCompatTaskInfo.freeformCameraCompatMode;
                if (!CameraManager.isInCameraCompatMode(freeformCameraCompatMode) || taskInfo.topActivity == null || !taskInfo.topActivity.getPackageName().equals(packageName)) continue;
                return CameraManager.getRotationOverrideForCompatFreeform(freeformCameraCompatMode, taskInfo.appCompatTaskInfo.cameraCompatTaskInfo.displayRotation);
            }
        }
        if (packageManager != null && packageName != null) {
            try {
                return packageManager.getProperty("android.camera.PROPERTY_COMPAT_OVERRIDE_LANDSCAPE_TO_PORTRAIT", packageName).getBoolean() ? 1 : 0;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return CompatChanges.isChangeEnabled(250678880L) ? 1 : 0;
    }

    private static boolean isInCameraCompatMode(int freeformCameraCompatMode) {
        return freeformCameraCompatMode != 0 && freeformCameraCompatMode != 1;
    }

    private static int getRotationOverrideForCompatFreeform(int freeformCameraCompatMode, int displayRotation) {
        if (freeformCameraCompatMode == 5 || freeformCameraCompatMode == 2) {
            if (displayRotation == 1 && Flags.enableCameraCompatCheckDeviceRotationBugfix()) {
                return 3;
            }
            if (displayRotation == 3) {
                return 2;
            }
            return 2;
        }
        return 0;
    }

    public static boolean shouldOverrideToPortrait(@Nullable PackageManager packageManager, @Nullable String packageName) {
        if (!CameraManagerGlobal.sLandscapeToPortrait) {
            return false;
        }
        if (packageManager != null && packageName != null) {
            try {
                return packageManager.getProperty("android.camera.PROPERTY_COMPAT_OVERRIDE_LANDSCAPE_TO_PORTRAIT", packageName).getBoolean();
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return CompatChanges.isChangeEnabled(250678880L);
    }

    public static boolean physicalCallbacksAreEnabledForUnavailableCamera() {
        return CompatChanges.isChangeEnabled(244358506L);
    }

    public static boolean isHiddenPhysicalCamera(String cameraId) {
        try {
            ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
            if (cameraService == null) {
                return false;
            }
            return cameraService.isHiddenPhysicalCamera(cameraId);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA_INJECT_EXTERNAL_CAMERA")
    public void injectCamera(@NonNull String packageName, @NonNull String internalCamId, @NonNull String externalCamId, @NonNull Executor executor, @NonNull CameraInjectionSession.InjectionStatusCallback callback) throws CameraAccessException, SecurityException, IllegalArgumentException {
        if (CameraManagerGlobal.sCameraServiceDisabled) {
            throw new IllegalArgumentException("No cameras available on device");
        }
        ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
        if (cameraService == null) {
            throw new CameraAccessException(2, "Camera service is currently unavailable");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                CameraInjectionSessionImpl injectionSessionImpl = new CameraInjectionSessionImpl(callback, executor);
                CameraInjectionSessionImpl.CameraInjectionCallback cameraInjectionCallback = injectionSessionImpl.getCallback();
                ICameraInjectionSession injectionSession = cameraService.injectCamera(packageName, internalCamId, externalCamId, cameraInjectionCallback);
                injectionSessionImpl.setRemoteInjectionSession(injectionSession);
            }
            catch (ServiceSpecificException e) {
                throw ExceptionUtils.throwAsPublicException(e);
            }
            catch (RemoteException e) {
                ServiceSpecificException sse = new ServiceSpecificException(4, "Camera service is currently unavailable");
                throw ExceptionUtils.throwAsPublicException(sse);
            }
        }
    }

    @RequiresPermission(value="android.permission.CAMERA_INJECT_EXTERNAL_CAMERA")
    public void injectSessionParams(@NonNull String cameraId, @NonNull CaptureRequest sessionParams) throws CameraAccessException, SecurityException {
        CameraManagerGlobal.get().injectSessionParams(cameraId, sessionParams);
    }

    public ICameraService getCameraService() {
        return CameraManagerGlobal.get().getCameraService();
    }

    public boolean isCameraServiceDisabled() {
        return CameraManagerGlobal.sCameraServiceDisabled;
    }

    public static String reportExtensionSessionStats(CameraExtensionSessionStats extStats) {
        ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
        if (cameraService == null) {
            Log.e(TAG, "CameraService not available. Not reporting extension stats.");
            return "";
        }
        try {
            return cameraService.reportExtensionSessionStats(extStats);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to report extension session stats to cameraservice.", e);
            return "";
        }
    }

    private static class CameraManagerGlobal
    extends ICameraServiceListener.Stub
    implements IBinder.DeathRecipient {
        private static final String TAG = "CameraManagerGlobal";
        private final boolean DEBUG = false;
        private final int CAMERA_SERVICE_RECONNECT_DELAY_MS = 1000;
        private static final CameraManagerGlobal gCameraManager = new CameraManagerGlobal();
        private static final String CAMERA_SERVICE_BINDER_NAME = "media.camera";
        private final ScheduledExecutorService mScheduler = Executors.newScheduledThreadPool(1);
        private final ArrayMap<DeviceCameraInfo, Integer> mDeviceStatus = new ArrayMap();
        private final ArrayMap<DeviceCameraInfo, ArrayList<String>> mUnavailablePhysicalDevices = new ArrayMap();
        private final ArrayMap<DeviceCameraInfo, String> mOpenedDevices = new ArrayMap();
        private final Set<Set<DeviceCameraInfo>> mConcurrentCameraIdCombinations = new ArraySet<Set<DeviceCameraInfo>>();
        private static final int DEVICE_STATUS_ARRAY_SIZE = 10;
        private final ArrayDeque<String> mDeviceStatusHistory = new ArrayDeque(10);
        private final ArrayMap<AvailabilityCallback, Executor> mCallbackMap = new ArrayMap();
        private final Binder mTorchClientBinder = new Binder();
        private final ArrayMap<DeviceCameraInfo, Integer> mTorchStatus = new ArrayMap();
        private final ArrayMap<TorchCallback, Executor> mTorchCallbackMap = new ArrayMap();
        private final Object mLock = new Object();
        private ICameraService mCameraService;
        private boolean mHasOpenCloseListenerPermission = false;
        private HandlerThread mDeviceStateHandlerThread;
        private Handler mDeviceStateHandler;
        private FoldStateListener mFoldStateListener;
        public static final boolean sCameraServiceDisabled = SystemProperties.getBoolean("config.disable_cameraservice", false);
        public static final boolean sLandscapeToPortrait = SystemProperties.getBoolean("camera.enable_landscape_to_portrait", false);

        private CameraManagerGlobal() {
        }

        public static CameraManagerGlobal get() {
            return gCameraManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerDeviceStateListener(@NonNull CameraCharacteristics chars, @NonNull Context ctx) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mDeviceStateHandlerThread == null) {
                    this.mDeviceStateHandlerThread = new HandlerThread(TAG);
                    this.mDeviceStateHandlerThread.start();
                    this.mDeviceStateHandler = new Handler(this.mDeviceStateHandlerThread.getLooper());
                }
                if (this.mFoldStateListener == null) {
                    this.mFoldStateListener = new FoldStateListener(ctx);
                    try {
                        ctx.getSystemService(DeviceStateManager.class).registerCallback(new HandlerExecutor(this.mDeviceStateHandler), this.mFoldStateListener);
                    }
                    catch (IllegalStateException e) {
                        this.mFoldStateListener = null;
                        Log.v(TAG, "Failed to register device state listener!");
                        Log.v(TAG, "Device state dependent characteristics updates will not befunctional!");
                        return;
                    }
                }
                this.mFoldStateListener.addDeviceStateListener(chars.getDeviceStateListener());
            }
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ICameraService getCameraService() {
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                if (this.mCameraService == null && !sCameraServiceDisabled) {
                    Log.e(TAG, "Camera service is unavailable");
                }
                return this.mCameraService;
            }
        }

        private void connectCameraServiceLocked() {
            if (this.mCameraService != null || sCameraServiceDisabled) {
                return;
            }
            Log.i(TAG, "Connecting to camera service");
            IBinder cameraServiceBinder = ServiceManager.getService(CAMERA_SERVICE_BINDER_NAME);
            if (cameraServiceBinder == null) {
                return;
            }
            try {
                cameraServiceBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                return;
            }
            ICameraService cameraService = ICameraService.Stub.asInterface(cameraServiceBinder);
            try {
                CameraMetadataNative.setupGlobalVendorTagDescriptor();
            }
            catch (ServiceSpecificException e) {
                this.handleRecoverableSetupErrors(e);
            }
            try {
                this.addDeviceStatusHistoryLocked(TextUtils.formatSimple("connectCameraServiceLocked(E): tid(%d): mDeviceStatus size %d", Thread.currentThread().getId(), this.mDeviceStatus.size()));
                CameraStatus[] cameraStatuses = cameraService.addListener(this);
                for (Parcelable parcelable : cameraStatuses) {
                    DeviceCameraInfo info = new DeviceCameraInfo(((CameraStatus)parcelable).cameraId, ((CameraStatus)parcelable).deviceId);
                    this.onStatusChangedLocked(((CameraStatus)parcelable).status, info);
                    if (((CameraStatus)parcelable).unavailablePhysicalCameras != null) {
                        for (String unavailablePhysicalCamera : ((CameraStatus)parcelable).unavailablePhysicalCameras) {
                            this.onPhysicalCameraStatusChangedLocked(0, info, unavailablePhysicalCamera);
                        }
                    }
                    if (!this.mHasOpenCloseListenerPermission || ((CameraStatus)parcelable).status != -2 || ((CameraStatus)parcelable).clientPackage.isEmpty()) continue;
                    this.onCameraOpenedLocked(info, ((CameraStatus)parcelable).clientPackage);
                }
                this.mCameraService = cameraService;
                this.addDeviceStatusHistoryLocked(TextUtils.formatSimple("connectCameraServiceLocked(X): tid(%d): mDeviceStatus size %d", Thread.currentThread().getId(), this.mDeviceStatus.size()));
            }
            catch (ServiceSpecificException e) {
                throw new IllegalStateException("Failed to register a camera service listener", e);
            }
            catch (RemoteException e) {
                // empty catch block
            }
            try {
                ConcurrentCameraIdCombination[] cameraIdCombinations = cameraService.getConcurrentCameraIds();
                for (ConcurrentCameraIdCombination concurrentCameraIdCombination : cameraIdCombinations) {
                    Set<Pair<String, Integer>> combination = concurrentCameraIdCombination.getConcurrentCameraIdCombination();
                    ArraySet<DeviceCameraInfo> deviceCameraInfoSet = new ArraySet<DeviceCameraInfo>();
                    for (Pair<String, Integer> entry : combination) {
                        deviceCameraInfoSet.add(new DeviceCameraInfo((String)entry.first, (Integer)entry.second));
                    }
                    this.mConcurrentCameraIdCombinations.add(deviceCameraInfoSet);
                }
            }
            catch (ServiceSpecificException e) {
                throw new IllegalStateException("Failed to get concurrent camera id combinations", e);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void injectSessionParams(@NonNull String cameraId, @NonNull CaptureRequest sessionParams) throws CameraAccessException, SecurityException {
            Object object = this.mLock;
            synchronized (object) {
                ICameraService cameraService = this.getCameraService();
                if (cameraService == null) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable.");
                }
                try {
                    cameraService.injectSessionParams(cameraId, sessionParams.getNativeMetadata());
                }
                catch (ServiceSpecificException e) {
                    throw ExceptionUtils.throwAsPublicException(e);
                }
                catch (RemoteException e) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable.");
                }
            }
        }

        private String[] extractCameraIdListLocked(int deviceId, int devicePolicy) {
            this.addDeviceStatusHistoryLocked(TextUtils.formatSimple("extractCameraIdListLocked(E): tid(%d): mDeviceStatus size %d", Thread.currentThread().getId(), this.mDeviceStatus.size()));
            try {
                ArrayList<String> cameraIds = new ArrayList<String>();
                for (int i = 0; i < this.mDeviceStatus.size(); ++i) {
                    int status = this.mDeviceStatus.valueAt(i);
                    DeviceCameraInfo info = this.mDeviceStatus.keyAt(i);
                    if (status == 0 || status == 2 || this.shouldHideCamera(deviceId, devicePolicy, info)) continue;
                    cameraIds.add(info.mCameraId);
                }
                return cameraIds.toArray(new String[0]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                String message = e.getMessage();
                String messageWithHistory = message + ": {" + String.join((CharSequence)" -> ", this.mDeviceStatusHistory) + "}";
                throw new ArrayIndexOutOfBoundsException(messageWithHistory);
            }
        }

        private Set<Set<String>> extractConcurrentCameraIdListLocked(int deviceId, int devicePolicy) {
            ArraySet<Set<String>> concurrentCameraIds = new ArraySet<Set<String>>();
            for (Set<DeviceCameraInfo> deviceCameraInfos : this.mConcurrentCameraIdCombinations) {
                ArraySet<String> extractedCameraIds = new ArraySet<String>();
                for (DeviceCameraInfo info : deviceCameraInfos) {
                    Integer status = this.mDeviceStatus.get(info);
                    if (status == null || status == 2 || status == 0 || this.shouldHideCamera(deviceId, devicePolicy, info)) continue;
                    extractedCameraIds.add(info.mCameraId);
                }
                if (extractedCameraIds.isEmpty()) continue;
                concurrentCameraIds.add(extractedCameraIds);
            }
            return concurrentCameraIds;
        }

        private static void sortCameraIds(String[] cameraIds) {
            Arrays.sort(cameraIds, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    int s1Int = 0;
                    int s2Int = 0;
                    try {
                        s1Int = Integer.parseInt(s1);
                    }
                    catch (NumberFormatException e) {
                        s1Int = -1;
                    }
                    try {
                        s2Int = Integer.parseInt(s2);
                    }
                    catch (NumberFormatException e) {
                        s2Int = -1;
                    }
                    if (s1Int >= 0 && s2Int >= 0) {
                        return s1Int - s2Int;
                    }
                    if (s1Int >= 0) {
                        return -1;
                    }
                    if (s2Int >= 0) {
                        return 1;
                    }
                    return s1.compareTo(s2);
                }
            });
        }

        private boolean shouldHideCamera(int currentDeviceId, int devicePolicy, DeviceCameraInfo info) {
            if (devicePolicy == 0 && info.mDeviceId == 0) {
                return false;
            }
            return currentDeviceId != info.mDeviceId;
        }

        private static boolean cameraStatusesContains(CameraStatus[] cameraStatuses, DeviceCameraInfo info) {
            for (CameraStatus c : cameraStatuses) {
                if (!c.cameraId.equals(info.mCameraId) || c.deviceId != info.mDeviceId) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getCameraIdListNoLazy(int deviceId, int devicePolicy) {
            String[] cameraIds;
            if (sCameraServiceDisabled) {
                return new String[0];
            }
            ICameraServiceListener.Stub testListener = new ICameraServiceListener.Stub(this){

                @Override
                public void onStatusChanged(int status, String id2, int deviceId) throws RemoteException {
                }

                @Override
                public void onPhysicalCameraStatusChanged(int status, String id2, String physicalId, int deviceId) throws RemoteException {
                }

                @Override
                public void onTorchStatusChanged(int status, String id2, int deviceId) throws RemoteException {
                }

                @Override
                public void onTorchStrengthLevelChanged(String id2, int newStrengthLevel, int deviceId) throws RemoteException {
                }

                @Override
                public void onCameraAccessPrioritiesChanged() {
                }

                @Override
                public void onCameraOpened(String id2, String clientPackageId, int deviceId) {
                }

                @Override
                public void onCameraClosed(String id2, int deviceId) {
                }

                @Override
                public void onCameraOpenedInSharedMode(String id2, String clientPackageId, int deviceId, boolean primaryClient) {
                }
            };
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                try {
                    this.addDeviceStatusHistoryLocked(TextUtils.formatSimple("getCameraIdListNoLazy(E): tid(%d): mDeviceStatus size %d", Thread.currentThread().getId(), this.mDeviceStatus.size()));
                    CameraStatus[] cameraStatuses = this.mCameraService.addListener(testListener);
                    this.mCameraService.removeListener(testListener);
                    for (CameraStatus cameraStatus : cameraStatuses) {
                        this.onStatusChangedLocked(cameraStatus.status, new DeviceCameraInfo(cameraStatus.cameraId, cameraStatus.deviceId));
                    }
                    Set<DeviceCameraInfo> deviceCameraInfos = this.mDeviceStatus.keySet();
                    ArrayList<DeviceCameraInfo> deviceInfosToRemove = new ArrayList<DeviceCameraInfo>();
                    for (DeviceCameraInfo info : deviceCameraInfos) {
                        if (CameraManagerGlobal.cameraStatusesContains(cameraStatuses, info)) continue;
                        deviceInfosToRemove.add(info);
                    }
                    for (DeviceCameraInfo info : deviceInfosToRemove) {
                        this.onStatusChangedLocked(0, info);
                        this.mTorchStatus.remove(info);
                    }
                    this.addDeviceStatusHistoryLocked(TextUtils.formatSimple("getCameraIdListNoLazy(X): tid(%d): mDeviceStatus size %d", Thread.currentThread().getId(), this.mDeviceStatus.size()));
                }
                catch (ServiceSpecificException e) {
                    throw new IllegalStateException("Failed to register a camera service listener", e);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                cameraIds = this.extractCameraIdListLocked(deviceId, devicePolicy);
            }
            CameraManagerGlobal.sortCameraIds(cameraIds);
            return cameraIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getCameraIdList(int deviceId, int devicePolicy) {
            String[] cameraIds;
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                cameraIds = this.extractCameraIdListLocked(deviceId, devicePolicy);
            }
            CameraManagerGlobal.sortCameraIds(cameraIds);
            return cameraIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public Set<Set<String>> getConcurrentCameraIds(int deviceId, int devicePolicy) {
            Set<Set<String>> concurrentStreamingCameraIds;
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                concurrentStreamingCameraIds = this.extractConcurrentCameraIdListLocked(deviceId, devicePolicy);
            }
            return concurrentStreamingCameraIds;
        }

        public boolean isConcurrentSessionConfigurationSupported(@NonNull Map<String, SessionConfiguration> cameraIdsAndSessionConfigurations, int targetSdkVersion, AttributionSourceState clientAttribution, int devicePolicy) throws CameraAccessException {
            if (cameraIdsAndSessionConfigurations == null) {
                throw new IllegalArgumentException("cameraIdsAndSessionConfigurations was null");
            }
            int size = cameraIdsAndSessionConfigurations.size();
            if (size == 0) {
                throw new IllegalArgumentException("camera id and session combination is empty");
            }
            Object object = this.mLock;
            synchronized (object) {
                boolean subsetFound = false;
                for (Set<DeviceCameraInfo> combination : this.mConcurrentCameraIdCombinations) {
                    ArraySet infos = new ArraySet();
                    for (String cameraId : cameraIdsAndSessionConfigurations.keySet()) {
                        infos.add(new DeviceCameraInfo(cameraId, devicePolicy == 0 ? 0 : clientAttribution.deviceId));
                    }
                    if (!combination.containsAll(infos)) continue;
                    subsetFound = true;
                }
                if (!subsetFound) {
                    Log.v(TAG, "isConcurrentSessionConfigurationSupported called with a subset of camera ids not returned by getConcurrentCameraIds");
                    return false;
                }
                CameraIdAndSessionConfiguration[] cameraIdsAndConfigs = new CameraIdAndSessionConfiguration[size];
                int i = 0;
                for (Map.Entry entry : cameraIdsAndSessionConfigurations.entrySet()) {
                    cameraIdsAndConfigs[i] = new CameraIdAndSessionConfiguration((String)entry.getKey(), (SessionConfiguration)entry.getValue());
                    ++i;
                }
                try {
                    return this.mCameraService.isConcurrentSessionConfigurationSupported(cameraIdsAndConfigs, targetSdkVersion, clientAttribution, devicePolicy);
                }
                catch (ServiceSpecificException e) {
                    throw ExceptionUtils.throwAsPublicException(e);
                }
                catch (RemoteException e) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cameraIdHasConcurrentStreams(String cameraId, int deviceId, int devicePolicy) {
            Object object = this.mLock;
            synchronized (object) {
                DeviceCameraInfo info = new DeviceCameraInfo(cameraId, devicePolicy == 0 ? 0 : deviceId);
                if (!this.mDeviceStatus.containsKey(info)) {
                    return false;
                }
                for (Set<DeviceCameraInfo> comb : this.mConcurrentCameraIdCombinations) {
                    if (!comb.contains(info)) continue;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTorchMode(String cameraId, boolean enabled, AttributionSourceState clientAttribution, int devicePolicy) throws CameraAccessException {
            Object object = this.mLock;
            synchronized (object) {
                if (cameraId == null) {
                    throw new IllegalArgumentException("cameraId was null");
                }
                ICameraService cameraService = this.getCameraService();
                if (cameraService == null) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable");
                }
                try {
                    cameraService.setTorchMode(cameraId, enabled, this.mTorchClientBinder, clientAttribution, devicePolicy);
                }
                catch (ServiceSpecificException e) {
                    throw ExceptionUtils.throwAsPublicException(e);
                }
                catch (RemoteException e) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void turnOnTorchWithStrengthLevel(String cameraId, int torchStrength, AttributionSourceState clientAttribution, int devicePolicy) throws CameraAccessException {
            Object object = this.mLock;
            synchronized (object) {
                if (cameraId == null) {
                    throw new IllegalArgumentException("cameraId was null");
                }
                ICameraService cameraService = this.getCameraService();
                if (cameraService == null) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable.");
                }
                try {
                    cameraService.turnOnTorchWithStrengthLevel(cameraId, torchStrength, this.mTorchClientBinder, clientAttribution, devicePolicy);
                }
                catch (ServiceSpecificException e) {
                    throw ExceptionUtils.throwAsPublicException(e);
                }
                catch (RemoteException e) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getTorchStrengthLevel(String cameraId, AttributionSourceState clientAttribution, int devicePolicy) throws CameraAccessException {
            int torchStrength;
            Object object = this.mLock;
            synchronized (object) {
                if (cameraId == null) {
                    throw new IllegalArgumentException("cameraId was null");
                }
                ICameraService cameraService = this.getCameraService();
                if (cameraService == null) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable.");
                }
                try {
                    torchStrength = cameraService.getTorchStrengthLevel(cameraId, clientAttribution, devicePolicy);
                }
                catch (ServiceSpecificException e) {
                    throw ExceptionUtils.throwAsPublicException(e);
                }
                catch (RemoteException e) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable.");
                }
            }
            return torchStrength;
        }

        private void handleRecoverableSetupErrors(ServiceSpecificException e) {
            switch (e.errorCode) {
                case 4: {
                    Log.w(TAG, e.getMessage());
                    break;
                }
                default: {
                    throw new IllegalStateException(e);
                }
            }
        }

        private boolean isAvailable(int status) {
            switch (status) {
                case 1: {
                    return true;
                }
            }
            return false;
        }

        private boolean validStatus(int status) {
            switch (status) {
                case -2: 
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        private boolean validTorchStatus(int status) {
            switch (status) {
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postSingleAccessPriorityChangeUpdate(AvailabilityCallback callback, Executor executor) {
            long ident = Binder.clearCallingIdentity();
            try {
                executor.execute(callback::onCameraAccessPrioritiesChanged);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postSingleCameraOpenedUpdate(AvailabilityCallback callback, Executor executor, String id2, String packageId) {
            long ident = Binder.clearCallingIdentity();
            try {
                executor.execute(() -> callback.onCameraOpened(id2, packageId));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postSingleCameraClosedUpdate(AvailabilityCallback callback, Executor executor, String id2) {
            long ident = Binder.clearCallingIdentity();
            try {
                executor.execute(() -> callback.onCameraClosed(id2));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postSingleUpdate(AvailabilityCallback callback, Executor executor, String id2, String physicalId, int status) {
            if (this.isAvailable(status)) {
                long ident = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> {
                        if (physicalId == null) {
                            callback.onCameraAvailable(id2);
                        } else {
                            callback.onPhysicalCameraAvailable(id2, physicalId);
                        }
                    });
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            long ident = Binder.clearCallingIdentity();
            try {
                executor.execute(() -> {
                    if (physicalId == null) {
                        callback.onCameraUnavailable(id2);
                    } else {
                        callback.onPhysicalCameraUnavailable(id2, physicalId);
                    }
                });
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postSingleTorchUpdate(TorchCallback callback, Executor executor, String id2, int status) {
            switch (status) {
                case 1: 
                case 2: {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onTorchModeChanged(id2, status == 2));
                        break;
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                default: {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onTorchModeUnavailable(id2));
                        break;
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postSingleTorchStrengthLevelUpdate(TorchCallback callback, Executor executor, String id2, int newStrengthLevel) {
            long ident = Binder.clearCallingIdentity();
            try {
                executor.execute(() -> callback.onTorchStrengthLevelChanged(id2, newStrengthLevel));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        private void updateCallbackLocked(AvailabilityCallback callback, Executor executor) {
            DeviceCameraInfo info;
            int i;
            for (i = 0; i < this.mDeviceStatus.size(); ++i) {
                info = this.mDeviceStatus.keyAt(i);
                if (this.shouldHideCamera(callback.mDeviceId, callback.mDevicePolicy, info)) continue;
                Integer status = this.mDeviceStatus.valueAt(i);
                this.postSingleUpdate(callback, executor, info.mCameraId, null, status);
                if (!this.isAvailable(status) && !CameraManager.physicalCallbacksAreEnabledForUnavailableCamera() || !this.mUnavailablePhysicalDevices.containsKey(info)) continue;
                List unavailableIds = this.mUnavailablePhysicalDevices.get(info);
                for (String unavailableId : unavailableIds) {
                    this.postSingleUpdate(callback, executor, info.mCameraId, unavailableId, 0);
                }
            }
            for (i = 0; i < this.mOpenedDevices.size(); ++i) {
                info = this.mOpenedDevices.keyAt(i);
                if (this.shouldHideCamera(callback.mDeviceId, callback.mDevicePolicy, info)) continue;
                String clientPackageId = this.mOpenedDevices.valueAt(i);
                this.postSingleCameraOpenedUpdate(callback, executor, info.mCameraId, clientPackageId);
            }
        }

        private void onStatusChangedLocked(int status, DeviceCameraInfo info) {
            Integer oldStatus;
            if (!this.validStatus(status)) {
                Log.e(TAG, String.format("Ignoring invalid camera %s status 0x%x for device %d", info.mCameraId, status, info.mDeviceId));
                return;
            }
            if (status == 0) {
                oldStatus = this.mDeviceStatus.remove(info);
                this.mUnavailablePhysicalDevices.remove(info);
            } else {
                oldStatus = this.mDeviceStatus.put(info, status);
                if (oldStatus == null) {
                    this.mUnavailablePhysicalDevices.put(info, new ArrayList());
                }
            }
            if (oldStatus != null && oldStatus == status) {
                return;
            }
            if (oldStatus != null && this.isAvailable(status) == this.isAvailable(oldStatus)) {
                return;
            }
            int callbackCount = this.mCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                AvailabilityCallback callback = this.mCallbackMap.keyAt(i);
                if (this.shouldHideCamera(callback.mDeviceId, callback.mDevicePolicy, info)) continue;
                Executor executor = this.mCallbackMap.valueAt(i);
                this.postSingleUpdate(callback, executor, info.mCameraId, null, status);
                if (!this.isAvailable(status) || !this.mUnavailablePhysicalDevices.containsKey(info)) continue;
                List unavailableIds = this.mUnavailablePhysicalDevices.get(info);
                for (String unavailableId : unavailableIds) {
                    this.postSingleUpdate(callback, executor, info.mCameraId, unavailableId, 0);
                }
            }
        }

        private void onPhysicalCameraStatusChangedLocked(int status, DeviceCameraInfo info, String physicalId) {
            if (!this.validStatus(status)) {
                Log.e(TAG, String.format("Ignoring invalid device %s physical device %s status 0x%x for device %d", info.mCameraId, physicalId, status, info.mDeviceId));
                return;
            }
            if (!this.mDeviceStatus.containsKey(info) || !this.mUnavailablePhysicalDevices.containsKey(info)) {
                Log.e(TAG, String.format("Camera %s is not present. Ignore physical camera status change", info.mCameraId));
                return;
            }
            List unavailablePhysicalDevices = this.mUnavailablePhysicalDevices.get(info);
            if (!this.isAvailable(status) && !unavailablePhysicalDevices.contains(physicalId)) {
                unavailablePhysicalDevices.add(physicalId);
            } else if (this.isAvailable(status) && unavailablePhysicalDevices.contains(physicalId)) {
                unavailablePhysicalDevices.remove(physicalId);
            } else {
                return;
            }
            if (!CameraManager.physicalCallbacksAreEnabledForUnavailableCamera() && !this.isAvailable(this.mDeviceStatus.get(info))) {
                Log.i(TAG, String.format("Camera %s is not available. Ignore physical camera status change callback(s)", info.mCameraId));
                return;
            }
            int callbackCount = this.mCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                AvailabilityCallback callback = this.mCallbackMap.keyAt(i);
                if (this.shouldHideCamera(callback.mDeviceId, callback.mDevicePolicy, info)) continue;
                Executor executor = this.mCallbackMap.valueAt(i);
                this.postSingleUpdate(callback, executor, info.mCameraId, physicalId, status);
            }
        }

        private void updateTorchCallbackLocked(TorchCallback callback, Executor executor) {
            for (int i = 0; i < this.mTorchStatus.size(); ++i) {
                DeviceCameraInfo info = this.mTorchStatus.keyAt(i);
                if (this.shouldHideCamera(callback.mDeviceId, callback.mDevicePolicy, info)) continue;
                Integer status = this.mTorchStatus.valueAt(i);
                this.postSingleTorchUpdate(callback, executor, info.mCameraId, status);
            }
        }

        private void onTorchStatusChangedLocked(int status, DeviceCameraInfo info) {
            if (!this.validTorchStatus(status)) {
                Log.e(TAG, String.format("Ignoring invalid camera %s torch status 0x%x for device %d", info.mCameraId, status, info.mDeviceId));
                return;
            }
            Integer oldStatus = this.mTorchStatus.put(info, status);
            if (oldStatus != null && oldStatus == status) {
                return;
            }
            int callbackCount = this.mTorchCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                TorchCallback callback = this.mTorchCallbackMap.keyAt(i);
                if (this.shouldHideCamera(callback.mDeviceId, callback.mDevicePolicy, info)) continue;
                Executor executor = this.mTorchCallbackMap.valueAt(i);
                this.postSingleTorchUpdate(callback, executor, info.mCameraId, status);
            }
        }

        private void onTorchStrengthLevelChangedLocked(DeviceCameraInfo info, int newStrengthLevel) {
            int callbackCount = this.mTorchCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                TorchCallback callback = this.mTorchCallbackMap.keyAt(i);
                if (this.shouldHideCamera(callback.mDeviceId, callback.mDevicePolicy, info)) continue;
                Executor executor = this.mTorchCallbackMap.valueAt(i);
                this.postSingleTorchStrengthLevelUpdate(callback, executor, info.mCameraId, newStrengthLevel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerAvailabilityCallback(AvailabilityCallback callback, Executor executor, boolean hasOpenCloseListenerPermission, int deviceId, int devicePolicy) {
            Object object = this.mLock;
            synchronized (object) {
                this.mHasOpenCloseListenerPermission = hasOpenCloseListenerPermission;
                this.connectCameraServiceLocked();
                callback.mDeviceId = deviceId;
                callback.mDevicePolicy = devicePolicy;
                Executor oldExecutor = this.mCallbackMap.put(callback, executor);
                if (oldExecutor == null) {
                    this.updateCallbackLocked(callback, executor);
                }
                if (this.mCameraService == null) {
                    this.scheduleCameraServiceReconnectionLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterAvailabilityCallback(AvailabilityCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mCallbackMap.remove(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerTorchCallback(TorchCallback callback, Executor executor, int deviceId, int devicePolicy) {
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                callback.mDeviceId = deviceId;
                callback.mDevicePolicy = devicePolicy;
                Executor oldExecutor = this.mTorchCallbackMap.put(callback, executor);
                if (oldExecutor == null) {
                    this.updateTorchCallbackLocked(callback, executor);
                }
                if (this.mCameraService == null) {
                    this.scheduleCameraServiceReconnectionLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterTorchCallback(TorchCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mTorchCallbackMap.remove(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStatusChanged(int status, String cameraId, int deviceId) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                this.addDeviceStatusHistoryLocked(TextUtils.formatSimple("onStatusChanged(E): tid(%d): mDeviceStatus size %d", Thread.currentThread().getId(), this.mDeviceStatus.size()));
                this.onStatusChangedLocked(status, new DeviceCameraInfo(cameraId, deviceId));
                this.addDeviceStatusHistoryLocked(TextUtils.formatSimple("onStatusChanged(X): tid(%d): mDeviceStatus size %d", Thread.currentThread().getId(), this.mDeviceStatus.size()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPhysicalCameraStatusChanged(int status, String cameraId, String physicalCameraId, int deviceId) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                this.onPhysicalCameraStatusChangedLocked(status, new DeviceCameraInfo(cameraId, deviceId), physicalCameraId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTorchStatusChanged(int status, String cameraId, int deviceId) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                this.onTorchStatusChangedLocked(status, new DeviceCameraInfo(cameraId, deviceId));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTorchStrengthLevelChanged(String cameraId, int newStrengthLevel, int deviceId) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                this.onTorchStrengthLevelChangedLocked(new DeviceCameraInfo(cameraId, deviceId), newStrengthLevel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraAccessPrioritiesChanged() {
            Object object = this.mLock;
            synchronized (object) {
                int callbackCount = this.mCallbackMap.size();
                for (int i = 0; i < callbackCount; ++i) {
                    Executor executor = this.mCallbackMap.valueAt(i);
                    AvailabilityCallback callback = this.mCallbackMap.keyAt(i);
                    this.postSingleAccessPriorityChangeUpdate(callback, executor);
                }
            }
        }

        @Override
        public void onCameraOpenedInSharedMode(String cameraId, String clientPackageId, int deviceId, boolean primaryClient) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraOpened(String cameraId, String clientPackageId, int deviceId) {
            Object object = this.mLock;
            synchronized (object) {
                this.onCameraOpenedLocked(new DeviceCameraInfo(cameraId, deviceId), clientPackageId);
            }
        }

        private void onCameraOpenedLocked(DeviceCameraInfo info, String clientPackageId) {
            String oldApk = this.mOpenedDevices.put(info, clientPackageId);
            if (oldApk != null) {
                if (oldApk.equals(clientPackageId)) {
                    Log.w(TAG, "onCameraOpened was previously called for " + oldApk + " and is now again called for the same package name, so no new client visible update will be sent");
                    return;
                }
                Log.w(TAG, "onCameraOpened was previously called for " + oldApk + " and is now called for " + clientPackageId + " without onCameraClosed being called first");
            }
            int callbackCount = this.mCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                AvailabilityCallback callback = this.mCallbackMap.keyAt(i);
                if (this.shouldHideCamera(callback.mDeviceId, callback.mDevicePolicy, info)) continue;
                Executor executor = this.mCallbackMap.valueAt(i);
                this.postSingleCameraOpenedUpdate(callback, executor, info.mCameraId, clientPackageId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraClosed(String cameraId, int deviceId) {
            Object object = this.mLock;
            synchronized (object) {
                this.onCameraClosedLocked(new DeviceCameraInfo(cameraId, deviceId));
            }
        }

        private void onCameraClosedLocked(DeviceCameraInfo info) {
            this.mOpenedDevices.remove(info);
            int callbackCount = this.mCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                AvailabilityCallback callback = this.mCallbackMap.keyAt(i);
                if (this.shouldHideCamera(callback.mDeviceId, callback.mDevicePolicy, info)) continue;
                Executor executor = this.mCallbackMap.valueAt(i);
                this.postSingleCameraClosedUpdate(callback, executor, info.mCameraId);
            }
        }

        private void scheduleCameraServiceReconnectionLocked() {
            if (this.mCallbackMap.isEmpty() && this.mTorchCallbackMap.isEmpty()) {
                return;
            }
            try {
                this.mScheduler.schedule(() -> {
                    ICameraService cameraService = this.getCameraService();
                    if (cameraService == null) {
                        Object object = this.mLock;
                        synchronized (object) {
                            this.scheduleCameraServiceReconnectionLocked();
                        }
                    }
                }, 1000L, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException e) {
                Log.e(TAG, "Failed to schedule camera service re-connect: " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = this.mLock;
            synchronized (object) {
                DeviceCameraInfo info;
                int i;
                this.addDeviceStatusHistoryLocked(TextUtils.formatSimple("binderDied(E): tid(%d): mDeviceStatus size %d", Thread.currentThread().getId(), this.mDeviceStatus.size()));
                if (this.mCameraService == null) {
                    return;
                }
                this.mCameraService = null;
                for (i = this.mDeviceStatus.size() - 1; i >= 0; --i) {
                    info = this.mDeviceStatus.keyAt(i);
                    this.onStatusChangedLocked(0, info);
                    if (!this.mHasOpenCloseListenerPermission) continue;
                    this.onCameraClosedLocked(info);
                }
                for (i = 0; i < this.mTorchStatus.size(); ++i) {
                    info = this.mTorchStatus.keyAt(i);
                    this.onTorchStatusChangedLocked(0, info);
                }
                this.mConcurrentCameraIdCombinations.clear();
                this.scheduleCameraServiceReconnectionLocked();
                this.addDeviceStatusHistoryLocked(TextUtils.formatSimple("binderDied(X): tid(%d): mDeviceStatus size %d", Thread.currentThread().getId(), this.mDeviceStatus.size()));
            }
        }

        private void addDeviceStatusHistoryLocked(String log) {
            if (this.mDeviceStatusHistory.size() == 10) {
                this.mDeviceStatusHistory.removeFirst();
            }
            this.mDeviceStatusHistory.addLast(log);
        }

        private static class DeviceCameraInfo {
            private final String mCameraId;
            private final int mDeviceId;

            DeviceCameraInfo(String cameraId, int deviceId) {
                this.mCameraId = cameraId;
                this.mDeviceId = deviceId;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DeviceCameraInfo that = (DeviceCameraInfo)o;
                return this.mDeviceId == that.mDeviceId && Objects.equals(this.mCameraId, that.mCameraId);
            }

            public int hashCode() {
                return Objects.hash(this.mCameraId, this.mDeviceId);
            }
        }
    }

    public static abstract class AvailabilityCallback {
        private int mDeviceId;
        private int mDevicePolicy;

        public void onCameraAvailable(@NonNull String cameraId) {
        }

        public void onCameraUnavailable(@NonNull String cameraId) {
        }

        public void onCameraAccessPrioritiesChanged() {
        }

        public void onPhysicalCameraAvailable(@NonNull String cameraId, @NonNull String physicalCameraId) {
        }

        public void onPhysicalCameraUnavailable(@NonNull String cameraId, @NonNull String physicalCameraId) {
        }

        @SystemApi
        @RequiresPermission(value="android.permission.CAMERA_OPEN_CLOSE_LISTENER")
        public void onCameraOpened(@NonNull String cameraId, @NonNull String packageId) {
        }

        @SystemApi
        @RequiresPermission(value="android.permission.CAMERA_OPEN_CLOSE_LISTENER")
        public void onCameraClosed(@NonNull String cameraId) {
        }
    }

    public static abstract class TorchCallback {
        private int mDeviceId;
        private int mDevicePolicy;

        public void onTorchModeUnavailable(@NonNull String cameraId) {
        }

        public void onTorchModeChanged(@NonNull String cameraId, boolean enabled) {
        }

        public void onTorchStrengthLevelChanged(@NonNull String cameraId, int newStrengthLevel) {
        }
    }

    private static class FoldStateListener
    implements DeviceStateManager.DeviceStateCallback {
        private final int[] mFoldedDeviceStates;
        private ArrayList<WeakReference<DeviceStateListener>> mDeviceStateListeners = new ArrayList();
        private boolean mFoldedDeviceState;
        private final FeatureFlags mDeviceStateManagerFlags;

        public FoldStateListener(Context context) {
            this.mFoldedDeviceStates = context.getResources().getIntArray(17236091);
            this.mDeviceStateManagerFlags = new FeatureFlagsImpl();
        }

        private synchronized void handleStateChange(DeviceState state) {
            boolean folded = this.mDeviceStateManagerFlags.deviceStatePropertyMigration() ? state.hasProperty(11) : ArrayUtils.contains(this.mFoldedDeviceStates, state.getIdentifier());
            this.mFoldedDeviceState = folded;
            Iterator<WeakReference<DeviceStateListener>> it = this.mDeviceStateListeners.iterator();
            while (it.hasNext()) {
                DeviceStateListener callback = (DeviceStateListener)it.next().get();
                if (callback != null) {
                    callback.onDeviceStateChanged(folded);
                    continue;
                }
                it.remove();
            }
        }

        public synchronized void addDeviceStateListener(DeviceStateListener listener) {
            listener.onDeviceStateChanged(this.mFoldedDeviceState);
            this.mDeviceStateListeners.removeIf(l -> l.get() == null);
            this.mDeviceStateListeners.add(new WeakReference<DeviceStateListener>(listener));
        }

        @Override
        public void onDeviceStateChanged(@NonNull DeviceState state) {
            this.handleStateChange(state);
        }
    }

    public static interface DeviceStateListener {
        public void onDeviceStateChanged(boolean var1);
    }
}

