/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraOfflineSession;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.OutputConfiguration;
import android.os.Handler;
import android.view.Surface;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;

public abstract class CameraCaptureSession
implements AutoCloseable {
    public static final int SESSION_ID_NONE = -1;

    @NonNull
    public abstract CameraDevice getDevice();

    public abstract void prepare(@NonNull Surface var1) throws CameraAccessException;

    public abstract void prepare(int var1, @NonNull Surface var2) throws CameraAccessException;

    public abstract void tearDown(@NonNull Surface var1) throws CameraAccessException;

    public abstract void finalizeOutputConfigurations(List<OutputConfiguration> var1) throws CameraAccessException;

    public abstract int capture(@NonNull CaptureRequest var1, @Nullable CaptureCallback var2, @Nullable Handler var3) throws CameraAccessException;

    public int captureSingleRequest(@NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CaptureCallback listener) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public abstract int captureBurst(@NonNull List<CaptureRequest> var1, @Nullable CaptureCallback var2, @Nullable Handler var3) throws CameraAccessException;

    public int captureBurstRequests(@NonNull List<CaptureRequest> requests, @NonNull Executor executor, @NonNull CaptureCallback listener) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public abstract int setRepeatingRequest(@NonNull CaptureRequest var1, @Nullable CaptureCallback var2, @Nullable Handler var3) throws CameraAccessException;

    public int setSingleRepeatingRequest(@NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CaptureCallback listener) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public abstract int setRepeatingBurst(@NonNull List<CaptureRequest> var1, @Nullable CaptureCallback var2, @Nullable Handler var3) throws CameraAccessException;

    public int setRepeatingBurstRequests(@NonNull List<CaptureRequest> requests, @NonNull Executor executor, @NonNull CaptureCallback listener) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public abstract void stopRepeating() throws CameraAccessException;

    public abstract void abortCaptures() throws CameraAccessException;

    public abstract boolean isReprocessable();

    @Nullable
    public abstract Surface getInputSurface();

    public void updateOutputConfiguration(OutputConfiguration config) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    @Nullable
    public CameraOfflineSession switchToOffline(@NonNull Collection<Surface> offlineSurfaces, @NonNull Executor executor, @NonNull CameraOfflineSession.CameraOfflineSessionCallback listener) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public boolean supportsOfflineProcessing(@NonNull Surface surface) {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    @Override
    public abstract void close();

    public static abstract class CaptureCallback {
        public static final int NO_FRAMES_CAPTURED = -1;

        public void onCaptureStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frameNumber) {
        }

        public void onReadoutStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frameNumber) {
        }

        public void onCapturePartial(CameraCaptureSession session, CaptureRequest request, CaptureResult result) {
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        }

        public void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
        }

        public void onCaptureSequenceCompleted(@NonNull CameraCaptureSession session, int sequenceId, long frameNumber) {
        }

        public void onCaptureSequenceAborted(@NonNull CameraCaptureSession session, int sequenceId) {
        }

        public void onCaptureBufferLost(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull Surface target, long frameNumber) {
        }
    }

    public static abstract class StateCallback {
        public abstract void onConfigured(@NonNull CameraCaptureSession var1);

        public abstract void onConfigureFailed(@NonNull CameraCaptureSession var1);

        public void onReady(@NonNull CameraCaptureSession session) {
        }

        public void onActive(@NonNull CameraCaptureSession session) {
        }

        public void onCaptureQueueEmpty(@NonNull CameraCaptureSession session) {
        }

        public void onClosed(@NonNull CameraCaptureSession session) {
        }

        public void onSurfacePrepared(@NonNull CameraCaptureSession session, @NonNull Surface surface) {
        }
    }
}

