/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics.common;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICancellationSignal
extends IInterface {
    public static final int VERSION = 4;
    public static final String HASH = "8a6cd86630181a4df6f20056259ec200ffe39209";
    public static final String DESCRIPTOR = "android$hardware$biometrics$common$ICancellationSignal".replace('$', '.');

    public void cancel() throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public String getInterfaceHash() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICancellationSignal {
        static final int TRANSACTION_cancel = 1;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;
        static final int TRANSACTION_getInterfaceHash = 0xFFFFFE;

        public Stub() {
            this.markVintfStability();
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICancellationSignal asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICancellationSignal) {
                return (ICancellationSignal)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "cancel";
                }
                case 0xFFFFFF: {
                    return "getInterfaceVersion";
                }
                case 0xFFFFFE: {
                    return "getInterfaceHash";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            if (code == 0xFFFFFF) {
                reply.writeNoException();
                reply.writeInt(this.getInterfaceVersion());
                return true;
            }
            if (code == 0xFFFFFE) {
                reply.writeNoException();
                reply.writeString(this.getInterfaceHash());
                return true;
            }
            switch (code) {
                case 1: {
                    this.cancel();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0xFFFFFE;
        }

        private static class Proxy
        implements ICancellationSignal {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            private String mCachedHash = "-1";

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            @Override
            public void cancel() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status) {
                        throw new RemoteException("Method cancel is unimplemented.");
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain(this.asBinder());
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized String getInterfaceHash() throws RemoteException {
                if ("-1".equals(this.mCachedHash)) {
                    Parcel data = Parcel.obtain(this.asBinder());
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFE, data, reply, 0);
                        reply.readException();
                        this.mCachedHash = reply.readString();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedHash;
            }
        }
    }

    public static class Default
    implements ICancellationSignal {
        @Override
        public void cancel() throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return 0;
        }

        @Override
        public String getInterfaceHash() {
            return "";
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

