/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.graphics.Bitmap;
import android.hardware.biometrics.FallbackOption;
import android.hardware.biometrics.PromptContentView;
import android.hardware.biometrics.PromptContentViewParcelable;
import android.hardware.biometrics.PromptContentViewWithMoreOptionsButton;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.hidden_from_bootclasspath.android.hardware.biometrics.Flags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PromptInfo
implements Parcelable {
    private int mLogoRes;
    @Nullable
    private Bitmap mLogoBitmap;
    @Nullable
    private String mLogoDescription;
    @NonNull
    private CharSequence mTitle;
    private boolean mUseDefaultTitle;
    @Nullable
    private CharSequence mSubtitle;
    private boolean mUseDefaultSubtitle;
    @Nullable
    private CharSequence mDescription;
    @Nullable
    private PromptContentViewParcelable mContentView;
    @Nullable
    private CharSequence mDeviceCredentialTitle;
    @Nullable
    private CharSequence mDeviceCredentialSubtitle;
    @Nullable
    private CharSequence mDeviceCredentialDescription;
    @Nullable
    private CharSequence mNegativeButtonText;
    private List<FallbackOption> mFallbackOptions = new ArrayList<FallbackOption>();
    private boolean mConfirmationRequested = true;
    private boolean mDeviceCredentialAllowed;
    private boolean mIdentityCheckActive = false;
    private int mAuthenticators;
    private boolean mDisallowBiometricsIfPolicyExists;
    private boolean mReceiveSystemEvents;
    @NonNull
    private List<Integer> mAllowedSensorIds = new ArrayList<Integer>();
    private boolean mAllowBackgroundAuthentication;
    private boolean mIgnoreEnrollmentState;
    private boolean mIsForLegacyFingerprintManager = false;
    private boolean mShowEmergencyCallButton = false;
    private boolean mUseParentProfileForDeviceCredential = false;
    private ComponentName mRealCallerForConfirmDeviceCredentialActivity = null;
    private String mClassNameIfItIsConfirmDeviceCredentialActivity = null;
    public static final Parcelable.Creator<PromptInfo> CREATOR = new Parcelable.Creator<PromptInfo>(){

        @Override
        public PromptInfo createFromParcel(Parcel in) {
            return new PromptInfo(in);
        }

        public PromptInfo[] newArray(int size) {
            return new PromptInfo[size];
        }
    };

    public PromptInfo() {
    }

    PromptInfo(Parcel in) {
        this.mLogoRes = in.readInt();
        this.mLogoBitmap = in.readTypedObject(Bitmap.CREATOR);
        this.mLogoDescription = in.readString();
        this.mTitle = in.readCharSequence();
        this.mUseDefaultTitle = in.readBoolean();
        this.mSubtitle = in.readCharSequence();
        this.mUseDefaultSubtitle = in.readBoolean();
        this.mDescription = in.readCharSequence();
        this.mContentView = in.readParcelable(PromptContentViewParcelable.class.getClassLoader(), PromptContentViewParcelable.class);
        this.mDeviceCredentialTitle = in.readCharSequence();
        this.mDeviceCredentialSubtitle = in.readCharSequence();
        this.mDeviceCredentialDescription = in.readCharSequence();
        this.mNegativeButtonText = in.readCharSequence();
        this.mConfirmationRequested = in.readBoolean();
        this.mDeviceCredentialAllowed = in.readBoolean();
        this.mIdentityCheckActive = in.readBoolean();
        this.mAuthenticators = in.readInt();
        this.mDisallowBiometricsIfPolicyExists = in.readBoolean();
        this.mReceiveSystemEvents = in.readBoolean();
        this.mAllowedSensorIds = in.readArrayList(Integer.class.getClassLoader(), Integer.class);
        this.mAllowBackgroundAuthentication = in.readBoolean();
        this.mIgnoreEnrollmentState = in.readBoolean();
        this.mIsForLegacyFingerprintManager = in.readBoolean();
        this.mShowEmergencyCallButton = in.readBoolean();
        this.mUseParentProfileForDeviceCredential = in.readBoolean();
        this.mRealCallerForConfirmDeviceCredentialActivity = in.readParcelable(ComponentName.class.getClassLoader(), ComponentName.class);
        this.mClassNameIfItIsConfirmDeviceCredentialActivity = in.readString();
        if (Flags.addFallback()) {
            ArrayList<FallbackOption> options = new ArrayList<FallbackOption>();
            in.readTypedList(options, FallbackOption.CREATOR);
            this.mFallbackOptions = options;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mLogoRes);
        dest.writeTypedObject(this.mLogoBitmap, 0);
        dest.writeString(this.mLogoDescription);
        dest.writeCharSequence(this.mTitle);
        dest.writeBoolean(this.mUseDefaultTitle);
        dest.writeCharSequence(this.mSubtitle);
        dest.writeBoolean(this.mUseDefaultSubtitle);
        dest.writeCharSequence(this.mDescription);
        dest.writeParcelable(this.mContentView, 0);
        dest.writeCharSequence(this.mDeviceCredentialTitle);
        dest.writeCharSequence(this.mDeviceCredentialSubtitle);
        dest.writeCharSequence(this.mDeviceCredentialDescription);
        dest.writeCharSequence(this.mNegativeButtonText);
        dest.writeBoolean(this.mConfirmationRequested);
        dest.writeBoolean(this.mDeviceCredentialAllowed);
        dest.writeBoolean(this.mIdentityCheckActive);
        dest.writeInt(this.mAuthenticators);
        dest.writeBoolean(this.mDisallowBiometricsIfPolicyExists);
        dest.writeBoolean(this.mReceiveSystemEvents);
        dest.writeList(this.mAllowedSensorIds);
        dest.writeBoolean(this.mAllowBackgroundAuthentication);
        dest.writeBoolean(this.mIgnoreEnrollmentState);
        dest.writeBoolean(this.mIsForLegacyFingerprintManager);
        dest.writeBoolean(this.mShowEmergencyCallButton);
        dest.writeBoolean(this.mUseParentProfileForDeviceCredential);
        dest.writeParcelable(this.mRealCallerForConfirmDeviceCredentialActivity, 0);
        dest.writeString(this.mClassNameIfItIsConfirmDeviceCredentialActivity);
        if (Flags.addFallback()) {
            dest.writeTypedList(this.mFallbackOptions);
        }
    }

    public boolean requiresTestOrInternalPermission() {
        if (this.mIsForLegacyFingerprintManager && this.mAllowedSensorIds.size() == 1 && !this.mAllowBackgroundAuthentication) {
            return false;
        }
        if (!this.mAllowedSensorIds.isEmpty()) {
            return true;
        }
        if (this.mAllowBackgroundAuthentication) {
            return true;
        }
        if (this.mIsForLegacyFingerprintManager) {
            return true;
        }
        if (this.mIgnoreEnrollmentState) {
            return true;
        }
        if (this.mShowEmergencyCallButton) {
            return true;
        }
        return this.mRealCallerForConfirmDeviceCredentialActivity != null;
    }

    public boolean requiresInternalPermission() {
        if (this.mDisallowBiometricsIfPolicyExists) {
            return true;
        }
        if (this.mUseDefaultTitle) {
            return true;
        }
        if (this.mUseDefaultSubtitle) {
            return true;
        }
        if (this.mDeviceCredentialTitle != null) {
            return true;
        }
        if (this.mDeviceCredentialSubtitle != null) {
            return true;
        }
        if (this.mDeviceCredentialDescription != null) {
            return true;
        }
        return this.mReceiveSystemEvents;
    }

    public boolean requiresAdvancedPermission() {
        if (this.mLogoRes != 0) {
            return true;
        }
        if (this.mLogoBitmap != null) {
            return true;
        }
        if (this.mLogoDescription != null) {
            return true;
        }
        if (this.mContentView != null && this.isContentViewMoreOptionsButtonUsed()) {
            return true;
        }
        return (this.mAuthenticators & 0x10000) != 0;
    }

    public boolean shouldUseParentProfileForDeviceCredential() {
        return this.mUseParentProfileForDeviceCredential;
    }

    public boolean isContentViewMoreOptionsButtonUsed() {
        return this.mContentView != null && this.mContentView instanceof PromptContentViewWithMoreOptionsButton;
    }

    public void setLogo(int logoRes, @NonNull Bitmap logoBitmap) {
        this.mLogoRes = logoRes;
        this.mLogoBitmap = logoBitmap;
    }

    public void setLogoDescription(@NonNull String logoDescription) {
        this.mLogoDescription = logoDescription;
    }

    public void setTitle(CharSequence title) {
        this.mTitle = title;
    }

    public void setUseDefaultTitle(boolean useDefaultTitle) {
        this.mUseDefaultTitle = useDefaultTitle;
    }

    public void setSubtitle(CharSequence subtitle) {
        this.mSubtitle = subtitle;
    }

    public void setUseDefaultSubtitle(boolean useDefaultSubtitle) {
        this.mUseDefaultSubtitle = useDefaultSubtitle;
    }

    public void setDescription(CharSequence description) {
        this.mDescription = description;
    }

    public void setContentView(PromptContentView view) {
        this.mContentView = (PromptContentViewParcelable)view;
    }

    public void setDeviceCredentialTitle(CharSequence deviceCredentialTitle) {
        this.mDeviceCredentialTitle = deviceCredentialTitle;
    }

    public void setDeviceCredentialSubtitle(CharSequence deviceCredentialSubtitle) {
        this.mDeviceCredentialSubtitle = deviceCredentialSubtitle;
    }

    public void setDeviceCredentialDescription(CharSequence deviceCredentialDescription) {
        this.mDeviceCredentialDescription = deviceCredentialDescription;
    }

    public void setNegativeButtonText(CharSequence negativeButtonText) {
        this.mNegativeButtonText = negativeButtonText;
    }

    public void setConfirmationRequested(boolean confirmationRequested) {
        this.mConfirmationRequested = confirmationRequested;
    }

    public void setDeviceCredentialAllowed(boolean deviceCredentialAllowed) {
        this.mDeviceCredentialAllowed = deviceCredentialAllowed;
    }

    public void setIdentityCheckActive(boolean identityCheckActive) {
        this.mIdentityCheckActive = identityCheckActive;
    }

    public void setAuthenticators(int authenticators) {
        this.mAuthenticators = authenticators;
    }

    public void setDisallowBiometricsIfPolicyExists(boolean disallowBiometricsIfPolicyExists) {
        this.mDisallowBiometricsIfPolicyExists = disallowBiometricsIfPolicyExists;
    }

    public void setReceiveSystemEvents(boolean receiveSystemEvents) {
        this.mReceiveSystemEvents = receiveSystemEvents;
    }

    public void setAllowedSensorIds(@NonNull List<Integer> sensorIds) {
        this.mAllowedSensorIds.clear();
        this.mAllowedSensorIds.addAll(sensorIds);
    }

    public void setAllowBackgroundAuthentication(boolean allow) {
        this.mAllowBackgroundAuthentication = allow;
    }

    public void setIgnoreEnrollmentState(boolean ignoreEnrollmentState) {
        this.mIgnoreEnrollmentState = ignoreEnrollmentState;
    }

    public void setIsForLegacyFingerprintManager(int sensorId) {
        this.mIsForLegacyFingerprintManager = true;
        this.mAllowedSensorIds.clear();
        this.mAllowedSensorIds.add(sensorId);
    }

    public void setShowEmergencyCallButton(boolean showEmergencyCallButton) {
        this.mShowEmergencyCallButton = showEmergencyCallButton;
    }

    public void setRealCallerForConfirmDeviceCredentialActivity(ComponentName realCaller) {
        this.mRealCallerForConfirmDeviceCredentialActivity = realCaller;
    }

    public void setUseParentProfileForDeviceCredential(boolean useParentProfileForDeviceCredential) {
        this.mUseParentProfileForDeviceCredential = useParentProfileForDeviceCredential;
    }

    void setClassNameIfItIsConfirmDeviceCredentialActivity(String className) {
        this.mClassNameIfItIsConfirmDeviceCredentialActivity = className;
    }

    public Bitmap getLogo() {
        return this.mLogoBitmap;
    }

    public int getLogoRes() {
        return this.mLogoRes;
    }

    public Bitmap getLogoBitmap() {
        return this.mLogoRes == 0 ? this.mLogoBitmap : null;
    }

    public String getLogoDescription() {
        return this.mLogoDescription;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public boolean isUseDefaultTitle() {
        return this.mUseDefaultTitle;
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public boolean isUseDefaultSubtitle() {
        return this.mUseDefaultSubtitle;
    }

    public CharSequence getDescription() {
        return this.mDescription;
    }

    public PromptContentView getContentView() {
        return this.mContentView;
    }

    public CharSequence getDeviceCredentialTitle() {
        return this.mDeviceCredentialTitle;
    }

    public CharSequence getDeviceCredentialSubtitle() {
        return this.mDeviceCredentialSubtitle;
    }

    public CharSequence getDeviceCredentialDescription() {
        return this.mDeviceCredentialDescription;
    }

    public CharSequence getNegativeButtonText() {
        return this.mNegativeButtonText;
    }

    public boolean isConfirmationRequested() {
        return this.mConfirmationRequested;
    }

    @Deprecated
    public boolean isDeviceCredentialAllowed() {
        return this.mDeviceCredentialAllowed;
    }

    public boolean isIdentityCheckActive() {
        return this.mIdentityCheckActive;
    }

    public int getAuthenticators() {
        return this.mAuthenticators;
    }

    public boolean isDisallowBiometricsIfPolicyExists() {
        return this.mDisallowBiometricsIfPolicyExists;
    }

    public boolean isReceiveSystemEvents() {
        return this.mReceiveSystemEvents;
    }

    @NonNull
    public List<Integer> getAllowedSensorIds() {
        return this.mAllowedSensorIds;
    }

    public boolean isAllowBackgroundAuthentication() {
        return this.mAllowBackgroundAuthentication;
    }

    public boolean isIgnoreEnrollmentState() {
        return this.mIgnoreEnrollmentState;
    }

    public boolean isForLegacyFingerprintManager() {
        return this.mIsForLegacyFingerprintManager;
    }

    public boolean isShowEmergencyCallButton() {
        return this.mShowEmergencyCallButton;
    }

    public ComponentName getRealCallerForConfirmDeviceCredentialActivity() {
        return this.mRealCallerForConfirmDeviceCredentialActivity;
    }

    public String getClassNameIfItIsConfirmDeviceCredentialActivity() {
        return this.mClassNameIfItIsConfirmDeviceCredentialActivity;
    }

    public List<FallbackOption> getFallbackOptions() {
        return Collections.unmodifiableList(this.mFallbackOptions);
    }

    public void addFallbackOption(FallbackOption fallbackOption) {
        this.mFallbackOptions.add(fallbackOption);
    }
}

