/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.hardware.biometrics.AuthenticationStateListener;
import android.hardware.biometrics.BiometricEnrollmentStatusInternal;
import android.hardware.biometrics.IBiometricEnabledOnKeyguardCallback;
import android.hardware.biometrics.IBiometricServiceReceiver;
import android.hardware.biometrics.IInvalidationCallback;
import android.hardware.biometrics.ITestSession;
import android.hardware.biometrics.ITestSessionCallback;
import android.hardware.biometrics.IdentityCheckStatus;
import android.hardware.biometrics.PromptInfo;
import android.hardware.biometrics.SensorPropertiesInternal;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public interface IAuthService
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.biometrics.IAuthService";

    @EnforcePermission(value="android.permission.TEST_BIOMETRIC")
    public ITestSession createTestSession(int var1, ITestSessionCallback var2, String var3) throws RemoteException;

    @EnforcePermission(value="android.permission.TEST_BIOMETRIC")
    public void setIdentityCheckTestStatus(IdentityCheckStatus var1) throws RemoteException;

    @EnforcePermission(value="android.permission.TEST_BIOMETRIC")
    public List<SensorPropertiesInternal> getSensorProperties(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.TEST_BIOMETRIC")
    public String getUiPackage() throws RemoteException;

    public long authenticate(IBinder var1, long var2, int var4, IBiometricServiceReceiver var5, String var6, PromptInfo var7) throws RemoteException;

    public void cancelAuthentication(IBinder var1, String var2, long var3) throws RemoteException;

    public int canAuthenticate(String var1, int var2, int var3) throws RemoteException;

    public long getLastAuthenticationTime(int var1, int var2) throws RemoteException;

    public boolean hasEnrolledBiometrics(int var1, String var2) throws RemoteException;

    public List<BiometricEnrollmentStatusInternal> getEnrollmentStatusList(String var1) throws RemoteException;

    public void registerEnabledOnKeyguardCallback(IBiometricEnabledOnKeyguardCallback var1) throws RemoteException;

    public void registerAuthenticationStateListener(AuthenticationStateListener var1) throws RemoteException;

    public void unregisterAuthenticationStateListener(AuthenticationStateListener var1) throws RemoteException;

    public void invalidateAuthenticatorIds(int var1, int var2, IInvalidationCallback var3) throws RemoteException;

    public long[] getAuthenticatorIds(int var1) throws RemoteException;

    public void resetLockoutTimeBound(IBinder var1, String var2, int var3, int var4, byte[] var5) throws RemoteException;

    public void resetLockout(int var1, byte[] var2) throws RemoteException;

    public CharSequence getButtonLabel(int var1, String var2, int var3) throws RemoteException;

    public CharSequence getPromptMessage(int var1, String var2, int var3) throws RemoteException;

    public CharSequence getSettingName(int var1, String var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAuthService {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_createTestSession = 1;
        static final int TRANSACTION_setIdentityCheckTestStatus = 2;
        static final int TRANSACTION_getSensorProperties = 3;
        static final int TRANSACTION_getUiPackage = 4;
        static final int TRANSACTION_authenticate = 5;
        static final int TRANSACTION_cancelAuthentication = 6;
        static final int TRANSACTION_canAuthenticate = 7;
        static final int TRANSACTION_getLastAuthenticationTime = 8;
        static final int TRANSACTION_hasEnrolledBiometrics = 9;
        static final int TRANSACTION_getEnrollmentStatusList = 10;
        static final int TRANSACTION_registerEnabledOnKeyguardCallback = 11;
        static final int TRANSACTION_registerAuthenticationStateListener = 12;
        static final int TRANSACTION_unregisterAuthenticationStateListener = 13;
        static final int TRANSACTION_invalidateAuthenticatorIds = 14;
        static final int TRANSACTION_getAuthenticatorIds = 15;
        static final int TRANSACTION_resetLockoutTimeBound = 16;
        static final int TRANSACTION_resetLockout = 17;
        static final int TRANSACTION_getButtonLabel = 18;
        static final int TRANSACTION_getPromptMessage = 19;
        static final int TRANSACTION_getSettingName = 20;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IAuthService.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IAuthService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAuthService.DESCRIPTOR);
            if (iin != null && iin instanceof IAuthService) {
                return (IAuthService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createTestSession";
                }
                case 2: {
                    return "setIdentityCheckTestStatus";
                }
                case 3: {
                    return "getSensorProperties";
                }
                case 4: {
                    return "getUiPackage";
                }
                case 5: {
                    return "authenticate";
                }
                case 6: {
                    return "cancelAuthentication";
                }
                case 7: {
                    return "canAuthenticate";
                }
                case 8: {
                    return "getLastAuthenticationTime";
                }
                case 9: {
                    return "hasEnrolledBiometrics";
                }
                case 10: {
                    return "getEnrollmentStatusList";
                }
                case 11: {
                    return "registerEnabledOnKeyguardCallback";
                }
                case 12: {
                    return "registerAuthenticationStateListener";
                }
                case 13: {
                    return "unregisterAuthenticationStateListener";
                }
                case 14: {
                    return "invalidateAuthenticatorIds";
                }
                case 15: {
                    return "getAuthenticatorIds";
                }
                case 16: {
                    return "resetLockoutTimeBound";
                }
                case 17: {
                    return "resetLockout";
                }
                case 18: {
                    return "getButtonLabel";
                }
                case 19: {
                    return "getPromptMessage";
                }
                case 20: {
                    return "getSettingName";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAuthService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    ITestSessionCallback _arg1 = ITestSessionCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    ITestSession _result = this.createTestSession(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    IdentityCheckStatus _arg0 = data.readTypedObject(IdentityCheckStatus.CREATOR);
                    data.enforceNoDataAvail();
                    this.setIdentityCheckTestStatus(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    List<SensorPropertiesInternal> _result = this.getSensorProperties(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 4: {
                    String _result = this.getUiPackage();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    IBiometricServiceReceiver _arg3 = IBiometricServiceReceiver.Stub.asInterface(data.readStrongBinder());
                    String _arg4 = data.readString();
                    PromptInfo _arg5 = data.readTypedObject(PromptInfo.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.authenticate(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 6: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.cancelAuthentication(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.canAuthenticate(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.getLastAuthenticationTime(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasEnrolledBiometrics(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    List<BiometricEnrollmentStatusInternal> _result = this.getEnrollmentStatusList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 11: {
                    IBiometricEnabledOnKeyguardCallback _arg0 = IBiometricEnabledOnKeyguardCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerEnabledOnKeyguardCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    AuthenticationStateListener _arg0 = AuthenticationStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerAuthenticationStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    AuthenticationStateListener _arg0 = AuthenticationStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAuthenticationStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IInvalidationCallback _arg2 = IInvalidationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.invalidateAuthenticatorIds(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    long[] _result = this.getAuthenticatorIds(_arg0);
                    reply.writeNoException();
                    reply.writeLongArray(_result);
                    break;
                }
                case 16: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    byte[] _arg4 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.resetLockoutTimeBound(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.resetLockout(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    CharSequence _result = this.getButtonLabel(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        TextUtils.writeToParcel(_result, reply, 1);
                        break;
                    }
                    reply.writeInt(0);
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    CharSequence _result = this.getPromptMessage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        TextUtils.writeToParcel(_result, reply, 1);
                        break;
                    }
                    reply.writeInt(0);
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    CharSequence _result = this.getSettingName(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        TextUtils.writeToParcel(_result, reply, 1);
                        break;
                    }
                    reply.writeInt(0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void createTestSession_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setIdentityCheckTestStatus_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getSensorProperties_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getUiPackage_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_BIOMETRIC", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 19;
        }

        private static class Proxy
        implements IAuthService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAuthService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ITestSession createTestSession(int sensorId, ITestSessionCallback callback, String opPackageName) throws RemoteException {
                ITestSession _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeStrongInterface(callback);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = ITestSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIdentityCheckTestStatus(IdentityCheckStatus identityCheckStatus) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeTypedObject(identityCheckStatus, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SensorPropertiesInternal> getSensorProperties(String opPackageName) throws RemoteException {
                ArrayList<SensorPropertiesInternal> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SensorPropertiesInternal.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getUiPackage() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long authenticate(IBinder token, long sessionId, int userId, IBiometricServiceReceiver receiver, String opPackageName, PromptInfo promptInfo) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeLong(sessionId);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(receiver);
                    _data.writeString(opPackageName);
                    _data.writeTypedObject(promptInfo, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelAuthentication(IBinder token, String opPackageName, long requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(opPackageName);
                    _data.writeLong(requestId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int canAuthenticate(String opPackageName, int userId, int authenticators) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeString(opPackageName);
                    _data.writeInt(userId);
                    _data.writeInt(authenticators);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getLastAuthenticationTime(int userId, int authenticators) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(authenticators);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasEnrolledBiometrics(int userId, String opPackageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<BiometricEnrollmentStatusInternal> getEnrollmentStatusList(String opPackageName) throws RemoteException {
                ArrayList<BiometricEnrollmentStatusInternal> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BiometricEnrollmentStatusInternal.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerEnabledOnKeyguardCallback(IBiometricEnabledOnKeyguardCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAuthenticationStateListener(AuthenticationStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAuthenticationStateListener(AuthenticationStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invalidateAuthenticatorIds(int userId, int fromSensorId, IInvalidationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(fromSensorId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long[] getAuthenticatorIds(int userId) throws RemoteException {
                long[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createLongArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetLockoutTimeBound(IBinder token, String opPackageName, int fromSensorId, int userId, byte[] hardwareAuthToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(opPackageName);
                    _data.writeInt(fromSensorId);
                    _data.writeInt(userId);
                    _data.writeByteArray(hardwareAuthToken);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetLockout(int userId, byte[] hardwareAuthToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeByteArray(hardwareAuthToken);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CharSequence getButtonLabel(int userId, String opPackageName, int authenticators) throws RemoteException {
                CharSequence _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    _data.writeInt(authenticators);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CharSequence getPromptMessage(int userId, String opPackageName, int authenticators) throws RemoteException {
                CharSequence _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    _data.writeInt(authenticators);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CharSequence getSettingName(int userId, String opPackageName, int authenticators) throws RemoteException {
                CharSequence _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthService.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    _data.writeInt(authenticators);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IAuthService {
        @Override
        public ITestSession createTestSession(int sensorId, ITestSessionCallback callback, String opPackageName) throws RemoteException {
            return null;
        }

        @Override
        public void setIdentityCheckTestStatus(IdentityCheckStatus identityCheckStatus) throws RemoteException {
        }

        @Override
        public List<SensorPropertiesInternal> getSensorProperties(String opPackageName) throws RemoteException {
            return null;
        }

        @Override
        public String getUiPackage() throws RemoteException {
            return null;
        }

        @Override
        public long authenticate(IBinder token, long sessionId, int userId, IBiometricServiceReceiver receiver, String opPackageName, PromptInfo promptInfo) throws RemoteException {
            return 0L;
        }

        @Override
        public void cancelAuthentication(IBinder token, String opPackageName, long requestId) throws RemoteException {
        }

        @Override
        public int canAuthenticate(String opPackageName, int userId, int authenticators) throws RemoteException {
            return 0;
        }

        @Override
        public long getLastAuthenticationTime(int userId, int authenticators) throws RemoteException {
            return 0L;
        }

        @Override
        public boolean hasEnrolledBiometrics(int userId, String opPackageName) throws RemoteException {
            return false;
        }

        @Override
        public List<BiometricEnrollmentStatusInternal> getEnrollmentStatusList(String opPackageName) throws RemoteException {
            return null;
        }

        @Override
        public void registerEnabledOnKeyguardCallback(IBiometricEnabledOnKeyguardCallback callback) throws RemoteException {
        }

        @Override
        public void registerAuthenticationStateListener(AuthenticationStateListener listener) throws RemoteException {
        }

        @Override
        public void unregisterAuthenticationStateListener(AuthenticationStateListener listener) throws RemoteException {
        }

        @Override
        public void invalidateAuthenticatorIds(int userId, int fromSensorId, IInvalidationCallback callback) throws RemoteException {
        }

        @Override
        public long[] getAuthenticatorIds(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void resetLockoutTimeBound(IBinder token, String opPackageName, int fromSensorId, int userId, byte[] hardwareAuthToken) throws RemoteException {
        }

        @Override
        public void resetLockout(int userId, byte[] hardwareAuthToken) throws RemoteException {
        }

        @Override
        public CharSequence getButtonLabel(int userId, String opPackageName, int authenticators) throws RemoteException {
            return null;
        }

        @Override
        public CharSequence getPromptMessage(int userId, String opPackageName, int authenticators) throws RemoteException {
            return null;
        }

        @Override
        public CharSequence getSettingName(int userId, String opPackageName, int authenticators) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

