/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.content.Context;
import android.hardware.biometrics.BiometricManager;
import android.hardware.biometrics.ITestSession;
import android.hardware.biometrics.ITestSessionCallback;
import android.hardware.biometrics.IdentityCheckStatus;
import android.hardware.biometrics.SensorProperties;
import android.os.RemoteException;
import android.util.ArraySet;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class BiometricTestSession
implements AutoCloseable {
    private static final String BASE_TAG = "BiometricTestSession";
    private final int mSensorId;
    private final BiometricManager mBiometricManager;
    private final List<ITestSession> mTestSessionsForAllSensors = new ArrayList<ITestSession>();
    private ITestSession mTestSession;
    @NonNull
    private final ArraySet<Integer> mTestedUsers;
    @Nullable
    private CountDownLatch mCloseLatch;
    @NonNull
    private final ArraySet<Integer> mUsersCleaningUp;

    public BiometricTestSession(@NonNull Context context, List<SensorProperties> sensors, int sensorId, @NonNull TestSessionProvider testSessionProvider) throws RemoteException {
        this.mSensorId = sensorId;
        this.mBiometricManager = context.getSystemService(BiometricManager.class);
        for (SensorProperties sensor : sensors) {
            int id2 = sensor.getSensorId();
            ITestSession session = testSessionProvider.createTestSession(context, id2, new TestSessionCallbackIml(id2));
            this.mTestSessionsForAllSensors.add(session);
            if (id2 != sensorId) continue;
            this.mTestSession = session;
        }
        this.mTestedUsers = new ArraySet();
        this.mUsersCleaningUp = new ArraySet();
        this.setTestHalEnabled(true);
        Log.d(this.getTag(), "Opening BiometricTestSession");
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    private void setTestHalEnabled(boolean enabled) {
        try {
            for (ITestSession session : this.mTestSessionsForAllSensors) {
                Log.w(this.getTag(), "setTestHalEnabled, sensor: " + session.getSensorId() + " enabled: " + enabled);
                session.setTestHalEnabled(enabled);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void startEnroll(int userId) {
        try {
            this.mTestedUsers.add(userId);
            this.mTestSession.startEnroll(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void finishEnroll(int userId) {
        try {
            this.mTestedUsers.add(userId);
            this.mTestSession.finishEnroll(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void acceptAuthentication(int userId) {
        try {
            this.mTestSession.acceptAuthentication(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void rejectAuthentication(int userId) {
        try {
            this.mTestSession.rejectAuthentication(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void notifyAcquired(int userId, int acquireInfo) {
        try {
            this.mTestSession.notifyAcquired(userId, acquireInfo);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void notifyError(int userId, int errorCode) {
        try {
            this.mTestSession.notifyError(userId, errorCode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void cleanupInternalState(int userId) {
        try {
            if (this.mUsersCleaningUp.contains(userId)) {
                Log.w(this.getTag(), "Cleanup already in progress for user: " + userId);
            }
            for (ITestSession session : this.mTestSessionsForAllSensors) {
                this.mUsersCleaningUp.add(userId);
                Log.d(this.getTag(), "cleanupInternalState for sensor: " + session.getSensorId());
                this.mCloseLatch = new CountDownLatch(1);
                session.cleanupInternalState(userId);
                try {
                    Log.d(this.getTag(), "Awaiting latch...");
                    this.mCloseLatch.await(3L, TimeUnit.SECONDS);
                    Log.d(this.getTag(), "Finished awaiting");
                }
                catch (InterruptedException e) {
                    Log.e(this.getTag(), "Latch interrupted", e);
                }
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public void close() {
        Log.d(this.getTag(), "Close, mTestedUsers size; " + this.mTestedUsers.size());
        if (!this.mTestedUsers.isEmpty()) {
            for (int user : this.mTestedUsers) {
                this.cleanupInternalState(user);
            }
        }
        if (!this.mUsersCleaningUp.isEmpty()) {
            Log.e(this.getTag(), "Cleanup not finished before shutdown - pending: " + this.mUsersCleaningUp.size());
        }
        this.mBiometricManager.setIdentityCheckTestStatus(new IdentityCheckStatus.Builder().setIdentityCheckActive(false).setIdentityCheckValueForTestAvailable(false).build());
        this.setTestHalEnabled(false);
    }

    private String getTag() {
        return "BiometricTestSession_" + this.mSensorId;
    }

    private class TestSessionCallbackIml
    extends ITestSessionCallback.Stub {
        private final int mSensorId;

        private TestSessionCallbackIml(int sensorId) {
            this.mSensorId = sensorId;
        }

        @Override
        public void onCleanupStarted(int userId) {
            Log.d(BiometricTestSession.this.getTag(), "onCleanupStarted, sensor: " + this.mSensorId + ", userId: " + userId);
        }

        @Override
        public void onCleanupFinished(int userId) {
            Log.d(BiometricTestSession.this.getTag(), "onCleanupFinished, sensor: " + this.mSensorId + ", userId: " + userId + ", remaining users: " + BiometricTestSession.this.mUsersCleaningUp.size());
            BiometricTestSession.this.mUsersCleaningUp.remove(userId);
            if (BiometricTestSession.this.mUsersCleaningUp.isEmpty() && BiometricTestSession.this.mCloseLatch != null) {
                Log.d(BiometricTestSession.this.getTag(), "counting down");
                BiometricTestSession.this.mCloseLatch.countDown();
            }
        }
    }

    public static interface TestSessionProvider {
        @NonNull
        public ITestSession createTestSession(@NonNull Context var1, int var2, @NonNull ITestSessionCallback var3) throws RemoteException;
    }
}

