/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.hardware.ISerialManager;
import android.hardware.SerialPort;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodThrow;
import java.io.IOException;

@RavenwoodKeepWholeClass
public class SerialManager {
    private static final String TAG = "SerialManager";
    private final Context mContext;
    private final ISerialManager mService;

    public SerialManager(Context context, ISerialManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public String[] getSerialPorts() {
        try {
            return this.mService.getSerialPorts();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RavenwoodThrow(blockedBy={ParcelFileDescriptor.class}, reason="Needs socketpair() to offer accurate emulation")
    public SerialPort openSerialPort(String name, int speed) throws IOException {
        try {
            ParcelFileDescriptor pfd = this.mService.openSerialPort(name);
            if (pfd != null) {
                SerialPort port = new SerialPort(name);
                port.open(pfd, speed);
                return port;
            }
            throw new IOException("Could not open serial port " + name);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

