/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.graphics.fonts.Font;
import android.graphics.fonts.FontFileUtil;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.SparseIntArray;
import com.android.internal.util.Preconditions;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Set;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
public final class FontFamily {
    private static final String TAG = "FontFamily";
    private final long mNativePtr;

    public FontFamily(long ptr) {
        this.mNativePtr = ptr;
    }

    @Nullable
    public String getLangTags() {
        return FontFamily.nGetLangTags(this.mNativePtr);
    }

    public int getVariant() {
        return FontFamily.nGetVariant(this.mNativePtr);
    }

    @NonNull
    public Font getFont(int index) {
        if (index < 0 || this.getSize() <= index) {
            throw new IndexOutOfBoundsException();
        }
        return new Font(FontFamily.nGetFont(this.mNativePtr, index));
    }

    public int getSize() {
        return FontFamily.nGetFontSize(this.mNativePtr);
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    @CriticalNative
    private static native int nGetFontSize(long var0);

    @CriticalNative
    private static native long nGetFont(long var0, int var2);

    @FastNative
    private static native String nGetLangTags(long var0);

    @CriticalNative
    private static native int nGetVariant(long var0);

    public static final class Builder {
        private final ArrayList<Font> mFonts = new ArrayList();
        private final SparseIntArray mStyles = new SparseIntArray(4);
        public static final int VARIABLE_FONT_FAMILY_TYPE_UNKNOWN = -1;
        public static final int VARIABLE_FONT_FAMILY_TYPE_NONE = 0;
        public static final int VARIABLE_FONT_FAMILY_TYPE_SINGLE_FONT_WGHT_ONLY = 1;
        public static final int VARIABLE_FONT_FAMILY_TYPE_SINGLE_FONT_WGHT_ITAL = 2;
        public static final int VARIABLE_FONT_FAMILY_TYPE_TWO_FONTS_WGHT = 3;
        private static final int TAG_ital = 1769234796;
        private static final int TAG_wght = 2003265652;

        public Builder(@NonNull Font font) {
            Preconditions.checkNotNull(font, "font can not be null");
            this.mStyles.append(Builder.makeStyleIdentifier(font), 0);
            this.mFonts.add(font);
        }

        @NonNull
        public Builder addFont(@NonNull Font font) {
            Preconditions.checkNotNull(font, "font can not be null");
            int key = Builder.makeStyleIdentifier(font);
            if (this.mStyles.indexOfKey(key) >= 0) {
                throw new IllegalArgumentException(font + " has already been added");
            }
            this.mStyles.append(key, 0);
            this.mFonts.add(font);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @FlaggedApi(value="com.android.text.flags.new_fonts_fallback_xml")
        @Nullable
        public FontFamily buildVariableFamily() {
            int variableFamilyType = Builder.analyzeAndResolveVariableType(this.mFonts);
            if (variableFamilyType == -1) {
                return null;
            }
            return this.build("", 0, true, false, variableFamilyType);
        }

        @NonNull
        public FontFamily build() {
            return this.build("", 0, true, false, 0);
        }

        @NonNull
        public FontFamily build(@NonNull String langTags, int variant, boolean isCustomFallback, boolean isDefaultFallback, int variableFamilyType) {
            long builderPtr = Builder.nInitBuilder();
            for (int i = 0; i < this.mFonts.size(); ++i) {
                Builder.nAddFont(builderPtr, this.mFonts.get(i).getNativePtr());
            }
            long ptr = Builder.nBuild(builderPtr, langTags, variant, isCustomFallback, isDefaultFallback, variableFamilyType);
            FontFamily family = new FontFamily(ptr);
            NoImagePreloadHolder.sFamilyRegistry.registerNativeAllocation(family, ptr);
            return family;
        }

        private static int makeStyleIdentifier(@NonNull Font font) {
            return font.getStyle().getWeight() | font.getStyle().getSlant() << 16;
        }

        public static int analyzeAndResolveVariableType(ArrayList<Font> fonts) {
            boolean italic2;
            if (fonts.size() > 2) {
                return -1;
            }
            if (fonts.size() == 1) {
                Font font = fonts.get(0);
                Set<Integer> supportedAxes = FontFileUtil.getSupportedAxes(font.getBuffer(), font.getTtcIndex());
                if (supportedAxes.contains(2003265652)) {
                    if (supportedAxes.contains(1769234796)) {
                        return 2;
                    }
                    return 1;
                }
                return -1;
            }
            for (int i = 0; i < fonts.size(); ++i) {
                Font font = fonts.get(i);
                Set<Integer> supportedAxes = FontFileUtil.getSupportedAxes(font.getBuffer(), font.getTtcIndex());
                if (supportedAxes.contains(2003265652)) continue;
                return -1;
            }
            boolean italic1 = fonts.get(0).getStyle().getSlant() == 1;
            boolean bl = italic2 = fonts.get(1).getStyle().getSlant() == 1;
            if (italic1 == italic2) {
                return -1;
            }
            if (italic1) {
                Font firstFont = fonts.get(0);
                fonts.set(0, fonts.get(1));
                fonts.set(1, firstFont);
            }
            return 3;
        }

        private static native long nInitBuilder();

        @CriticalNative
        private static native void nAddFont(long var0, long var2);

        private static native long nBuild(long var0, String var2, int var3, boolean var4, boolean var5, int var6);

        @CriticalNative
        private static native long nGetReleaseNativeFamily();

        private static class NoImagePreloadHolder {
            private static final NativeAllocationRegistry sFamilyRegistry = NativeAllocationRegistry.createMalloced(FontFamily.class.getClassLoader(), Builder.nGetReleaseNativeFamily());

            private NoImagePreloadHolder() {
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface VariableFontFamilyType {
        }
    }
}

