/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable.shapes;

import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.drawable.shapes.RectShape;
import java.util.Objects;

public class ArcShape
extends RectShape {
    private final float mStartAngle;
    private final float mSweepAngle;

    public ArcShape(float startAngle, float sweepAngle) {
        this.mStartAngle = startAngle;
        this.mSweepAngle = sweepAngle;
    }

    public float getStartAngle() {
        return this.mStartAngle;
    }

    public float getSweepAngle() {
        return this.mSweepAngle;
    }

    @Override
    public void draw(Canvas canvas, Paint paint) {
        canvas.drawArc(this.rect(), this.mStartAngle, this.mSweepAngle, true, paint);
    }

    @Override
    public void getOutline(Outline outline) {
    }

    @Override
    public ArcShape clone() throws CloneNotSupportedException {
        return (ArcShape)super.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArcShape arcShape = (ArcShape)o;
        return Float.compare(arcShape.mStartAngle, this.mStartAngle) == 0 && Float.compare(arcShape.mSweepAngle, this.mSweepAngle) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Float.valueOf(this.mStartAngle), Float.valueOf(this.mSweepAngle));
    }
}

