/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Process;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;

@RavenwoodKeepWholeClass
public class LeakyTypefaceStorage {
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static final ArrayList<Typeface> sStorage = new ArrayList();
    @GuardedBy(value={"sLock"})
    private static final ArrayMap<Typeface, Integer> sTypefaceMap = new ArrayMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTypefaceToParcel(@Nullable Typeface typeface, @NonNull Parcel parcel) {
        parcel.writeInt(Process.myPid());
        Object object = sLock;
        synchronized (object) {
            int id2;
            Integer i = sTypefaceMap.get(typeface);
            if (i != null) {
                id2 = i;
            } else {
                id2 = sStorage.size();
                sStorage.add(typeface);
                sTypefaceMap.put(typeface, id2);
            }
            parcel.writeInt(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Typeface readTypefaceFromParcel(@NonNull Parcel parcel) {
        int pid = parcel.readInt();
        int typefaceId = parcel.readInt();
        if (pid != Process.myPid()) {
            return null;
        }
        Object object = sLock;
        synchronized (object) {
            return sStorage.get(typefaceId);
        }
    }
}

