/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorSpace;
import android.graphics.ComposeShader;
import android.graphics.Matrix;
import android.graphics.Mesh;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.RuntimeShader;
import android.graphics.Shader;
import android.graphics.TemporaryBuffer;
import android.graphics.fonts.Font;
import android.graphics.text.MeasuredText;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.GraphicsOperations;
import android.text.MeasuredParagraph;
import android.text.PrecomputedText;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import java.util.Objects;

@RavenwoodKeepWholeClass
public abstract class BaseCanvas {
    @UnsupportedAppUsage
    protected long mNativeCanvasWrapper;
    protected int mScreenDensity = 0;
    protected int mDensity = 0;
    private boolean mAllowHwFeaturesInSwMode = false;

    protected void throwIfCannotDraw(Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new RuntimeException("Canvas: trying to use a recycled bitmap " + bitmap);
        }
        if (!bitmap.isPremultiplied() && bitmap.getConfig() == Bitmap.Config.ARGB_8888 && bitmap.hasAlpha()) {
            throw new RuntimeException("Canvas: trying to use a non-premultiplied bitmap " + bitmap);
        }
        this.throwIfHwBitmapInSwMode(bitmap);
    }

    protected static final void checkRange(int length, int offset, int count) {
        if ((offset | count) < 0 || offset + count > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public boolean isHardwareAccelerated() {
        return false;
    }

    public void drawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean useCenter, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawArc(this.mNativeCanvasWrapper, left, top, right, bottom, startAngle, sweepAngle, useCenter, paint.getNativeInstance());
    }

    public void drawArc(@NonNull RectF oval, float startAngle, float sweepAngle, boolean useCenter, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        this.drawArc(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, useCenter, paint);
    }

    public void drawARGB(int a, int r, int g, int b) {
        this.drawColor(Color.argb(a, r, g, b));
    }

    public void drawBitmap(@NonNull Bitmap bitmap, float left, float top, @Nullable Paint paint) {
        this.throwIfCannotDraw(bitmap);
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawBitmap(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), left, top, paint != null ? paint.getNativeInstance() : 0L, this.mDensity, this.mScreenDensity, bitmap.mDensity);
    }

    public void drawBitmap(@NonNull Bitmap bitmap, @NonNull Matrix matrix, @Nullable Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawBitmapMatrix(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), matrix.ni(), paint != null ? paint.getNativeInstance() : 0L);
    }

    public void drawBitmap(@NonNull Bitmap bitmap, @Nullable Rect src, @NonNull Rect dst, @Nullable Paint paint) {
        int bottom;
        int right;
        int left;
        int top;
        long nativePaint;
        if (dst == null) {
            throw new NullPointerException();
        }
        this.throwIfCannotDraw(bitmap);
        this.throwIfHasHwFeaturesInSwMode(paint);
        long l = nativePaint = paint == null ? 0L : paint.getNativeInstance();
        if (src == null) {
            top = 0;
            left = 0;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        BaseCanvas.nDrawBitmap(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mScreenDensity, bitmap.mDensity);
    }

    public void drawBitmap(@NonNull Bitmap bitmap, @Nullable Rect src, @NonNull RectF dst, @Nullable Paint paint) {
        float bottom;
        float right;
        float left;
        float top;
        long nativePaint;
        if (dst == null) {
            throw new NullPointerException();
        }
        this.throwIfCannotDraw(bitmap);
        this.throwIfHasHwFeaturesInSwMode(paint);
        long l = nativePaint = paint == null ? 0L : paint.getNativeInstance();
        if (src == null) {
            top = 0.0f;
            left = 0.0f;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        BaseCanvas.nDrawBitmap(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mScreenDensity, bitmap.mDensity);
    }

    @Deprecated
    public void drawBitmap(@NonNull int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, @Nullable Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.throwIfHasHwFeaturesInSwMode(paint);
        if (width == 0 || height == 0) {
            return;
        }
        BaseCanvas.nDrawBitmap(this.mNativeCanvasWrapper, colors, offset, stride, x, y, width, height, hasAlpha, paint != null ? paint.getNativeInstance() : 0L);
    }

    @Deprecated
    public void drawBitmap(@NonNull int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, @Nullable Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    public void drawBitmapMesh(@NonNull Bitmap bitmap, int meshWidth, int meshHeight, @NonNull float[] verts, int vertOffset, @Nullable int[] colors, int colorOffset, @Nullable Paint paint) {
        if ((meshWidth | meshHeight | vertOffset | colorOffset) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.throwIfHasHwFeaturesInSwMode(paint);
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        BaseCanvas.checkRange(verts.length, vertOffset, count * 2);
        if (colors != null) {
            BaseCanvas.checkRange(colors.length, colorOffset, count);
        }
        BaseCanvas.nDrawBitmapMesh(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint != null ? paint.getNativeInstance() : 0L);
    }

    public void drawCircle(float cx, float cy, float radius, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawCircle(this.mNativeCanvasWrapper, cx, cy, radius, paint.getNativeInstance());
    }

    public void drawColor(int color2) {
        BaseCanvas.nDrawColor(this.mNativeCanvasWrapper, color2, BlendMode.SRC_OVER.getXfermode().porterDuffMode);
    }

    public void drawColor(int color2, @NonNull PorterDuff.Mode mode) {
        BaseCanvas.nDrawColor(this.mNativeCanvasWrapper, color2, mode.nativeInt);
    }

    public void drawColor(int color2, @NonNull BlendMode mode) {
        BaseCanvas.nDrawColor(this.mNativeCanvasWrapper, color2, mode.getXfermode().porterDuffMode);
    }

    public void drawColor(long color2, @NonNull BlendMode mode) {
        ColorSpace cs = Color.colorSpace(color2);
        BaseCanvas.nDrawColor(this.mNativeCanvasWrapper, cs.getNativeInstance(), color2, mode.getXfermode().porterDuffMode);
    }

    public void drawLine(float startX, float startY, float stopX, float stopY, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawLine(this.mNativeCanvasWrapper, startX, startY, stopX, stopY, paint.getNativeInstance());
    }

    public void drawLines(@NonNull float[] pts, int offset, int count, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawLines(this.mNativeCanvasWrapper, pts, offset, count, paint.getNativeInstance());
    }

    public void drawLines(@NonNull float[] pts, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        this.drawLines(pts, 0, pts.length, paint);
    }

    public void drawOval(float left, float top, float right, float bottom, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawOval(this.mNativeCanvasWrapper, left, top, right, bottom, paint.getNativeInstance());
    }

    public void drawOval(@NonNull RectF oval, @NonNull Paint paint) {
        if (oval == null) {
            throw new NullPointerException();
        }
        this.throwIfHasHwFeaturesInSwMode(paint);
        this.drawOval(oval.left, oval.top, oval.right, oval.bottom, paint);
    }

    public void drawPaint(@NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawPaint(this.mNativeCanvasWrapper, paint.getNativeInstance());
    }

    public void drawPatch(@NonNull NinePatch patch, @NonNull Rect dst, @Nullable Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        this.throwIfCannotDraw(bitmap);
        this.throwIfHasHwFeaturesInSwMode(paint);
        long nativePaint = paint == null ? 0L : paint.getNativeInstance();
        BaseCanvas.nDrawNinePatch(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mDensity, patch.getDensity());
    }

    public void drawPatch(@NonNull NinePatch patch, @NonNull RectF dst, @Nullable Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        this.throwIfCannotDraw(bitmap);
        this.throwIfHasHwFeaturesInSwMode(paint);
        long nativePaint = paint == null ? 0L : paint.getNativeInstance();
        BaseCanvas.nDrawNinePatch(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mDensity, patch.getDensity());
    }

    public void drawPath(@NonNull Path path, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawPath(this.mNativeCanvasWrapper, path.readOnlyNI(), paint.getNativeInstance());
    }

    public void drawRegion(@NonNull Region region, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawRegion(this.mNativeCanvasWrapper, region.mNativeRegion, paint.getNativeInstance());
    }

    public void drawPoint(float x, float y, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawPoint(this.mNativeCanvasWrapper, x, y, paint.getNativeInstance());
    }

    public void drawPoints(float[] pts, int offset, int count, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawPoints(this.mNativeCanvasWrapper, pts, offset, count, paint.getNativeInstance());
    }

    public void drawPoints(@NonNull float[] pts, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        this.drawPoints(pts, 0, pts.length, paint);
    }

    @Deprecated
    public void drawPosText(@NonNull char[] text, int index, int count, @NonNull float[] pos, @NonNull Paint paint) {
        if (index < 0 || index + count > text.length || count * 2 > pos.length) {
            throw new IndexOutOfBoundsException();
        }
        this.throwIfHasHwFeaturesInSwMode(paint);
        for (int i = 0; i < count; ++i) {
            this.drawText(text, index + i, 1, pos[i * 2], pos[i * 2 + 1], paint);
        }
    }

    @Deprecated
    public void drawPosText(@NonNull String text, @NonNull float[] pos, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        this.drawPosText(text.toCharArray(), 0, text.length(), pos, paint);
    }

    public void drawRect(float left, float top, float right, float bottom, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawRect(this.mNativeCanvasWrapper, left, top, right, bottom, paint.getNativeInstance());
    }

    public void drawRect(@NonNull Rect r, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRect(@NonNull RectF rect, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, paint.getNativeInstance());
    }

    public void drawRGB(int r, int g, int b) {
        this.drawColor(Color.rgb(r, g, b));
    }

    public void drawRoundRect(float left, float top, float right, float bottom, float rx, float ry, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawRoundRect(this.mNativeCanvasWrapper, left, top, right, bottom, rx, ry, paint.getNativeInstance());
    }

    public void drawRoundRect(@NonNull RectF rect, float rx, float ry, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        this.drawRoundRect(rect.left, rect.top, rect.right, rect.bottom, rx, ry, paint);
    }

    public void drawDoubleRoundRect(@NonNull RectF outer, float outerRx, float outerRy, @NonNull RectF inner, float innerRx, float innerRy, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        float outerLeft = outer.left;
        float outerTop = outer.top;
        float outerRight = outer.right;
        float outerBottom = outer.bottom;
        float innerLeft = inner.left;
        float innerTop = inner.top;
        float innerRight = inner.right;
        float innerBottom = inner.bottom;
        BaseCanvas.nDrawDoubleRoundRect(this.mNativeCanvasWrapper, outerLeft, outerTop, outerRight, outerBottom, outerRx, outerRy, innerLeft, innerTop, innerRight, innerBottom, innerRx, innerRy, paint.getNativeInstance());
    }

    public void drawDoubleRoundRect(@NonNull RectF outer, @NonNull float[] outerRadii, @NonNull RectF inner, @NonNull float[] innerRadii, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        if (innerRadii == null || outerRadii == null || innerRadii.length != 8 || outerRadii.length != 8) {
            throw new IllegalArgumentException("Both inner and outer radii arrays must contain exactly 8 values");
        }
        float outerLeft = outer.left;
        float outerTop = outer.top;
        float outerRight = outer.right;
        float outerBottom = outer.bottom;
        float innerLeft = inner.left;
        float innerTop = inner.top;
        float innerRight = inner.right;
        float innerBottom = inner.bottom;
        BaseCanvas.nDrawDoubleRoundRect(this.mNativeCanvasWrapper, outerLeft, outerTop, outerRight, outerBottom, outerRadii, innerLeft, innerTop, innerRight, innerBottom, innerRadii, paint.getNativeInstance());
    }

    public void drawGlyphs(@NonNull int[] glyphIds, int glyphIdOffset, @NonNull float[] positions, int positionOffset, int glyphCount, @NonNull Font font, @NonNull Paint paint) {
        Objects.requireNonNull(glyphIds, "glyphIds must not be null.");
        Objects.requireNonNull(positions, "positions must not be null.");
        Objects.requireNonNull(font, "font must not be null.");
        Objects.requireNonNull(paint, "paint must not be null.");
        Preconditions.checkArgumentNonnegative(glyphCount);
        if (glyphIdOffset < 0 || glyphIdOffset + glyphCount > glyphIds.length) {
            throw new IndexOutOfBoundsException("glyphIds must have at least " + (glyphIdOffset + glyphCount) + " of elements");
        }
        if (positionOffset < 0 || positionOffset + glyphCount * 2 > positions.length) {
            throw new IndexOutOfBoundsException("positions must have at least " + (positionOffset + glyphCount * 2) + " of elements");
        }
        BaseCanvas.nDrawGlyphs(this.mNativeCanvasWrapper, glyphIds, positions, glyphIdOffset, positionOffset, glyphCount, font.getNativePtr(), paint.getNativeInstance());
    }

    public void drawText(@NonNull char[] text, int index, int count, float x, float y, @NonNull Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawText(this.mNativeCanvasWrapper, text, index, count, x, y, paint.mBidiFlags, paint.getNativeInstance());
    }

    public void drawText(@NonNull CharSequence text, int start, int end, float x, float y, @NonNull Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.throwIfHasHwFeaturesInSwMode(paint);
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            BaseCanvas.nDrawText(this.mNativeCanvasWrapper, text.toString(), start, end, x, y, paint.mBidiFlags, paint.getNativeInstance());
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
        } else {
            char[] buf = TemporaryBuffer.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
            BaseCanvas.nDrawText(this.mNativeCanvasWrapper, buf, 0, end - start, x, y, paint.mBidiFlags, paint.getNativeInstance());
            TemporaryBuffer.recycle(buf);
        }
    }

    public void drawText(@NonNull String text, float x, float y, @NonNull Paint paint) {
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawText(this.mNativeCanvasWrapper, text, 0, text.length(), x, y, paint.mBidiFlags, paint.getNativeInstance());
    }

    public void drawText(@NonNull String text, int start, int end, float x, float y, @NonNull Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawText(this.mNativeCanvasWrapper, text, start, end, x, y, paint.mBidiFlags, paint.getNativeInstance());
    }

    public void drawTextOnPath(@NonNull char[] text, int index, int count, @NonNull Path path, float hOffset, float vOffset, @NonNull Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawTextOnPath(this.mNativeCanvasWrapper, text, index, count, path.readOnlyNI(), hOffset, vOffset, paint.mBidiFlags, paint.getNativeInstance());
    }

    public void drawTextOnPath(@NonNull String text, @NonNull Path path, float hOffset, float vOffset, @NonNull Paint paint) {
        if (text.length() > 0) {
            this.throwIfHasHwFeaturesInSwMode(paint);
            BaseCanvas.nDrawTextOnPath(this.mNativeCanvasWrapper, text, path.readOnlyNI(), hOffset, vOffset, paint.mBidiFlags, paint.getNativeInstance());
        }
    }

    public void drawTextRun(@NonNull char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, boolean isRtl, @NonNull Paint paint) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((index | count | contextIndex | contextCount | index - contextIndex | contextIndex + contextCount - (index + count) | text.length - (contextIndex + contextCount)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawTextRun(this.mNativeCanvasWrapper, text, index, count, contextIndex, contextCount, x, y, isRtl, paint.getNativeInstance(), 0L);
    }

    public void drawTextRun(@NonNull CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, @NonNull Paint paint) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((start | end | contextStart | contextEnd | start - contextStart | end - start | contextEnd - end | text.length() - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.throwIfHasHwFeaturesInSwMode(paint);
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            BaseCanvas.nDrawTextRun(this.mNativeCanvasWrapper, text.toString(), start, end, contextStart, contextEnd, x, y, isRtl, paint.getNativeInstance());
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawTextRun(this, start, end, contextStart, contextEnd, x, y, isRtl, paint);
        } else {
            int paraIndex;
            PrecomputedText pt;
            if (text instanceof PrecomputedText && end <= (pt = (PrecomputedText)text).getParagraphEnd(paraIndex = pt.findParaIndex(start))) {
                int paraStart = pt.getParagraphStart(paraIndex);
                MeasuredParagraph mp = pt.getMeasuredParagraph(paraIndex);
                this.drawTextRun(mp.getMeasuredText(), start - paraStart, end - paraStart, contextStart - paraStart, contextEnd - paraStart, x, y, isRtl, paint);
                return;
            }
            int contextLen = contextEnd - contextStart;
            int len = end - start;
            char[] buf = TemporaryBuffer.obtain(contextLen);
            TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
            BaseCanvas.nDrawTextRun(this.mNativeCanvasWrapper, buf, start - contextStart, len, 0, contextLen, x, y, isRtl, paint.getNativeInstance(), 0L);
            TemporaryBuffer.recycle(buf);
        }
    }

    public void drawTextRun(@NonNull MeasuredText measuredText, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, @NonNull Paint paint) {
        BaseCanvas.nDrawTextRun(this.mNativeCanvasWrapper, measuredText.getChars(), start, end - start, contextStart, contextEnd - contextStart, x, y, isRtl, paint.getNativeInstance(), measuredText.getNativePtr());
    }

    public void drawVertices(@NonNull Canvas.VertexMode mode, int vertexCount, @NonNull float[] verts, int vertOffset, @Nullable float[] texs, int texOffset, @Nullable int[] colors, int colorOffset, @Nullable short[] indices, int indexOffset, int indexCount, @NonNull Paint paint) {
        BaseCanvas.checkRange(verts.length, vertOffset, vertexCount);
        if (texs != null) {
            BaseCanvas.checkRange(texs.length, texOffset, vertexCount);
        }
        if (colors != null) {
            BaseCanvas.checkRange(colors.length, colorOffset, vertexCount / 2);
        }
        if (indices != null) {
            BaseCanvas.checkRange(indices.length, indexOffset, indexCount);
        }
        this.throwIfHasHwFeaturesInSwMode(paint);
        BaseCanvas.nDrawVertices(this.mNativeCanvasWrapper, mode.nativeInt, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint.getNativeInstance());
    }

    public void drawMesh(@NonNull Mesh mesh, @Nullable BlendMode blendMode, @NonNull Paint paint) {
        if (!this.isHardwareAccelerated() && this.onHwFeatureInSwMode()) {
            throw new RuntimeException("software rendering doesn't support meshes");
        }
        if (blendMode == null) {
            blendMode = BlendMode.MODULATE;
        }
        BaseCanvas.nDrawMesh(this.mNativeCanvasWrapper, mesh.getNativeWrapperInstance(), blendMode.getXfermode().porterDuffMode, paint.getNativeInstance());
    }

    public void punchHole(float left, float top, float right, float bottom, float rx, float ry, float alpha) {
        BaseCanvas.nPunchHole(this.mNativeCanvasWrapper, left, top, right, bottom, rx, ry, alpha);
    }

    public void setHwFeaturesInSwModeEnabled(boolean enabled) {
        this.mAllowHwFeaturesInSwMode = enabled;
    }

    public boolean isHwFeaturesInSwModeEnabled() {
        return this.mAllowHwFeaturesInSwMode;
    }

    protected boolean onHwFeatureInSwMode() {
        return !this.mAllowHwFeaturesInSwMode;
    }

    private void throwIfHwBitmapInSwMode(Bitmap bitmap) {
        if (!this.isHardwareAccelerated() && bitmap.getConfig() == Bitmap.Config.HARDWARE && this.onHwFeatureInSwMode()) {
            throw new IllegalArgumentException("Software rendering doesn't support hardware bitmaps");
        }
    }

    private void throwIfHasHwFeaturesInSwMode(Paint p) {
        if (this.isHardwareAccelerated() || p == null) {
            return;
        }
        this.throwIfHasHwFeaturesInSwMode(p.getShader());
    }

    private void throwIfHasHwFeaturesInSwMode(Shader shader) {
        if (shader == null) {
            return;
        }
        if (shader instanceof BitmapShader) {
            this.throwIfHwBitmapInSwMode(((BitmapShader)shader).mBitmap);
        } else {
            if (shader instanceof RuntimeShader && this.onHwFeatureInSwMode()) {
                throw new IllegalArgumentException("Software rendering doesn't support RuntimeShader");
            }
            if (shader instanceof ComposeShader) {
                this.throwIfHasHwFeaturesInSwMode(((ComposeShader)shader).mShaderA);
                this.throwIfHasHwFeaturesInSwMode(((ComposeShader)shader).mShaderB);
            }
        }
    }

    private static native void nDrawBitmap(long var0, long var2, float var4, float var5, long var6, int var8, int var9, int var10);

    private static native void nDrawBitmap(long var0, long var2, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, long var12, int var14, int var15);

    private static native void nDrawBitmap(long var0, int[] var2, int var3, int var4, float var5, float var6, int var7, int var8, boolean var9, long var10);

    private static native void nDrawColor(long var0, int var2, int var3);

    private static native void nDrawColor(long var0, long var2, long var4, int var6);

    private static native void nDrawPaint(long var0, long var2);

    private static native void nDrawPoint(long var0, float var2, float var3, long var4);

    private static native void nDrawPoints(long var0, float[] var2, int var3, int var4, long var5);

    private static native void nDrawLine(long var0, float var2, float var3, float var4, float var5, long var6);

    private static native void nDrawLines(long var0, float[] var2, int var3, int var4, long var5);

    private static native void nDrawRect(long var0, float var2, float var3, float var4, float var5, long var6);

    private static native void nDrawOval(long var0, float var2, float var3, float var4, float var5, long var6);

    private static native void nDrawCircle(long var0, float var2, float var3, float var4, long var5);

    private static native void nDrawArc(long var0, float var2, float var3, float var4, float var5, float var6, float var7, boolean var8, long var9);

    private static native void nDrawRoundRect(long var0, float var2, float var3, float var4, float var5, float var6, float var7, long var8);

    private static native void nDrawDoubleRoundRect(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, long var14);

    private static native void nDrawDoubleRoundRect(long var0, float var2, float var3, float var4, float var5, float[] var6, float var7, float var8, float var9, float var10, float[] var11, long var12);

    private static native void nDrawPath(long var0, long var2, long var4);

    private static native void nDrawRegion(long var0, long var2, long var4);

    private static native void nDrawNinePatch(long var0, long var2, long var4, float var6, float var7, float var8, float var9, long var10, int var12, int var13);

    private static native void nDrawBitmapMatrix(long var0, long var2, long var4, long var6);

    private static native void nDrawBitmapMesh(long var0, long var2, int var4, int var5, float[] var6, int var7, int[] var8, int var9, long var10);

    private static native void nDrawVertices(long var0, int var2, int var3, float[] var4, int var5, float[] var6, int var7, int[] var8, int var9, short[] var10, int var11, int var12, long var13);

    private static native void nDrawMesh(long var0, long var2, int var4, long var5);

    private static native void nDrawGlyphs(long var0, int[] var2, float[] var3, int var4, int var5, int var6, long var7, long var9);

    private static native void nDrawText(long var0, char[] var2, int var3, int var4, float var5, float var6, int var7, long var8);

    private static native void nDrawText(long var0, String var2, int var3, int var4, float var5, float var6, int var7, long var8);

    private static native void nDrawTextRun(long var0, String var2, int var3, int var4, int var5, int var6, float var7, float var8, boolean var9, long var10);

    private static native void nDrawTextRun(long var0, char[] var2, int var3, int var4, int var5, int var6, float var7, float var8, boolean var9, long var10, long var12);

    private static native void nDrawTextOnPath(long var0, char[] var2, int var3, int var4, long var5, float var7, float var8, int var9, long var10);

    private static native void nDrawTextOnPath(long var0, String var2, long var3, float var5, float var6, int var7, long var8);

    private static native void nPunchHole(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8);
}

