/*
 * Decompiled with CFR 0.152.
 */
package android.federatedcompute.common;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TrainingInterval
implements Parcelable {
    public static final int SCHEDULING_MODE_ONE_TIME = 1;
    public static final int SCHEDULING_MODE_RECURRENT = 2;
    private int mSchedulingMode;
    private long mMinimumIntervalMillis = 0L;
    @NonNull
    public static final Parcelable.Creator<TrainingInterval> CREATOR = new Parcelable.Creator<TrainingInterval>(){

        public TrainingInterval[] newArray(int size) {
            return new TrainingInterval[size];
        }

        @Override
        public TrainingInterval createFromParcel(@NonNull Parcel in) {
            return new TrainingInterval(in);
        }
    };

    public static String schedulingModeToString(int value) {
        switch (value) {
            case 1: {
                return "SCHEDULING_MODE_ONE_TIME";
            }
            case 2: {
                return "SCHEDULING_MODE_RECURRENT";
            }
        }
        return Integer.toHexString(value);
    }

    TrainingInterval(int schedulingMode, long minimumIntervalMillis) {
        this.mSchedulingMode = schedulingMode;
        if (this.mSchedulingMode != 1 && this.mSchedulingMode != 2) {
            throw new IllegalArgumentException("schedulingMode was " + this.mSchedulingMode + " but must be one of: SCHEDULING_MODE_ONE_TIME(" + 1 + "), SCHEDULING_MODE_RECURRENT(" + 2 + ")");
        }
        Preconditions.checkArgument(schedulingMode != 2 || minimumIntervalMillis > 0L, "Recurrent jobs cannot have non-positive minimal interval.");
        this.mMinimumIntervalMillis = minimumIntervalMillis;
    }

    public int getSchedulingMode() {
        return this.mSchedulingMode;
    }

    public long getMinimumIntervalMillis() {
        return this.mMinimumIntervalMillis;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainingInterval that = (TrainingInterval)o;
        return this.mSchedulingMode == that.mSchedulingMode && this.mMinimumIntervalMillis == that.mMinimumIntervalMillis;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mSchedulingMode;
        _hash = 31 * _hash + Long.hashCode(this.mMinimumIntervalMillis);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mSchedulingMode);
        dest.writeLong(this.mMinimumIntervalMillis);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    TrainingInterval(@NonNull Parcel in) {
        int schedulingMode = in.readInt();
        long minimumIntervalMillis = in.readLong();
        this.mSchedulingMode = schedulingMode;
        if (this.mSchedulingMode != 1 && this.mSchedulingMode != 2) {
            throw new IllegalArgumentException("schedulingMode was " + this.mSchedulingMode + " but must be one of: SCHEDULING_MODE_ONE_TIME(" + 1 + "), SCHEDULING_MODE_RECURRENT(" + 2 + ")");
        }
        this.mMinimumIntervalMillis = minimumIntervalMillis;
    }

    public static class Builder {
        private int mSchedulingMode;
        private long mMinimumIntervalMillis;
        private long mBuilderFieldsSet = 0L;

        @NonNull
        public Builder setSchedulingMode(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mSchedulingMode = value;
            return this;
        }

        @NonNull
        public Builder setMinimumIntervalMillis(long value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mMinimumIntervalMillis = value;
            return this;
        }

        @NonNull
        public TrainingInterval build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mMinimumIntervalMillis = 0L;
            }
            TrainingInterval o = new TrainingInterval(this.mSchedulingMode, this.mMinimumIntervalMillis);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 4L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SchedulingMode {
    }
}

