/*
 * Decompiled with CFR 0.152.
 */
package android.debug;

import android.debug.FingerprintAndPairDevice;
import android.debug.IAdbCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IAdbManager
extends IInterface {
    public static final String DESCRIPTOR = "android.debug.IAdbManager";

    public void allowDebugging(boolean var1, String var2) throws RemoteException;

    public void denyDebugging() throws RemoteException;

    public void clearDebuggingKeys() throws RemoteException;

    public void allowWirelessDebugging(boolean var1, String var2) throws RemoteException;

    public void denyWirelessDebugging() throws RemoteException;

    public FingerprintAndPairDevice[] getPairedDevices() throws RemoteException;

    public void unpairDevice(String var1) throws RemoteException;

    public void enablePairingByPairingCode() throws RemoteException;

    public void enablePairingByQrCode(String var1, String var2) throws RemoteException;

    public int getAdbWirelessPort() throws RemoteException;

    public void disablePairing() throws RemoteException;

    public boolean isAdbWifiSupported() throws RemoteException;

    public boolean isAdbWifiQrSupported() throws RemoteException;

    public void registerCallback(IAdbCallback var1) throws RemoteException;

    public void unregisterCallback(IAdbCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAdbManager {
        static final int TRANSACTION_allowDebugging = 1;
        static final int TRANSACTION_denyDebugging = 2;
        static final int TRANSACTION_clearDebuggingKeys = 3;
        static final int TRANSACTION_allowWirelessDebugging = 4;
        static final int TRANSACTION_denyWirelessDebugging = 5;
        static final int TRANSACTION_getPairedDevices = 6;
        static final int TRANSACTION_unpairDevice = 7;
        static final int TRANSACTION_enablePairingByPairingCode = 8;
        static final int TRANSACTION_enablePairingByQrCode = 9;
        static final int TRANSACTION_getAdbWirelessPort = 10;
        static final int TRANSACTION_disablePairing = 11;
        static final int TRANSACTION_isAdbWifiSupported = 12;
        static final int TRANSACTION_isAdbWifiQrSupported = 13;
        static final int TRANSACTION_registerCallback = 14;
        static final int TRANSACTION_unregisterCallback = 15;

        public Stub() {
            this.attachInterface(this, IAdbManager.DESCRIPTOR);
        }

        public static IAdbManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAdbManager.DESCRIPTOR);
            if (iin != null && iin instanceof IAdbManager) {
                return (IAdbManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "allowDebugging";
                }
                case 2: {
                    return "denyDebugging";
                }
                case 3: {
                    return "clearDebuggingKeys";
                }
                case 4: {
                    return "allowWirelessDebugging";
                }
                case 5: {
                    return "denyWirelessDebugging";
                }
                case 6: {
                    return "getPairedDevices";
                }
                case 7: {
                    return "unpairDevice";
                }
                case 8: {
                    return "enablePairingByPairingCode";
                }
                case 9: {
                    return "enablePairingByQrCode";
                }
                case 10: {
                    return "getAdbWirelessPort";
                }
                case 11: {
                    return "disablePairing";
                }
                case 12: {
                    return "isAdbWifiSupported";
                }
                case 13: {
                    return "isAdbWifiQrSupported";
                }
                case 14: {
                    return "registerCallback";
                }
                case 15: {
                    return "unregisterCallback";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAdbManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.allowDebugging(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    this.denyDebugging();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    this.clearDebuggingKeys();
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.allowWirelessDebugging(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    this.denyWirelessDebugging();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    Parcelable[] _result = this.getPairedDevices();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.unpairDevice(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    this.enablePairingByPairingCode();
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.enablePairingByQrCode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _result = this.getAdbWirelessPort();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    this.disablePairing();
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    boolean _result = this.isAdbWifiSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    boolean _result = this.isAdbWifiQrSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    IAdbCallback _arg0 = IAdbCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IAdbCallback _arg0 = IAdbCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 14;
        }

        private static class Proxy
        implements IAdbManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAdbManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowDebugging(boolean alwaysAllow, String publicKey) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    _data.writeBoolean(alwaysAllow);
                    _data.writeString(publicKey);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void denyDebugging() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearDebuggingKeys() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowWirelessDebugging(boolean alwaysAllow, String bssid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    _data.writeBoolean(alwaysAllow);
                    _data.writeString(bssid);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void denyWirelessDebugging() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FingerprintAndPairDevice[] getPairedDevices() throws RemoteException {
                FingerprintAndPairDevice[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(FingerprintAndPairDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unpairDevice(String fingerprint) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    _data.writeString(fingerprint);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enablePairingByPairingCode() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enablePairingByQrCode(String serviceName, String password) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    _data.writeString(serviceName);
                    _data.writeString(password);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAdbWirelessPort() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disablePairing() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAdbWifiSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAdbWifiQrSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(IAdbCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCallback(IAdbCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdbManager.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAdbManager {
        @Override
        public void allowDebugging(boolean alwaysAllow, String publicKey) throws RemoteException {
        }

        @Override
        public void denyDebugging() throws RemoteException {
        }

        @Override
        public void clearDebuggingKeys() throws RemoteException {
        }

        @Override
        public void allowWirelessDebugging(boolean alwaysAllow, String bssid) throws RemoteException {
        }

        @Override
        public void denyWirelessDebugging() throws RemoteException {
        }

        @Override
        public FingerprintAndPairDevice[] getPairedDevices() throws RemoteException {
            return null;
        }

        @Override
        public void unpairDevice(String fingerprint) throws RemoteException {
        }

        @Override
        public void enablePairingByPairingCode() throws RemoteException {
        }

        @Override
        public void enablePairingByQrCode(String serviceName, String password) throws RemoteException {
        }

        @Override
        public int getAdbWirelessPort() throws RemoteException {
            return 0;
        }

        @Override
        public void disablePairing() throws RemoteException {
        }

        @Override
        public boolean isAdbWifiSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isAdbWifiQrSupported() throws RemoteException {
            return false;
        }

        @Override
        public void registerCallback(IAdbCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterCallback(IAdbCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

