/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.ddm.DdmHandle;
import android.os.Debug;
import android.util.Log;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleProfiling
extends DdmHandle {
    public static final int CHUNK_MPRS = ChunkHandler.type("MPRS");
    public static final int CHUNK_MPRE = ChunkHandler.type("MPRE");
    public static final int CHUNK_MPSS = ChunkHandler.type("MPSS");
    public static final int CHUNK_MPSE = ChunkHandler.type("MPSE");
    public static final int CHUNK_MPRQ = ChunkHandler.type("MPRQ");
    public static final int CHUNK_SPSS = ChunkHandler.type("SPSS");
    public static final int CHUNK_SPSE = ChunkHandler.type("SPSE");
    private static final boolean DEBUG = false;
    private static DdmHandleProfiling mInstance = new DdmHandleProfiling();

    private DdmHandleProfiling() {
    }

    public static void register() {
        DdmServer.registerHandler(CHUNK_MPRS, mInstance);
        DdmServer.registerHandler(CHUNK_MPRE, mInstance);
        DdmServer.registerHandler(CHUNK_MPSS, mInstance);
        DdmServer.registerHandler(CHUNK_MPSE, mInstance);
        DdmServer.registerHandler(CHUNK_MPRQ, mInstance);
        DdmServer.registerHandler(CHUNK_SPSS, mInstance);
        DdmServer.registerHandler(CHUNK_SPSE, mInstance);
    }

    @Override
    public void onConnected() {
    }

    @Override
    public void onDisconnected() {
    }

    @Override
    public Chunk handleChunk(Chunk request) {
        int type = request.type;
        if (type == CHUNK_MPRS) {
            return this.handleMPRS(request);
        }
        if (type == CHUNK_MPRE) {
            return this.handleMPRE(request);
        }
        if (type == CHUNK_MPSS) {
            return this.handleMPSS(request);
        }
        if (type == CHUNK_MPSE) {
            return this.handleMPSEOrSPSE(request, "Method");
        }
        if (type == CHUNK_MPRQ) {
            return this.handleMPRQ(request);
        }
        if (type == CHUNK_SPSS) {
            return this.handleSPSS(request);
        }
        if (type == CHUNK_SPSE) {
            return this.handleMPSEOrSPSE(request, "Sample");
        }
        throw new RuntimeException("Unknown packet " + DdmHandleProfiling.name(type));
    }

    private Chunk handleMPRS(Chunk request) {
        ByteBuffer in = DdmHandleProfiling.wrapChunk(request);
        int bufferSize = in.getInt();
        int flags = in.getInt();
        int len = in.getInt();
        String fileName = DdmHandleProfiling.getString(in, len);
        try {
            Debug.startMethodTracing(fileName, bufferSize, flags);
            return null;
        }
        catch (RuntimeException re) {
            return DdmHandleProfiling.createFailChunk(1, re.getMessage());
        }
    }

    private Chunk handleMPRE(Chunk request) {
        byte result;
        try {
            Debug.stopMethodTracing();
            result = 0;
        }
        catch (RuntimeException re) {
            Log.w("ddm-heap", "Method profiling end failed: " + re.getMessage());
            result = 1;
        }
        byte[] reply = new byte[]{result};
        return new Chunk(CHUNK_MPRE, reply, 0, reply.length);
    }

    private Chunk handleMPSS(Chunk request) {
        ByteBuffer in = DdmHandleProfiling.wrapChunk(request);
        int bufferSize = in.getInt();
        int flags = in.getInt();
        try {
            Debug.startMethodTracingDdms(bufferSize, flags, false, 0);
            return null;
        }
        catch (RuntimeException re) {
            return DdmHandleProfiling.createFailChunk(1, re.getMessage());
        }
    }

    private Chunk handleMPSEOrSPSE(Chunk request, String type) {
        try {
            Debug.stopMethodTracing();
        }
        catch (RuntimeException re) {
            Log.w("ddm-heap", type + " prof stream end failed: " + re.getMessage());
            return DdmHandleProfiling.createFailChunk(1, re.getMessage());
        }
        return null;
    }

    private Chunk handleMPRQ(Chunk request) {
        int result = Debug.getMethodTracingMode();
        byte[] reply = new byte[]{(byte)result};
        return new Chunk(CHUNK_MPRQ, reply, 0, reply.length);
    }

    private Chunk handleSPSS(Chunk request) {
        ByteBuffer in = DdmHandleProfiling.wrapChunk(request);
        int bufferSize = in.getInt();
        int flags = in.getInt();
        int interval = in.getInt();
        try {
            Debug.startMethodTracingDdms(bufferSize, flags, true, interval);
            return null;
        }
        catch (RuntimeException re) {
            return DdmHandleProfiling.createFailChunk(1, re.getMessage());
        }
    }
}

