/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteConnection;
import android.database.sqlite.SQLiteConnectionPool;
import android.database.sqlite.SQLiteStatementInfo;
import android.database.sqlite.SQLiteTransactionListener;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;

public class SQLiteSession {
    private final SQLiteConnectionPool mConnectionPool;
    private SQLiteConnection mConnection;
    private int mConnectionFlags;
    private int mConnectionUseCount;
    private Transaction mTransactionPool;
    private Transaction mTransactionStack;
    private final ArrayDeque<Closeable> mOpenDependents = new ArrayDeque();
    public static final int TRANSACTION_MODE_DEFERRED = 0;
    public static final int TRANSACTION_MODE_IMMEDIATE = 1;
    public static final int TRANSACTION_MODE_EXCLUSIVE = 2;

    public SQLiteSession(SQLiteConnectionPool connectionPool) {
        if (connectionPool == null) {
            throw new IllegalArgumentException("connectionPool must not be null");
        }
        this.mConnectionPool = connectionPool;
    }

    public boolean hasTransaction() {
        return this.mTransactionStack != null;
    }

    public boolean hasNestedTransaction() {
        return this.mTransactionStack != null && this.mTransactionStack.mParent != null;
    }

    public boolean hasConnection() {
        return this.mConnection != null;
    }

    @UnsupportedAppUsage
    public void beginTransaction(int transactionMode, SQLiteTransactionListener transactionListener, int connectionFlags, CancellationSignal cancellationSignal) {
        this.throwIfTransactionMarkedSuccessful();
        this.beginTransactionUnchecked(transactionMode, transactionListener, connectionFlags, cancellationSignal);
    }

    private String modeString(int transactionMode) {
        switch (transactionMode) {
            case 1: {
                return "TRANSACTION-IMMEDIATE";
            }
            case 2: {
                return "TRANSACTION-EXCLUSIVE";
            }
            case 0: {
                return "TRANSACTION-DEFERRED";
            }
        }
        return "TRANSACTION";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginTransactionUnchecked(int transactionMode, SQLiteTransactionListener transactionListener, int connectionFlags, CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        if (this.mTransactionStack == null) {
            this.acquireConnection(null, connectionFlags, cancellationSignal);
            this.mConnection.recordBeginTransaction(this.modeString(transactionMode));
        }
        try {
            if (this.mTransactionStack == null) {
                switch (transactionMode) {
                    case 1: {
                        this.mConnection.execute("BEGIN IMMEDIATE;", null, cancellationSignal);
                        break;
                    }
                    case 2: {
                        this.mConnection.execute("BEGIN EXCLUSIVE;", null, cancellationSignal);
                        break;
                    }
                    case 0: {
                        this.mConnection.execute("BEGIN DEFERRED;", null, cancellationSignal);
                        break;
                    }
                    default: {
                        this.mConnection.execute("BEGIN;", null, cancellationSignal);
                    }
                }
            }
            if (transactionListener != null) {
                try {
                    transactionListener.onBegin();
                }
                catch (RuntimeException ex) {
                    if (this.mTransactionStack == null) {
                        this.mConnection.execute("ROLLBACK;", null, cancellationSignal);
                    }
                    throw ex;
                }
            }
            Transaction transaction = this.obtainTransaction(transactionMode, transactionListener);
            transaction.mParent = this.mTransactionStack;
            this.mTransactionStack = transaction;
        }
        finally {
            if (this.mTransactionStack == null) {
                this.releaseConnection();
            }
        }
    }

    public void setTransactionSuccessful() {
        this.throwIfNoTransaction();
        this.throwIfTransactionMarkedSuccessful();
        this.mTransactionStack.mMarkedSuccessful = true;
        this.closeOpenDependents();
    }

    public void endTransaction(CancellationSignal cancellationSignal) {
        this.throwIfNoTransaction();
        assert (this.mConnection != null);
        this.endTransactionUnchecked(cancellationSignal, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endTransactionUnchecked(CancellationSignal cancellationSignal, boolean yielding) {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        Transaction top = this.mTransactionStack;
        boolean successful = (top.mMarkedSuccessful || yielding) && !top.mChildFailed;
        RuntimeException listenerException = null;
        SQLiteTransactionListener listener = top.mListener;
        if (listener != null) {
            try {
                if (successful) {
                    listener.onCommit();
                } else {
                    listener.onRollback();
                }
            }
            catch (RuntimeException ex) {
                listenerException = ex;
                successful = false;
            }
        }
        this.mTransactionStack = top.mParent;
        this.recycleTransaction(top);
        if (this.mTransactionStack != null) {
            if (!successful) {
                this.mTransactionStack.mChildFailed = true;
            }
        } else {
            this.closeOpenDependents();
            try {
                if (successful) {
                    this.mConnection.execute("COMMIT;", null, cancellationSignal);
                } else {
                    this.mConnection.execute("ROLLBACK;", null, cancellationSignal);
                }
            }
            finally {
                this.mConnection.recordEndTransaction(successful);
                this.releaseConnection();
            }
        }
        if (listenerException != null) {
            throw listenerException;
        }
    }

    public boolean yieldTransaction(long sleepAfterYieldDelayMillis, boolean throwIfUnsafe, CancellationSignal cancellationSignal) {
        if (throwIfUnsafe) {
            this.throwIfNoTransaction();
            this.throwIfTransactionMarkedSuccessful();
            this.throwIfNestedTransaction();
        } else if (this.mTransactionStack == null || this.mTransactionStack.mMarkedSuccessful || this.mTransactionStack.mParent != null) {
            return false;
        }
        assert (this.mConnection != null);
        if (this.mTransactionStack.mChildFailed) {
            return false;
        }
        return this.yieldTransactionUnchecked(sleepAfterYieldDelayMillis, cancellationSignal);
    }

    private boolean yieldTransactionUnchecked(long sleepAfterYieldDelayMillis, CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        if (!this.mConnectionPool.shouldYieldConnection(this.mConnection, this.mConnectionFlags)) {
            return false;
        }
        int transactionMode = this.mTransactionStack.mMode;
        SQLiteTransactionListener listener = this.mTransactionStack.mListener;
        int connectionFlags = this.mConnectionFlags;
        this.endTransactionUnchecked(cancellationSignal, true);
        if (sleepAfterYieldDelayMillis > 0L) {
            try {
                Thread.sleep(sleepAfterYieldDelayMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.beginTransactionUnchecked(transactionMode, listener, connectionFlags, cancellationSignal);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(String sql, int connectionFlags, CancellationSignal cancellationSignal, SQLiteStatementInfo outStatementInfo) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            this.mConnection.prepare(sql, outStatementInfo);
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String sql, Object[] bindArgs, int connectionFlags, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(sql, bindArgs, connectionFlags, cancellationSignal)) {
            return;
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            this.mConnection.execute(sql, bindArgs, cancellationSignal);
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeForLong(String sql, Object[] bindArgs, int connectionFlags, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(sql, bindArgs, connectionFlags, cancellationSignal)) {
            return 0L;
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            long l = this.mConnection.executeForLong(sql, bindArgs, cancellationSignal);
            return l;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeForString(String sql, Object[] bindArgs, int connectionFlags, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(sql, bindArgs, connectionFlags, cancellationSignal)) {
            return null;
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            String string2 = this.mConnection.executeForString(sql, bindArgs, cancellationSignal);
            return string2;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelFileDescriptor executeForBlobFileDescriptor(String sql, Object[] bindArgs, int connectionFlags, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(sql, bindArgs, connectionFlags, cancellationSignal)) {
            return null;
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            ParcelFileDescriptor parcelFileDescriptor = this.mConnection.executeForBlobFileDescriptor(sql, bindArgs, cancellationSignal);
            return parcelFileDescriptor;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeForChangedRowCount(String sql, Object[] bindArgs, int connectionFlags, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(sql, bindArgs, connectionFlags, cancellationSignal)) {
            return 0;
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            int n = this.mConnection.executeForChangedRowCount(sql, bindArgs, cancellationSignal);
            return n;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeForLastInsertedRowId(String sql, Object[] bindArgs, int connectionFlags, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(sql, bindArgs, connectionFlags, cancellationSignal)) {
            return 0L;
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            long l = this.mConnection.executeForLastInsertedRowId(sql, bindArgs, cancellationSignal);
            return l;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeForCursorWindow(String sql, Object[] bindArgs, CursorWindow window, int startPos, int requiredPos, boolean countAllRows, int connectionFlags, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (window == null) {
            throw new IllegalArgumentException("window must not be null.");
        }
        if (this.executeSpecial(sql, bindArgs, connectionFlags, cancellationSignal)) {
            window.clear();
            return 0;
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            int n = this.mConnection.executeForCursorWindow(sql, bindArgs, window, startPos, requiredPos, countAllRows, cancellationSignal);
            return n;
        }
        finally {
            this.releaseConnection();
        }
    }

    private boolean executeSpecial(String sql, Object[] bindArgs, int connectionFlags, CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        int type = DatabaseUtils.getSqlStatementType(sql);
        switch (type) {
            case 4: {
                this.beginTransaction(2, null, connectionFlags, cancellationSignal);
                return true;
            }
            case 5: {
                this.setTransactionSuccessful();
                this.endTransaction(cancellationSignal);
                return true;
            }
            case 6: {
                this.endTransaction(cancellationSignal);
                return true;
            }
        }
        return false;
    }

    private void acquireConnection(String sql, int connectionFlags, CancellationSignal cancellationSignal) {
        if (this.mConnection == null) {
            assert (this.mConnectionUseCount == 0);
            this.mConnection = this.mConnectionPool.acquireConnection(sql, connectionFlags, cancellationSignal);
            this.mConnectionFlags = connectionFlags;
        }
        ++this.mConnectionUseCount;
    }

    private void releaseConnection() {
        assert (this.mConnection != null);
        assert (this.mConnectionUseCount > 0);
        if (--this.mConnectionUseCount == 0) {
            try {
                this.mConnectionPool.releaseConnection(this.mConnection);
            }
            finally {
                this.mConnection = null;
            }
        }
    }

    @NonNull
    SQLiteConnection.PreparedStatement acquirePersistentStatement(@NonNull String query, @NonNull Closeable dependent) {
        this.throwIfNoTransaction();
        this.throwIfTransactionMarkedSuccessful();
        this.mOpenDependents.addFirst(dependent);
        try {
            return this.mConnection.acquirePersistentStatement(query);
        }
        catch (Throwable e) {
            this.mOpenDependents.remove(dependent);
            throw e;
        }
    }

    void releasePersistentStatement(@NonNull SQLiteConnection.PreparedStatement statement, @NonNull Closeable dependent) {
        this.mConnection.releasePreparedStatement(statement);
        this.mOpenDependents.remove(dependent);
    }

    void closeOpenDependents() {
        while (this.mOpenDependents.size() > 0) {
            Closeable dependent = this.mOpenDependents.pollFirst();
            if (dependent == null) continue;
            try {
                dependent.close();
            }
            catch (IOException iOException) {}
        }
    }

    long getLastInsertRowId() {
        this.throwIfNoTransaction();
        return this.mConnection.getLastInsertRowId();
    }

    long getLastChangedRowCount() {
        this.throwIfNoTransaction();
        return this.mConnection.getLastChangedRowCount();
    }

    long getTotalChangedRowCount() {
        this.throwIfNoTransaction();
        return this.mConnection.getTotalChangedRowCount();
    }

    void throwIfNoTransaction() {
        if (this.mTransactionStack == null) {
            throw new IllegalStateException("Cannot perform this operation because there is no current transaction.");
        }
    }

    private void throwIfTransactionMarkedSuccessful() {
        if (this.mTransactionStack != null && this.mTransactionStack.mMarkedSuccessful) {
            throw new IllegalStateException("Cannot perform this operation because the transaction has already been marked successful.  The only thing you can do now is call endTransaction().");
        }
    }

    private void throwIfNestedTransaction() {
        if (this.hasNestedTransaction()) {
            throw new IllegalStateException("Cannot perform this operation because a nested transaction is in progress.");
        }
    }

    private Transaction obtainTransaction(int mode, SQLiteTransactionListener listener) {
        Transaction transaction = this.mTransactionPool;
        if (transaction != null) {
            this.mTransactionPool = transaction.mParent;
            transaction.mParent = null;
            transaction.mMarkedSuccessful = false;
            transaction.mChildFailed = false;
        } else {
            transaction = new Transaction();
        }
        transaction.mMode = mode;
        transaction.mListener = listener;
        return transaction;
    }

    private void recycleTransaction(Transaction transaction) {
        transaction.mParent = this.mTransactionPool;
        transaction.mListener = null;
        this.mTransactionPool = transaction;
    }

    private static class Transaction {
        public Transaction mParent;
        public int mMode;
        public SQLiteTransactionListener mListener;
        public boolean mMarkedSuccessful;
        public boolean mChildFailed;

        private Transaction() {
        }
    }
}

