/*
 * Decompiled with CFR 0.152.
 */
package android.credentials;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.credentials.CredentialEntry;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CredentialDescription
implements Parcelable {
    private static final int MAX_ALLOWED_ENTRIES_PER_DESCRIPTION = 16;
    @NonNull
    private final String mType;
    @NonNull
    private final Set<String> mSupportedElementKeys;
    @NonNull
    private final List<CredentialEntry> mCredentialEntries;
    @NonNull
    public static final Parcelable.Creator<CredentialDescription> CREATOR = new Parcelable.Creator<CredentialDescription>(){

        @Override
        public CredentialDescription createFromParcel(Parcel in) {
            return new CredentialDescription(in);
        }

        public CredentialDescription[] newArray(int size) {
            return new CredentialDescription[size];
        }
    };

    public CredentialDescription(@NonNull String type, @NonNull Set<String> supportedElementKeys, @NonNull List<CredentialEntry> credentialEntries) {
        this.mType = Preconditions.checkStringNotEmpty(type, "type must not be empty");
        this.mSupportedElementKeys = Objects.requireNonNull(supportedElementKeys);
        this.mCredentialEntries = Objects.requireNonNull(credentialEntries);
        Preconditions.checkArgument(credentialEntries.size() <= 16, "The number of Credential Entries exceed 16.");
        Preconditions.checkArgument(CredentialDescription.compareEntryTypes(type, credentialEntries) == 0, "Credential Entry type(s) do not match the request type.");
    }

    private CredentialDescription(@NonNull Parcel in) {
        String type = in.readString8();
        ArrayList<String> descriptions = in.createStringArrayList();
        ArrayList<CredentialEntry> entries = new ArrayList<CredentialEntry>();
        in.readTypedList(entries, CredentialEntry.CREATOR);
        this.mType = type;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mType);
        this.mSupportedElementKeys = new HashSet<String>(descriptions);
        AnnotationValidations.validate(NonNull.class, null, this.mSupportedElementKeys);
        this.mCredentialEntries = entries;
        AnnotationValidations.validate(NonNull.class, null, this.mCredentialEntries);
    }

    private static int compareEntryTypes(@NonNull String type, @NonNull List<CredentialEntry> credentialEntries) {
        return credentialEntries.stream().filter(credentialEntry -> !credentialEntry.getType().equals(type)).toList().size();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mType);
        dest.writeStringList(this.mSupportedElementKeys.stream().toList());
        dest.writeTypedList(this.mCredentialEntries, flags);
    }

    @NonNull
    public String getType() {
        return this.mType;
    }

    @NonNull
    public Set<String> getSupportedElementKeys() {
        return new HashSet<String>(this.mSupportedElementKeys);
    }

    @NonNull
    public List<CredentialEntry> getCredentialEntries() {
        return this.mCredentialEntries;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mSupportedElementKeys);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CredentialDescription)) {
            return false;
        }
        CredentialDescription other = (CredentialDescription)obj;
        return this.mType.equals(other.mType) && this.mSupportedElementKeys.equals(other.mSupportedElementKeys);
    }
}

