/*
 * Decompiled with CFR 0.152.
 */
package android.content.res.loader;

import android.annotation.NonNull;
import android.content.res.ApkAssets;
import android.content.res.loader.ResourcesProvider;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import com.android.tools.layoutlib.java.Reference_Delegate;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ResourcesLoader {
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private ApkAssets[] mApkAssets;
    @GuardedBy(value={"mLock"})
    private ResourcesProvider[] mPreviousProviders;
    @GuardedBy(value={"mLock"})
    private ResourcesProvider[] mProviders;
    @GuardedBy(value={"mLock"})
    private ArrayMap<WeakReference<Object>, UpdateCallbacks> mChangeCallbacks = new ArrayMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<ResourcesProvider> getProviders() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mProviders == null ? Collections.emptyList() : Arrays.asList(this.mProviders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProvider(@NonNull ResourcesProvider resourcesProvider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mProviders = ArrayUtils.appendElement(ResourcesProvider.class, this.mProviders, resourcesProvider);
            this.notifyProvidersChangedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProvider(@NonNull ResourcesProvider resourcesProvider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mProviders = ArrayUtils.removeElement(ResourcesProvider.class, this.mProviders, resourcesProvider);
            this.notifyProvidersChangedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProviders(@NonNull List<ResourcesProvider> resourcesProviders) {
        Object object = this.mLock;
        synchronized (object) {
            this.mProviders = resourcesProviders.toArray(new ResourcesProvider[0]);
            this.notifyProvidersChangedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProviders() {
        Object object = this.mLock;
        synchronized (object) {
            this.mProviders = null;
            this.notifyProvidersChangedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<ApkAssets> getApkAssets() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mApkAssets == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.mApkAssets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnProvidersChangedCallback(@NonNull Object instance, @NonNull UpdateCallbacks callbacks) {
        Object object = this.mLock;
        synchronized (object) {
            this.mChangeCallbacks.put(new WeakReference<Object>(instance), callbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnProvidersChangedCallback(@NonNull Object instance) {
        Object object = this.mLock;
        synchronized (object) {
            int n = this.mChangeCallbacks.size();
            for (int i = 0; i < n; ++i) {
                WeakReference<Object> key = this.mChangeCallbacks.keyAt(i);
                if (instance != key.get()) continue;
                this.mChangeCallbacks.removeAt(i);
                return;
            }
        }
    }

    private static boolean arrayEquals(ResourcesProvider[] a1, ResourcesProvider[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        int n = a1.length;
        for (int i = 0; i < n; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    private void notifyProvidersChangedLocked() {
        int i;
        int n;
        ArraySet<UpdateCallbacks> uniqueCallbacks = new ArraySet<UpdateCallbacks>();
        if (ResourcesLoader.arrayEquals(this.mPreviousProviders, this.mProviders)) {
            return;
        }
        if (this.mProviders == null || this.mProviders.length == 0) {
            this.mApkAssets = null;
        } else {
            this.mApkAssets = new ApkAssets[this.mProviders.length];
            n = this.mProviders.length;
            for (i = 0; i < n; ++i) {
                this.mProviders[i].incrementRefCount();
                this.mApkAssets[i] = this.mProviders[i].getApkAssets();
            }
        }
        if (this.mPreviousProviders != null) {
            for (ResourcesProvider provider : this.mPreviousProviders) {
                provider.decrementRefCount();
            }
        }
        this.mPreviousProviders = this.mProviders;
        for (i = this.mChangeCallbacks.size() - 1; i >= 0; --i) {
            WeakReference<Object> key = this.mChangeCallbacks.keyAt(i);
            if (Reference_Delegate.refersTo(key, null)) {
                this.mChangeCallbacks.removeAt(i);
                continue;
            }
            uniqueCallbacks.add(this.mChangeCallbacks.valueAt(i));
        }
        n = uniqueCallbacks.size();
        for (i = 0; i < n; ++i) {
            ((UpdateCallbacks)uniqueCallbacks.valueAt(i)).onLoaderUpdated(this);
        }
    }

    public static interface UpdateCallbacks {
        public void onLoaderUpdated(@NonNull ResourcesLoader var1);
    }
}

