/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.verify.domain;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.IBinder;
import android.os.Parcel;
import android.util.ArraySet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class DomainVerificationUtils {
    private static final int STRINGS_TARGET_BYTE_SIZE = IBinder.getSuggestedMaxIpcSizeBytes() / 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeHostMap(@NonNull Parcel dest, @NonNull Map<String, ?> map) {
        boolean targetSizeExceeded = false;
        int totalSize = dest.dataSize();
        for (String host : map.keySet()) {
            if ((totalSize += DomainVerificationUtils.estimatedByteSizeOf(host)) <= STRINGS_TARGET_BYTE_SIZE) continue;
            targetSizeExceeded = true;
            break;
        }
        dest.writeBoolean(targetSizeExceeded);
        if (!targetSizeExceeded) {
            dest.writeMap(map);
            return;
        }
        Parcel data = Parcel.obtain();
        try {
            data.writeMap(map);
            dest.writeBlob(data.marshall());
        }
        finally {
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static <T extends Map> T readHostMap(@NonNull Parcel in, @NonNull T map, @NonNull ClassLoader classLoader) {
        boolean targetSizeExceeded = in.readBoolean();
        if (!targetSizeExceeded) {
            in.readMap(map, classLoader);
            return map;
        }
        Parcel data = Parcel.obtain();
        try {
            byte[] blob = in.readBlob();
            data.unmarshall(blob, 0, blob.length);
            data.setDataPosition(0);
            data.readMap(map, classLoader);
        }
        finally {
            data.recycle();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeHostSet(@NonNull Parcel dest, @NonNull Set<String> set) {
        boolean targetSizeExceeded = false;
        int totalSize = dest.dataSize();
        for (String host : set) {
            if ((totalSize += DomainVerificationUtils.estimatedByteSizeOf(host)) <= STRINGS_TARGET_BYTE_SIZE) continue;
            targetSizeExceeded = true;
            break;
        }
        dest.writeBoolean(targetSizeExceeded);
        if (!targetSizeExceeded) {
            DomainVerificationUtils.writeSet(dest, set);
            return;
        }
        Parcel data = Parcel.obtain();
        try {
            DomainVerificationUtils.writeSet(data, set);
            dest.writeBlob(data.marshall());
        }
        finally {
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Set<String> readHostSet(@NonNull Parcel in) {
        boolean targetSizeExceeded = in.readBoolean();
        if (!targetSizeExceeded) {
            return DomainVerificationUtils.readSet(in);
        }
        Parcel data = Parcel.obtain();
        try {
            byte[] blob = in.readBlob();
            data.unmarshall(blob, 0, blob.length);
            data.setDataPosition(0);
            Set<String> set = DomainVerificationUtils.readSet(data);
            return set;
        }
        finally {
            data.recycle();
        }
    }

    private static void writeSet(@NonNull Parcel dest, @Nullable Set<String> set) {
        if (set == null) {
            dest.writeInt(-1);
            return;
        }
        dest.writeInt(set.size());
        for (String string2 : set) {
            dest.writeString(string2);
        }
    }

    @NonNull
    private static Set<String> readSet(@NonNull Parcel in) {
        int size = in.readInt();
        if (size == -1) {
            return Collections.emptySet();
        }
        ArraySet<String> set = new ArraySet<String>(size);
        for (int count = 0; count < size; ++count) {
            set.add(in.readString());
        }
        return set;
    }

    public static int estimatedByteSizeOf(String string2) {
        return string2.length() * 2 + 12;
    }
}

