/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.verify.domain;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.content.pm.verify.domain.DomainVerificationUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.util.ArrayMap;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Parcelling;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class DomainVerificationUserState
implements Parcelable {
    public static final int DOMAIN_STATE_NONE = 0;
    public static final int DOMAIN_STATE_SELECTED = 1;
    public static final int DOMAIN_STATE_VERIFIED = 2;
    @NonNull
    private final UUID mIdentifier;
    @NonNull
    private final String mPackageName;
    @NonNull
    private final UserHandle mUser;
    @NonNull
    private final boolean mLinkHandlingAllowed;
    @NonNull
    private final Map<String, Integer> mHostToStateMap;
    static Parcelling<UUID> sParcellingForIdentifier = Parcelling.Cache.get(Parcelling.BuiltIn.ForUUID.class);
    @NonNull
    public static final Parcelable.Creator<DomainVerificationUserState> CREATOR;

    private void parcelHostToStateMap(Parcel dest, int flags) {
        DomainVerificationUtils.writeHostMap(dest, this.mHostToStateMap);
    }

    @NonNull
    private Map<String, Integer> unparcelHostToStateMap(Parcel in) {
        return DomainVerificationUtils.readHostMap(in, new ArrayMap(), DomainVerificationUserState.class.getClassLoader());
    }

    @SystemApi
    @NonNull
    public UUID getIdentifier() {
        return this.mIdentifier;
    }

    public static String domainStateToString(int value) {
        switch (value) {
            case 0: {
                return "DOMAIN_STATE_NONE";
            }
            case 1: {
                return "DOMAIN_STATE_SELECTED";
            }
            case 2: {
                return "DOMAIN_STATE_VERIFIED";
            }
        }
        return Integer.toHexString(value);
    }

    public DomainVerificationUserState(@NonNull UUID identifier, @NonNull String packageName, @NonNull UserHandle user, @NonNull boolean linkHandlingAllowed, @NonNull Map<String, Integer> hostToStateMap) {
        this.mIdentifier = identifier;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mIdentifier);
        this.mPackageName = packageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
        this.mUser = user;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mUser);
        this.mLinkHandlingAllowed = linkHandlingAllowed;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mLinkHandlingAllowed);
        this.mHostToStateMap = hostToStateMap;
        AnnotationValidations.validate(NonNull.class, null, this.mHostToStateMap);
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public UserHandle getUser() {
        return this.mUser;
    }

    @NonNull
    public boolean isLinkHandlingAllowed() {
        return this.mLinkHandlingAllowed;
    }

    @NonNull
    public Map<String, Integer> getHostToStateMap() {
        return this.mHostToStateMap;
    }

    public String toString() {
        return "DomainVerificationUserState { identifier = " + this.mIdentifier + ", packageName = " + this.mPackageName + ", user = " + this.mUser + ", linkHandlingAllowed = " + this.mLinkHandlingAllowed + ", hostToStateMap = " + this.mHostToStateMap + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainVerificationUserState that = (DomainVerificationUserState)o;
        return Objects.equals(this.mIdentifier, that.mIdentifier) && Objects.equals(this.mPackageName, that.mPackageName) && Objects.equals(this.mUser, that.mUser) && this.mLinkHandlingAllowed == that.mLinkHandlingAllowed && Objects.equals(this.mHostToStateMap, that.mHostToStateMap);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mIdentifier);
        _hash = 31 * _hash + Objects.hashCode(this.mPackageName);
        _hash = 31 * _hash + Objects.hashCode(this.mUser);
        _hash = 31 * _hash + Boolean.hashCode(this.mLinkHandlingAllowed);
        _hash = 31 * _hash + Objects.hashCode(this.mHostToStateMap);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mLinkHandlingAllowed) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        sParcellingForIdentifier.parcel(this.mIdentifier, dest, flags);
        dest.writeString(this.mPackageName);
        dest.writeTypedObject(this.mUser, flags);
        this.parcelHostToStateMap(dest, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    DomainVerificationUserState(@NonNull Parcel in) {
        byte flg = in.readByte();
        boolean linkHandlingAllowed = (flg & 8) != 0;
        UUID identifier = sParcellingForIdentifier.unparcel(in);
        String packageName = in.readString();
        UserHandle user = in.readTypedObject(UserHandle.CREATOR);
        Map<String, Integer> hostToStateMap = this.unparcelHostToStateMap(in);
        this.mIdentifier = identifier;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mIdentifier);
        this.mPackageName = packageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
        this.mUser = user;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mUser);
        this.mLinkHandlingAllowed = linkHandlingAllowed;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mLinkHandlingAllowed);
        this.mHostToStateMap = hostToStateMap;
        AnnotationValidations.validate(NonNull.class, null, this.mHostToStateMap);
    }

    @Deprecated
    private void __metadata() {
    }

    static {
        if (sParcellingForIdentifier == null) {
            sParcellingForIdentifier = Parcelling.Cache.put(new Parcelling.BuiltIn.ForUUID());
        }
        CREATOR = new Parcelable.Creator<DomainVerificationUserState>(){

            public DomainVerificationUserState[] newArray(int size) {
                return new DomainVerificationUserState[size];
            }

            @Override
            public DomainVerificationUserState createFromParcel(@NonNull Parcel in) {
                return new DomainVerificationUserState(in);
            }
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DomainState {
    }
}

