/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.verify.domain;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.content.pm.verify.domain.DomainVerificationUserState;
import android.content.pm.verify.domain.DomainVerificationUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Parcelling;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@SystemApi
public class DomainVerificationInfo
implements Parcelable {
    public static final int STATE_NO_RESPONSE = 0;
    public static final int STATE_SUCCESS = 1;
    public static final int STATE_UNMODIFIABLE = 2;
    public static final int STATE_MODIFIABLE_UNVERIFIED = 3;
    public static final int STATE_MODIFIABLE_VERIFIED = 4;
    public static final int STATE_FIRST_VERIFIER_DEFINED = 1024;
    @NonNull
    private final UUID mIdentifier;
    @NonNull
    private final String mPackageName;
    @NonNull
    private final Map<String, Integer> mHostToStateMap;
    static Parcelling<UUID> sParcellingForIdentifier = Parcelling.Cache.get(Parcelling.BuiltIn.ForUUID.class);
    @NonNull
    public static final Parcelable.Creator<DomainVerificationInfo> CREATOR;

    private void parcelHostToStateMap(Parcel dest, int flags) {
        DomainVerificationUtils.writeHostMap(dest, this.mHostToStateMap);
    }

    private Map<String, Integer> unparcelHostToStateMap(Parcel in) {
        return DomainVerificationUtils.readHostMap(in, new ArrayMap(), DomainVerificationUserState.class.getClassLoader());
    }

    public static String stateToString(int value) {
        switch (value) {
            case 0: {
                return "STATE_NO_RESPONSE";
            }
            case 1: {
                return "STATE_SUCCESS";
            }
            case 2: {
                return "STATE_UNMODIFIABLE";
            }
            case 3: {
                return "STATE_MODIFIABLE_UNVERIFIED";
            }
            case 4: {
                return "STATE_MODIFIABLE_VERIFIED";
            }
            case 1024: {
                return "STATE_FIRST_VERIFIER_DEFINED";
            }
        }
        return Integer.toHexString(value);
    }

    public DomainVerificationInfo(@NonNull UUID identifier, @NonNull String packageName, @NonNull Map<String, Integer> hostToStateMap) {
        this.mIdentifier = identifier;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mIdentifier);
        this.mPackageName = packageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
        this.mHostToStateMap = hostToStateMap;
        AnnotationValidations.validate(NonNull.class, null, this.mHostToStateMap);
    }

    @NonNull
    public UUID getIdentifier() {
        return this.mIdentifier;
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public Map<String, Integer> getHostToStateMap() {
        return this.mHostToStateMap;
    }

    public String toString() {
        return "DomainVerificationInfo { identifier = " + this.mIdentifier + ", packageName = " + this.mPackageName + ", hostToStateMap = " + this.mHostToStateMap + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainVerificationInfo that = (DomainVerificationInfo)o;
        return Objects.equals(this.mIdentifier, that.mIdentifier) && Objects.equals(this.mPackageName, that.mPackageName) && Objects.equals(this.mHostToStateMap, that.mHostToStateMap);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mIdentifier);
        _hash = 31 * _hash + Objects.hashCode(this.mPackageName);
        _hash = 31 * _hash + Objects.hashCode(this.mHostToStateMap);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        sParcellingForIdentifier.parcel(this.mIdentifier, dest, flags);
        dest.writeString(this.mPackageName);
        this.parcelHostToStateMap(dest, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    DomainVerificationInfo(@NonNull Parcel in) {
        UUID identifier = sParcellingForIdentifier.unparcel(in);
        String packageName = in.readString();
        Map<String, Integer> hostToStateMap = this.unparcelHostToStateMap(in);
        this.mIdentifier = identifier;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mIdentifier);
        this.mPackageName = packageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
        this.mHostToStateMap = hostToStateMap;
        AnnotationValidations.validate(NonNull.class, null, this.mHostToStateMap);
    }

    @Deprecated
    private void __metadata() {
    }

    static {
        if (sParcellingForIdentifier == null) {
            sParcellingForIdentifier = Parcelling.Cache.put(new Parcelling.BuiltIn.ForUUID());
        }
        CREATOR = new Parcelable.Creator<DomainVerificationInfo>(){

            public DomainVerificationInfo[] newArray(int size) {
                return new DomainVerificationInfo[size];
            }

            @Override
            public DomainVerificationInfo createFromParcel(@NonNull Parcel in) {
                return new DomainVerificationInfo(in);
            }
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

