/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.Signature;
import android.content.pm.SigningDetails;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.PublicKey;
import java.util.Collection;

public class SigningInfo
implements Parcelable {
    @FlaggedApi(value="android.content.pm.cloud_compilation_pm")
    public static final int VERSION_JAR = 1;
    @FlaggedApi(value="android.content.pm.cloud_compilation_pm")
    public static final int VERSION_SIGNING_BLOCK_V2 = 2;
    @FlaggedApi(value="android.content.pm.cloud_compilation_pm")
    public static final int VERSION_SIGNING_BLOCK_V3 = 3;
    @FlaggedApi(value="android.content.pm.cloud_compilation_pm")
    public static final int VERSION_SIGNING_BLOCK_V4 = 4;
    @NonNull
    private final SigningDetails mSigningDetails;
    @NonNull
    public static final Parcelable.Creator<SigningInfo> CREATOR = new Parcelable.Creator<SigningInfo>(){

        @Override
        public SigningInfo createFromParcel(Parcel source) {
            return new SigningInfo(source);
        }

        public SigningInfo[] newArray(int size) {
            return new SigningInfo[size];
        }
    };

    public SigningInfo() {
        this.mSigningDetails = SigningDetails.UNKNOWN;
    }

    @FlaggedApi(value="android.content.pm.archiving")
    public SigningInfo(int schemeVersion, @Nullable Collection<Signature> apkContentsSigners, @Nullable Collection<PublicKey> publicKeys, @Nullable Collection<Signature> signingCertificateHistory) {
        Signature[] pastSignatures;
        if (schemeVersion <= 0 || apkContentsSigners == null) {
            this.mSigningDetails = SigningDetails.UNKNOWN;
            return;
        }
        Signature[] signatures = apkContentsSigners != null && !apkContentsSigners.isEmpty() ? apkContentsSigners.toArray(new Signature[apkContentsSigners.size()]) : null;
        Signature[] signatureArray = pastSignatures = signingCertificateHistory != null && !signingCertificateHistory.isEmpty() ? signingCertificateHistory.toArray(new Signature[signingCertificateHistory.size()]) : null;
        if (Signature.areExactArraysMatch(signatures, pastSignatures)) {
            pastSignatures = null;
        }
        ArraySet<PublicKey> keys = publicKeys != null && !publicKeys.isEmpty() ? new ArraySet<PublicKey>(publicKeys) : null;
        this.mSigningDetails = new SigningDetails(signatures, schemeVersion, keys, pastSignatures);
    }

    public SigningInfo(SigningDetails signingDetails) {
        this.mSigningDetails = new SigningDetails(signingDetails);
    }

    public SigningInfo(SigningInfo orig) {
        this.mSigningDetails = new SigningDetails(orig.mSigningDetails);
    }

    private SigningInfo(Parcel source) {
        this.mSigningDetails = SigningDetails.CREATOR.createFromParcel(source);
    }

    public boolean hasMultipleSigners() {
        return this.mSigningDetails.getSignatures() != null && this.mSigningDetails.getSignatures().length > 1;
    }

    public boolean hasPastSigningCertificates() {
        return this.mSigningDetails.getPastSigningCertificates() != null && this.mSigningDetails.getPastSigningCertificates().length > 0;
    }

    public Signature[] getSigningCertificateHistory() {
        if (this.hasMultipleSigners()) {
            return null;
        }
        if (!this.hasPastSigningCertificates()) {
            return this.mSigningDetails.getSignatures();
        }
        return this.mSigningDetails.getPastSigningCertificates();
    }

    public Signature[] getApkContentsSigners() {
        return this.mSigningDetails.getSignatures();
    }

    @FlaggedApi(value="android.content.pm.archiving")
    public int getSchemeVersion() {
        return this.mSigningDetails.getSignatureSchemeVersion();
    }

    @FlaggedApi(value="android.content.pm.archiving")
    @NonNull
    public Collection<PublicKey> getPublicKeys() {
        return this.mSigningDetails.getPublicKeys();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        this.mSigningDetails.writeToParcel(dest, parcelableFlags);
    }

    @NonNull
    public SigningDetails getSigningDetails() {
        return this.mSigningDetails;
    }

    @FlaggedApi(value="android.content.pm.cloud_compilation_pm")
    public boolean signersMatchExactly(@NonNull SigningInfo other) {
        return this.mSigningDetails.signaturesMatchExactly(other.mSigningDetails);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AppSigningSchemeVersion {
    }
}

