/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class PermissionGroupInfo
extends PackageItemInfo
implements Parcelable {
    public int descriptionRes;
    @SystemApi
    public int requestRes;
    @SystemApi
    public final int requestDetailResourceId;
    @SystemApi
    public final int backgroundRequestResourceId;
    @SystemApi
    public final int backgroundRequestDetailResourceId;
    @Nullable
    public CharSequence nonLocalizedDescription;
    public static final int FLAG_PERSONAL_INFO = 1;
    public int flags;
    public int priority;
    @NonNull
    public static final Parcelable.Creator<PermissionGroupInfo> CREATOR = new Parcelable.Creator<PermissionGroupInfo>(){

        @Override
        public PermissionGroupInfo createFromParcel(Parcel source) {
            return new PermissionGroupInfo(source);
        }

        public PermissionGroupInfo[] newArray(int size) {
            return new PermissionGroupInfo[size];
        }
    };

    public PermissionGroupInfo(int requestDetailResourceId, int backgroundRequestResourceId, int backgroundRequestDetailResourceId) {
        this.requestDetailResourceId = requestDetailResourceId;
        this.backgroundRequestResourceId = backgroundRequestResourceId;
        this.backgroundRequestDetailResourceId = backgroundRequestDetailResourceId;
    }

    @Deprecated
    public PermissionGroupInfo() {
        this(0, 0, 0);
    }

    @Deprecated
    public PermissionGroupInfo(@NonNull PermissionGroupInfo orig) {
        super(orig);
        this.descriptionRes = orig.descriptionRes;
        this.requestRes = orig.requestRes;
        this.requestDetailResourceId = orig.requestDetailResourceId;
        this.backgroundRequestResourceId = orig.backgroundRequestResourceId;
        this.backgroundRequestDetailResourceId = orig.backgroundRequestDetailResourceId;
        this.nonLocalizedDescription = orig.nonLocalizedDescription;
        this.flags = orig.flags;
        this.priority = orig.priority;
    }

    @Nullable
    public CharSequence loadDescription(@NonNull PackageManager pm) {
        CharSequence label;
        if (this.nonLocalizedDescription != null) {
            return this.nonLocalizedDescription;
        }
        if (this.descriptionRes != 0 && (label = pm.getText(this.packageName, this.descriptionRes, null)) != null) {
            return label;
        }
        return null;
    }

    public String toString() {
        return "PermissionGroupInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.name + " flgs=0x" + Integer.toHexString(this.flags) + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        super.writeToParcel(dest, parcelableFlags);
        dest.writeInt(this.descriptionRes);
        dest.writeInt(this.requestRes);
        dest.writeInt(this.requestDetailResourceId);
        dest.writeInt(this.backgroundRequestResourceId);
        dest.writeInt(this.backgroundRequestDetailResourceId);
        TextUtils.writeToParcel(this.nonLocalizedDescription, dest, parcelableFlags);
        dest.writeInt(this.flags);
        dest.writeInt(this.priority);
    }

    private PermissionGroupInfo(Parcel source) {
        super(source);
        this.descriptionRes = source.readInt();
        this.requestRes = source.readInt();
        this.requestDetailResourceId = source.readInt();
        this.backgroundRequestResourceId = source.readInt();
        this.backgroundRequestDetailResourceId = source.readInt();
        this.nonLocalizedDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
        this.flags = source.readInt();
        this.priority = source.readInt();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

