/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.content.IntentSender;
import android.content.pm.Checksum;
import android.content.pm.DataLoaderParamsParcel;
import android.content.pm.IOnChecksumsReadyListener;
import android.content.pm.PackageInstaller;
import android.content.pm.verify.domain.DomainSet;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IPackageInstallerSession
extends IInterface {
    public void setClientProgress(float var1) throws RemoteException;

    public void addClientProgress(float var1) throws RemoteException;

    public String[] getNames() throws RemoteException;

    public ParcelFileDescriptor openWrite(String var1, long var2, long var4) throws RemoteException;

    public ParcelFileDescriptor openRead(String var1) throws RemoteException;

    public void write(String var1, long var2, long var4, ParcelFileDescriptor var6) throws RemoteException;

    public void stageViaHardLink(String var1) throws RemoteException;

    public void setChecksums(String var1, Checksum[] var2, byte[] var3) throws RemoteException;

    public void requestChecksums(String var1, int var2, int var3, List var4, IOnChecksumsReadyListener var5) throws RemoteException;

    public void removeSplit(String var1) throws RemoteException;

    public void close() throws RemoteException;

    public void commit(IntentSender var1, boolean var2) throws RemoteException;

    public void transfer(String var1) throws RemoteException;

    public void abandon() throws RemoteException;

    public void seal() throws RemoteException;

    public List<String> fetchPackageNames() throws RemoteException;

    @EnforcePermission(value="com.android.permission.USE_INSTALLER_V2")
    public DataLoaderParamsParcel getDataLoaderParams() throws RemoteException;

    @EnforcePermission(value="com.android.permission.USE_INSTALLER_V2")
    public void addFile(int var1, String var2, long var3, byte[] var5, byte[] var6) throws RemoteException;

    @EnforcePermission(value="com.android.permission.USE_INSTALLER_V2")
    public void removeFile(int var1, String var2) throws RemoteException;

    public boolean isMultiPackage() throws RemoteException;

    public int[] getChildSessionIds() throws RemoteException;

    public void addChildSessionId(int var1) throws RemoteException;

    public void removeChildSessionId(int var1) throws RemoteException;

    public int getParentSessionId() throws RemoteException;

    public boolean isStaged() throws RemoteException;

    public int getInstallFlags() throws RemoteException;

    public void requestUserPreapproval(PackageInstaller.PreapprovalDetails var1, IntentSender var2) throws RemoteException;

    public boolean isApplicationEnabledSettingPersistent() throws RemoteException;

    public boolean isRequestUpdateOwnership() throws RemoteException;

    public ParcelFileDescriptor getAppMetadataFd() throws RemoteException;

    public ParcelFileDescriptor openWriteAppMetadata() throws RemoteException;

    public void removeAppMetadata() throws RemoteException;

    public void setPreVerifiedDomains(DomainSet var1) throws RemoteException;

    public DomainSet getPreVerifiedDomains() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPackageInstallerSession {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.content.pm.IPackageInstallerSession";
        static final int TRANSACTION_setClientProgress = 1;
        static final int TRANSACTION_addClientProgress = 2;
        static final int TRANSACTION_getNames = 3;
        static final int TRANSACTION_openWrite = 4;
        static final int TRANSACTION_openRead = 5;
        static final int TRANSACTION_write = 6;
        static final int TRANSACTION_stageViaHardLink = 7;
        static final int TRANSACTION_setChecksums = 8;
        static final int TRANSACTION_requestChecksums = 9;
        static final int TRANSACTION_removeSplit = 10;
        static final int TRANSACTION_close = 11;
        static final int TRANSACTION_commit = 12;
        static final int TRANSACTION_transfer = 13;
        static final int TRANSACTION_abandon = 14;
        static final int TRANSACTION_seal = 15;
        static final int TRANSACTION_fetchPackageNames = 16;
        static final int TRANSACTION_getDataLoaderParams = 17;
        static final int TRANSACTION_addFile = 18;
        static final int TRANSACTION_removeFile = 19;
        static final int TRANSACTION_isMultiPackage = 20;
        static final int TRANSACTION_getChildSessionIds = 21;
        static final int TRANSACTION_addChildSessionId = 22;
        static final int TRANSACTION_removeChildSessionId = 23;
        static final int TRANSACTION_getParentSessionId = 24;
        static final int TRANSACTION_isStaged = 25;
        static final int TRANSACTION_getInstallFlags = 26;
        static final int TRANSACTION_requestUserPreapproval = 27;
        static final int TRANSACTION_isApplicationEnabledSettingPersistent = 28;
        static final int TRANSACTION_isRequestUpdateOwnership = 29;
        static final int TRANSACTION_getAppMetadataFd = 30;
        static final int TRANSACTION_openWriteAppMetadata = 31;
        static final int TRANSACTION_removeAppMetadata = 32;
        static final int TRANSACTION_setPreVerifiedDomains = 33;
        static final int TRANSACTION_getPreVerifiedDomains = 34;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IPackageInstallerSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPackageInstallerSession) {
                return (IPackageInstallerSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setClientProgress";
                }
                case 2: {
                    return "addClientProgress";
                }
                case 3: {
                    return "getNames";
                }
                case 4: {
                    return "openWrite";
                }
                case 5: {
                    return "openRead";
                }
                case 6: {
                    return "write";
                }
                case 7: {
                    return "stageViaHardLink";
                }
                case 8: {
                    return "setChecksums";
                }
                case 9: {
                    return "requestChecksums";
                }
                case 10: {
                    return "removeSplit";
                }
                case 11: {
                    return "close";
                }
                case 12: {
                    return "commit";
                }
                case 13: {
                    return "transfer";
                }
                case 14: {
                    return "abandon";
                }
                case 15: {
                    return "seal";
                }
                case 16: {
                    return "fetchPackageNames";
                }
                case 17: {
                    return "getDataLoaderParams";
                }
                case 18: {
                    return "addFile";
                }
                case 19: {
                    return "removeFile";
                }
                case 20: {
                    return "isMultiPackage";
                }
                case 21: {
                    return "getChildSessionIds";
                }
                case 22: {
                    return "addChildSessionId";
                }
                case 23: {
                    return "removeChildSessionId";
                }
                case 24: {
                    return "getParentSessionId";
                }
                case 25: {
                    return "isStaged";
                }
                case 26: {
                    return "getInstallFlags";
                }
                case 27: {
                    return "requestUserPreapproval";
                }
                case 28: {
                    return "isApplicationEnabledSettingPersistent";
                }
                case 29: {
                    return "isRequestUpdateOwnership";
                }
                case 30: {
                    return "getAppMetadataFd";
                }
                case 31: {
                    return "openWriteAppMetadata";
                }
                case 32: {
                    return "removeAppMetadata";
                }
                case 33: {
                    return "setPreVerifiedDomains";
                }
                case 34: {
                    return "getPreVerifiedDomains";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setClientProgress(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.addClientProgress(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String[] _result = this.getNames();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.openWrite(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.openRead(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    ParcelFileDescriptor _arg3 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.write(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.stageViaHardLink(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    Checksum[] _arg1 = data.createTypedArray(Checksum.CREATOR);
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.setChecksums(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ClassLoader cl = this.getClass().getClassLoader();
                    ArrayList _arg3 = data.readArrayList(cl);
                    IOnChecksumsReadyListener _arg4 = IOnChecksumsReadyListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestChecksums(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeSplit(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    this.close();
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IntentSender _arg0 = data.readTypedObject(IntentSender.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.commit(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.transfer(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    this.abandon();
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    this.seal();
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    List<String> _result = this.fetchPackageNames();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 17: {
                    DataLoaderParamsParcel _result = this.getDataLoaderParams();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    byte[] _arg3 = data.createByteArray();
                    byte[] _arg4 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.addFile(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeFile(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    boolean _result = this.isMultiPackage();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 21: {
                    int[] _result = this.getChildSessionIds();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addChildSessionId(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeChildSessionId(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    int _result = this.getParentSessionId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 25: {
                    boolean _result = this.isStaged();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 26: {
                    int _result = this.getInstallFlags();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 27: {
                    PackageInstaller.PreapprovalDetails _arg0 = data.readTypedObject(PackageInstaller.PreapprovalDetails.CREATOR);
                    IntentSender _arg1 = data.readTypedObject(IntentSender.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestUserPreapproval(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    boolean _result = this.isApplicationEnabledSettingPersistent();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 29: {
                    boolean _result = this.isRequestUpdateOwnership();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 30: {
                    ParcelFileDescriptor _result = this.getAppMetadataFd();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 31: {
                    ParcelFileDescriptor _result = this.openWriteAppMetadata();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 32: {
                    this.removeAppMetadata();
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    DomainSet _arg0 = data.readTypedObject(DomainSet.CREATOR);
                    data.enforceNoDataAvail();
                    this.setPreVerifiedDomains(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    DomainSet _result = this.getPreVerifiedDomains();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void getDataLoaderParams_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("com.android.permission.USE_INSTALLER_V2", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addFile_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("com.android.permission.USE_INSTALLER_V2", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeFile_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("com.android.permission.USE_INSTALLER_V2", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 33;
        }

        private static class Proxy
        implements IPackageInstallerSession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setClientProgress(float progress) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(progress);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addClientProgress(float progress) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(progress);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getNames() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor openWrite(String name, long offsetBytes, long lengthBytes) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeLong(offsetBytes);
                    _data.writeLong(lengthBytes);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor openRead(String name) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(String name, long offsetBytes, long lengthBytes, ParcelFileDescriptor fd) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeLong(offsetBytes);
                    _data.writeLong(lengthBytes);
                    _data.writeTypedObject(fd, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stageViaHardLink(String target) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(target);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setChecksums(String name, Checksum[] checksums, byte[] signature) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeTypedArray(checksums, 0);
                    _data.writeByteArray(signature);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestChecksums(String name, int optional, int required, List trustedInstallers, IOnChecksumsReadyListener onChecksumsReadyListener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeInt(optional);
                    _data.writeInt(required);
                    _data.writeList(trustedInstallers);
                    _data.writeStrongInterface(onChecksumsReadyListener);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSplit(String splitName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(splitName);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commit(IntentSender statusReceiver, boolean forTransferred) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(statusReceiver, 0);
                    _data.writeBoolean(forTransferred);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void transfer(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abandon() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void seal() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> fetchPackageNames() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DataLoaderParamsParcel getDataLoaderParams() throws RemoteException {
                DataLoaderParamsParcel _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DataLoaderParamsParcel.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addFile(int location, String name, long lengthBytes, byte[] metadata, byte[] signature) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(location);
                    _data.writeString(name);
                    _data.writeLong(lengthBytes);
                    _data.writeByteArray(metadata);
                    _data.writeByteArray(signature);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeFile(int location, String name) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(location);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMultiPackage() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getChildSessionIds() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addChildSessionId(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeChildSessionId(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getParentSessionId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isStaged() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInstallFlags() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestUserPreapproval(PackageInstaller.PreapprovalDetails details, IntentSender statusReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(details, 0);
                    _data.writeTypedObject(statusReceiver, 0);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isApplicationEnabledSettingPersistent() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRequestUpdateOwnership() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor getAppMetadataFd() throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor openWriteAppMetadata() throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAppMetadata() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPreVerifiedDomains(DomainSet preVerifiedDomains) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(preVerifiedDomains, 0);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DomainSet getPreVerifiedDomains() throws RemoteException {
                DomainSet _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DomainSet.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IPackageInstallerSession {
        @Override
        public void setClientProgress(float progress) throws RemoteException {
        }

        @Override
        public void addClientProgress(float progress) throws RemoteException {
        }

        @Override
        public String[] getNames() throws RemoteException {
            return null;
        }

        @Override
        public ParcelFileDescriptor openWrite(String name, long offsetBytes, long lengthBytes) throws RemoteException {
            return null;
        }

        @Override
        public ParcelFileDescriptor openRead(String name) throws RemoteException {
            return null;
        }

        @Override
        public void write(String name, long offsetBytes, long lengthBytes, ParcelFileDescriptor fd) throws RemoteException {
        }

        @Override
        public void stageViaHardLink(String target) throws RemoteException {
        }

        @Override
        public void setChecksums(String name, Checksum[] checksums, byte[] signature) throws RemoteException {
        }

        @Override
        public void requestChecksums(String name, int optional, int required, List trustedInstallers, IOnChecksumsReadyListener onChecksumsReadyListener) throws RemoteException {
        }

        @Override
        public void removeSplit(String splitName) throws RemoteException {
        }

        @Override
        public void close() throws RemoteException {
        }

        @Override
        public void commit(IntentSender statusReceiver, boolean forTransferred) throws RemoteException {
        }

        @Override
        public void transfer(String packageName) throws RemoteException {
        }

        @Override
        public void abandon() throws RemoteException {
        }

        @Override
        public void seal() throws RemoteException {
        }

        @Override
        public List<String> fetchPackageNames() throws RemoteException {
            return null;
        }

        @Override
        public DataLoaderParamsParcel getDataLoaderParams() throws RemoteException {
            return null;
        }

        @Override
        public void addFile(int location, String name, long lengthBytes, byte[] metadata, byte[] signature) throws RemoteException {
        }

        @Override
        public void removeFile(int location, String name) throws RemoteException {
        }

        @Override
        public boolean isMultiPackage() throws RemoteException {
            return false;
        }

        @Override
        public int[] getChildSessionIds() throws RemoteException {
            return null;
        }

        @Override
        public void addChildSessionId(int sessionId) throws RemoteException {
        }

        @Override
        public void removeChildSessionId(int sessionId) throws RemoteException {
        }

        @Override
        public int getParentSessionId() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isStaged() throws RemoteException {
            return false;
        }

        @Override
        public int getInstallFlags() throws RemoteException {
            return 0;
        }

        @Override
        public void requestUserPreapproval(PackageInstaller.PreapprovalDetails details, IntentSender statusReceiver) throws RemoteException {
        }

        @Override
        public boolean isApplicationEnabledSettingPersistent() throws RemoteException {
            return false;
        }

        @Override
        public boolean isRequestUpdateOwnership() throws RemoteException {
            return false;
        }

        @Override
        public ParcelFileDescriptor getAppMetadataFd() throws RemoteException {
            return null;
        }

        @Override
        public ParcelFileDescriptor openWriteAppMetadata() throws RemoteException {
            return null;
        }

        @Override
        public void removeAppMetadata() throws RemoteException {
        }

        @Override
        public void setPreVerifiedDomains(DomainSet preVerifiedDomains) throws RemoteException {
        }

        @Override
        public DomainSet getPreVerifiedDomains() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

