/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.app.ActivityOptions;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ICrossProfileApps;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import com.android.internal.util.UserIcons;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CrossProfileApps {
    public static final String ACTION_CAN_INTERACT_ACROSS_PROFILES_CHANGED = "android.content.pm.action.CAN_INTERACT_ACROSS_PROFILES_CHANGED";
    private final Context mContext;
    private final ICrossProfileApps mService;
    private final UserManager mUserManager;
    private final Resources mResources;

    public CrossProfileApps(Context context, ICrossProfileApps service) {
        this.mContext = context;
        this.mService = service;
        this.mUserManager = context.getSystemService(UserManager.class);
        this.mResources = context.getResources();
    }

    public void startMainActivity(@NonNull ComponentName component, @NonNull UserHandle targetUser) {
        try {
            this.mService.startActivityAsUser(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), component, targetUser.getIdentifier(), true, this.mContext.getActivityToken(), ActivityOptions.makeBasic().toBundle());
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void startMainActivity(@NonNull ComponentName component, @NonNull UserHandle targetUser, @Nullable Activity callingActivity, @Nullable Bundle options) {
        try {
            this.mService.startActivityAsUser(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), component, targetUser.getIdentifier(), true, callingActivity != null ? callingActivity.getActivityToken() : null, options);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_PROFILES", "android.permission.INTERACT_ACROSS_USERS"})
    public void startActivity(@NonNull Intent intent, @NonNull UserHandle targetUser, @Nullable Activity callingActivity) {
        this.startActivity(intent, targetUser, callingActivity, null);
    }

    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_PROFILES", "android.permission.INTERACT_ACROSS_USERS"})
    public void startActivity(@NonNull Intent intent, @NonNull UserHandle targetUser, @Nullable Activity callingActivity, @Nullable Bundle options) {
        try {
            this.mService.startActivityAsUserByIntent(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), intent, targetUser.getIdentifier(), callingActivity != null ? callingActivity.getActivityToken() : null, options);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_PROFILES", "android.permission.START_CROSS_PROFILE_ACTIVITIES"})
    public void startActivity(@NonNull ComponentName component, @NonNull UserHandle targetUser, @Nullable Activity callingActivity, @Nullable Bundle options) {
        try {
            this.mService.startActivityAsUser(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), component, targetUser.getIdentifier(), false, callingActivity != null ? callingActivity.getActivityToken() : null, options);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_PROFILES", "android.permission.START_CROSS_PROFILE_ACTIVITIES"})
    public void startActivity(@NonNull ComponentName component, @NonNull UserHandle targetUser) {
        try {
            this.mService.startActivityAsUser(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), component, targetUser.getIdentifier(), false, null, null);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<UserHandle> getTargetUserProfiles() {
        try {
            return this.mService.getTargetUserProfiles(this.mContext.getPackageName());
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.app.admin.flags.allow_querying_profile_type")
    public boolean isProfile(@NonNull UserHandle userHandle) {
        this.verifyCanAccessUser(userHandle);
        return this.mUserManager.isProfile(userHandle.getIdentifier());
    }

    @FlaggedApi(value="android.app.admin.flags.allow_querying_profile_type")
    public boolean isManagedProfile(@NonNull UserHandle userHandle) {
        this.verifyCanAccessUser(userHandle);
        return this.mUserManager.isManagedProfile(userHandle.getIdentifier());
    }

    @NonNull
    public CharSequence getProfileSwitchingLabel(@NonNull UserHandle userHandle) {
        this.verifyCanAccessUser(userHandle);
        boolean isManagedProfile = this.mUserManager.isManagedProfile(userHandle.getIdentifier());
        DevicePolicyManager dpm = this.mContext.getSystemService(DevicePolicyManager.class);
        String callingAppLabel = this.getCallingApplicationLabel().toString();
        return dpm.getResources().getString(this.getUpdatableProfileSwitchingLabelId(isManagedProfile), () -> this.getDefaultProfileSwitchingLabel(isManagedProfile, callingAppLabel), callingAppLabel);
    }

    private CharSequence getCallingApplicationLabel() {
        PackageManager pm = this.mContext.getPackageManager();
        Intent launchIntent = pm.getLaunchIntentForPackage(this.mContext.getPackageName());
        if (launchIntent == null) {
            return this.getDefaultCallingApplicationLabel();
        }
        List<ResolveInfo> infos = pm.queryIntentActivities(launchIntent, PackageManager.ResolveInfoFlags.of(65536L));
        if (infos.size() > 0) {
            return infos.get(0).loadLabel(pm);
        }
        return this.getDefaultCallingApplicationLabel();
    }

    private CharSequence getDefaultCallingApplicationLabel() {
        return this.mContext.getApplicationInfo().loadSafeLabel(this.mContext.getPackageManager(), 0.0f, 3);
    }

    private String getUpdatableProfileSwitchingLabelId(boolean isManagedProfile) {
        return isManagedProfile ? "Core.SWITCH_TO_WORK_LABEL" : "Core.SWITCH_TO_PERSONAL_LABEL";
    }

    private String getDefaultProfileSwitchingLabel(boolean isManagedProfile, String label) {
        int stringRes = isManagedProfile ? 17040858 : 17042063;
        return this.mResources.getString(stringRes, label);
    }

    @NonNull
    public Drawable getProfileSwitchingIconDrawable(@NonNull UserHandle userHandle) {
        this.verifyCanAccessUser(userHandle);
        boolean isManagedProfile = this.mUserManager.isManagedProfile(userHandle.getIdentifier());
        if (isManagedProfile) {
            return this.mContext.getPackageManager().getUserBadgeForDensityNoBackground(userHandle, 0);
        }
        Drawable personalProfileIcon = UserIcons.getDefaultUserIcon(this.mResources, 0, true);
        int colorId = this.mContext.getResources().getConfiguration().isNightModeActive() ? 17171256 : 17171255;
        personalProfileIcon.setColorFilter(null);
        personalProfileIcon.setTint(this.mResources.getColor(colorId, null));
        return personalProfileIcon;
    }

    public boolean canRequestInteractAcrossProfiles() {
        try {
            return this.mService.canRequestInteractAcrossProfiles(this.mContext.getPackageName());
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public boolean canInteractAcrossProfiles() {
        try {
            return this.mService.canInteractAcrossProfiles(this.mContext.getPackageName());
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @NonNull
    public Intent createRequestInteractAcrossProfilesIntent() {
        if (!this.canRequestInteractAcrossProfiles()) {
            throw new SecurityException("The calling package can not request to interact across profiles.");
        }
        Intent settingsIntent = new Intent();
        settingsIntent.setAction("android.settings.MANAGE_CROSS_PROFILE_ACCESS");
        Uri packageUri = Uri.parse("package:" + this.mContext.getPackageName());
        settingsIntent.setData(packageUri);
        return settingsIntent;
    }

    @RequiresPermission(allOf={"android.permission.CONFIGURE_INTERACT_ACROSS_PROFILES", "android.permission.INTERACT_ACROSS_USERS"})
    public void setInteractAcrossProfilesAppOp(@NonNull String packageName, int newMode) {
        try {
            this.mService.setInteractAcrossProfilesAppOp(this.mContext.getUserId(), packageName, newMode);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public boolean canConfigureInteractAcrossProfiles(@NonNull String packageName) {
        try {
            return this.mService.canConfigureInteractAcrossProfiles(this.mContext.getUserId(), packageName);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public boolean canUserAttemptToConfigureInteractAcrossProfiles(String packageName) {
        try {
            return this.mService.canUserAttemptToConfigureInteractAcrossProfiles(this.mContext.getUserId(), packageName);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.CONFIGURE_INTERACT_ACROSS_PROFILES", "android.permission.INTERACT_ACROSS_USERS"})
    public void resetInteractAcrossProfilesAppOps(@NonNull Collection<String> previousCrossProfilePackages, @NonNull Set<String> newCrossProfilePackages) {
        if (previousCrossProfilePackages.isEmpty()) {
            return;
        }
        List<String> unsetCrossProfilePackages = previousCrossProfilePackages.stream().filter(packageName -> !newCrossProfilePackages.contains(packageName)).collect(Collectors.toList());
        if (unsetCrossProfilePackages.isEmpty()) {
            return;
        }
        try {
            this.mService.resetInteractAcrossProfilesAppOps(this.mContext.getUserId(), unsetCrossProfilePackages);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.CONFIGURE_INTERACT_ACROSS_PROFILES", "android.permission.INTERACT_ACROSS_USERS"})
    public void clearInteractAcrossProfilesAppOps() {
        try {
            this.mService.clearInteractAcrossProfilesAppOps(this.mContext.getUserId());
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private void verifyCanAccessUser(UserHandle userHandle) {
        if (!this.getTargetUserProfiles().contains(userHandle)) {
            throw new SecurityException("Not allowed to access " + userHandle);
        }
    }
}

