/*
 * Decompiled with CFR 0.152.
 */
package android.content.om;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.compat.Compatibility;
import android.content.Context;
import android.content.om.IOverlayManager;
import android.content.om.OverlayConstraint;
import android.content.om.OverlayIdentifier;
import android.content.om.OverlayInfo;
import android.content.om.OverlayManagerTransaction;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import com.android.internal.content.om.OverlayManagerImpl;
import java.io.IOException;
import java.util.List;

public class OverlayManager {
    private final IOverlayManager mService;
    private final OverlayManagerImpl mOverlayManagerImpl;
    private static final long THROW_SECURITY_EXCEPTIONS = 147340954L;
    public static final long SELF_TARGETING_OVERLAY = 205919743L;

    @SuppressLint(value={"ReferencesHidden"})
    public OverlayManager(@NonNull Context context, @Nullable IOverlayManager service) {
        this.mService = service;
        this.mOverlayManagerImpl = new OverlayManagerImpl(context);
    }

    @SuppressLint(value={"ReferencesHidden"})
    public OverlayManager(@NonNull Context context) {
        this(context, IOverlayManager.Stub.asInterface(ServiceManager.getService("overlay")));
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void setEnabledExclusiveInCategory(@NonNull String packageName, @NonNull UserHandle user) throws SecurityException, IllegalStateException {
        try {
            if (!this.mService.setEnabledExclusiveInCategory(packageName, user.getIdentifier())) {
                throw new IllegalStateException("setEnabledExclusiveInCategory failed");
            }
        }
        catch (SecurityException e) {
            this.rethrowSecurityException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void setEnabled(@NonNull String packageName, boolean enable, @NonNull UserHandle user) throws SecurityException, IllegalStateException {
        try {
            if (!this.mService.setEnabled(packageName, enable, user.getIdentifier())) {
                throw new IllegalStateException("setEnabled failed");
            }
        }
        catch (SecurityException e) {
            this.rethrowSecurityException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void enableWithConstraints(@NonNull String packageName, @NonNull UserHandle user, @Nullable List<OverlayConstraint> constraints) throws SecurityException, IllegalStateException {
        try {
            if (!this.mService.enableWithConstraints(packageName, user.getIdentifier(), constraints)) {
                throw new IllegalStateException("enableWithConstraints failed");
            }
        }
        catch (SecurityException e) {
            this.rethrowSecurityException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Nullable
    public OverlayInfo getOverlayInfo(@NonNull String packageName, @NonNull UserHandle userHandle) {
        try {
            return this.mService.getOverlayInfo(packageName, userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public OverlayInfo getOverlayInfo(@NonNull OverlayIdentifier overlay, @NonNull UserHandle userHandle) {
        try {
            return this.mService.getOverlayInfoByIdentifier(overlay, userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    @NonNull
    public List<OverlayInfo> getOverlayInfosForTarget(@NonNull String targetPackageName, @NonNull UserHandle user) {
        try {
            return this.mService.getOverlayInfosForTarget(targetPackageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS"})
    public void invalidateCachesForOverlay(@NonNull String targetPackageName, @NonNull UserHandle user) {
        try {
            this.mService.invalidateCachesForOverlay(targetPackageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void commitToSystemServer(@NonNull OverlayManagerTransaction transaction) {
        try {
            this.mService.commit(transaction);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void commit(@NonNull OverlayManagerTransaction transaction) {
        if (transaction.isSelfTargeting() || this.mService == null || this.mService.asBinder() == null) {
            try {
                this.commitSelfTarget(transaction);
            }
            catch (PackageManager.NameNotFoundException | IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        this.commitToSystemServer(transaction);
    }

    private void rethrowSecurityException(SecurityException e) {
        if (!Compatibility.isChangeEnabled(147340954L)) {
            throw new IllegalStateException(e);
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitSelfTarget(@NonNull OverlayManagerTransaction transaction) throws PackageManager.NameNotFoundException, IOException {
        OverlayManagerImpl overlayManagerImpl = this.mOverlayManagerImpl;
        synchronized (overlayManagerImpl) {
            this.mOverlayManagerImpl.commit(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<OverlayInfo> getOverlayInfosForTarget(@NonNull String targetPackageName) {
        OverlayManagerImpl overlayManagerImpl = this.mOverlayManagerImpl;
        synchronized (overlayManagerImpl) {
            return this.mOverlayManagerImpl.getOverlayInfosForTarget(targetPackageName);
        }
    }
}

