/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.ActivityThread;
import android.content.ComponentName;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import android.util.Log;
import android.view.contentcapture.ContentCaptureManager;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ContentCaptureOptions
implements Parcelable {
    private static final String TAG = ContentCaptureOptions.class.getSimpleName();
    public final int loggingLevel;
    public final int maxBufferSize;
    public final int idleFlushingFrequencyMs;
    public final int textChangeFlushingFrequencyMs;
    public final int logHistorySize;
    public final boolean disableFlushForViewTreeAppearing;
    public final boolean enableReceiver;
    @NonNull
    public final ContentProtectionOptions contentProtectionOptions;
    @Nullable
    @SuppressLint(value={"NullableCollection"})
    public final ArraySet<ComponentName> whitelistedComponents;
    public final boolean lite;
    @NonNull
    public static final Parcelable.Creator<ContentCaptureOptions> CREATOR = new Parcelable.Creator<ContentCaptureOptions>(){

        @Override
        public ContentCaptureOptions createFromParcel(Parcel parcel) {
            boolean lite = parcel.readBoolean();
            int loggingLevel = parcel.readInt();
            if (lite) {
                return new ContentCaptureOptions(loggingLevel);
            }
            int maxBufferSize = parcel.readInt();
            int idleFlushingFrequencyMs = parcel.readInt();
            int textChangeFlushingFrequencyMs = parcel.readInt();
            int logHistorySize = parcel.readInt();
            boolean disableFlushForViewTreeAppearing = parcel.readBoolean();
            boolean enableReceiver = parcel.readBoolean();
            ContentProtectionOptions contentProtectionOptions = ContentProtectionOptions.createFromParcel(parcel);
            ArraySet<? extends Object> whitelistedComponents = parcel.readArraySet(null);
            return new ContentCaptureOptions(loggingLevel, maxBufferSize, idleFlushingFrequencyMs, textChangeFlushingFrequencyMs, logHistorySize, disableFlushForViewTreeAppearing, enableReceiver, contentProtectionOptions, whitelistedComponents);
        }

        public ContentCaptureOptions[] newArray(int size) {
            return new ContentCaptureOptions[size];
        }
    };

    public ContentCaptureOptions(int loggingLevel) {
        this(true, loggingLevel, 0, 0, 0, 0, false, false, new ContentProtectionOptions(false, 0, Collections.emptyList(), Collections.emptyList(), 0), null);
    }

    public ContentCaptureOptions(int loggingLevel, int maxBufferSize, int idleFlushingFrequencyMs, int textChangeFlushingFrequencyMs, int logHistorySize, @SuppressLint(value={"ConcreteCollection", "NullableCollection"}) @Nullable ArraySet<ComponentName> whitelistedComponents) {
        this(false, loggingLevel, maxBufferSize, idleFlushingFrequencyMs, textChangeFlushingFrequencyMs, logHistorySize, false, true, new ContentProtectionOptions(), whitelistedComponents);
    }

    public ContentCaptureOptions(int loggingLevel, int maxBufferSize, int idleFlushingFrequencyMs, int textChangeFlushingFrequencyMs, int logHistorySize, boolean disableFlushForViewTreeAppearing, boolean enableReceiver, @NonNull ContentProtectionOptions contentProtectionOptions, @SuppressLint(value={"ConcreteCollection", "NullableCollection"}) @Nullable ArraySet<ComponentName> whitelistedComponents) {
        this(false, loggingLevel, maxBufferSize, idleFlushingFrequencyMs, textChangeFlushingFrequencyMs, logHistorySize, disableFlushForViewTreeAppearing, enableReceiver, contentProtectionOptions, whitelistedComponents);
    }

    @VisibleForTesting
    public ContentCaptureOptions(@Nullable ArraySet<ComponentName> whitelistedComponents) {
        this(2, 500, 5000, 1000, 10, false, true, new ContentProtectionOptions(), whitelistedComponents);
    }

    private ContentCaptureOptions(boolean lite, int loggingLevel, int maxBufferSize, int idleFlushingFrequencyMs, int textChangeFlushingFrequencyMs, int logHistorySize, boolean disableFlushForViewTreeAppearing, boolean enableReceiver, @NonNull ContentProtectionOptions contentProtectionOptions, @SuppressLint(value={"ConcreteCollection", "NullableCollection"}) @Nullable ArraySet<ComponentName> whitelistedComponents) {
        this.lite = lite;
        this.loggingLevel = loggingLevel;
        this.maxBufferSize = maxBufferSize;
        this.idleFlushingFrequencyMs = idleFlushingFrequencyMs;
        this.textChangeFlushingFrequencyMs = textChangeFlushingFrequencyMs;
        this.logHistorySize = logHistorySize;
        this.disableFlushForViewTreeAppearing = disableFlushForViewTreeAppearing;
        this.enableReceiver = enableReceiver;
        this.contentProtectionOptions = contentProtectionOptions;
        this.whitelistedComponents = whitelistedComponents;
    }

    public static ContentCaptureOptions forWhitelistingItself() {
        ActivityThread at = ActivityThread.currentActivityThread();
        if (at == null) {
            throw new IllegalStateException("No ActivityThread");
        }
        String packageName = at.getApplication().getPackageName();
        if (!"android.contentcaptureservice.cts".equals(packageName) && !"android.translation.cts".equals(packageName)) {
            Log.e(TAG, "forWhitelistingItself(): called by " + packageName);
            throw new SecurityException("Thou shall not pass!");
        }
        ContentCaptureOptions options = new ContentCaptureOptions(null);
        Log.i(TAG, "forWhitelistingItself(" + packageName + "): " + options);
        return options;
    }

    @VisibleForTesting
    public boolean isWhitelisted(@NonNull Context context) {
        if (this.whitelistedComponents == null) {
            return true;
        }
        ContentCaptureManager.ContentCaptureClient client = context.getContentCaptureClient();
        if (client == null) {
            Log.w(TAG, "isWhitelisted(): no ContentCaptureClient on " + context);
            return false;
        }
        return this.whitelistedComponents.contains(client.contentCaptureClientGetComponentName());
    }

    public String toString() {
        if (this.lite) {
            return "ContentCaptureOptions [loggingLevel=" + this.loggingLevel + " (lite)]";
        }
        StringBuilder string2 = new StringBuilder("ContentCaptureOptions [");
        string2.append("loggingLevel=").append(this.loggingLevel).append(", maxBufferSize=").append(this.maxBufferSize).append(", idleFlushingFrequencyMs=").append(this.idleFlushingFrequencyMs).append(", textChangeFlushingFrequencyMs=").append(this.textChangeFlushingFrequencyMs).append(", logHistorySize=").append(this.logHistorySize).append(", disableFlushForViewTreeAppearing=").append(this.disableFlushForViewTreeAppearing).append(", enableReceiver=").append(this.enableReceiver).append(", contentProtectionOptions=").append(this.contentProtectionOptions);
        if (this.whitelistedComponents != null) {
            string2.append(", whitelisted=").append(this.whitelistedComponents);
        }
        return string2.append(']').toString();
    }

    public void dumpShort(@NonNull PrintWriter pw) {
        pw.print("logLvl=");
        pw.print(this.loggingLevel);
        if (this.lite) {
            pw.print(", lite");
            return;
        }
        pw.print(", bufferSize=");
        pw.print(this.maxBufferSize);
        pw.print(", idle=");
        pw.print(this.idleFlushingFrequencyMs);
        pw.print(", textIdle=");
        pw.print(this.textChangeFlushingFrequencyMs);
        pw.print(", logSize=");
        pw.print(this.logHistorySize);
        pw.print(", disableFlushForViewTreeAppearing=");
        pw.print(this.disableFlushForViewTreeAppearing);
        pw.print(", enableReceiver=");
        pw.print(this.enableReceiver);
        pw.print(", contentProtectionOptions=[");
        this.contentProtectionOptions.dumpShort(pw);
        pw.print("]");
        if (this.whitelistedComponents != null) {
            pw.print(", whitelisted=");
            pw.print(this.whitelistedComponents);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeBoolean(this.lite);
        parcel.writeInt(this.loggingLevel);
        if (this.lite) {
            return;
        }
        parcel.writeInt(this.maxBufferSize);
        parcel.writeInt(this.idleFlushingFrequencyMs);
        parcel.writeInt(this.textChangeFlushingFrequencyMs);
        parcel.writeInt(this.logHistorySize);
        parcel.writeBoolean(this.disableFlushForViewTreeAppearing);
        parcel.writeBoolean(this.enableReceiver);
        this.contentProtectionOptions.writeToParcel(parcel);
        parcel.writeArraySet(this.whitelistedComponents);
    }

    public static class ContentProtectionOptions {
        public final boolean enableReceiver;
        public final int bufferSize;
        @NonNull
        public final List<List<String>> requiredGroups;
        @NonNull
        public final List<List<String>> optionalGroups;
        public final int optionalGroupsThreshold;

        public ContentProtectionOptions() {
            this(false, 150, ContentCaptureManager.DEFAULT_CONTENT_PROTECTION_REQUIRED_GROUPS, ContentCaptureManager.DEFAULT_CONTENT_PROTECTION_OPTIONAL_GROUPS, 0);
        }

        public ContentProtectionOptions(boolean enableReceiver, int bufferSize, @NonNull List<List<String>> requiredGroups, @NonNull List<List<String>> optionalGroups, int optionalGroupsThreshold) {
            this.enableReceiver = enableReceiver;
            this.bufferSize = bufferSize;
            this.requiredGroups = requiredGroups;
            this.optionalGroups = optionalGroups;
            this.optionalGroupsThreshold = optionalGroupsThreshold;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("ContentProtectionOptions [");
            stringBuilder.append("enableReceiver=").append(this.enableReceiver).append(", bufferSize=").append(this.bufferSize).append(", requiredGroupsSize=").append(this.requiredGroups.size()).append(", optionalGroupsSize=").append(this.optionalGroups.size()).append(", optionalGroupsThreshold=").append(this.optionalGroupsThreshold);
            return stringBuilder.append(']').toString();
        }

        private void dumpShort(@NonNull PrintWriter pw) {
            pw.print("enableReceiver=");
            pw.print(this.enableReceiver);
            pw.print(", bufferSize=");
            pw.print(this.bufferSize);
            pw.print(", requiredGroupsSize=");
            pw.print(this.requiredGroups.size());
            pw.print(", optionalGroupsSize=");
            pw.print(this.optionalGroups.size());
            pw.print(", optionalGroupsThreshold=");
            pw.print(this.optionalGroupsThreshold);
        }

        private void writeToParcel(@NonNull Parcel parcel) {
            parcel.writeBoolean(this.enableReceiver);
            parcel.writeInt(this.bufferSize);
            ContentProtectionOptions.writeGroupsToParcel(this.requiredGroups, parcel);
            ContentProtectionOptions.writeGroupsToParcel(this.optionalGroups, parcel);
            parcel.writeInt(this.optionalGroupsThreshold);
        }

        @NonNull
        private static ContentProtectionOptions createFromParcel(@NonNull Parcel parcel) {
            boolean enableReceiver = parcel.readBoolean();
            int bufferSize = parcel.readInt();
            List<List<String>> requiredGroups = ContentProtectionOptions.createGroupsFromParcel(parcel);
            List<List<String>> optionalGroups = ContentProtectionOptions.createGroupsFromParcel(parcel);
            int optionalGroupsThreshold = parcel.readInt();
            return new ContentProtectionOptions(enableReceiver, bufferSize, requiredGroups, optionalGroups, optionalGroupsThreshold);
        }

        private static void writeGroupsToParcel(@NonNull List<List<String>> groups, @NonNull Parcel parcel) {
            parcel.writeInt(groups.size());
            groups.forEach(parcel::writeStringList);
        }

        @NonNull
        private static List<List<String>> createGroupsFromParcel(@NonNull Parcel parcel) {
            int size = parcel.readInt();
            return IntStream.range(0, size).mapToObj(i -> new ArrayList()).peek(parcel::readStringList).collect(Collectors.toUnmodifiableList());
        }
    }
}

