/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.ClipDescription;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.ravenwood.annotation.RavenwoodKeep;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.ravenwood.annotation.RavenwoodThrow;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.URLSpan;
import android.util.proto.ProtoOutputStream;
import android.view.textclassifier.TextLinks;
import com.android.internal.util.ArrayUtils;
import java.util.ArrayList;
import java.util.List;

@RavenwoodKeepWholeClass
public class ClipData
implements Parcelable {
    private static final String TAG = "ClipData";
    static final String[] MIMETYPES_TEXT_PLAIN = new String[]{"text/plain"};
    static final String[] MIMETYPES_TEXT_HTML = new String[]{"text/html"};
    static final String[] MIMETYPES_TEXT_URILIST = new String[]{"text/uri-list"};
    static final String[] MIMETYPES_TEXT_INTENT = new String[]{"text/vnd.android.intent"};
    final ClipDescription mClipDescription;
    final Bitmap mIcon;
    final ArrayList<Item> mItems;
    private boolean mParcelItemActivityInfos;
    @NonNull
    public static final Parcelable.Creator<ClipData> CREATOR = new Parcelable.Creator<ClipData>(){

        @Override
        public ClipData createFromParcel(Parcel source) {
            return new ClipData(source);
        }

        public ClipData[] newArray(int size) {
            return new ClipData[size];
        }
    };

    public ClipData(CharSequence label, String[] mimeTypes, Item item) {
        this.mClipDescription = new ClipDescription(label, mimeTypes);
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        this.mIcon = null;
        this.mItems = new ArrayList();
        this.mItems.add(item);
        this.mClipDescription.setIsStyledText(this.isStyledText());
    }

    public ClipData(ClipDescription description, Item item) {
        this.mClipDescription = description;
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        this.mIcon = null;
        this.mItems = new ArrayList();
        this.mItems.add(item);
        this.mClipDescription.setIsStyledText(this.isStyledText());
    }

    public ClipData(ClipDescription description, ArrayList<Item> items) {
        this.mClipDescription = description;
        if (items == null) {
            throw new NullPointerException("item is null");
        }
        this.mIcon = null;
        this.mItems = items;
    }

    public ClipData(ClipData other) {
        this.mClipDescription = other.mClipDescription;
        this.mIcon = other.mIcon;
        this.mItems = new ArrayList<Item>(other.mItems);
    }

    public ClipData copyForTransferWithActivityInfo() {
        ClipData copy = new ClipData(this);
        copy.mParcelItemActivityInfos = true;
        return copy;
    }

    public boolean willParcelWithActivityInfo() {
        return this.mParcelItemActivityInfos;
    }

    public ClipData cloneOnlyUriItems() {
        ArrayList<Item> items = null;
        int N2 = this.mItems.size();
        for (int i = 0; i < N2; ++i) {
            Item item = this.mItems.get(i);
            if (item.getUri() != null) {
                if (items == null) {
                    items = new ArrayList<Item>(N2);
                }
                items.add(new Item(item.getUri()));
                continue;
            }
            if (item.getIntent() == null) continue;
            if (items == null) {
                items = new ArrayList(N2);
            }
            items.add(new Item(item.getIntent().cloneForCreatorToken()));
        }
        if (items == null || items.isEmpty()) {
            return null;
        }
        return new ClipData(new ClipDescription("", new String[0]), items);
    }

    public static ClipData newPlainText(CharSequence label, CharSequence text) {
        Item item = new Item(text);
        return new ClipData(label, MIMETYPES_TEXT_PLAIN, item);
    }

    public static ClipData newHtmlText(CharSequence label, CharSequence text, String htmlText) {
        Item item = new Item(text, htmlText);
        return new ClipData(label, MIMETYPES_TEXT_HTML, item);
    }

    public static ClipData newIntent(CharSequence label, Intent intent) {
        Item item = new Item(intent);
        return new ClipData(label, MIMETYPES_TEXT_INTENT, item);
    }

    public static ClipData newUri(ContentResolver resolver, CharSequence label, Uri uri) {
        Item item = new Item(uri);
        String[] mimeTypes = ClipData.getMimeTypes(resolver, uri);
        return new ClipData(label, mimeTypes, item);
    }

    private static String[] getMimeTypes(ContentResolver resolver, Uri uri) {
        String[] mimeTypes = null;
        if ("content".equals(uri.getScheme())) {
            String realType = resolver.getType(uri);
            mimeTypes = resolver.getStreamTypes(uri, "*/*");
            if (realType != null) {
                if (mimeTypes == null) {
                    mimeTypes = new String[]{realType};
                } else if (!ArrayUtils.contains(mimeTypes, realType)) {
                    String[] tmp = new String[mimeTypes.length + 1];
                    tmp[0] = realType;
                    System.arraycopy(mimeTypes, 0, tmp, 1, mimeTypes.length);
                    mimeTypes = tmp;
                }
            }
        }
        if (mimeTypes == null) {
            mimeTypes = MIMETYPES_TEXT_URILIST;
        }
        return mimeTypes;
    }

    public static ClipData newRawUri(CharSequence label, Uri uri) {
        Item item = new Item(uri);
        return new ClipData(label, MIMETYPES_TEXT_URILIST, item);
    }

    public ClipDescription getDescription() {
        return this.mClipDescription;
    }

    public void addItem(Item item) {
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        this.mItems.add(item);
        if (this.mItems.size() == 1) {
            this.mClipDescription.setIsStyledText(this.isStyledText());
        }
    }

    public void addItem(ContentResolver resolver, Item item) {
        this.addItem(item);
        if (item.getHtmlText() != null) {
            this.mClipDescription.addMimeTypes(MIMETYPES_TEXT_HTML);
        } else if (item.getText() != null) {
            this.mClipDescription.addMimeTypes(MIMETYPES_TEXT_PLAIN);
        }
        if (item.getIntent() != null) {
            this.mClipDescription.addMimeTypes(MIMETYPES_TEXT_INTENT);
        }
        if (item.getUri() != null) {
            this.mClipDescription.addMimeTypes(ClipData.getMimeTypes(resolver, item.getUri()));
        }
    }

    @UnsupportedAppUsage
    public Bitmap getIcon() {
        return this.mIcon;
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    public Item getItemAt(int index) {
        return this.mItems.get(index);
    }

    public void setItemAt(int index, Item item) {
        this.mItems.set(index, item);
    }

    @RavenwoodKeep
    public void prepareToLeaveProcess(boolean leavingPackage) {
        this.prepareToLeaveProcess(leavingPackage, 1);
    }

    @RavenwoodReplace
    public void prepareToLeaveProcess(boolean leavingPackage, int intentFlags) {
        int size = this.mItems.size();
        for (int i = 0; i < size; ++i) {
            Item item = this.mItems.get(i);
            if (item.mIntent != null) {
                item.mIntent.prepareToLeaveProcess(leavingPackage, false);
            }
            if (item.mUri == null || !leavingPackage) continue;
            if (StrictMode.vmFileUriExposureEnabled()) {
                item.mUri.checkFileUriExposed("ClipData.Item.getUri()");
            }
            if (!StrictMode.vmContentUriWithoutPermissionEnabled()) continue;
            item.mUri.checkContentUriWithoutPermission("ClipData.Item.getUri()", intentFlags);
        }
    }

    public void prepareToLeaveProcess$ravenwood(boolean leavingPackage, int intentFlags) {
    }

    @RavenwoodThrow
    public void prepareToEnterProcess(AttributionSource source) {
        int size = this.mItems.size();
        for (int i = 0; i < size; ++i) {
            Item item = this.mItems.get(i);
            if (item.mIntent == null) continue;
            item.mIntent.prepareToEnterProcess(false, source);
        }
    }

    @RavenwoodThrow
    public void fixUris(int contentUserHint) {
        int size = this.mItems.size();
        for (int i = 0; i < size; ++i) {
            Item item = this.mItems.get(i);
            if (item.mIntent != null) {
                item.mIntent.fixUris(contentUserHint);
            }
            if (item.mUri == null) continue;
            item.mUri = ContentProvider.maybeAddUserId(item.mUri, contentUserHint);
        }
    }

    @RavenwoodThrow
    public void fixUrisLight(int contentUserHint) {
        int size = this.mItems.size();
        for (int i = 0; i < size; ++i) {
            Uri data;
            Item item = this.mItems.get(i);
            if (item.mIntent != null && (data = item.mIntent.getData()) != null) {
                item.mIntent.setData(ContentProvider.maybeAddUserId(data, contentUserHint));
            }
            if (item.mUri == null) continue;
            item.mUri = ContentProvider.maybeAddUserId(item.mUri, contentUserHint);
        }
    }

    private boolean isStyledText() {
        Spanned spanned;
        if (this.mItems.isEmpty()) {
            return false;
        }
        CharSequence text = this.mItems.get(0).getText();
        return text instanceof Spanned && TextUtils.hasStyleSpan(spanned = (Spanned)text);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(128);
        b.append("ClipData { ");
        this.toShortString(b, true);
        b.append(" }");
        return b.toString();
    }

    public void toShortString(StringBuilder b, boolean redactContent) {
        boolean first = this.mClipDescription != null ? !this.mClipDescription.toShortString(b, redactContent) : true;
        if (this.mIcon != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("I:");
            b.append(this.mIcon.getWidth());
            b.append('x');
            b.append(this.mIcon.getHeight());
        }
        if (this.mItems.size() != 1) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append(this.mItems.size()).append(" items:");
        }
        for (int i = 0; i < this.mItems.size(); ++i) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append('{');
            this.mItems.get(i).toShortString(b, redactContent);
            b.append('}');
        }
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        if (this.mClipDescription != null) {
            this.mClipDescription.dumpDebug(proto, 0x10B00000001L);
        }
        if (this.mIcon != null) {
            long iToken = proto.start(1146756268034L);
            proto.write(0x10500000001L, this.mIcon.getWidth());
            proto.write(1120986464258L, this.mIcon.getHeight());
            proto.end(iToken);
        }
        for (int i = 0; i < this.mItems.size(); ++i) {
            this.mItems.get(i).dumpDebug(proto, 2246267895811L);
        }
        proto.end(token);
    }

    public void collectUris(List<Uri> out) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            Intent intent;
            Item item = this.getItemAt(i);
            if (item.getUri() != null) {
                out.add(item.getUri());
            }
            if ((intent = item.getIntent()) == null) continue;
            if (intent.getData() != null) {
                out.add(intent.getData());
            }
            if (intent.getClipData() == null) continue;
            intent.getClipData().collectUris(out);
        }
    }

    void setTokenVerificationEnabled() {
        for (int i = 0; i < this.mItems.size(); ++i) {
            this.mItems.get(i).setTokenVerificationEnabled();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mClipDescription.writeToParcel(dest, flags);
        if (this.mIcon != null) {
            dest.writeInt(1);
            this.mIcon.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        int N2 = this.mItems.size();
        dest.writeInt(N2);
        for (int i = 0; i < N2; ++i) {
            Item item = this.mItems.get(i);
            TextUtils.writeToParcel(item.mText, dest, flags);
            dest.writeString8(item.mHtmlText);
            dest.writeTypedObject(item.mIntent, flags);
            dest.writeTypedObject(item.mIntentSender, flags);
            dest.writeTypedObject(item.mUri, flags);
            dest.writeTypedObject(this.mParcelItemActivityInfos ? item.mActivityInfo : null, flags);
            dest.writeTypedObject(item.mTextLinks, flags);
        }
    }

    ClipData(Parcel in) {
        this.mClipDescription = new ClipDescription(in);
        this.mIcon = in.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(in) : null;
        this.mItems = new ArrayList();
        int N2 = in.readInt();
        for (int i = 0; i < N2; ++i) {
            CharSequence text = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            String htmlText = in.readString8();
            Intent intent = in.readTypedObject(Intent.CREATOR);
            IntentSender intentSender = in.readTypedObject(IntentSender.CREATOR);
            Uri uri = in.readTypedObject(Uri.CREATOR);
            ActivityInfo info = in.readTypedObject(ActivityInfo.CREATOR);
            TextLinks textLinks = in.readTypedObject(TextLinks.CREATOR);
            Item item = new Item(text, htmlText, intent, intentSender, uri);
            item.setActivityInfo(info);
            item.setTextLinks(textLinks);
            this.mItems.add(item);
        }
    }

    public static class Item {
        final CharSequence mText;
        final String mHtmlText;
        final Intent mIntent;
        final IntentSender mIntentSender;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        Uri mUri;
        private TextLinks mTextLinks;
        private ActivityInfo mActivityInfo;
        private boolean mTokenVerificationEnabled;

        void setTokenVerificationEnabled() {
            this.mTokenVerificationEnabled = true;
        }

        public Item(Item other) {
            this.mText = other.mText;
            this.mHtmlText = other.mHtmlText;
            this.mIntent = other.mIntent;
            this.mIntentSender = other.mIntentSender;
            this.mUri = other.mUri;
            this.mActivityInfo = other.mActivityInfo;
            this.mTextLinks = other.mTextLinks;
        }

        public Item(CharSequence text) {
            this(text, null, null, null, null);
        }

        public Item(CharSequence text, String htmlText) {
            this(text, htmlText, null, null, null);
        }

        public Item(Intent intent) {
            this(null, null, intent, null, null);
        }

        public Item(Uri uri) {
            this(null, null, null, null, uri);
        }

        public Item(CharSequence text, Intent intent, Uri uri) {
            this(text, null, intent, null, uri);
        }

        public Item(CharSequence text, String htmlText, Intent intent, Uri uri) {
            this(text, htmlText, intent, null, uri);
        }

        private Item(CharSequence text, String htmlText, Intent intent, IntentSender intentSender, Uri uri) {
            if (htmlText != null && text == null) {
                throw new IllegalArgumentException("Plain text must be supplied if HTML text is supplied");
            }
            this.mText = text;
            this.mHtmlText = htmlText;
            this.mIntent = intent;
            this.mIntentSender = intentSender;
            this.mUri = uri;
        }

        public CharSequence getText() {
            return this.mText;
        }

        public String getHtmlText() {
            return this.mHtmlText;
        }

        public Intent getIntent() {
            if (this.mTokenVerificationEnabled) {
                Intent.maybeMarkAsMissingCreatorToken(this.mIntent);
            }
            return this.mIntent;
        }

        @FlaggedApi(value="com.android.window.flags.delegate_unhandled_drags")
        @Nullable
        public IntentSender getIntentSender() {
            return this.mIntentSender;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public ActivityInfo getActivityInfo() {
            return this.mActivityInfo;
        }

        public void setActivityInfo(ActivityInfo info) {
            this.mActivityInfo = info;
        }

        @Nullable
        public TextLinks getTextLinks() {
            return this.mTextLinks;
        }

        public void setTextLinks(TextLinks textLinks) {
            this.mTextLinks = textLinks;
        }

        /*
         * Exception decompiling
         */
        public CharSequence coerceToText(Context context) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @RavenwoodThrow
        public CharSequence coerceToStyledText(Context context) {
            CharSequence text = this.getText();
            if (text instanceof Spanned) {
                return text;
            }
            String htmlText = this.getHtmlText();
            if (htmlText != null) {
                try {
                    Spanned newText = Html.fromHtml(htmlText);
                    if (newText != null) {
                        return newText;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (text != null) {
                return text;
            }
            return this.coerceToHtmlOrStyledText(context, true);
        }

        @RavenwoodThrow
        public String coerceToHtmlText(Context context) {
            String htmlText = this.getHtmlText();
            if (htmlText != null) {
                return htmlText;
            }
            CharSequence text = this.getText();
            if (text != null) {
                if (text instanceof Spanned) {
                    return Html.toHtml((Spanned)text);
                }
                return Html.escapeHtml(text);
            }
            text = this.coerceToHtmlOrStyledText(context, false);
            return text != null ? text.toString() : null;
        }

        /*
         * Exception decompiling
         */
        @RavenwoodThrow
        private CharSequence coerceToHtmlOrStyledText(Context context, boolean styled) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 46[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private String uriToHtml(String uri) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("<a href=\"");
            builder.append(Html.escapeHtml(uri));
            builder.append("\">");
            builder.append(Html.escapeHtml(uri));
            builder.append("</a>");
            return builder.toString();
        }

        private CharSequence uriToStyledText(String uri) {
            SpannableStringBuilder builder = new SpannableStringBuilder();
            builder.append(uri);
            builder.setSpan(new URLSpan(uri), 0, builder.length(), 33);
            return builder;
        }

        public String toString() {
            StringBuilder b = new StringBuilder(128);
            b.append("ClipData.Item { ");
            this.toShortString(b, true);
            b.append(" }");
            return b.toString();
        }

        public void toShortString(StringBuilder b, boolean redactContent) {
            boolean first = true;
            if (this.mHtmlText != null) {
                first = false;
                if (redactContent) {
                    b.append("H(").append(this.mHtmlText.length()).append(')');
                } else {
                    b.append("H:").append(this.mHtmlText);
                }
            }
            if (this.mText != null) {
                if (!first) {
                    b.append(' ');
                }
                first = false;
                if (redactContent) {
                    b.append("T(").append(this.mText.length()).append(')');
                } else {
                    b.append("T:").append(this.mText);
                }
            }
            if (this.mUri != null) {
                if (!first) {
                    b.append(' ');
                }
                first = false;
                if (redactContent) {
                    b.append("U(").append(this.mUri.getScheme()).append(')');
                } else {
                    b.append("U:").append(this.mUri);
                }
            }
            if (this.mIntent != null) {
                if (!first) {
                    b.append(' ');
                }
                first = false;
                b.append("I:");
                this.mIntent.toShortString(b, redactContent, true, true, true);
            }
        }

        public void dumpDebug(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            if (this.mHtmlText != null) {
                proto.write(0x10900000001L, this.mHtmlText);
            } else if (this.mText != null) {
                proto.write(1138166333442L, this.mText.toString());
            } else if (this.mUri != null) {
                proto.write(1138166333443L, this.mUri.toString());
            } else if (this.mIntent != null) {
                this.mIntent.dumpDebug(proto, 1146756268036L, true, true, true, true);
            } else {
                proto.write(1133871366149L, true);
            }
            proto.end(token);
        }

        @FlaggedApi(value="com.android.window.flags.delegate_unhandled_drags")
        public static class Builder {
            private CharSequence mText;
            private String mHtmlText;
            private Intent mIntent;
            private IntentSender mIntentSender;
            private Uri mUri;

            @FlaggedApi(value="com.android.window.flags.delegate_unhandled_drags")
            @NonNull
            public Builder setText(@Nullable CharSequence text) {
                this.mText = text;
                return this;
            }

            @FlaggedApi(value="com.android.window.flags.delegate_unhandled_drags")
            @NonNull
            public Builder setHtmlText(@Nullable String htmlText) {
                this.mHtmlText = htmlText;
                return this;
            }

            @FlaggedApi(value="com.android.window.flags.delegate_unhandled_drags")
            @NonNull
            public Builder setIntent(@Nullable Intent intent) {
                this.mIntent = intent;
                return this;
            }

            @FlaggedApi(value="com.android.window.flags.delegate_unhandled_drags")
            @NonNull
            public Builder setIntentSender(@Nullable IntentSender intentSender) {
                if (intentSender != null && !intentSender.isImmutable()) {
                    throw new IllegalArgumentException("Expected intent sender to be immutable");
                }
                this.mIntentSender = intentSender;
                return this;
            }

            @FlaggedApi(value="com.android.window.flags.delegate_unhandled_drags")
            @NonNull
            public Builder setUri(@Nullable Uri uri) {
                this.mUri = uri;
                return this;
            }

            @FlaggedApi(value="com.android.window.flags.delegate_unhandled_drags")
            @NonNull
            public Item build() {
                return new Item(this.mText, this.mHtmlText, this.mIntent, this.mIntentSender, this.mUri);
            }
        }
    }
}

