/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.companion.virtual.ActivityPolicyExemption;
import android.companion.virtual.IVirtualDevice;
import android.companion.virtual.IVirtualDeviceListener;
import android.companion.virtual.IVirtualDeviceManager;
import android.companion.virtual.VirtualDeviceInternal;
import android.companion.virtual.VirtualDeviceParams;
import android.companion.virtual.audio.VirtualAudioDevice;
import android.companion.virtual.camera.VirtualCamera;
import android.companion.virtual.camera.VirtualCameraConfig;
import android.companion.virtual.sensor.VirtualSensor;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.graphics.Point;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.VirtualDisplayConfig;
import android.hardware.input.VirtualDpad;
import android.hardware.input.VirtualDpadConfig;
import android.hardware.input.VirtualKeyboard;
import android.hardware.input.VirtualKeyboardConfig;
import android.hardware.input.VirtualMouse;
import android.hardware.input.VirtualMouseConfig;
import android.hardware.input.VirtualNavigationTouchpad;
import android.hardware.input.VirtualNavigationTouchpadConfig;
import android.hardware.input.VirtualRotaryEncoder;
import android.hardware.input.VirtualRotaryEncoderConfig;
import android.hardware.input.VirtualStylus;
import android.hardware.input.VirtualStylusConfig;
import android.hardware.input.VirtualTouchscreen;
import android.hardware.input.VirtualTouchscreenConfig;
import android.os.Binder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Log;
import android.view.Surface;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.hidden_from_bootclasspath.android.companion.virtualdevice.flags.Flags;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;

public class VirtualDeviceManager {
    private static final String TAG = "VirtualDeviceManager";
    @SystemApi
    public static final int LAUNCH_SUCCESS = 0;
    @SystemApi
    public static final int LAUNCH_FAILURE_PENDING_INTENT_CANCELED = 1;
    @SystemApi
    public static final int LAUNCH_FAILURE_NO_ACTIVITY = 2;
    @SystemApi
    public static final String PERSISTENT_DEVICE_ID_DEFAULT = "default:0";
    private final IVirtualDeviceManager mService;
    private final Context mContext;
    @GuardedBy(value={"mVirtualDeviceListeners"})
    private final List<VirtualDeviceListenerDelegate> mVirtualDeviceListeners = new ArrayList<VirtualDeviceListenerDelegate>();

    public VirtualDeviceManager(@Nullable IVirtualDeviceManager service, @NonNull Context context) {
        this.mService = service;
        this.mContext = context;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    @NonNull
    public VirtualDevice createVirtualDevice(int associationId, @NonNull VirtualDeviceParams params) {
        Objects.requireNonNull(params, "params must not be null");
        try {
            return new VirtualDevice(this.mService, this.mContext, associationId, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_COMPUTER_CONTROL")
    @NonNull
    public VirtualDevice createVirtualDevice(@NonNull VirtualDeviceParams params) {
        Objects.requireNonNull(params, "params must not be null");
        try {
            return new VirtualDevice(this.mService, this.mContext, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<android.companion.virtual.VirtualDevice> getVirtualDevices() {
        if (this.mService == null) {
            Log.w(TAG, "Failed to retrieve virtual devices; no virtual device manager service.");
            return new ArrayList<android.companion.virtual.VirtualDevice>();
        }
        try {
            return this.mService.getVirtualDevices();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public android.companion.virtual.VirtualDevice getVirtualDevice(int deviceId) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to retrieve virtual devices; no virtual device manager service.");
            return null;
        }
        if (deviceId == -1 || deviceId == 0) {
            return null;
        }
        try {
            return this.mService.getVirtualDevice(deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerVirtualDeviceListener(@NonNull Executor executor, @NonNull VirtualDeviceListener listener) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to register listener; no virtual device manager service.");
            return;
        }
        VirtualDeviceListenerDelegate delegate = new VirtualDeviceListenerDelegate(Objects.requireNonNull(executor), Objects.requireNonNull(listener));
        List<VirtualDeviceListenerDelegate> list = this.mVirtualDeviceListeners;
        synchronized (list) {
            try {
                this.mService.registerVirtualDeviceListener(delegate);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mVirtualDeviceListeners.add(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterVirtualDeviceListener(@NonNull VirtualDeviceListener listener) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to unregister listener; no virtual device manager service.");
            return;
        }
        Objects.requireNonNull(listener);
        List<VirtualDeviceListenerDelegate> list = this.mVirtualDeviceListeners;
        synchronized (list) {
            Iterator<VirtualDeviceListenerDelegate> it = this.mVirtualDeviceListeners.iterator();
            while (it.hasNext()) {
                VirtualDeviceListenerDelegate delegate = it.next();
                if (delegate.mListener != listener) continue;
                try {
                    this.mService.unregisterVirtualDeviceListener(delegate);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                it.remove();
            }
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    public int getDevicePolicy(int deviceId, int policyType) {
        if (deviceId == 0) {
            return 0;
        }
        if (this.mService == null) {
            Log.w(TAG, "Failed to retrieve device policy; no virtual device manager service.");
            return 0;
        }
        try {
            return this.mService.getDevicePolicy(deviceId, policyType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    public int getDeviceIdForDisplayId(int displayId) {
        if (displayId == 0 || displayId == -1) {
            return 0;
        }
        if (this.mService == null) {
            Log.w(TAG, "Failed to retrieve virtual devices; no virtual device manager service.");
            return 0;
        }
        try {
            return this.mService.getDeviceIdForDisplayId(displayId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Nullable
    public CharSequence getDisplayNameForPersistentDeviceId(@NonNull String persistentDeviceId) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to retrieve virtual devices; no virtual device manager service.");
            return null;
        }
        try {
            return this.mService.getDisplayNameForPersistentDeviceId(Objects.requireNonNull(persistentDeviceId));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    public Set<String> getAllPersistentDeviceIds() {
        if (this.mService == null) {
            Log.w(TAG, "Failed to retrieve persistent ids; no virtual device manager service.");
            return Collections.emptySet();
        }
        try {
            return new ArraySet<String>(this.mService.getAllPersistentDeviceIds());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isValidVirtualDeviceId(int deviceId) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to retrieve virtual devices; no virtual device manager service.");
            return false;
        }
        try {
            return this.mService.isValidVirtualDeviceId(deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    public int getAudioPlaybackSessionId(int deviceId) {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getAudioPlaybackSessionId(deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    public int getAudioRecordingSessionId(int deviceId) {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getAudioRecordingSessionId(deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    public void playSoundEffect(int deviceId, int effectType) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to dispatch sound effect; no virtual device manager service.");
            return;
        }
        try {
            this.mService.playSoundEffect(deviceId, effectType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isVirtualDeviceOwnedMirrorDisplay(int displayId) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to retrieve virtual devices; no virtual device manager service.");
            return false;
        }
        try {
            return this.mService.isVirtualDeviceOwnedMirrorDisplay(displayId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public static class VirtualDevice
    implements AutoCloseable {
        private final VirtualDeviceInternal mVirtualDeviceInternal;

        @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
        private VirtualDevice(IVirtualDeviceManager service, Context context, int associationId, VirtualDeviceParams params) throws RemoteException {
            this.mVirtualDeviceInternal = new VirtualDeviceInternal(service, context, associationId, params);
        }

        @RequiresPermission(value="android.permission.ACCESS_COMPUTER_CONTROL")
        private VirtualDevice(IVirtualDeviceManager service, Context context, VirtualDeviceParams params) throws RemoteException {
            this.mVirtualDeviceInternal = new VirtualDeviceInternal(service, context, params);
        }

        public VirtualDevice(Context context, IVirtualDevice virtualDevice) {
            this.mVirtualDeviceInternal = new VirtualDeviceInternal(context, virtualDevice);
        }

        public int getDeviceId() {
            return this.mVirtualDeviceInternal.getDeviceId();
        }

        @Nullable
        public String getPersistentDeviceId() {
            return this.mVirtualDeviceInternal.getPersistentDeviceId();
        }

        @NonNull
        public Context createContext() {
            return this.mVirtualDeviceInternal.createContext();
        }

        @NonNull
        public List<VirtualSensor> getVirtualSensorList() {
            return this.mVirtualDeviceInternal.getVirtualSensorList();
        }

        @FlaggedApi(value="android.companion.virtualdevice.flags.device_aware_display_power")
        public void goToSleep() {
            this.mVirtualDeviceInternal.goToSleep();
        }

        @FlaggedApi(value="android.companion.virtualdevice.flags.device_aware_display_power")
        public void wakeUp() {
            this.mVirtualDeviceInternal.wakeUp();
        }

        public void launchPendingIntent(int displayId, @NonNull PendingIntent pendingIntent, @NonNull Executor executor, @NonNull IntConsumer listener) {
            Objects.requireNonNull(pendingIntent, "pendingIntent must not be null");
            Objects.requireNonNull(executor, "executor must not be null");
            Objects.requireNonNull(listener, "listener must not be null");
            this.mVirtualDeviceInternal.launchPendingIntent(displayId, pendingIntent, executor, listener);
        }

        @Deprecated
        @Nullable
        public VirtualDisplay createVirtualDisplay(int width, int height, int densityDpi, @Nullable Surface surface, int flags, @Nullable Executor executor, @Nullable VirtualDisplay.Callback callback) {
            String virtualDisplayName = "VirtualDevice_" + this.getDeviceId();
            VirtualDisplayConfig.Builder builder = new VirtualDisplayConfig.Builder(virtualDisplayName, width, height, densityDpi).setFlags(flags);
            if (surface != null) {
                builder.setSurface(surface);
            }
            return this.mVirtualDeviceInternal.createVirtualDisplay(builder.build(), executor, callback);
        }

        @Nullable
        public VirtualDisplay createVirtualDisplay(@NonNull VirtualDisplayConfig config, @Nullable Executor executor, @Nullable VirtualDisplay.Callback callback) {
            Objects.requireNonNull(config, "config must not be null");
            return this.mVirtualDeviceInternal.createVirtualDisplay(config, executor, callback);
        }

        @Override
        public void close() {
            this.mVirtualDeviceInternal.close();
        }

        public void setDevicePolicy(int policyType, int devicePolicy) {
            this.mVirtualDeviceInternal.setDevicePolicy(policyType, devicePolicy);
        }

        public void addActivityPolicyExemption(@NonNull ComponentName componentName) {
            this.addActivityPolicyExemption(new ActivityPolicyExemption.Builder().setComponentName(componentName).build());
        }

        public void removeActivityPolicyExemption(@NonNull ComponentName componentName) {
            this.removeActivityPolicyExemption(new ActivityPolicyExemption.Builder().setComponentName(componentName).build());
        }

        @FlaggedApi(value="android.companion.virtualdevice.flags.activity_control_api")
        public void addActivityPolicyExemption(@NonNull ActivityPolicyExemption exemption) {
            this.mVirtualDeviceInternal.addActivityPolicyExemption(Objects.requireNonNull(exemption));
        }

        @FlaggedApi(value="android.companion.virtualdevice.flags.activity_control_api")
        public void removeActivityPolicyExemption(@NonNull ActivityPolicyExemption exemption) {
            this.mVirtualDeviceInternal.removeActivityPolicyExemption(Objects.requireNonNull(exemption));
        }

        @FlaggedApi(value="android.companion.virtualdevice.flags.activity_control_api")
        public void setDevicePolicy(int policyType, int devicePolicy, int displayId) {
            this.mVirtualDeviceInternal.setDevicePolicyForDisplay(displayId, policyType, devicePolicy);
        }

        @NonNull
        public VirtualDpad createVirtualDpad(@NonNull VirtualDpadConfig config) {
            Objects.requireNonNull(config, "config must not be null");
            return this.mVirtualDeviceInternal.createVirtualDpad(config);
        }

        @NonNull
        public VirtualKeyboard createVirtualKeyboard(@NonNull VirtualKeyboardConfig config) {
            Objects.requireNonNull(config, "config must not be null");
            return this.mVirtualDeviceInternal.createVirtualKeyboard(config);
        }

        @Deprecated
        @NonNull
        public VirtualKeyboard createVirtualKeyboard(@NonNull VirtualDisplay display, @NonNull String inputDeviceName, int vendorId, int productId) {
            VirtualKeyboardConfig keyboardConfig = ((VirtualKeyboardConfig.Builder)((VirtualKeyboardConfig.Builder)((VirtualKeyboardConfig.Builder)((VirtualKeyboardConfig.Builder)new VirtualKeyboardConfig.Builder().setVendorId(vendorId)).setProductId(productId)).setInputDeviceName(inputDeviceName)).setAssociatedDisplayId(display.getDisplay().getDisplayId())).build();
            return this.mVirtualDeviceInternal.createVirtualKeyboard(keyboardConfig);
        }

        @NonNull
        public VirtualMouse createVirtualMouse(@NonNull VirtualMouseConfig config) {
            Objects.requireNonNull(config, "config must not be null");
            return this.mVirtualDeviceInternal.createVirtualMouse(config);
        }

        @Deprecated
        @NonNull
        public VirtualMouse createVirtualMouse(@NonNull VirtualDisplay display, @NonNull String inputDeviceName, int vendorId, int productId) {
            VirtualMouseConfig mouseConfig = ((VirtualMouseConfig.Builder)((VirtualMouseConfig.Builder)((VirtualMouseConfig.Builder)((VirtualMouseConfig.Builder)new VirtualMouseConfig.Builder().setVendorId(vendorId)).setProductId(productId)).setInputDeviceName(inputDeviceName)).setAssociatedDisplayId(display.getDisplay().getDisplayId())).build();
            return this.mVirtualDeviceInternal.createVirtualMouse(mouseConfig);
        }

        @NonNull
        public VirtualTouchscreen createVirtualTouchscreen(@NonNull VirtualTouchscreenConfig config) {
            Objects.requireNonNull(config, "config must not be null");
            return this.mVirtualDeviceInternal.createVirtualTouchscreen(config);
        }

        @Deprecated
        @NonNull
        public VirtualTouchscreen createVirtualTouchscreen(@NonNull VirtualDisplay display, @NonNull String inputDeviceName, int vendorId, int productId) {
            Point size = new Point();
            display.getDisplay().getSize(size);
            VirtualTouchscreenConfig touchscreenConfig = ((VirtualTouchscreenConfig.Builder)((VirtualTouchscreenConfig.Builder)((VirtualTouchscreenConfig.Builder)((VirtualTouchscreenConfig.Builder)new VirtualTouchscreenConfig.Builder(size.x, size.y).setVendorId(vendorId)).setProductId(productId)).setInputDeviceName(inputDeviceName)).setAssociatedDisplayId(display.getDisplay().getDisplayId())).build();
            return this.mVirtualDeviceInternal.createVirtualTouchscreen(touchscreenConfig);
        }

        @NonNull
        public VirtualNavigationTouchpad createVirtualNavigationTouchpad(@NonNull VirtualNavigationTouchpadConfig config) {
            return this.mVirtualDeviceInternal.createVirtualNavigationTouchpad(config);
        }

        @NonNull
        public VirtualStylus createVirtualStylus(@NonNull VirtualStylusConfig config) {
            return this.mVirtualDeviceInternal.createVirtualStylus(config);
        }

        @NonNull
        @FlaggedApi(value="android.companion.virtualdevice.flags.virtual_rotary")
        public VirtualRotaryEncoder createVirtualRotaryEncoder(@NonNull VirtualRotaryEncoderConfig config) {
            if (!Flags.virtualRotary()) {
                throw new UnsupportedOperationException("Virtual rotary support not enabled");
            }
            return this.mVirtualDeviceInternal.createVirtualRotaryEncoder(config);
        }

        @NonNull
        public VirtualAudioDevice createVirtualAudioDevice(@NonNull VirtualDisplay display, @Nullable Executor executor, @Nullable VirtualAudioDevice.AudioConfigurationChangeCallback callback) {
            Objects.requireNonNull(display, "display must not be null");
            return this.mVirtualDeviceInternal.createVirtualAudioDevice(display, executor, callback);
        }

        @NonNull
        public VirtualCamera createVirtualCamera(@NonNull VirtualCameraConfig config) {
            return this.mVirtualDeviceInternal.createVirtualCamera(Objects.requireNonNull(config));
        }

        public void setShowPointerIcon(boolean showPointerIcon) {
            this.mVirtualDeviceInternal.setShowPointerIcon(showPointerIcon);
        }

        public void setDisplayImePolicy(int displayId, int policy) {
            this.mVirtualDeviceInternal.setDisplayImePolicy(displayId, policy);
        }

        public void addActivityListener(@NonNull Executor executor, @NonNull ActivityListener listener) {
            this.mVirtualDeviceInternal.addActivityListener(executor, listener);
        }

        public void removeActivityListener(@NonNull ActivityListener listener) {
            this.mVirtualDeviceInternal.removeActivityListener(listener);
        }

        public void addSoundEffectListener(@NonNull Executor executor, @NonNull SoundEffectListener soundEffectListener) {
            this.mVirtualDeviceInternal.addSoundEffectListener(executor, soundEffectListener);
        }

        public void removeSoundEffectListener(@NonNull SoundEffectListener soundEffectListener) {
            this.mVirtualDeviceInternal.removeSoundEffectListener(soundEffectListener);
        }

        public void registerIntentInterceptor(@NonNull IntentFilter interceptorFilter, @NonNull Executor executor, @NonNull IntentInterceptorCallback interceptorCallback) {
            this.mVirtualDeviceInternal.registerIntentInterceptor(interceptorFilter, executor, interceptorCallback);
        }

        public void unregisterIntentInterceptor(@NonNull IntentInterceptorCallback interceptorCallback) {
            this.mVirtualDeviceInternal.unregisterIntentInterceptor(interceptorCallback);
        }
    }

    private static class VirtualDeviceListenerDelegate
    extends IVirtualDeviceListener.Stub {
        private final VirtualDeviceListener mListener;
        private final Executor mExecutor;

        private VirtualDeviceListenerDelegate(Executor executor, VirtualDeviceListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVirtualDeviceCreated(int deviceId) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mListener.onVirtualDeviceCreated(deviceId));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVirtualDeviceClosed(int deviceId) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mListener.onVirtualDeviceClosed(deviceId));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    public static interface VirtualDeviceListener {
        default public void onVirtualDeviceCreated(int deviceId) {
        }

        default public void onVirtualDeviceClosed(int deviceId) {
        }
    }

    @SystemApi
    public static interface SoundEffectListener {
        public void onPlaySoundEffect(int var1);
    }

    @SystemApi
    public static interface IntentInterceptorCallback {
        public void onIntentIntercepted(@NonNull Intent var1);
    }

    @SystemApi
    public static interface ActivityListener {
        public void onTopActivityChanged(int var1, @NonNull ComponentName var2);

        default public void onTopActivityChanged(int displayId, @NonNull ComponentName topActivity, int userId) {
        }

        public void onDisplayEmpty(int var1);

        @FlaggedApi(value="android.companion.virtualdevice.flags.activity_control_api")
        default public void onActivityLaunchBlocked(int displayId, @NonNull ComponentName componentName, @NonNull UserHandle user, @Nullable IntentSender intentSender) {
        }

        @FlaggedApi(value="android.companion.virtualdevice.flags.activity_control_api")
        default public void onSecureWindowShown(int displayId, @NonNull ComponentName componentName, @NonNull UserHandle user) {
        }

        @FlaggedApi(value="android.companion.virtualdevice.flags.activity_control_api")
        default public void onSecureWindowHidden(int displayId) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface PendingIntentLaunchStatus {
    }
}

